/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.customhud.HudElements;

import com.minenash.customhud.HudElements.interfaces.HudElement;
import com.minenash.customhud.data.Flags;
import org.apache.commons.lang3.text.WordUtils;

public class FormattedElement
implements HudElement {
    static final char[] delimiters = new char[]{' ', '_', '-', ':'};
    private final HudElement base;
    private final Flags flags;

    public FormattedElement(HudElement base, Flags flags) {
        this.base = base;
        this.flags = flags;
    }

    @Override
    public String getString() {
        String text = this.base.getString();
        if (this.flags.noDelimiters) {
            text = text.replace('-', ' ').replace('_', ' ');
        }
        if (this.flags.textCase != null) {
            switch (this.flags.textCase) {
                case UPPER: {
                    text = text.toUpperCase();
                    break;
                }
                case LOWER: {
                    text = text.toLowerCase();
                    break;
                }
                case TITLE: {
                    text = WordUtils.capitalizeFully((String)text, (char[])delimiters);
                }
            }
        }
        if (this.flags.smallCaps) {
            text = Flags.smallCaps(text);
        }
        if (this.flags.numSize == 1) {
            text = Flags.subNums(text);
        }
        if (this.flags.numSize == 2) {
            text = Flags.supNums(text);
        }
        return text;
    }

    @Override
    public Number getNumber() {
        return this.base.getNumber();
    }

    @Override
    public boolean getBoolean() {
        return this.base.getBoolean();
    }
}

