/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.customhud.HudElements.functional;

import com.minenash.customhud.HudElements.interfaces.ExecuteElement;
import com.minenash.customhud.HudElements.interfaces.HudElement;
import com.minenash.customhud.HudElements.list.Attributers;
import com.minenash.customhud.HudElements.list.FilteredListElement;
import com.minenash.customhud.HudElements.list.ListElement;
import com.minenash.customhud.HudElements.list.ListProvider;
import com.minenash.customhud.HudElements.list.ListProviderSet;
import com.minenash.customhud.complex.ComplexData;
import com.minenash.customhud.complex.ListManager;
import com.minenash.customhud.data.CHFormatting;
import com.minenash.customhud.data.Flags;
import com.minenash.customhud.data.HudTheme;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;

public class FunctionalElement
implements HudElement {
    @Override
    public String getString() {
        return null;
    }

    @Override
    public Number getNumber() {
        return null;
    }

    @Override
    public boolean getBoolean() {
        return false;
    }

    public static boolean isList(HudElement element) {
        return element instanceof XList || element instanceof ListElement || element instanceof FilteredListElement;
    }

    public static interface XList
    extends ExecuteElement {
    }

    public static class RefreshTimings
    extends FunctionalElement
    implements ExecuteElement {
        @Override
        public void run() {
            ComplexData.refreshTimings = true;
        }
    }

    public static class IgnoreErrorElement
    extends FunctionalElement {
    }

    public static class CreateListElement
    extends FunctionalElement {
        public final ListProviderSet.Entry entry;
        public final Attributers.Attributer attributer;
        public HudElement attribute;

        public CreateListElement(Supplier<?> supplier, Function<?, List<?>> function, Attributers.Attributer attributer, Flags flags) {
            String prefix = flags.listPrefix.isEmpty() ? Attributers.DEFAULT_PREFIX.get(attributer) : flags.listPrefix;
            this.entry = new ListProviderSet.Entry(new ListProvider.ListFunctioner(supplier, function), UUID.randomUUID(), prefix, flags.reverseList);
            this.attributer = attributer;
            Attributers.ATTRIBUTER_MAP.put(this.entry.provider(), attributer);
        }
    }

    public static class ContinueList
    extends FunctionalElement {
        public final UUID providerID;

        public ContinueList(UUID providerID) {
            this.providerID = providerID;
        }
    }

    public static class ExitList
    extends FunctionalElement {
        public final UUID providerID;

        public ExitList(UUID providerID) {
            this.providerID = providerID;
        }
    }

    public static class PushList
    extends FunctionalElement
    implements XList {
        public final UUID providerID;
        public final List<?> values;

        public PushList(UUID providerID, List<?> values) {
            this.providerID = providerID;
            this.values = values;
        }

        @Override
        public void run() {
            ListManager.push(this.providerID, this.values);
        }
    }

    public static class PopList
    extends FunctionalElement
    implements XList {
        public final UUID providerID;

        public PopList(UUID providerID) {
            this.providerID = providerID;
        }

        @Override
        public void run() {
            ListManager.pop(this.providerID);
        }
    }

    public static class AdvanceList
    extends FunctionalElement
    implements XList {
        public final UUID providerID;

        public AdvanceList(UUID providerID) {
            this.providerID = providerID;
        }

        @Override
        public void run() {
            ListManager.advance(this.providerID);
        }
    }

    public static class IgnoreNewLineIfSurroundedByNewLine
    extends FunctionalElement {
    }

    public static class EndProfile
    extends NewLine {
    }

    public static class LineBreak
    extends NewLine {
    }

    public static class NewLine
    extends FunctionalElement {
    }

    public static class ChangeFormattingFromElement
    extends ChangeFormatting {
        public final HudElement element;

        public ChangeFormattingFromElement(HudElement element) {
            super(null);
            this.element = element;
        }

        @Override
        public CHFormatting getFormatting() {
            Number color = this.element.getNumber();
            return color == null ? null : new CHFormatting().color(color.intValue(), this.mask(color.intValue()));
        }
    }

    public static class ChangeFormatting
    extends FunctionalElement {
        public final CHFormatting formatting;

        public ChangeFormatting(CHFormatting formatting) {
            this.formatting = formatting;
        }

        public ChangeFormatting(int color) {
            this.formatting = new CHFormatting().color(color, this.mask(color));
        }

        protected int mask(int color) {
            return ((color & 0xFF000000) != 0 ? -16777216 : 0) | ((color & 0xFFFFFF) != 0 ? 0xFFFFFF : 0);
        }

        public CHFormatting getFormatting() {
            return this.formatting;
        }
    }

    public static class ChangeTheme
    extends FunctionalElement {
        public final HudTheme theme;

        public ChangeTheme(HudTheme theme) {
            this.theme = theme;
        }
    }
}

