/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.customhud.HudElements.icon;

import com.minenash.customhud.HudElements.functional.FunctionalElement;
import com.minenash.customhud.data.Flags;
import com.minenash.customhud.render.RenderPiece;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public abstract class IconElement
extends FunctionalElement {
    protected final float scale;
    protected final int shiftX;
    protected final int shiftY;
    protected final int width;
    protected final Quaternionf rotation;
    protected final Quaternionf rotationInverse;
    protected final boolean referenceCorner;
    protected UUID providerID = null;

    protected IconElement(Flags flags, double defaultWidth) {
        this.scale = (float)flags.scale;
        this.shiftX = flags.iconShiftX;
        this.shiftY = flags.iconShiftY;
        this.width = (int)Math.ceil(flags.iconWidth != -1 ? (double)flags.iconWidth : defaultWidth * (double)this.scale);
        this.rotation = new Quaternionf().rotationZ(flags.rotation);
        this.rotationInverse = new Quaternionf().rotationZ(-flags.rotation);
        this.referenceCorner = flags.iconReferenceCorner;
    }

    public abstract void render(class_332 var1, RenderPiece var2);

    public int getTextWidth() {
        return this.width;
    }

    public UUID getProviderID() {
        return this.providerID;
    }

    @Override
    public String getString() {
        return "\ufffe";
    }

    protected void rotate(class_4587 matrices, float renderWidth, float renderHeight) {
        matrices.method_46416(renderWidth / 2.0f, renderHeight / 2.0f, 0.0f);
        matrices.method_22907((Quaternionfc)this.rotation);
        matrices.method_46416(-renderWidth / 2.0f, -renderHeight / 2.0f, 0.0f);
    }

    public void renderItemStack(class_332 context, int x, int y, class_1799 stack, boolean fitInLine) {
        int size;
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_46416((float)(x + this.shiftX), (float)(y + this.shiftY - 2), 0.0f);
        int n = size = fitInLine ? 11 : 16;
        if (!this.referenceCorner) {
            matrices.method_46416(0.0f, -((float)size * this.scale - 11.0f) / 2.0f, 0.0f);
        }
        matrices.method_22905((float)size / 16.0f * this.scale, (float)size / 16.0f * this.scale, 1.0f);
        this.rotate(matrices, 16.0f, 16.0f);
        this.rotate(matrices, 16.0f, 16.0f);
        context.method_51427(stack, 0, 0);
        matrices.method_22909();
    }
}

