/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.customhud.HudElements.list;

import com.minenash.customhud.HudElements.functional.FunctionalElement;
import com.minenash.customhud.HudElements.interfaces.HudElement;
import com.minenash.customhud.HudElements.interfaces.MultiElement;
import com.minenash.customhud.HudElements.list.FilteredListElement;
import com.minenash.customhud.HudElements.list.ListProvider;
import com.minenash.customhud.conditionals.Operation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class ListElement
extends FunctionalElement
implements HudElement,
MultiElement {
    private final HudElement popList;
    private final HudElement advanceList;
    private final UUID providerID;
    private final ListProvider provider;
    private final List<HudElement> main;
    private final List<HudElement> last;
    private final boolean multiline;
    private final boolean reverse;

    public ListElement(ListProvider provider, UUID providerID, List<HudElement> format, List<HudElement> separator, boolean multiline, boolean reverse) {
        this.provider = provider;
        this.providerID = providerID;
        this.popList = new FunctionalElement.PopList(providerID);
        this.advanceList = new FunctionalElement.AdvanceList(providerID);
        this.multiline = multiline;
        this.reverse = reverse;
        this.last = format;
        if (format == null) {
            this.main = null;
        } else {
            this.main = new ArrayList<HudElement>(format);
            if (separator != null) {
                this.main.addAll(separator);
            }
        }
    }

    public static HudElement of(ListProvider provider, UUID providerID, List<HudElement> format, List<HudElement> separator, Operation operation, boolean reverse) {
        return operation == null ? new ListElement(provider, providerID, format, separator, false, reverse) : new FilteredListElement(provider, providerID, format, separator, operation, false, reverse);
    }

    @Override
    public List<HudElement> expand() {
        if (this.main == null) {
            return Collections.EMPTY_LIST;
        }
        List<?> values = this.provider.get();
        if (values.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.reverse) {
            Collections.reverse(values);
        }
        ArrayList<HudElement> expanded = new ArrayList<HudElement>();
        expanded.add(new FunctionalElement.PushList(this.providerID, values));
        for (int i = 0; i < values.size(); ++i) {
            expanded.addAll(i < values.size() - 1 ? this.main : this.last);
            expanded.add(this.advanceList);
        }
        expanded.set(expanded.size() - 1, this.popList);
        return expanded;
    }

    @Override
    public boolean ignoreNewlineIfEmpty() {
        return !this.multiline;
    }

    @Override
    public String getString() {
        return this.expandIntoString();
    }

    public static class MultiLineBuilder {
        private static final ListProvider EMPTY = () -> Collections.EMPTY_LIST;
        public final UUID providerID;
        public final ListProvider provider;
        private final List<HudElement> elements = new ArrayList<HudElement>();
        private final List<HudElement> separator = new ArrayList<HudElement>();
        private final Operation filter;
        private final boolean reverse;
        private boolean separatorMode = false;

        public MultiLineBuilder(ListProvider provider, UUID providerID, Operation filter, boolean reverse) {
            this.provider = provider == null ? EMPTY : provider;
            this.providerID = providerID;
            this.filter = filter;
            this.reverse = reverse;
        }

        public void add(HudElement element) {
            (this.separatorMode ? this.separator : this.elements).add(element);
        }

        public void addAll(List<HudElement> elements) {
            (this.separatorMode ? this.separator : this.elements).addAll(elements);
        }

        public void separatorMode() {
            this.separatorMode = true;
        }

        public HudElement build() {
            return this.filter == null ? new ListElement(this.provider, this.providerID, this.elements, this.separator, true, this.reverse) : new FilteredListElement(this.provider, this.providerID, this.elements, this.separator, this.filter, true, this.reverse);
        }
    }
}

