/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.customhud.conditionals;

import com.minenash.customhud.CustomHud;
import com.minenash.customhud.HudElements.functional.FunctionalElement;
import com.minenash.customhud.HudElements.icon.IconElement;
import com.minenash.customhud.HudElements.interfaces.HudElement;
import com.minenash.customhud.HudElements.interfaces.IdElement;
import com.minenash.customhud.HudElements.interfaces.MultiElement;
import com.minenash.customhud.HudElements.list.ListCountElement;
import com.minenash.customhud.complex.ListManager;
import com.minenash.customhud.conditionals.ExpressionParser;
import com.minenash.customhud.conditionals.SudoElements;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2960;

public interface Operation {
    public double getValue();

    default public boolean getBooleanValue() {
        return this.getValue() != 0.0;
    }

    public void printTree(int var1);

    public static String indent(int indent) {
        return " ".repeat(indent);
    }

    public record ElementUseBool(HudElement element) implements Operation
    {
        @Override
        public double getValue() {
            return this.element.getBoolean() ? 1.0 : 0.0;
        }

        @Override
        public boolean getBooleanValue() {
            return this.element.getBoolean();
        }

        @Override
        public void printTree(int indent) {
            CustomHud.logInDebugMode(Operation.indent(indent) + "- Element: " + String.valueOf(this.element));
        }
    }

    public record Element(HudElement element) implements Operation
    {
        @Override
        public double getValue() {
            return this.element.getNumber().doubleValue();
        }

        @Override
        public boolean getBooleanValue() {
            return this.element.getBoolean();
        }

        @Override
        public void printTree(int indent) {
            CustomHud.logInDebugMode(Operation.indent(indent) + "- Element: " + String.valueOf(this.element));
        }
    }

    public record Literal(double value) implements Operation
    {
        @Override
        public double getValue() {
            return this.value;
        }

        @Override
        public void printTree(int indent) {
            CustomHud.logInDebugMode(Operation.indent(indent) + "- Literal: " + this.value);
        }
    }

    public record Func(Function<Double, Double> func, Operation op) implements Operation
    {
        @Override
        public double getValue() {
            return this.func.apply(this.op.getValue());
        }

        @Override
        public void printTree(int indent) {
            CustomHud.logInDebugMode(Operation.indent(indent) + "- Function: " + this.func.toString());
            this.op.printTree(indent + 2);
        }
    }

    public record MathOperationsOp(List<Operation> elements, List<ExpressionParser.MathOperator> operations) implements Operation
    {
        @Override
        public double getValue() {
            double value = this.elements().isEmpty() ? 0.0 : this.elements.get(0).getValue();
            for (int i = 1; i < this.elements.size(); ++i) {
                value = MathOperationsOp.apply(value, this.elements.get(i), this.operations.get(i - 1));
            }
            return value;
        }

        public static double apply(double value, Operation second, ExpressionParser.MathOperator op) {
            return switch (op) {
                default -> throw new IncompatibleClassChangeError();
                case ExpressionParser.MathOperator.ADD -> value + second.getValue();
                case ExpressionParser.MathOperator.SUBTRACT -> value - second.getValue();
                case ExpressionParser.MathOperator.MULTIPLY -> value * second.getValue();
                case ExpressionParser.MathOperator.DIVIDE -> value / second.getValue();
                case ExpressionParser.MathOperator.MOD -> value % second.getValue();
                case ExpressionParser.MathOperator.EXPONENT -> Math.pow(value, second.getValue());
                case ExpressionParser.MathOperator.IF_NULL -> !Double.isNaN(value) ? value : second.getValue();
            };
        }

        @Override
        public void printTree(int indent) {
            CustomHud.logInDebugMode(Operation.indent(indent) + "- Operations: " + this.operations.toString());
            for (Operation op : this.elements) {
                op.printTree(indent + 2);
            }
        }
    }

    public record MathOperation(List<HudElement> elements, List<ExpressionParser.MathOperator> operations) implements Operation
    {
        @Override
        public double getValue() {
            if (this.elements.isEmpty()) {
                return 0.0;
            }
            double value = this.elements.get(0).getNumber().doubleValue();
            for (int i = 1; i < this.elements.size(); ++i) {
                value = MathOperation.apply(value, this.elements.get(i), this.operations.get(i - 1));
            }
            return value;
        }

        public static double apply(double value, HudElement second, ExpressionParser.MathOperator op) {
            return switch (op) {
                default -> throw new IncompatibleClassChangeError();
                case ExpressionParser.MathOperator.ADD -> value + second.getNumber().doubleValue();
                case ExpressionParser.MathOperator.SUBTRACT -> value - second.getNumber().doubleValue();
                case ExpressionParser.MathOperator.MULTIPLY -> value * second.getNumber().doubleValue();
                case ExpressionParser.MathOperator.DIVIDE -> value / second.getNumber().doubleValue();
                case ExpressionParser.MathOperator.MOD -> value % second.getNumber().doubleValue();
                case ExpressionParser.MathOperator.EXPONENT -> Math.pow(value, second.getNumber().doubleValue());
                case ExpressionParser.MathOperator.IF_NULL -> !Double.isNaN(value) ? value : second.getNumber().doubleValue();
            };
        }

        @Override
        public void printTree(int indent) {
            CustomHud.logInDebugMode(Operation.indent(indent) + "- Operations: " + this.operations.toString());
            for (HudElement element : this.elements) {
                CustomHud.logInDebugMode(Operation.indent(indent) + "- " + element.getString());
            }
        }
    }

    public record BiMathOperation(Operation left, Operation right, ExpressionParser.MathOperator op) implements Operation
    {
        @Override
        public double getValue() {
            return MathOperationsOp.apply(this.left.getValue(), this.right, this.op);
        }

        @Override
        public void printTree(int indent) {
            CustomHud.logInDebugMode(Operation.indent(indent) + "- Operations(" + this.op.name() + ")");
            this.left.printTree(indent + 2);
            this.right.printTree(indent + 2);
        }
    }

    public static class Comparison
    implements Operation {
        public final HudElement left;
        public final HudElement right;
        public final boolean checkBool;
        public final boolean checkNum;
        public final boolean checkId;
        public final ExpressionParser.Comparison comparison;

        Comparison(HudElement left, HudElement right, ExpressionParser.Comparison comparison) {
            this.left = left;
            this.right = right;
            this.comparison = comparison;
            this.checkBool = left instanceof SudoElements.Bool || right instanceof SudoElements.Bool;
            this.checkNum = left instanceof SudoElements.Num || right instanceof SudoElements.Num || left instanceof SudoElements.Op || right instanceof SudoElements.Op;
            this.checkId = left instanceof IdElement || right instanceof IdElement;
        }

        @Override
        public double getValue() {
            return this.getBooleanValue() ? 1.0 : 0.0;
        }

        @Override
        public boolean getBooleanValue() {
            if (this.left == null || this.right == null) {
                return false;
            }
            return switch (this.comparison) {
                default -> throw new IncompatibleClassChangeError();
                case ExpressionParser.Comparison.EQUALS -> {
                    if (this.checkBool) {
                        if (this.left.getBoolean() == this.right.getBoolean()) {
                            yield true;
                        }
                        yield false;
                    }
                    if (this.checkNum) {
                        if (this.left.getNumber().doubleValue() == this.right.getNumber().doubleValue()) {
                            yield true;
                        }
                        yield false;
                    }
                    if (this.checkId) {
                        yield this.compareID(this.left, this.right);
                    }
                    yield this.left.getString().equalsIgnoreCase(this.right.getString());
                }
                case ExpressionParser.Comparison.NOT_EQUALS -> {
                    if (this.checkBool) {
                        if (this.left.getBoolean() != this.right.getBoolean()) {
                            yield true;
                        }
                        yield false;
                    }
                    if (this.checkNum) {
                        if (this.left.getNumber().doubleValue() != this.right.getNumber().doubleValue()) {
                            yield true;
                        }
                        yield false;
                    }
                    if (this.checkId) {
                        if (!this.compareID(this.left, this.right)) {
                            yield true;
                        }
                        yield false;
                    }
                    if (!this.left.getString().equalsIgnoreCase(this.right.getString())) {
                        yield true;
                    }
                    yield false;
                }
                case ExpressionParser.Comparison.LESS_THAN -> {
                    if (this.left.getNumber().doubleValue() < this.right.getNumber().doubleValue()) {
                        yield true;
                    }
                    yield false;
                }
                case ExpressionParser.Comparison.GREATER_THAN -> {
                    if (this.left.getNumber().doubleValue() > this.right.getNumber().doubleValue()) {
                        yield true;
                    }
                    yield false;
                }
                case ExpressionParser.Comparison.LESS_THAN_OR_EQUAL -> {
                    if (this.left.getNumber().doubleValue() <= this.right.getNumber().doubleValue()) {
                        yield true;
                    }
                    yield false;
                }
                case ExpressionParser.Comparison.GREATER_THAN_OR_EQUALS -> {
                    if (this.left.getNumber().doubleValue() >= this.right.getNumber().doubleValue()) {
                        yield true;
                    }
                    yield false;
                }
                case ExpressionParser.Comparison.HAS -> this.has(this.left, this.right);
                case ExpressionParser.Comparison.NOT_HAS -> {
                    if (!this.has(this.left, this.right)) {
                        yield true;
                    }
                    yield false;
                }
                case ExpressionParser.Comparison.IS_IN -> this.has(this.right, this.left);
                case ExpressionParser.Comparison.NOT_IS_IN -> !this.has(this.right, this.left);
            };
        }

        public boolean compareID(HudElement left, HudElement right) {
            class_2960 class_29602;
            class_2960 l;
            if (left instanceof IdElement) {
                IdElement ide = (IdElement)((Object)left);
                v0 = ide.getIdentifier();
            } else {
                v0 = l = class_2960.method_12829((String)left.getString());
            }
            if (right instanceof IdElement) {
                IdElement ide = (IdElement)((Object)right);
                class_29602 = ide.getIdentifier();
            } else {
                class_29602 = class_2960.method_12829((String)right.getString());
            }
            class_2960 r = class_29602;
            return l != null && l.equals((Object)r);
        }

        public boolean has(HudElement left, HudElement right) {
            if (left instanceof ListCountElement) {
                ListCountElement lce = (ListCountElement)left;
                if (lce.attribute == null) {
                    return false;
                }
                ListManager.push(lce.providerID, lce.provider.get());
                while (ListManager.getIndex(lce.providerID) < ListManager.getCount(lce.providerID)) {
                    if (new Comparison(lce.attribute, right, ExpressionParser.Comparison.EQUALS).getBooleanValue()) {
                        ListManager.pop(lce.providerID);
                        return true;
                    }
                    ListManager.advance(lce.providerID);
                }
                ListManager.pop(lce.providerID);
                return false;
            }
            return left.getString().toLowerCase().contains(right.getString().toLowerCase());
        }

        @Override
        public void printTree(int indent) {
            SudoElements.Op op;
            String bool = (this.comparison == ExpressionParser.Comparison.EQUALS || this.comparison == ExpressionParser.Comparison.NOT_EQUALS) && this.checkBool ? "BOOL_" : "";
            CustomHud.logInDebugMode(Operation.indent(indent) + "- Conditional(" + bool + String.valueOf((Object)this.comparison) + "): " + this.left.getClass().getName() + ", " + this.right.getClass().getName());
            HudElement hudElement = this.left;
            if (hudElement instanceof SudoElements.Op) {
                op = (SudoElements.Op)hudElement;
                op.op().printTree(indent + 2);
            }
            if ((hudElement = this.right) instanceof SudoElements.Op) {
                op = (SudoElements.Op)hudElement;
                op.op().printTree(indent + 2);
            }
        }
    }

    public record Negate(HudElement element) implements Operation
    {
        @Override
        public double getValue() {
            return this.element.getBoolean() ? 0.0 : 1.0;
        }

        @Override
        public void printTree(int indent) {
            CustomHud.logInDebugMode(Operation.indent(indent) + "- Negate: " + this.element.getString());
        }
    }

    public record And(List<Operation> elements) implements Operation
    {
        @Override
        public double getValue() {
            for (Operation element : this.elements) {
                if (element.getBooleanValue()) continue;
                return 0.0;
            }
            return 1.0;
        }

        @Override
        public void printTree(int indent) {
            CustomHud.logInDebugMode(Operation.indent(indent) + "- And:");
            for (Operation elem : this.elements) {
                elem.printTree(indent + 2);
            }
        }
    }

    public record Or(List<Operation> elements) implements Operation
    {
        @Override
        public double getValue() {
            for (Operation element : this.elements) {
                if (!element.getBooleanValue()) continue;
                return 1.0;
            }
            return 0.0;
        }

        @Override
        public void printTree(int indent) {
            CustomHud.logInDebugMode(Operation.indent(indent) + "- Or: ");
            for (Operation elem : this.elements) {
                elem.printTree(indent + 2);
            }
        }
    }

    public record Ternary(Operation conditional, Operation left, Operation right) implements Operation
    {
        @Override
        public double getValue() {
            return this.conditional.getValue() > 0.0 ? this.left.getValue() : this.right.getValue();
        }

        @Override
        public void printTree(int indent) {
            CustomHud.logInDebugMode(Operation.indent(indent) + "- Ternary: ");
            this.conditional.printTree(indent + 2);
            this.left.printTree(indent + 2);
            this.right.printTree(indent + 2);
        }
    }

    public record Length(List<HudElement> elements) implements Operation
    {
        @Override
        public double getValue() {
            double length = 0.0;
            for (HudElement element : this.elements) {
                length += this.getLength(element);
            }
            return length;
        }

        private double getLength(HudElement element) {
            if (element instanceof IconElement) {
                IconElement ie = (IconElement)element;
                return ie.getTextWidth();
            }
            if (element instanceof FunctionalElement) {
                if (element instanceof FunctionalElement.XList) {
                    FunctionalElement.XList xl = (FunctionalElement.XList)((Object)element);
                    xl.run();
                }
                return 0.0;
            }
            if (!(element instanceof MultiElement)) {
                return CustomHud.CLIENT.field_1772.method_1727(element.getString());
            }
            MultiElement me = (MultiElement)((Object)element);
            double length = 0.0;
            for (HudElement e : me.expand()) {
                length += this.getLength(e);
            }
            return length;
        }

        @Override
        public void printTree(int indent) {
            CustomHud.logInDebugMode(Operation.indent(indent) + "- Length: ");
            for (HudElement elem : this.elements) {
                CustomHud.logInDebugMode(Operation.indent(indent + 1) + elem.toString());
            }
        }
    }
}

