/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.customhud.data;

import com.minenash.customhud.CustomHud;
import com.minenash.customhud.HudElements.ConditionalElement;
import com.minenash.customhud.HudElements.functional.FunctionalElement;
import com.minenash.customhud.HudElements.interfaces.HudElement;
import com.minenash.customhud.HudElements.list.Attributers;
import com.minenash.customhud.HudElements.list.ListElement;
import com.minenash.customhud.HudElements.list.ListProvider;
import com.minenash.customhud.HudElements.list.ListProviderSet;
import com.minenash.customhud.VariableParser;
import com.minenash.customhud.complex.ComplexData;
import com.minenash.customhud.conditionals.ExpressionParser;
import com.minenash.customhud.conditionals.Operation;
import com.minenash.customhud.data.Flags;
import com.minenash.customhud.data.Profile;
import com.minenash.customhud.errors.ErrorType;
import com.minenash.customhud.errors.Errors;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class MultiLineStacker {
    private final List<HudElement> base = new ArrayList<HudElement>();
    private final Stack<Object> stack = new Stack();
    private final ListProviderSet listProviders = new ListProviderSet();

    public void startIf(String cond, Profile profile, int line, String source, ComplexData.Enabled enabled) {
        Operation op = ExpressionParser.parseExpression(cond, source, profile, line, enabled, this.listProviders, true);
        this.stack.push(new ConditionalElement.MultiLineBuilder(op));
    }

    public void elseIf(String cond, Profile profile, int line, String source, ComplexData.Enabled enabled) {
        if (this.stack.isEmpty()) {
            Errors.addError(profile.name, line, source, ErrorType.CONDITIONAL_NOT_STARTED, "elseif");
        } else {
            Object object = this.stack.peek();
            if (object instanceof ConditionalElement.MultiLineBuilder) {
                ConditionalElement.MultiLineBuilder mlb = (ConditionalElement.MultiLineBuilder)object;
                mlb.setConditional(ExpressionParser.parseExpression(cond, source, profile, line, enabled, this.listProviders, true));
            } else {
                boolean success = false;
                for (int i = this.stack.size() - 1; i >= 0; --i) {
                    Object e = this.stack.get(i);
                    if (!(e instanceof ConditionalElement.MultiLineBuilder)) continue;
                    ConditionalElement.MultiLineBuilder mlb = (ConditionalElement.MultiLineBuilder)e;
                    mlb.addAll(this.finish(i + 1, profile, line, false));
                    ((ConditionalElement.MultiLineBuilder)this.stack.peek()).setConditional(ExpressionParser.parseExpression(cond, source, profile, line, enabled, this.listProviders, true));
                    success = true;
                    break;
                }
                if (!success) {
                    Errors.addError(profile.name, line, source, ErrorType.CONDITIONAL_NOT_STARTED, "elseif");
                }
            }
        }
    }

    public void else1(Profile profile, int line, String source) {
        if (this.stack.isEmpty()) {
            Errors.addError(profile.name, line, source, ErrorType.CONDITIONAL_NOT_STARTED, "else");
        } else {
            Object object = this.stack.peek();
            if (object instanceof ConditionalElement.MultiLineBuilder) {
                ConditionalElement.MultiLineBuilder mlb = (ConditionalElement.MultiLineBuilder)object;
                mlb.setConditional(new Operation.Literal(1.0));
            } else {
                boolean success = false;
                for (int i = this.stack.size() - 1; i >= 0; --i) {
                    Object e = this.stack.get(i);
                    if (!(e instanceof ConditionalElement.MultiLineBuilder)) continue;
                    ConditionalElement.MultiLineBuilder mlb = (ConditionalElement.MultiLineBuilder)e;
                    mlb.addAll(this.finish(i + 1, profile, line, false));
                    ((ConditionalElement.MultiLineBuilder)this.stack.peek()).setConditional(new Operation.Literal(1.0));
                    success = true;
                    break;
                }
                if (!success) {
                    Errors.addError(profile.name, line, source, ErrorType.CONDITIONAL_NOT_STARTED, "else");
                }
            }
        }
    }

    public void endIf(Profile profile, int line, String source) {
        if (this.stack.isEmpty()) {
            Errors.addError(profile.name, line, source, ErrorType.CONDITIONAL_NOT_STARTED, "end");
        } else {
            Object object = this.stack.peek();
            if (object instanceof ConditionalElement.MultiLineBuilder) {
                ConditionalElement.MultiLineBuilder mlb = (ConditionalElement.MultiLineBuilder)object;
                ConditionalElement element = mlb.build();
                this.stack.pop();
                this.addElement(element);
            } else {
                boolean success = false;
                for (int i = this.stack.size() - 1; i >= 0; --i) {
                    Object e = this.stack.get(i);
                    if (!(e instanceof ConditionalElement.MultiLineBuilder)) continue;
                    ConditionalElement.MultiLineBuilder mlb = (ConditionalElement.MultiLineBuilder)e;
                    mlb.addAll(this.finish(i + 1, profile, line, false));
                    ConditionalElement element = ((ConditionalElement.MultiLineBuilder)this.stack.peek()).build();
                    this.stack.pop();
                    this.addElement(element);
                    success = true;
                    break;
                }
                if (!success) {
                    Errors.addError(profile.name, line, source, ErrorType.CONDITIONAL_NOT_STARTED, "end");
                }
            }
        }
    }

    public void startFor(String list, Profile profile, int line, ComplexData.Enabled enabled, String source) {
        List<String> parts = VariableParser.partitionConditional(list);
        list = parts.get(0);
        boolean reverse = false;
        ListProviderSet.Entry provider = VariableParser.getListProvider(list, profile, line, enabled, source, this.listProviders);
        if (provider != null && provider.provider() == ListProvider.REGUIRES_MODMENU) {
            Errors.addError(profile.name, line, source, ErrorType.REQUIRES_MODMENU, "");
            this.listProviders.push(null);
            this.stack.push(new ListElement.MultiLineBuilder(null, null, null, false));
            return;
        }
        if (provider == null) {
            HudElement e = VariableParser.getAttributeElement(list, profile, line, enabled, source);
            if (e instanceof FunctionalElement.IgnoreErrorElement) {
                this.listProviders.push(null);
                this.stack.push(new ListElement.MultiLineBuilder(null, null, null, false));
                return;
            }
            if (e instanceof FunctionalElement.CreateListElement) {
                FunctionalElement.CreateListElement cle = (FunctionalElement.CreateListElement)e;
                provider = cle.entry;
            }
        }
        if (provider == null && !this.listProviders.isEmpty()) {
            Flags flags;
            String[] nameParts = list.split(" ");
            String first = nameParts[0];
            HudElement e = Attributers.getFromPrefix(this.listProviders, first, flags = Flags.parse(profile.name, line, nameParts), profile, line);
            if (e == null) {
                e = Attributers.get(this.listProviders, first, flags, profile, line);
            }
            if (e instanceof FunctionalElement.CreateListElement) {
                FunctionalElement.CreateListElement cle = (FunctionalElement.CreateListElement)e;
                provider = cle.entry;
            }
            reverse = flags.reverseList;
        }
        this.listProviders.push(provider);
        if (provider == null) {
            Errors.addError(profile.name, line, source, ErrorType.UNKNOWN_LIST, list);
            this.stack.push(new ListElement.MultiLineBuilder(null, null, null, false));
            return;
        }
        Operation filter = null;
        if (parts.size() > 1) {
            filter = ExpressionParser.parseExpression(parts.get(1), source, profile, line, enabled, this.listProviders, true);
            CustomHud.logInDebugMode("Filter:");
            filter.printTree(2);
        }
        this.stack.push(new ListElement.MultiLineBuilder(provider.provider(), provider.id(), filter, reverse));
    }

    public void forSeparator(Profile profile, int line, String source) {
        if (this.stack.isEmpty()) {
            Errors.addError(profile.name, line, source, ErrorType.LIST_NOT_STARTED, "=separator=");
        } else {
            Object object = this.stack.peek();
            if (object instanceof ListElement.MultiLineBuilder) {
                ListElement.MultiLineBuilder mlb = (ListElement.MultiLineBuilder)object;
                mlb.separatorMode();
            } else {
                boolean success = false;
                for (int i = this.stack.size() - 1; i >= 0; --i) {
                    Object e = this.stack.get(i);
                    if (!(e instanceof ListElement.MultiLineBuilder)) continue;
                    ListElement.MultiLineBuilder mlb = (ListElement.MultiLineBuilder)e;
                    mlb.addAll(this.finish(i + 1, profile, line, false));
                    ((ListElement.MultiLineBuilder)this.stack.peek()).separatorMode();
                    success = true;
                    break;
                }
                if (!success) {
                    Errors.addError(profile.name, line, source, ErrorType.CONDITIONAL_NOT_STARTED, "separator");
                }
            }
        }
    }

    public void endFor(Profile profile, int line, String source) {
        if (this.stack.isEmpty()) {
            Errors.addError(profile.name, line, source, ErrorType.LIST_NOT_STARTED, "");
            return;
        }
        Object object = this.stack.peek();
        if (object instanceof ListElement.MultiLineBuilder) {
            ListElement.MultiLineBuilder leb = (ListElement.MultiLineBuilder)object;
            HudElement element = leb.build();
            this.stack.pop();
            this.addElement(element);
        } else {
            boolean success = false;
            for (int i = this.stack.size() - 1; i >= 0; --i) {
                Object e = this.stack.get(i);
                if (!(e instanceof ListElement.MultiLineBuilder)) continue;
                ListElement.MultiLineBuilder mlb = (ListElement.MultiLineBuilder)e;
                mlb.addAll(this.finish(i + 1, profile, line, false));
                HudElement element = ((ListElement.MultiLineBuilder)this.stack.peek()).build();
                this.stack.pop();
                this.addElement(element);
                success = true;
                break;
            }
            if (!success) {
                Errors.addError(profile.name, line, source, ErrorType.CONDITIONAL_NOT_STARTED, "end");
            }
        }
        this.listProviders.pop();
    }

    public void addElement(HudElement element) {
        if (this.stack.empty()) {
            this.base.add(element);
        } else {
            Object object = this.stack.peek();
            if (object instanceof ConditionalElement.MultiLineBuilder) {
                ConditionalElement.MultiLineBuilder mlb = (ConditionalElement.MultiLineBuilder)object;
                mlb.add(element);
            } else {
                object = this.stack.peek();
                if (object instanceof ListElement.MultiLineBuilder) {
                    ListElement.MultiLineBuilder leb = (ListElement.MultiLineBuilder)object;
                    leb.add(element);
                }
            }
        }
    }

    public void addElements(String source, Profile profile, int line, ComplexData.Enabled enabled) {
        List<HudElement> elements = VariableParser.addElements(source, profile, line, enabled, true, this.listProviders);
        if (this.stack.empty()) {
            this.base.addAll(elements);
        } else {
            Object object = this.stack.peek();
            if (object instanceof ConditionalElement.MultiLineBuilder) {
                ConditionalElement.MultiLineBuilder mlb = (ConditionalElement.MultiLineBuilder)object;
                mlb.addAll(elements);
            } else {
                object = this.stack.peek();
                if (object instanceof ListElement.MultiLineBuilder) {
                    ListElement.MultiLineBuilder leb = (ListElement.MultiLineBuilder)object;
                    leb.addAll(elements);
                }
            }
        }
    }

    public List<HudElement> finish(int endSize, Profile profile, int endLine, boolean endOfFile) {
        while (this.stack.size() > endSize) {
            Object object = this.stack.peek();
            if (object instanceof ConditionalElement.MultiLineBuilder) {
                ConditionalElement.MultiLineBuilder mlb = (ConditionalElement.MultiLineBuilder)object;
                this.stack.pop();
                this.addElement(mlb.build());
                Errors.addError(profile.name, endLine, endOfFile ? "end of profile" : "end of section", ErrorType.CONDITIONAL_NOT_ENDED, "");
                continue;
            }
            object = this.stack.peek();
            if (!(object instanceof ListElement.MultiLineBuilder)) continue;
            ListElement.MultiLineBuilder leb = (ListElement.MultiLineBuilder)object;
            this.stack.pop();
            this.addElement(leb.build());
            Errors.addError(profile.name, endLine, endOfFile ? "end of profile" : "end of section", ErrorType.LIST_NOT_STARTED, "");
        }
        return this.base;
    }
}

