/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.customhud.render;

import com.minenash.customhud.HudElements.functional.FunctionalElement;
import com.minenash.customhud.data.Section;
import com.minenash.customhud.render.BgRenderPiece;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_287;
import net.minecraft.class_332;
import org.joml.Matrix4f;

public class BackgroundBuilder {
    public final int sectionWidth;
    public final Section.Align textAlign;
    public final boolean isDynamic;
    public final boolean isMax;
    public final boolean isSet;
    public int maxWidth = 0;
    List<BgRenderPiece> bgPieces = new ArrayList<BgRenderPiece>();
    BgRenderPiece nonDynamicBgPiece = null;

    public BackgroundBuilder(Section section) {
        this.sectionWidth = section.width;
        this.textAlign = section.textAlign;
        this.isDynamic = this.sectionWidth == -1;
        this.isMax = this.sectionWidth == -2;
        this.isSet = this.sectionWidth >= 0;
    }

    public void addLine(int yOffset, int width, int height, int color) {
        this.maxWidth = Math.max(this.maxWidth, width);
        if (this.isDynamic) {
            this.bgPieces.add(new BgRenderPiece(0, yOffset, width, height, color));
        } else if (this.nonDynamicBgPiece == null) {
            this.nonDynamicBgPiece = new BgRenderPiece(0, yOffset, width, height, color);
        } else {
            this.nonDynamicBgPiece.height += height;
        }
    }

    public void onThemeChange(FunctionalElement.ChangeTheme cte) {
        if (!this.isDynamic && this.nonDynamicBgPiece != null && this.nonDynamicBgPiece.color != cte.theme.bgColor) {
            int yOffset = this.nonDynamicBgPiece.y + this.nonDynamicBgPiece.height;
            this.bgPieces.add(this.nonDynamicBgPiece);
            this.nonDynamicBgPiece = new BgRenderPiece(0, yOffset, 0, 0, cte.theme.bgColor);
        }
    }

    public void finalizeBg(class_332 context, class_287 buffer, int x, int y) {
        if (this.isDynamic) {
            if (this.textAlign == Section.Align.RIGHT) {
                for (BgRenderPiece bgRenderPiece : this.bgPieces) {
                    bgRenderPiece.x = this.maxWidth - bgRenderPiece.width;
                }
            } else if (this.textAlign == Section.Align.CENTER) {
                for (BgRenderPiece bgRenderPiece : this.bgPieces) {
                    bgRenderPiece.x = this.maxWidth / 2 - bgRenderPiece.width / 2;
                }
            }
        } else {
            if (this.nonDynamicBgPiece != null) {
                this.bgPieces.add(this.nonDynamicBgPiece);
            }
            int width = this.isSet ? this.sectionWidth : this.maxWidth;
            for (BgRenderPiece piece : this.bgPieces) {
                piece.width = width;
            }
        }
        for (BgRenderPiece bgRenderPiece : this.bgPieces) {
            BackgroundBuilder.addToBuffer(context, buffer, x + bgRenderPiece.x, y + bgRenderPiece.y, x + bgRenderPiece.x + bgRenderPiece.width, y + bgRenderPiece.y + bgRenderPiece.height, bgRenderPiece.color);
        }
    }

    private static void addToBuffer(class_332 context, class_287 buffer, int x1, int y1, int x2, int y2, int color) {
        Matrix4f matrix = context.method_51448().method_23760().method_23761();
        float f = (float)(color >> 24 & 0xFF) / 255.0f;
        float g = (float)(color >> 16 & 0xFF) / 255.0f;
        float h = (float)(color >> 8 & 0xFF) / 255.0f;
        float j = (float)(color & 0xFF) / 255.0f;
        buffer.method_22918(matrix, (float)x1, (float)y2, 0.0f).method_22915(g, h, j, f).method_1344();
        buffer.method_22918(matrix, (float)x2, (float)y2, 0.0f).method_22915(g, h, j, f).method_1344();
        buffer.method_22918(matrix, (float)x2, (float)y1, 0.0f).method_22915(g, h, j, f).method_1344();
        buffer.method_22918(matrix, (float)x1, (float)y1, 0.0f).method_22915(g, h, j, f).method_1344();
    }
}

