/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.customhud;

import com.minenash.customhud.ConfigManager;
import com.minenash.customhud.ProfileManager;
import com.minenash.customhud.UpdateChecker;
import com.minenash.customhud.complex.ComplexData;
import com.minenash.customhud.complex.EstimatedTick;
import com.minenash.customhud.data.DisableElement;
import com.minenash.customhud.data.Profile;
import com.minenash.customhud.data.Toggle;
import com.minenash.customhud.errors.Errors;
import com.minenash.customhud.gui.ErrorsScreen;
import com.minenash.customhud.gui.NewConfigScreen;
import com.minenash.customhud.gui.TogglesScreen;
import com.minenash.customhud.render.CustomHudRenderer3;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1041;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_5250;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomHud
implements ModInitializer {
    public static final class_310 CLIENT = class_310.method_1551();
    public static final Logger LOGGER = LogManager.getLogger((String)"CustomHud");
    public static boolean MODMENU_INSTALLED = false;
    public static boolean DEBUG_MODE = false;
    public static final Path CONFIG_FOLDER = FabricLoader.getInstance().getConfigDir().resolve("custom-hud");
    public static final Path PROFILE_FOLDER = FabricLoader.getInstance().getConfigDir().resolve("custom-hud/profiles");
    public static WatchService profileWatcher;
    public static final class_304.class_11900 MAIN_KB_CAT;
    public static final class_304.class_11900 TOGGLES_KB_CAT;
    public static final class_304 kb_enable;
    public static final class_304 kb_cycleProfiles;
    public static final class_304 kb_showErrors;
    public static final class_304 kb_refreshProfilerTimings;
    private static ComplexData.Enabled previousEnabled;
    private static int saveDelay;
    public static final Map<Integer, Boolean> IS_MOUSE_DOWN;
    public static boolean ignoreFirstToast;

    private static class_304 registerKeyBinding(String binding, int defaultKey) {
        return KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.custom_hud." + binding, class_3675.class_307.field_1668, defaultKey, MAIN_KB_CAT));
    }

    public void onInitialize() {
        HudRenderCallback.EVENT.register(CustomHudRenderer3::render);
        ClientTickEvents.END_CLIENT_TICK.register(CustomHud::onTick);
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            if (UpdateChecker.updateMessage != null) {
                client.method_44714().method_44736(UpdateChecker.updateMessage, false);
            }
            EstimatedTick.reset();
            Profile profile = ProfileManager.getActive();
            if (profile != null) {
                profile.boolEvents.add("join");
            }
        });
    }

    public static void delayedInitialize() {
        MODMENU_INSTALLED = FabricLoader.getInstance().isModLoaded("modmenu");
        ConfigManager.load();
        CustomHud.updateCrosshairObjectShare();
        ConfigManager.save();
        try {
            profileWatcher = FileSystems.getDefault().newWatchService();
            PROFILE_FOLDER.register(profileWatcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
        }
        catch (IOException e) {
            LOGGER.catching((Throwable)e);
        }
    }

    public static void readProfiles() {
        try (Stream<Path> pathsStream = Files.list(PROFILE_FOLDER).sorted(Comparator.comparing(p -> p.getFileName().toString()));){
            for (Path path : pathsStream.toList()) {
                String name;
                if (Files.isDirectory(path, new LinkOption[0]) || !(name = path.getFileName().toString()).endsWith(".txt")) continue;
                ProfileManager.add(Profile.parseProfile(path, name.substring(0, name.length() - 4)));
            }
        }
        catch (IOException e) {
            LOGGER.catching((Throwable)e);
        }
    }

    private static void onTick(class_310 client) {
        if (saveDelay > 0) {
            --saveDelay;
        } else if (saveDelay == 0) {
            ConfigManager.save();
            saveDelay = -1;
        }
        CustomHud.updateProfiles();
        Profile profile = ProfileManager.getActive();
        if (profile != null && client.method_1560() != null) {
            if (!Objects.equals(previousEnabled, profile.enabled)) {
                ComplexData.reset();
                previousEnabled = profile.enabled;
            }
            ComplexData.update(profile);
        }
        while (kb_refreshProfilerTimings.method_1436()) {
            ComplexData.refreshTimings = true;
        }
        while (kb_enable.method_1436()) {
            ProfileManager.enabled = !ProfileManager.enabled;
            saveDelay = 100;
        }
        while (kb_cycleProfiles.method_1436()) {
            ProfileManager.cycle();
            saveDelay = 100;
        }
        for (Profile p : ProfileManager.getProfiles()) {
            while (p.keyBinding.method_1436()) {
                ProfileManager.setActive(p);
                ProfileManager.enabled = true;
                saveDelay = 100;
            }
            for (Toggle t : p.toggles.values()) {
                boolean wasPressed = t.key.method_1436();
                if (!CustomHud.isKeybindPressed(t.modifier) || !wasPressed) continue;
                t.toggle();
            }
        }
        while (kb_showErrors.method_1436()) {
            if (client.field_1755 != null) continue;
            if (ProfileManager.getActive() != null && Errors.hasErrors(ProfileManager.getActive().name)) {
                CLIENT.method_1507((class_437)new ErrorsScreen(null));
                continue;
            }
            CLIENT.method_1507((class_437)new NewConfigScreen(null));
        }
    }

    public static boolean isKeybindPressed(class_304 key) {
        if (key.method_1415()) {
            return true;
        }
        if (key.field_1655.field_1666 == class_3675.class_307.field_1672) {
            return IS_MOUSE_DOWN.getOrDefault(KeyBindingHelper.getBoundKeyOf((class_304)key).method_1444(), false);
        }
        return class_3675.method_15987((class_1041)class_310.method_1551().method_22683(), (int)KeyBindingHelper.getBoundKeyOf((class_304)key).method_1444());
    }

    public static boolean isNotDisabled(DisableElement element) {
        return ProfileManager.getActive() == null || !ProfileManager.getActive().disabled.contains((Object)element);
    }

    public static boolean isDisabled(DisableElement element) {
        return ProfileManager.getActive() != null && ProfileManager.getActive().disabled.contains((Object)element);
    }

    private static void updateProfiles() {
        WatchKey key = profileWatcher.poll();
        if (key == null) {
            return;
        }
        for (WatchEvent<?> event : key.pollEvents()) {
            Path path = PROFILE_FOLDER.resolve((Path)event.context());
            String fileName = path.getFileName().toString();
            CustomHud.logInDebugMode("Filename: `" + fileName + "`");
            if (!fileName.endsWith(".txt")) continue;
            fileName = fileName.substring(0, fileName.length() - 4);
            Map<String, Profile> profiles = ProfileManager.getProfiles().stream().collect(Collectors.toMap(p -> p.name, p -> p));
            Profile profile = profiles.get(fileName);
            if (event.kind().name().equals("ENTRY_DELETE")) {
                if (profile == null) continue;
                ProfileManager.remove(profile, false);
                continue;
            }
            if (event.kind().name().equals("ENTRY_CREATE")) {
                if (profile != null) continue;
                ProfileManager.add(Profile.parseProfile(path, fileName));
            }
            if (event.kind().name().equals("ENTRY_MODIFY")) {
                class_437 screen;
                if (profile == null) {
                    CustomHud.logInDebugMode("CustomHud ENTRY MODIFY: You Don't Exist?");
                    continue;
                }
                profile = Profile.parseProfile(path, fileName);
                ProfileManager.replace(profile);
                class_437 class_4372 = CustomHud.CLIENT.field_1755;
                if (class_4372 instanceof ErrorsScreen) {
                    screen = (ErrorsScreen)class_4372;
                    screen.changeProfile(profile);
                }
                if ((class_4372 = CustomHud.CLIENT.field_1755) instanceof TogglesScreen) {
                    screen = (TogglesScreen)class_4372;
                    screen.changeProfile(profile);
                }
                if ((class_4372 = CustomHud.CLIENT.field_1755) instanceof NewConfigScreen) {
                    screen = (NewConfigScreen)class_4372;
                    screen.method_25426();
                }
            }
            LOGGER.info("Updated Profile {}", (Object)fileName);
            if (!ignoreFirstToast) {
                CustomHud.showToast(fileName);
            }
            ignoreFirstToast = false;
        }
        key.reset();
    }

    public static void resourceTriggeredReload() {
        boolean anyHasErrors = false;
        try (Stream<Path> pathsStream = Files.list(PROFILE_FOLDER).sorted(Comparator.comparing(p -> p.getFileName().toString()));){
            for (Path path : pathsStream.toList()) {
                String name;
                if (Files.isDirectory(path, new LinkOption[0]) || !(name = path.getFileName().toString()).endsWith(".txt")) continue;
                name = name.substring(0, name.length() - 4);
                ProfileManager.replace(Profile.parseProfile(path, name));
                if (!Errors.hasErrors(name)) continue;
                anyHasErrors = true;
                CustomHud.showToast(name);
            }
            if (!anyHasErrors) {
                CustomHud.showAllUpdatedToast();
            }
        }
        catch (IOException e) {
            LOGGER.catching((Throwable)e);
        }
        CustomHud.updateCrosshairObjectShare();
    }

    public static void updateCrosshairObjectShare() {
        FabricLoader.getInstance().getObjectShare().put("customhud:crosshair", (Object)(ProfileManager.getActive() == null ? "normal" : ProfileManager.getActive().crosshair.getName()));
    }

    public static void showToast(String profileName) {
        CLIENT.method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47588, (class_2561)class_2561.method_43469((String)"gui.custom_hud.profile_updated", (Object[])new Object[]{profileName}).method_27692(class_124.field_1068), (class_2561)(Errors.hasErrors(profileName) ? class_2561.method_43470((String)("\u00a7cFound " + Errors.getErrors(profileName).size() + " errors")).method_10852((class_2561)(CustomHud.CLIENT.field_1755 instanceof class_442 ? class_2561.method_43470((String)"\u00a77, view in config screen via modmenu ") : class_2561.method_43470((String)"\u00a77, press ").method_10852((class_2561)((class_5250)kb_showErrors.method_16007()).method_27692(class_124.field_1075)).method_27693("\u00a77 to view"))) : class_2561.method_43470((String)"\u00a7aNo errors found"))));
    }

    public static void showAllUpdatedToast() {
        CLIENT.method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47588, (class_2561)class_2561.method_43470((String)"\u00a7fAll Profiles Updated"), (class_2561)class_2561.method_43470((String)"\u00a7aNo errors found")));
    }

    public static void logInDebugMode(String msg) {
        if (DEBUG_MODE) {
            LOGGER.info(msg);
        }
    }

    static {
        MAIN_KB_CAT = class_304.class_11900.method_74698((class_2960)class_2960.method_60655((String)"custom_hud", (String)"custom_hud"));
        TOGGLES_KB_CAT = class_304.class_11900.method_74698((class_2960)class_2960.method_60655((String)"custom_hud", (String)"toggles"));
        kb_enable = CustomHud.registerKeyBinding("enable", -1);
        kb_cycleProfiles = CustomHud.registerKeyBinding("cycle_profiles", 96);
        kb_showErrors = CustomHud.registerKeyBinding("show_errors", 66);
        kb_refreshProfilerTimings = CustomHud.registerKeyBinding("refresh_profiler_timings", -1);
        previousEnabled = ComplexData.Enabled.DISABLED;
        saveDelay = -1;
        IS_MOUSE_DOWN = new HashMap<Integer, Boolean>(6);
        ignoreFirstToast = false;
    }
}

