/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.customhud.HudElements;

import com.minenash.customhud.HudElements.interfaces.HudElement;
import com.minenash.customhud.conditionals.Operation;

public class ExpressionElement
implements HudElement {
    private final Operation expression;
    private final int precision;

    public ExpressionElement(Operation expression, int precision) {
        this.expression = expression;
        this.precision = precision;
    }

    @Override
    public String getString() {
        try {
            double num = this.expression.getValue();
            if (Double.isNaN(num)) {
                return "-";
            }
            if (this.precision == -1) {
                return num % 1.0 == 0.0 ? Integer.toString((int)num) : Double.toString(num);
            }
            return String.format("%." + this.precision + "f", num);
        }
        catch (Exception _e) {
            return "-";
        }
    }

    @Override
    public Number getNumber() {
        return this.expression.getValue();
    }

    @Override
    public boolean getBoolean() {
        return this.expression.getValue() != 0.0;
    }
}

