/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.customhud;

import com.minenash.customhud.CustomHud;
import com.minenash.customhud.HudElements.ConditionalElement;
import com.minenash.customhud.HudElements.ExpressionElement;
import com.minenash.customhud.HudElements.IntElement;
import com.minenash.customhud.HudElements.ItemCountElement;
import com.minenash.customhud.HudElements.ItemTagCountElement;
import com.minenash.customhud.HudElements.LastUpdatedElement;
import com.minenash.customhud.HudElements.MacroElement;
import com.minenash.customhud.HudElements.RealTimeElement;
import com.minenash.customhud.HudElements.SeededSlimeChunkElement;
import com.minenash.customhud.HudElements.SettingsElement;
import com.minenash.customhud.HudElements.StringElement;
import com.minenash.customhud.HudElements.TimerElement;
import com.minenash.customhud.HudElements.functional.FunctionalElement;
import com.minenash.customhud.HudElements.functional.GetValueElement;
import com.minenash.customhud.HudElements.functional.SetValueElement;
import com.minenash.customhud.HudElements.icon.ItemCountIconElement;
import com.minenash.customhud.HudElements.icon.ItemIconElement;
import com.minenash.customhud.HudElements.icon.NewTextureIconElement;
import com.minenash.customhud.HudElements.icon.PlayerHeadIconElement;
import com.minenash.customhud.HudElements.icon.ProgressBarIcon;
import com.minenash.customhud.HudElements.icon.RecordIconElement;
import com.minenash.customhud.HudElements.icon.RichItemSupplierIconElement;
import com.minenash.customhud.HudElements.icon.SimpleTextureIconElement;
import com.minenash.customhud.HudElements.icon.SpaceElement;
import com.minenash.customhud.HudElements.interfaces.HudElement;
import com.minenash.customhud.HudElements.list.AttributeHelpers;
import com.minenash.customhud.HudElements.list.Attributers;
import com.minenash.customhud.HudElements.list.ListCountElement;
import com.minenash.customhud.HudElements.list.ListElement;
import com.minenash.customhud.HudElements.list.ListProvider;
import com.minenash.customhud.HudElements.list.ListProviderSet;
import com.minenash.customhud.HudElements.list.ListSuppliers;
import com.minenash.customhud.HudElements.stats.CustomStatElement;
import com.minenash.customhud.HudElements.stats.TypedStatElement;
import com.minenash.customhud.HudElements.supplier.BooleanSupplierElement;
import com.minenash.customhud.HudElements.supplier.EntitySuppliers;
import com.minenash.customhud.HudElements.supplier.EntryNumberSuppliers;
import com.minenash.customhud.HudElements.supplier.IdentifierSupplier;
import com.minenash.customhud.HudElements.supplier.IntegerSuppliers;
import com.minenash.customhud.HudElements.supplier.NumberSupplierElement;
import com.minenash.customhud.HudElements.supplier.SpecialIdSupplier;
import com.minenash.customhud.HudElements.supplier.SpecialSupplierElement;
import com.minenash.customhud.HudElements.supplier.StringSupplierElement;
import com.minenash.customhud.HudElements.text.ActionbarMsgElement;
import com.minenash.customhud.HudElements.text.TextSupplierElement;
import com.minenash.customhud.HudElements.text.TitleMsgElement;
import com.minenash.customhud.ProfileManager;
import com.minenash.customhud.complex.ComplexData;
import com.minenash.customhud.complex.VelocityTracker;
import com.minenash.customhud.conditionals.ExpressionParser;
import com.minenash.customhud.conditionals.Operation;
import com.minenash.customhud.conditionals.SudoElements;
import com.minenash.customhud.data.CHFormatting;
import com.minenash.customhud.data.Flags;
import com.minenash.customhud.data.HudTheme;
import com.minenash.customhud.data.Macro;
import com.minenash.customhud.data.Profile;
import com.minenash.customhud.data.StatFormatters;
import com.minenash.customhud.data.Toggle;
import com.minenash.customhud.errors.ErrorType;
import com.minenash.customhud.errors.Errors;
import com.minenash.customhud.registry.CustomHudRegistry;
import com.minenash.customhud.registry.ParseContext;
import com.mojang.authlib.GameProfile;
import com.terraformersmc.modmenu.ModMenu;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_151;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3445;
import net.minecraft.class_3448;
import net.minecraft.class_3468;
import net.minecraft.class_3545;
import net.minecraft.class_3675;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9013;
import net.minecraft.class_9015;

public class VariableParser {
    private static final Pattern TEXTURE_ICON_PATTERN = Pattern.compile("((?:[a-z0-9/._-]+:)?[a-z0-9/._-]+(?:(?:[a-z0-9/._ -]*(?:-(?:sh|shift)(?:-?\\d+)(,(?:-?\\d+))?)[a-z0-9/._ -]*)|(?:[a-z0-9/._ -]*)))(?:,([^,]*))?(?:,([^,]*))?(?:,([^,]*))?(?:,([^,]*))?(?:,([^,]*))?(?:,([^,]*))?");
    private static final Pattern HEX_COLOR_VARIABLE_PATTERN = Pattern.compile("&\\{(?:0x|#)?([0-9a-fA-F]{3,8})}");
    private static final Pattern EXPRESSION_WITH_PRECISION = Pattern.compile("\\$(?:(\\d+) *,)?(.*)");
    private static final Pattern ITEM_VARIABLE_PATTERN = Pattern.compile("([\\w.-]*)(?::?([\\w.: /|-]*))?.*");
    private static final Pattern SPACE_STR_PATTERN = Pattern.compile("\"(.*)\"");
    private static final Pattern IS_LIST_PATTERN = Pattern.compile("([\\w\\s:-]+),\\s*\".*");
    private static final Pattern VELOCITY_PATTERN = Pattern.compile("(_[xyz]{1,3})?(_kph|_mph)?");

    public static List<HudElement> addElements(String str, Profile profile, int debugLine, ComplexData.Enabled enabled, boolean line, ListProviderSet listProviders) {
        ArrayList<HudElement> elements = new ArrayList<HudElement>();
        CustomHud.logInDebugMode("PARTITION:");
        for (String part : VariableParser.partition(str)) {
            CustomHud.logInDebugMode("`" + part + "`");
            HudElement element = VariableParser.parseElement(part, profile, debugLine, enabled, listProviders);
            if (element == null) continue;
            elements.add(element);
        }
        if (line) {
            elements.add(new FunctionalElement.LineBreak());
        }
        return elements;
    }

    private static boolean basicallyEmpty(List<HudElement> elements) {
        for (HudElement e : elements) {
            if (e instanceof FunctionalElement.NewLine) continue;
            return false;
        }
        return true;
    }

    private static List<String> partition(String str) {
        char[] chars = str.toCharArray();
        ArrayList<String> parts = new ArrayList<String>();
        int nest = 0;
        int startIndex = 0;
        block7: for (int i = 0; i < str.length(); ++i) {
            char c = chars[i];
            switch (c) {
                case '\\': {
                    if (nest != 0 || i + 1 >= chars.length || chars[i + 1] != 'n') continue block7;
                    parts.add(str.substring(startIndex, i));
                    parts.add("\n");
                    startIndex = i + 2;
                    ++i;
                    continue block7;
                }
                case '\u00a7': {
                    if (nest == 0 && i + 1 < chars.length && VariableParser.isColorCode(chars[i + 1])) {
                        parts.add(str.substring(startIndex, i));
                        parts.add(str.substring(i, i + 2));
                        startIndex = i + 2;
                        ++i;
                        continue block7;
                    }
                    if (nest != 0 || i + 2 >= chars.length || chars[i + 1] != 'z' || chars[i + 1] != 'n' && chars[i + 1] != 'm') continue block7;
                    parts.add(str.substring(startIndex, i));
                    parts.add(str.substring(i, i + 3));
                    startIndex = i + 3;
                    i += 2;
                    continue block7;
                }
                case '&': {
                    if (i >= chars.length - 1 || chars[i + 1] != '{') continue block7;
                    if (nest == 0 && i != startIndex) {
                        parts.add(str.substring(startIndex, i));
                        startIndex = i;
                    }
                    ++nest;
                    continue block7;
                }
                case '{': {
                    if (i > 0 && (chars[i - 1] == '{' || chars[i - 1] == '&')) continue block7;
                    if (nest == 0 && i != startIndex) {
                        parts.add(str.substring(startIndex, i));
                        startIndex = i;
                    }
                    ++nest;
                    continue block7;
                }
                case '}': {
                    if (i < chars.length - 1 && chars[i + 1] == '}') continue block7;
                    if (nest == 1) {
                        parts.add(str.substring(startIndex, i + 1));
                        startIndex = i + 1;
                    }
                    --nest;
                }
            }
        }
        if (startIndex < chars.length) {
            parts.add(str.substring(startIndex, chars.length));
        }
        return parts;
    }

    private static boolean isColorCode(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'u';
    }

    public static List<String> partitionConditional(String str) {
        char[] chars = str.toCharArray();
        ArrayList<String> parts = new ArrayList<String>();
        int nest = 0;
        int startIndex = 0;
        Stack<Character> qStack = new Stack<Character>();
        block10: for (int i = 0; i < str.length(); ++i) {
            char c = chars[i];
            switch (c) {
                case '&': {
                    if (i >= chars.length - 1 || chars[i + 1] != '{') continue block10;
                    ++nest;
                    continue block10;
                }
                case '{': {
                    if (i > 0 && (chars[i - 1] == '{' || chars[i - 1] == '&')) continue block10;
                    ++nest;
                    continue block10;
                }
                case '}': {
                    if (i < chars.length - 1 && chars[i + 1] == '}') continue block10;
                    --nest;
                    continue block10;
                }
                case '[': {
                    ++nest;
                    continue block10;
                }
                case ']': {
                    --nest;
                    continue block10;
                }
                case ',': {
                    if (nest != 0 || !qStack.isEmpty()) continue block10;
                    parts.add(str.substring(startIndex, i));
                    startIndex = i + 1;
                    continue block10;
                }
                case '\"': {
                    if (qStack.size() == nest) {
                        qStack.push(Character.valueOf('\"'));
                        continue block10;
                    }
                    if (qStack.isEmpty() || ((Character)qStack.peek()).charValue() != '\"') continue block10;
                    qStack.pop();
                    continue block10;
                }
                case '\'': {
                    if (qStack.size() == nest) {
                        qStack.push(Character.valueOf('\''));
                        continue block10;
                    }
                    if (qStack.isEmpty() || ((Character)qStack.peek()).charValue() != '\'') continue block10;
                    qStack.pop();
                }
            }
        }
        if (startIndex < chars.length) {
            parts.add(str.substring(startIndex, chars.length));
        }
        return parts;
    }

    public static HudElement parseElement(String part, Profile profile, int debugLine, ComplexData.Enabled enabled, ListProviderSet listProviders) {
        try {
            CHFormatting formatting;
            if (part == null || part.isEmpty()) {
                return null;
            }
            if (part.equals("\n")) {
                return new FunctionalElement.NewLine();
            }
            if (part.startsWith("\u00a7") && (formatting = HudTheme.parseColorCode(part)) != null) {
                return new FunctionalElement.ChangeFormatting(formatting);
            }
            if (part.startsWith("&{")) {
                Matcher m = HEX_COLOR_VARIABLE_PATTERN.matcher(part);
                if (m.matches()) {
                    return new FunctionalElement.ChangeFormatting(HudTheme.parseHexNumber(m.group(1)));
                }
                HudElement element = VariableParser.parseElement2(part.substring(1), profile, debugLine, enabled, listProviders);
                if (element instanceof FunctionalElement.ChangeFormatting) {
                    return element;
                }
                if (element instanceof IntElement) {
                    IntElement ie = (IntElement)element;
                    return new FunctionalElement.ChangeFormatting(ie.getNumber().intValue());
                }
                if (element != null) {
                    return new FunctionalElement.ChangeFormattingFromElement(element);
                }
                Errors.addError(profile.name, debugLine, part, ErrorType.UNKNOWN_COLOR, part.substring(2, part.length() - 1).trim());
                return null;
            }
            return VariableParser.parseElement2(part, profile, debugLine, enabled, listProviders);
        }
        catch (Exception e) {
            Errors.addError(profile.name, debugLine, part, ErrorType.VARIABLE_ERROR, "");
            CustomHud.LOGGER.catching((Throwable)e);
            return null;
        }
    }

    public static boolean inQuotes(String part) {
        return part.length() > 1 && part.startsWith("\"") && part.endsWith("\"") || part.startsWith("'") && part.endsWith("'");
    }

    public static HudElement parseElement2(String part, Profile profile, int debugLine, ComplexData.Enabled enabled, ListProviderSet listProviders) {
        Object name;
        Object setting;
        HudElement element;
        boolean crosshair;
        if (!part.startsWith("{") || part.length() < 2) {
            return new StringElement(part);
        }
        String original = part;
        if ((part = part.substring(1, part.length() - 1).trim()).isBlank()) {
            Errors.addError(profile.name, debugLine, original, ErrorType.EMPTY_VARIABLE, "");
            return null;
        }
        if (part.startsWith("{") && part.length() > 1) {
            if (!part.endsWith("}")) {
                Errors.addError(profile.name, debugLine, original, ErrorType.MALFORMED_CONDITIONAL, "Conditional not closed / incomplete");
                return null;
            }
            part = part.substring(1, part.length() - 1).trim();
            CustomHud.logInDebugMode("COND:");
            List<String> ps = VariableParser.partitionConditional(part);
            for (String p2 : ps) {
                CustomHud.logInDebugMode("`" + p2 + "`");
            }
            if (ps.size() < 2) {
                Errors.addError(profile.name, debugLine, original, ErrorType.MALFORMED_CONDITIONAL, "There's only a conditional section");
                return null;
            }
            ArrayList<ConditionalElement.ConditionalPair> pairs = new ArrayList<ConditionalElement.ConditionalPair>();
            for (int i = 0; i < ps.size() - 1; i += 2) {
                String cond = ps.get(i);
                String result = ps.get(i + 1).trim();
                if (!VariableParser.inQuotes(result)) {
                    Errors.addError(profile.name, debugLine, original, ErrorType.MALFORMED_CONDITIONAL, "Section not in quotations");
                    return null;
                }
                result = result.substring(1, result.length() - 1);
                pairs.add(new ConditionalElement.ConditionalPair(ExpressionParser.parseExpression(cond, original, profile, debugLine, enabled, listProviders, true), VariableParser.addElements(result, profile, debugLine, enabled, false, listProviders)));
            }
            if (ps.size() % 2 == 1) {
                String result = ps.get(ps.size() - 1).trim();
                if (result.length() < 2 || !VariableParser.inQuotes(result)) {
                    Errors.addError(profile.name, debugLine, original, ErrorType.MALFORMED_CONDITIONAL, "Section not in quotations");
                    return null;
                }
                result = result.substring(1, result.length() - 1);
                pairs.add(new ConditionalElement.ConditionalPair(new Operation.Literal(1.0), VariableParser.addElements(result, profile, debugLine, enabled, false, listProviders)));
            }
            if (pairs.isEmpty()) {
                Errors.addError(profile.name, debugLine, original, ErrorType.MALFORMED_CONDITIONAL, "No pairs");
                return null;
            }
            return new ConditionalElement(pairs, false);
        }
        if (part.startsWith("$")) {
            try {
                Matcher matcher = EXPRESSION_WITH_PRECISION.matcher(part);
                matcher.matches();
                int precision = matcher.group(1) == null ? -1 : Integer.parseInt(matcher.group(1));
                return new ExpressionElement(ExpressionParser.parseExpression(matcher.group(2), original, profile, debugLine, enabled, listProviders, false), precision);
            }
            catch (Exception e) {
                CustomHud.LOGGER.catching((Throwable)e);
                return null;
            }
        }
        HudElement el = CustomHudRegistry.get(part, new ParseContext(profile, debugLine, enabled, listProviders));
        if (el != null) {
            return el;
        }
        if (listProviders.isEmpty() || !part.startsWith("scores") || !part.contains(",")) {
            HudElement he = VariableParser.getListSupplierElements(part, profile, debugLine, enabled, original, listProviders);
            if (he instanceof FunctionalElement.IgnoreErrorElement) {
                return null;
            }
            if (he != null) {
                return he;
            }
        }
        if ((el = VariableParser.getAttributeElement(part, profile, debugLine, enabled, original)) != null) {
            if (el instanceof FunctionalElement.IgnoreErrorElement) {
                return null;
            }
            if (el instanceof FunctionalElement.CreateListElement) {
                FunctionalElement.CreateListElement cle = (FunctionalElement.CreateListElement)el;
                return VariableParser.listElement(cle.entry, part, part.indexOf(44), profile, debugLine, enabled, original, listProviders);
            }
            return el;
        }
        if (part.startsWith("bar")) {
            return VariableParser.barElement(true, part, profile, debugLine, enabled, original, listProviders);
        }
        if (part.startsWith("nb_bar")) {
            return VariableParser.barElement(false, part.substring(3), profile, debugLine, enabled, original, listProviders);
        }
        if (part.startsWith("space:")) {
            String widthStr = part.substring(6).trim();
            Matcher matcher = SPACE_STR_PATTERN.matcher(widthStr);
            Operation op = matcher.matches() ? new Operation.Length(VariableParser.addElements(matcher.group(1), profile, debugLine, enabled, false, listProviders)) : ExpressionParser.parseExpression(widthStr.trim(), part, profile, debugLine, enabled, listProviders, false);
            return new SpaceElement(op);
        }
        if (part.startsWith("set:")) {
            int commaIndex = part.indexOf(",");
            if (commaIndex == -1) {
                String valueName = part.substring(4).trim();
                return new SetValueElement(valueName, new Operation.Literal(0.0), null);
            }
            String name2 = part.substring(4, commaIndex).toLowerCase();
            String valueStr = part.substring(commaIndex + 1).trim();
            Matcher matcher = SPACE_STR_PATTERN.matcher(valueStr);
            if (matcher.matches()) {
                return new SetValueElement(name2, null, VariableParser.addElements(matcher.group(1), profile, debugLine, enabled, false, listProviders));
            }
            Operation op = ExpressionParser.parseExpression(valueStr, part, profile, debugLine, enabled, listProviders, false);
            return new SetValueElement(name2, op, null);
        }
        if (part.startsWith("setmacro:") || part.startsWith("setm:")) {
            int commaIndex = part.indexOf(",");
            if (commaIndex == -1) {
                String macroName = part.substring(part.indexOf(":") + 1).trim();
                profile.macros.put(macroName, new Macro(Collections.singletonList(new FunctionalElement.IgnoreNewLineIfSurroundedByNewLine()), null));
                return new FunctionalElement.IgnoreNewLineIfSurroundedByNewLine();
            }
            String macroName = part.substring(part.indexOf(":") + 1, commaIndex).trim();
            String macroStr = part.substring(commaIndex + 1).trim();
            Matcher matcher = SPACE_STR_PATTERN.matcher(macroStr);
            Macro macro = matcher.matches() ? new Macro(VariableParser.addElements(matcher.group(1), profile, debugLine, enabled, false, listProviders), null) : new Macro(null, ExpressionParser.parseExpression(macroStr.trim(), part, profile, debugLine, enabled, listProviders, false));
            profile.macros.put(macroName, macro);
            return new FunctionalElement.IgnoreNewLineIfSurroundedByNewLine();
        }
        if (part.startsWith("real_time:")) {
            try {
                return new RealTimeElement(new SimpleDateFormat(part.substring(10)));
            }
            catch (IllegalArgumentException e) {
                Errors.addError(profile.name, debugLine, original, ErrorType.INVALID_TIME_FORMAT, e.getMessage());
            }
        }
        if (part.equals("profile_last_modified")) {
            return new LastUpdatedElement(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM, FormatStyle.SHORT));
        }
        if (part.startsWith("profile_last_modified:")) {
            try {
                return new LastUpdatedElement(DateTimeFormatter.ofPattern(part.substring(22)));
            }
            catch (IllegalArgumentException e) {
                Errors.addError(profile.name, debugLine, original, ErrorType.INVALID_TIME_FORMAT, e.getMessage());
            }
        }
        if ((crosshair = part.startsWith("crosshair:")) || part.startsWith("icon:")) {
            class_1792 item;
            part = part.substring(part.indexOf(58) + 1);
            String[] flagParts = part.split(" ");
            String main = flagParts[0];
            if (!crosshair && (item = (class_1792)class_7923.field_41178.method_63535(class_2960.method_12829((String)main))) != class_1802.field_8162) {
                Flags flags = Flags.parse(profile.name, debugLine, flagParts);
                return Flags.wrap(new ItemIconElement(new class_1799((class_1935)item), flags), flags);
            }
            if (!part.contains(",")) {
                Object path = main.endsWith(".png") ? main : main + ".png";
                class_2960 id = class_2960.method_12829((String)path);
                if (id == null) {
                    Errors.addError(profile.name, debugLine, original, ErrorType.UNKNOWN_ICON, (String)path);
                    return null;
                }
                Flags flags = Flags.parse(profile.name, debugLine, flagParts);
                SimpleTextureIconElement element2 = new SimpleTextureIconElement(id, crosshair, flags);
                if (element2.isIconAvailable()) {
                    return Flags.wrap(element2, flags);
                }
                Errors.addError(profile.name, debugLine, original, ErrorType.UNKNOWN_ICON, id.toString());
                return null;
            }
            Matcher matcher = TEXTURE_ICON_PATTERN.matcher(part);
            if (!matcher.matches()) {
                Errors.addError(profile.name, debugLine, original, ErrorType.UNKNOWN_ICON, part);
                return null;
            }
            String[] mainParts = matcher.group(1).split(" ");
            Object path = mainParts[0].endsWith(".png") ? mainParts[0] : mainParts[0] + ".png";
            class_2960 id = class_2960.method_12829((String)path);
            if (id == null) {
                Errors.addError(profile.name, debugLine, original, ErrorType.UNKNOWN_ICON, (String)path);
                return null;
            }
            Operation u = matcher.group(3) == null || matcher.group(3).isBlank() ? null : ExpressionParser.parseExpression(matcher.group(3), original, profile, debugLine, enabled, listProviders, false);
            Operation v = matcher.group(4) == null || matcher.group(4).isBlank() ? null : ExpressionParser.parseExpression(matcher.group(4), original, profile, debugLine, enabled, listProviders, false);
            Operation w = matcher.group(5) == null || matcher.group(5).isBlank() ? null : ExpressionParser.parseExpression(matcher.group(5), original, profile, debugLine, enabled, listProviders, false);
            Operation h = matcher.group(6) == null || matcher.group(6).isBlank() ? null : ExpressionParser.parseExpression(matcher.group(6), original, profile, debugLine, enabled, listProviders, false);
            Operation width = matcher.group(8) == null || matcher.group(7).isBlank() ? null : ExpressionParser.parseExpression(matcher.group(7), original, profile, debugLine, enabled, listProviders, false);
            int hg = matcher.group(8) == null ? 7 : 8;
            Operation height = matcher.group(hg) == null || matcher.group(hg).isBlank() ? null : ExpressionParser.parseExpression(matcher.group(hg), original, profile, debugLine, enabled, listProviders, false);
            Flags flags = Flags.parse(profile.name, debugLine, mainParts);
            if (matcher.group(2) != null && !matcher.group(2).isEmpty() && u == null && v == null && w == null && h == null && width == null && height == null) {
                SimpleTextureIconElement element3 = new SimpleTextureIconElement(id, crosshair, flags);
                if (element3.isIconAvailable()) {
                    return Flags.wrap(element3, flags);
                }
                Errors.addError(profile.name, debugLine, original, ErrorType.UNKNOWN_ICON, id.toString());
                return null;
            }
            NewTextureIconElement element4 = new NewTextureIconElement(id, u, v, w, h, width, height, crosshair, flags);
            if (element4.isIconAvailable()) {
                return element4;
            }
            Errors.addError(profile.name, debugLine, original, ErrorType.UNKNOWN_ICON, id.toString());
            return null;
        }
        if (part.startsWith("velocity")) {
            String tracks;
            int flagStart;
            part = part.substring(8);
            int openBrace = part.indexOf(91);
            int closeBrace = part.lastIndexOf(93);
            int n = flagStart = closeBrace != -1 ? closeBrace + 1 : part.indexOf(32);
            int mainEnd = openBrace != -1 ? openBrace : (flagStart != -1 ? flagStart : part.length());
            String main = part.substring(0, mainEnd);
            Matcher matcher = VELOCITY_PATTERN.matcher(main);
            if (!matcher.matches()) {
                Errors.addError(profile.name, debugLine, original, ErrorType.MALFORMED_VELOCITY, main);
                return null;
            }
            String string = tracks = matcher.group(1) == null ? "" : matcher.group(1);
            double conversion = matcher.group(2) == null ? 1.0 : (matcher.group(2).equals("_kph") ? 3.6 : 2.236936292054402);
            Operation smoothing = new Operation.Literal(0.0);
            if (closeBrace != -1 && closeBrace > openBrace) {
                List<String> parts = VariableParser.partitionConditional(part.substring(openBrace + 1, closeBrace));
                if (parts.size() != 1) {
                    Errors.addError(profile.name, debugLine, original, ErrorType.MALFORMED_VELOCITY_SMOOTHING, "Expected 1 arg, found " + parts.size());
                    return null;
                }
                smoothing = ExpressionParser.parseExpression(parts.get(0), original, profile, debugLine, enabled, listProviders, false);
            }
            Flags flags = Flags.parse(profile.name, debugLine, flagStart == -1 || flagStart >= part.length() ? new String[]{} : part.substring(flagStart).split(" "));
            VelocityTracker tracker = new VelocityTracker(smoothing, tracks.contains("x"), tracks.contains("y"), tracks.contains("z"));
            enabled.velocityTrackers.add(tracker);
            return Flags.wrap(new NumberSupplierElement(NumberSupplierElement.of(() -> tracker.velocity * conversion, 1), flags), flags);
        }
        el = VariableParser.listOnlyElement(part, profile, debugLine, enabled, original, listProviders, p -> {
            int collinIndex = p.indexOf(58);
            if (collinIndex == -1) {
                return null;
            }
            String value = p.substring(collinIndex + 1);
            ListProvider provider = null;
            if (p.startsWith("itag:") || p.startsWith("item_tag:")) {
                provider = ListSuppliers.TAG_ENTRIES(class_7923.field_41178, value);
                Attributers.ATTRIBUTER_MAP.put(provider, Attributers.ITEM_CONVERTABLE_TAG_ENTRY);
            } else if (p.startsWith("btag:") || p.startsWith("block_tag:")) {
                provider = ListSuppliers.TAG_ENTRIES(class_7923.field_41175, value);
                Attributers.ATTRIBUTER_MAP.put(provider, Attributers.ITEM_CONVERTABLE_TAG_ENTRY);
            } else if (p.startsWith("score:") && p.indexOf(58, 6) == -1) {
                provider = ListSuppliers.SCORES(value);
                Attributers.ATTRIBUTER_MAP.put(provider, Attributers.SCOREBOARD_SCORE);
            }
            return provider;
        });
        if (el != null) {
            return el;
        }
        Matcher matcher = IS_LIST_PATTERN.matcher(part);
        String[] flagParts = (matcher.matches() ? matcher.group(1) : part).split(" ");
        part = flagParts[0];
        Flags flags = Flags.parse(profile.name, debugLine, flagParts);
        if (!listProviders.isEmpty()) {
            element = Attributers.getFromPrefix(listProviders, part, flags, profile, debugLine);
            if (element instanceof FunctionalElement.CreateListElement) {
                FunctionalElement.CreateListElement cle = (FunctionalElement.CreateListElement)element;
                String p3 = original.substring(1, original.length() - 1);
                return VariableParser.listElement(cle.entry, p3, p3.indexOf(44), profile, debugLine, enabled, original, listProviders);
            }
            if (element != null) {
                return Flags.wrap(element, flags);
            }
        }
        if (part.startsWith("get:")) {
            String valueName = part.substring(4).toLowerCase();
            return new GetValueElement(valueName, flags);
        }
        if (part.startsWith("macro:") || part.startsWith("m:")) {
            return new MacroElement(part.substring(part.indexOf(":") + 1), flags);
        }
        if (part.startsWith("score:")) {
            part = part.substring(6);
            int collinIndex = part.indexOf(58);
            String player = part.substring(0, collinIndex);
            String objective = part.substring(collinIndex + 1);
            return Flags.wrap(new NumberSupplierElement(() -> {
                class_266 obj = AttributeHelpers.scoreboard().method_1170(objective);
                if (obj == null) {
                    return null;
                }
                class_9013 score = AttributeHelpers.scoreboard().method_55430(class_9015.method_55422((String)player), obj);
                return score == null ? 0 : score.method_55397();
            }, flags), flags);
        }
        if (part.startsWith("pscore:") || part.startsWith("player_score:")) {
            String p4 = part.substring(part.indexOf(58) + 1);
            return Flags.wrap(new NumberSupplierElement(() -> {
                class_266 obj = AttributeHelpers.scoreboard().method_1170(p4);
                if (obj == null) {
                    return null;
                }
                class_9013 score = AttributeHelpers.scoreboard().method_55430(class_9015.method_55420((GameProfile)CustomHud.CLIENT.field_1724.method_7334()), obj);
                return score == null ? 0 : score.method_55397();
            }, flags), flags);
        }
        if (part.startsWith("stat:")) {
            String stat = part.substring(5);
            HudElement element5 = VariableParser.stat("mined:", class_3468.field_15427, class_7923.field_41175, stat, flags, enabled);
            if (element5 == null) {
                element5 = VariableParser.stat("crafted:", class_3468.field_15370, class_7923.field_41178, stat, flags, enabled);
            }
            if (element5 == null) {
                element5 = VariableParser.stat("used:", class_3468.field_15372, class_7923.field_41178, stat, flags, enabled);
            }
            if (element5 == null) {
                element5 = VariableParser.stat("broken:", class_3468.field_15383, class_7923.field_41178, stat, flags, enabled);
            }
            if (element5 == null) {
                element5 = VariableParser.stat("dropped:", class_3468.field_15405, class_7923.field_41178, stat, flags, enabled);
            }
            if (element5 == null) {
                element5 = VariableParser.stat("picked_up:", class_3468.field_15392, class_7923.field_41178, stat, flags, enabled);
            }
            if (element5 == null) {
                element5 = VariableParser.stat("killed:", class_3468.field_15403, class_7923.field_41177, stat, flags, enabled);
            }
            if (element5 == null) {
                element5 = VariableParser.stat("killed_by:", class_3468.field_15411, class_7923.field_41177, stat, flags, enabled);
            }
            if (element5 != null) {
                return Flags.wrap(element5, flags);
            }
            class_2960 statId = (class_2960)class_7923.field_41183.method_63535(class_2960.method_60654((String)stat));
            if (class_3468.field_15419.method_14958((Object)statId)) {
                enabled.updateStats = true;
                return Flags.wrap(new CustomStatElement((class_3445<class_2960>)class_3468.field_15419.method_14956((Object)statId), flags), flags);
            }
            Errors.addError(profile.name, debugLine, original, ErrorType.UNKNOWN_STATISTIC, stat);
            return null;
        }
        if (part.startsWith("pteam:") || part.startsWith("player_team:")) {
            HudElement element6;
            String method = part.substring(part.indexOf(58) + 1);
            int dotIndex = method.lastIndexOf(46);
            if (dotIndex != -1) {
                method = method.substring(0, dotIndex);
            }
            if ((element6 = Attributers.ATTRIBUTER_MAP.get(ListSuppliers.TEAMS).get(null, () -> CustomHud.CLIENT.field_1724.method_5781(), method, flags, null)) instanceof FunctionalElement.CreateListElement) {
                FunctionalElement.CreateListElement cle = (FunctionalElement.CreateListElement)element6;
                String attr = dotIndex == -1 ? "" : flagParts[0].substring(dotIndex + 1);
                cle.attribute = Attributers.get(new ListProviderSet().with(cle.entry), attr, new Flags(), profile, debugLine);
            }
            if (element6 == null) {
                Errors.addError(profile.name, debugLine, original, ErrorType.UNKNOWN_ATTRIBUTE_METHOD, method);
            }
            return element6;
        }
        if (part.startsWith("itemcount:") || part.startsWith("itemcount_icon:")) {
            boolean icon = part.charAt(9) == '_';
            part = part.substring(part.indexOf(58) + 1);
            try {
                if (!icon && part.startsWith("#")) {
                    return new ItemTagCountElement(class_2960.method_60654((String)part.substring(1)), flags);
                }
                class_1792 item = (class_1792)class_7923.field_41178.method_63535(class_2960.method_60654((String)part));
                if (item != class_1802.field_8162) {
                    return Flags.wrap(icon ? new ItemCountIconElement(item, flags) : new ItemCountElement(item, flags), flags);
                }
                Errors.addError(profile.name, debugLine, original, ErrorType.UNKNOWN_ITEM_ID, part);
                return null;
            }
            catch (class_151 e) {
                Errors.addError(profile.name, debugLine, original, ErrorType.UNKNOWN_ITEM_ID, part);
                return null;
            }
        }
        if (part.startsWith("s:") || part.startsWith("setting:")) {
            setting = part.substring(part.indexOf(58) + 1).toLowerCase();
            class_3545<HudElement, class_3545<ErrorType, String>> element7 = SettingsElement.create((String)setting, flags);
            if (element7.method_15442() != null) {
                return Flags.wrap((HudElement)element7.method_15442(), flags);
            }
            Errors.addError(profile.name, debugLine, original, (ErrorType)((Object)((class_3545)element7.method_15441()).method_15442()), (String)((class_3545)element7.method_15441()).method_15441());
            return null;
        }
        if (part.startsWith("is_pressed:")) {
            setting = part.substring(part.indexOf(58) + 1).toLowerCase();
            String context = setting;
            if (!((String)setting).startsWith("key_")) {
                if (!((String)setting).startsWith("key.")) {
                    setting = "key." + (String)setting;
                }
                context = setting;
                setting = "key_" + (String)setting;
            }
            class_315 options = class_310.method_1551().field_1690;
            String key = ((String)setting).substring(4);
            for (class_304 binding : options.field_1839) {
                if (!binding.method_1431().equalsIgnoreCase(key)) continue;
                return Flags.wrap(new BooleanSupplierElement(() -> ((class_304)binding).method_1434()), flags);
            }
            Errors.addError(profile.name, debugLine, original, ErrorType.UNKNOWN_KEYBIND, context);
            return null;
        }
        if (part.startsWith("toggle:")) {
            boolean lastPressed = part.endsWith(":last_pressed");
            String name3 = part.substring(7, part.length() - (lastPressed ? 13 : 0));
            if (name3.isEmpty()) {
                Errors.addError(profile.name, debugLine, original, ErrorType.EMPTY_TOGGLE, null);
                return null;
            }
            Toggle toggle = profile.toggles.get(name3);
            if (toggle == null) {
                toggle = new Toggle(name3.replace('_', ' '), false, debugLine, true, new class_304("customhud_toggle_" + String.valueOf(UUID.randomUUID()), -1, CustomHud.TOGGLES_KB_CAT), new class_304("customhud_toggle_" + String.valueOf(UUID.randomUUID()), -1, CustomHud.TOGGLES_KB_CAT));
            } else {
                toggle.lines.add(debugLine);
            }
            profile.toggles.put(name3, toggle);
            if (lastPressed) {
                Toggle finalToggle = toggle;
                return new NumberSupplierElement(new NumberSupplierElement.Entry(() -> finalToggle.lastPressed == 0L ? null : Long.valueOf(System.currentTimeMillis() - finalToggle.lastPressed), 0, StatFormatters.MIL_HMS), flags);
            }
            return new BooleanSupplierElement(toggle::getValue);
        }
        if (part.startsWith("toggle_keybind:")) {
            name = part.substring(15);
            if (((String)name).isEmpty()) {
                Errors.addError(profile.name, debugLine, original, ErrorType.EMPTY_TOGGLE, null);
                return null;
            }
            return new TextSupplierElement(() -> VariableParser.lambda$parseElement2$6((String)name), flags);
        }
        if (part.startsWith("toggle_key:")) {
            class_3675.class_306 key;
            name = part.substring(11);
            if (((String)name).isEmpty()) {
                Errors.addError(profile.name, debugLine, original, ErrorType.EMPTY_TOGGLE, null);
                return null;
            }
            if (!((String)name).startsWith("key.")) {
                if (!((String)name).startsWith("keyboard.") && !((String)name).startsWith("mouse.")) {
                    name = "keyboard." + (String)name;
                }
                name = "key." + (String)name;
            }
            try {
                key = class_3675.method_15981((String)name);
            }
            catch (Exception ignored) {
                key = null;
            }
            if (key == null) {
                Errors.addError(profile.name, debugLine, original, ErrorType.UNKNOWN_KEY, (String)name);
                return null;
            }
            Toggle toggle = profile.toggles.get(" " + (String)name);
            if (toggle == null) {
                toggle = new Toggle((String)name, true, debugLine, true, new class_304("customhud_key_toggle_" + String.valueOf(UUID.randomUUID()), -1, CustomHud.TOGGLES_KB_CAT), new class_304("customhud_key_toggle_" + String.valueOf(UUID.randomUUID()), key.method_1444(), CustomHud.TOGGLES_KB_CAT));
            } else {
                toggle.lines.add(debugLine);
            }
            profile.toggles.put(" " + (String)name, toggle);
            return new BooleanSupplierElement(toggle::getValue);
        }
        if (part.startsWith("timer")) {
            String argsStr = part.substring(5);
            if (!argsStr.startsWith("[") || !argsStr.endsWith("]")) {
                Errors.addError(profile.name, debugLine, original, ErrorType.MALFORMED_TIMER, null);
                return null;
            }
            List<String> parts = VariableParser.partitionConditional(argsStr.substring(1, argsStr.length() - 1));
            if (parts.isEmpty() || parts.size() > 2) {
                Errors.addError(profile.name, debugLine, original, ErrorType.MALFORMED_TIMER, "Expected 1 or 2 args, found" + parts.size());
                return null;
            }
            Operation end = ExpressionParser.parseExpression(parts.get(0), original, profile, debugLine, enabled, listProviders, false);
            Operation.Literal interval = parts.size() != 2 ? new Operation.Literal(1.0) : ExpressionParser.parseExpression(parts.get(1), original, profile, debugLine, enabled, listProviders, false);
            return Flags.wrap(new TimerElement(end, interval, flags), flags);
        }
        if (part.startsWith("slime_chunk:")) {
            String seedStr = part.substring(12).trim();
            if (seedStr.isEmpty()) {
                return new BooleanSupplierElement(BooleanSupplierElement.IS_SLIME_CHUNK);
            }
            return new SeededSlimeChunkElement(seedStr);
        }
        if (part.startsWith("mod_loaded:")) {
            String modid = part.substring(11);
            return new SudoElements.Bool(FabricLoader.getInstance().isModLoaded(modid));
        }
        switch (part) {
            case "gizmo": {
                Errors.addError(profile.name, debugLine, original, ErrorType.GIZMO_NO_WORK, null);
                return null;
            }
            case "record_icon": {
                enabled.music = true;
                return Flags.wrap(new RecordIconElement(flags), flags);
            }
            case "target_block_icon": 
            case "target_icon": 
            case "tbicon": {
                enabled.world = true;
                enabled.targetBlock = true;
                return Flags.wrap(new RichItemSupplierIconElement(null, () -> ComplexData.targetBlock == null ? null : new class_1799((class_1935)ComplexData.targetBlock.method_26204()), flags, false), flags);
            }
            case "target_fluid_icon": 
            case "tficon": {
                enabled.world = true;
                enabled.targetFluid = true;
                return Flags.wrap(new RichItemSupplierIconElement(null, () -> ComplexData.targetFluid == null ? null : new class_1799((class_1935)ComplexData.targetFluid.method_15772().method_15774()), flags, false), flags);
            }
            case "actionbar_msg": 
            case "actionbar": {
                return Flags.wrap(new ActionbarMsgElement(flags), flags);
            }
            case "title_msg": 
            case "title": {
                return Flags.wrap(new TitleMsgElement(TextSupplierElement.TITLE_MSG, flags), flags);
            }
            case "subtitle_msg": 
            case "subtitle": {
                return Flags.wrap(new TitleMsgElement(TextSupplierElement.SUBTITLE_MSG, flags), flags);
            }
            case "target_villager_xp_bar": 
            case "tveb": {
                enabled.targetVillager = true;
                enabled.targetEntity = true;
                return new ProgressBarIcon(true, new Operation.Element(new NumberSupplierElement(IntegerSuppliers.VILLAGER_XP, new Flags())), new Operation.Element(new NumberSupplierElement(IntegerSuppliers.VILLAGER_XP_NEEDED, new Flags())), ProgressBarIcon.VILLAGER_GREEN, flags);
            }
            case "player_head": {
                return new PlayerHeadIconElement(flags);
            }
            case "refresh_profiler_timings": {
                return new FunctionalElement.RefreshTimings();
            }
        }
        element = VariableParser.getSupplierElement(part, enabled, flags);
        if (element != null) {
            return Flags.wrap(element, flags);
        }
        element = Attributers.get(listProviders, part, flags, profile, debugLine);
        if (element instanceof FunctionalElement.CreateListElement) {
            FunctionalElement.CreateListElement cle = (FunctionalElement.CreateListElement)element;
            String p5 = original.substring(1, original.length() - 1);
            return VariableParser.listElement(cle.entry, p5, p5.indexOf(44), profile, debugLine, enabled, original, listProviders);
        }
        if (element != null) {
            return Flags.wrap(element, flags);
        }
        Errors.addError(profile.name, debugLine, original, ErrorType.UNKNOWN_VARIABLE, part);
        return null;
    }

    private static HudElement stat(String prefix, class_3448<?> type, class_2378<?> registry, String stat, Flags flags, ComplexData.Enabled enabled) {
        if (!stat.startsWith(prefix)) {
            return null;
        }
        Optional entry = registry.method_17966(class_2960.method_60654((String)stat.substring(prefix.length())));
        if (entry.isPresent()) {
            enabled.updateStats = true;
            return new TypedStatElement(type, entry.get(), flags);
        }
        return null;
    }

    private static HudElement getSupplierElement(String name, ComplexData.Enabled enabled, Flags flags) {
        Supplier<Object> supplier = VariableParser.getStringSupplier(name, enabled);
        if (supplier != null) {
            return new StringSupplierElement(supplier);
        }
        supplier = VariableParser.getBooleanSupplier(name, enabled);
        if (supplier != null) {
            return new BooleanSupplierElement(supplier);
        }
        supplier = VariableParser.getIntegerSupplier(name, enabled);
        if (supplier != null) {
            return new NumberSupplierElement(supplier, flags);
        }
        NumberSupplierElement.Entry entry = VariableParser.getDecimalSupplier(name, enabled);
        if (entry != null) {
            return new NumberSupplierElement(entry, flags);
        }
        SpecialSupplierElement.Entry entry2 = VariableParser.getSpecialSupplierElements(name, enabled);
        if (entry2 != null) {
            return new SpecialSupplierElement(entry2);
        }
        SpecialIdSupplier.Entry entry3 = VariableParser.getSpecialIdSupplierElements(name, enabled);
        if (entry3 != null) {
            return new SpecialIdSupplier(entry3, flags);
        }
        supplier = VariableParser.getTextSupplier(name, enabled);
        if (supplier != null) {
            return new TextSupplierElement(supplier, flags);
        }
        supplier = VariableParser.getIdentifierSupplier(name, enabled);
        if (supplier != null) {
            return new IdentifierSupplier(supplier, flags);
        }
        Integer color = HudTheme.parseColorName(name);
        if (color != null) {
            return new IntElement(color, flags);
        }
        CHFormatting formatting = HudTheme.parseFormattingName(name);
        if (formatting != null) {
            return new FunctionalElement.ChangeFormatting(formatting);
        }
        return null;
    }

    private static Supplier<class_2561> getTextSupplier(String element, ComplexData.Enabled enabled) {
        return switch (element) {
            case "display_name", "name" -> TextSupplierElement.DISPLAY_NAME;
            case "target_entity_name", "ten" -> {
                enabled.targetEntity = true;
                yield EntitySuppliers.TARGET_ENTITY_NAME;
            }
            case "last_hit_name", "lhn" -> {
                enabled.targetEntity = true;
                yield EntitySuppliers.LAST_HIT_ENTITY_NAME;
            }
            case "hooked_entity_name", "hen" -> EntitySuppliers.HOOKED_ENTITY_NAME;
            case "vehicle_entity_name", "vehicle_name", "ven" -> EntitySuppliers.VEHICLE_ENTITY_NAME;
            case "vehicle_horse_armor", "horse_armor", "vha" -> EntitySuppliers.VEHICLE_HORSE_ARMOR;
            case "team_name" -> TextSupplierElement.PLAYER_TEAM_NAME;
            case "record_name" -> {
                enabled.music = true;
                yield TextSupplierElement.RECORD_NAME;
            }
            case "team", "pteam", "player_team" -> TextSupplierElement.PLAYER_TEAM_NAME;
            default -> null;
        };
    }

    private static Supplier<class_2960> getIdentifierSupplier(String element, ComplexData.Enabled enabled) {
        return switch (element) {
            case "target_entity_id", "tei" -> {
                enabled.targetEntity = true;
                yield EntitySuppliers.TARGET_ENTITY_ID;
            }
            case "last_hit_id", "lhi" -> {
                enabled.targetEntity = true;
                yield EntitySuppliers.LAST_HIT_ENTITY_ID;
            }
            case "hooked_entity_id", "hei" -> EntitySuppliers.HOOKED_ENTITY_ID;
            case "vehicle_entity_id", "vehicle_id", "vei" -> EntitySuppliers.VEHICLE_ENTITY_ID;
            case "dimension_id" -> SpecialIdSupplier.DIMENSION_ID;
            case "biome_id" -> SpecialIdSupplier.BIOME_ID;
            case "music_id" -> {
                enabled.music = true;
                yield SpecialIdSupplier.MUSIC_ID;
            }
            case "record_id" -> {
                enabled.music = true;
                yield SpecialIdSupplier.RECORD_ID;
            }
            default -> null;
        };
    }

    private static Supplier<String> getStringSupplier(String element, ComplexData.Enabled enabled) {
        return switch (element) {
            case "profile_name" -> StringSupplierElement.PROFILE_NAME;
            case "version" -> StringSupplierElement.VERSION;
            case "client_version" -> StringSupplierElement.CLIENT_VERSION;
            case "modded_name" -> StringSupplierElement.MODDED_NAME;
            case "username" -> StringSupplierElement.USERNAME;
            case "uuid" -> StringSupplierElement.UUID;
            case "dimension" -> StringSupplierElement.DIMENSION;
            case "facing", "facing4" -> StringSupplierElement.FACING4;
            case "facing_short", "facing4_short" -> StringSupplierElement.FACING4_SHORT;
            case "facing8" -> StringSupplierElement.FACING8;
            case "facing8_short" -> StringSupplierElement.FACING8_SHORT;
            case "facing_towards_xz" -> StringSupplierElement.FACING_TOWARDS_XZ;
            case "biome" -> StringSupplierElement.BIOME;
            case "moon_phase_word" -> {
                enabled.clientChunk = true;
                yield StringSupplierElement.MOON_PHASE_WORD;
            }
            case "target_entity", "te" -> {
                enabled.targetEntity = true;
                yield EntitySuppliers.TARGET_ENTITY;
            }
            case "target_entity_uuid", "teu" -> {
                enabled.targetEntity = true;
                yield EntitySuppliers.TARGET_ENTITY_UUID;
            }
            case "target_villager_biome", "tvb" -> {
                enabled.targetVillager = true;
                enabled.targetEntity = true;
                yield StringSupplierElement.VILLAGER_BIOME;
            }
            case "target_villager_level_word", "tvlw" -> {
                enabled.targetVillager = true;
                enabled.targetEntity = true;
                yield StringSupplierElement.VILLAGER_LEVEL_WORD;
            }
            case "last_hit", "lh" -> {
                enabled.targetEntity = true;
                yield EntitySuppliers.LAST_HIT_ENTITY;
            }
            case "last_hit_uuid", "lhu" -> {
                enabled.targetEntity = true;
                yield EntitySuppliers.LAST_HIT_ENTITY_UUID;
            }
            case "hooked_entity", "he" -> EntitySuppliers.HOOKED_ENTITY;
            case "hooked_entity_uuid", "heu" -> EntitySuppliers.HOOKED_ENTITY_UUID;
            case "vehicle_entity", "vehicle", "ve" -> EntitySuppliers.VEHICLE_ENTITY;
            case "vehicle_entity_uuid", "vehicle_uuid", "veu" -> EntitySuppliers.VEHICLE_ENTITY_UUID;
            case "world_name", "world" -> StringSupplierElement.WORLD_NAME;
            case "server_name" -> StringSupplierElement.SERVER_NAME;
            case "server_address", "address", "ip" -> StringSupplierElement.SERVER_ADDRESS;
            case "java_version" -> StringSupplierElement.JAVA_VERSION;
            case "cpu_name" -> {
                enabled.cpu = true;
                yield StringSupplierElement.CPU_NAME;
            }
            case "gpu_name" -> StringSupplierElement.GPU_NAME;
            case "gpu_vendor" -> StringSupplierElement.GPU_VENDOR;
            case "gl_version" -> StringSupplierElement.GL_VERSION;
            case "gpu_driver" -> StringSupplierElement.GPU_DRIVER;
            case "server_brand" -> StringSupplierElement.SERVER_BRAND;
            case "music_name" -> {
                enabled.music = true;
                yield StringSupplierElement.MUSIC_NAME;
            }
            case "bb_peaks", "biome_builder_peaks" -> {
                enabled.serverWorld = true;
                yield StringSupplierElement.BIOME_BUILDER_PEAKS;
            }
            case "bb_cont", "biome_builder_continents" -> {
                enabled.serverWorld = true;
                yield StringSupplierElement.BIOME_BUILDER_CONTINENTS;
            }
            case "am_pm" -> {
                enabled.time = true;
                yield StringSupplierElement.TIME_AM_PM;
            }
            case "resource_pack_version", "rp_version" -> StringSupplierElement.RESOURCE_PACK_VERSION;
            case "data_pack_version", "datapack_version", "dp_version" -> StringSupplierElement.DATA_PACK_VERSION;
            default -> null;
        };
    }

    private static Supplier<Boolean> getBooleanSupplier(String element, ComplexData.Enabled enabled) {
        return switch (element) {
            case "profile_in_cycle" -> BooleanSupplierElement.PROFILE_IN_CYCLE;
            case "vsync" -> BooleanSupplierElement.VSYNC;
            case "sp", "singleplayer" -> BooleanSupplierElement.SINGLEPLAYER;
            case "mp", "multiplayer" -> BooleanSupplierElement.MULTIPLAYER;
            case "survival" -> BooleanSupplierElement.SURVIVAL;
            case "creative" -> BooleanSupplierElement.CREATIVE;
            case "adventure" -> BooleanSupplierElement.ADVENTURE;
            case "spectator" -> BooleanSupplierElement.SPECTATOR;
            case "chunks_culling" -> BooleanSupplierElement.CHUNK_CULLING;
            case "overworld" -> BooleanSupplierElement.IN_OVERWORLD;
            case "nether" -> BooleanSupplierElement.IN_NETHER;
            case "end" -> BooleanSupplierElement.IN_END;
            case "raining" -> {
                enabled.world = true;
                yield BooleanSupplierElement.IS_RAINING;
            }
            case "thundering" -> {
                enabled.world = true;
                yield BooleanSupplierElement.IS_THUNDERING;
            }
            case "snowing" -> {
                enabled.world = true;
                yield BooleanSupplierElement.IS_SNOWING;
            }
            case "slime_chunk" -> {
                enabled.world = true;
                yield BooleanSupplierElement.IS_SLIME_CHUNK;
            }
            case "sprinting" -> BooleanSupplierElement.SPRINTING;
            case "sneaking" -> BooleanSupplierElement.SNEAKING;
            case "swimming" -> BooleanSupplierElement.SWIMMING;
            case "flying" -> BooleanSupplierElement.FLYING;
            case "gliding", "flying_with_style" -> BooleanSupplierElement.FALLING_WITH_STYLE;
            case "on_ground" -> BooleanSupplierElement.ON_GROUND;
            case "sprint_held" -> BooleanSupplierElement.SPRINT_HELD;
            case "is_frozen" -> BooleanSupplierElement.IS_FROZEN;
            case "is_freezing" -> BooleanSupplierElement.IS_FREEZING;
            case "on_fire" -> BooleanSupplierElement.IS_ON_FIRE;
            case "hud_hidden" -> BooleanSupplierElement.HUD_HIDDEN;
            case "screen_open" -> BooleanSupplierElement.SCREEN_OPEN;
            case "chat_open" -> BooleanSupplierElement.CHAT_OPEN;
            case "player_list_open", "tab_open" -> BooleanSupplierElement.PLAYER_LIST_OPEN;
            case "window_focused" -> BooleanSupplierElement.WINDOW_FOCUSED;
            case "item_has_durability", "item_has_dur" -> BooleanSupplierElement.ITEM_HAS_DURABILITY;
            case "offhand_item_has_durability", "oitem_has_dur" -> BooleanSupplierElement.OFFHAND_ITEM_HAS_DURABILITY;
            case "fishing_is_cast" -> BooleanSupplierElement.FISHING_IS_CAST;
            case "fishing_is_hooked" -> BooleanSupplierElement.FISHING_IS_HOOKED;
            case "fishing_has_caught" -> BooleanSupplierElement.FISHING_HAS_CAUGHT;
            case "fishing_in_open_water" -> BooleanSupplierElement.FISHING_IN_OPEN_WATER;
            case "music_playing" -> {
                enabled.music = true;
                yield BooleanSupplierElement.MUSIC_PLAYING;
            }
            case "record_playing" -> {
                enabled.music = true;
                yield BooleanSupplierElement.RECORD_PLAYING;
            }
            case "has_noise" -> {
                enabled.serverWorld = true;
                yield BooleanSupplierElement.HAS_NOISE;
            }
            case "is_tick_sprinting", "tick_sprinting" -> BooleanSupplierElement.IS_TICK_SPRINTING;
            case "is_tick_frozen", "tick_frozen" -> BooleanSupplierElement.IS_TICK_FROZEN;
            case "is_tick_stepping", "tick_stepping" -> BooleanSupplierElement.IS_TICK_STEPPING;
            case "on_load" -> BooleanSupplierElement.ON_LOAD;
            case "on_join" -> BooleanSupplierElement.ON_JOIN;
            case "reaL_am" -> BooleanSupplierElement.REAL_AM;
            case "reaL_pm" -> BooleanSupplierElement.REAL_PM;
            default -> null;
        };
    }

    private static Supplier<Number> getIntegerSupplier(String element, ComplexData.Enabled enabled) {
        return switch (element) {
            case "profile_errors" -> IntegerSuppliers.PROFILE_ERRORS;
            case "fps" -> IntegerSuppliers.FPS;
            case "biome_blend" -> IntegerSuppliers.BIOME_BLEND;
            case "simulation_distance", "sd" -> IntegerSuppliers.SIMULATION_DISTANCE;
            case "packets_sent", "tx" -> IntegerSuppliers.PACKETS_SENT;
            case "packets_received", "rx" -> IntegerSuppliers.PACKETS_RECEIVED;
            case "chunks_rendered" -> IntegerSuppliers.CHUNKS_RENDERED;
            case "chunks_loaded" -> IntegerSuppliers.CHUNKS_LOADED;
            case "render_distance" -> IntegerSuppliers.RENDER_DISTANCE;
            case "queued_tasks" -> IntegerSuppliers.QUEUED_TASKS;
            case "upload_queue" -> IntegerSuppliers.UPLOAD_QUEUE;
            case "buffer_count" -> IntegerSuppliers.BUFFER_COUNT;
            case "entities_rendered" -> IntegerSuppliers.ENTITIES_RENDERED;
            case "entities_loaded" -> IntegerSuppliers.ENTITIES_LOADED;
            case "force_loaded_chunks", "fc" -> {
                enabled.world = true;
                yield IntegerSuppliers.FORCED_LOADED_CHUNKS;
            }
            case "block_x", "bx" -> IntegerSuppliers.BLOCK_X;
            case "block_y", "by" -> IntegerSuppliers.BLOCK_Y;
            case "block_z", "bz" -> IntegerSuppliers.BLOCK_Z;
            case "target_block_x", "target_x", "tbx" -> {
                enabled.targetBlock = true;
                enabled.world = true;
                yield IntegerSuppliers.TARGET_BLOCK_X;
            }
            case "target_block_y", "target_y", "tby" -> {
                enabled.targetBlock = true;
                enabled.world = true;
                yield IntegerSuppliers.TARGET_BLOCK_Y;
            }
            case "target_block_z", "target_z", "tbz" -> {
                enabled.targetBlock = true;
                enabled.world = true;
                yield IntegerSuppliers.TARGET_BLOCK_Z;
            }
            case "target_block_distance", "target_distance", "tbd" -> {
                enabled.targetBlock = true;
                enabled.world = true;
                yield IntegerSuppliers.TARGET_BLOCK_DISTANCE;
            }
            case "target_block_color", "target_color", "tbc" -> {
                enabled.targetBlock = true;
                enabled.world = true;
                yield IntegerSuppliers.TARGET_BLOCK_COLOR;
            }
            case "target_block_luminance", "target_luminance", "tbl" -> {
                enabled.targetBlock = true;
                enabled.world = true;
                yield IntegerSuppliers.TARGET_BLOCK_LUMINANCE;
            }
            case "target_fluid_x", "tfx" -> {
                enabled.targetFluid = true;
                enabled.world = true;
                yield IntegerSuppliers.TARGET_FLUID_X;
            }
            case "target_fluid_y", "tfy" -> {
                enabled.targetFluid = true;
                enabled.world = true;
                yield IntegerSuppliers.TARGET_FLUID_Y;
            }
            case "target_fluid_z", "tfz" -> {
                enabled.targetFluid = true;
                enabled.world = true;
                yield IntegerSuppliers.TARGET_FLUID_Z;
            }
            case "target_fluid_distance", "tfd" -> {
                enabled.targetFluid = true;
                enabled.world = true;
                yield IntegerSuppliers.TARGET_FLUID_DISTANCE;
            }
            case "target_fluid_color", "tfc" -> {
                enabled.targetFluid = true;
                enabled.world = true;
                yield IntegerSuppliers.TARGET_FLUID_COLOR;
            }
            case "target_villager_level", "tvl" -> {
                enabled.targetVillager = true;
                enabled.targetEntity = true;
                yield IntegerSuppliers.VILLAGER_LEVEL;
            }
            case "target_villager_xp", "tve" -> {
                enabled.targetVillager = true;
                enabled.targetEntity = true;
                yield IntegerSuppliers.VILLAGER_XP;
            }
            case "target_villager_xp_needed", "tven" -> {
                enabled.targetVillager = true;
                enabled.targetEntity = true;
                yield IntegerSuppliers.VILLAGER_XP_NEEDED;
            }
            case "vehicle_entity_armor", "vehicle_armor", "vea" -> EntitySuppliers.VEHICLE_ENTITY_ARMOR;
            case "target_block_power", "target_power", "tbp" -> {
                enabled.targetBlock = true;
                enabled.world = true;
                yield IntegerSuppliers.TARGET_BLOCK_POWERED;
            }
            case "target_block_power_north", "target_power_north", "tbpn" -> {
                enabled.targetBlock = true;
                enabled.world = true;
                yield IntegerSuppliers.TARGET_BLOCK_POWERED_NORTH;
            }
            case "target_block_power_south", "target_power_south", "tbps" -> {
                enabled.targetBlock = true;
                enabled.world = true;
                yield IntegerSuppliers.TARGET_BLOCK_POWERED_SOUTH;
            }
            case "target_block_power_east", "target_power_east", "tbpe" -> {
                enabled.targetBlock = true;
                enabled.world = true;
                yield IntegerSuppliers.TARGET_BLOCK_POWERED_EAST;
            }
            case "target_block_power_west", "target_power_west", "tbpw" -> {
                enabled.targetBlock = true;
                enabled.world = true;
                yield IntegerSuppliers.TARGET_BLOCK_POWERED_WEST;
            }
            case "target_block_power_up", "target_power_up", "tbpu" -> {
                enabled.targetBlock = true;
                enabled.world = true;
                yield IntegerSuppliers.TARGET_BLOCK_POWERED_UP;
            }
            case "target_block_power_down", "target_power_down", "tbpd" -> {
                enabled.targetBlock = true;
                enabled.world = true;
                yield IntegerSuppliers.TARGET_BLOCK_POWERED_DOWN;
            }
            case "target_block_strong_power", "target_strong_power", "tbsp" -> {
                enabled.targetBlock = true;
                enabled.world = true;
                yield IntegerSuppliers.TARGET_BLOCK_STRONG_POWERED;
            }
            case "target_block_strong_power_north", "target_strong_power_north", "tbspn" -> {
                enabled.targetBlock = true;
                enabled.world = true;
                yield IntegerSuppliers.TARGET_BLOCK_STRONG_POWERED_NORTH;
            }
            case "target_block_strong_power_south", "target_strong_power_south", "tbsps" -> {
                enabled.targetBlock = true;
                enabled.world = true;
                yield IntegerSuppliers.TARGET_BLOCK_STRONG_POWERED_SOUTH;
            }
            case "target_block_strong_power_east", "target_strong_power_east", "tbspe" -> {
                enabled.targetBlock = true;
                enabled.world = true;
                yield IntegerSuppliers.TARGET_BLOCK_STRONG_POWERED_EAST;
            }
            case "target_block_strong_power_west", "target_strong_power_west", "tbspw" -> {
                enabled.targetBlock = true;
                enabled.world = true;
                yield IntegerSuppliers.TARGET_BLOCK_STRONG_POWERED_WEST;
            }
            case "target_block_strong_power_up", "target_strong_power_up", "tbspu" -> {
                enabled.targetBlock = true;
                enabled.world = true;
                yield IntegerSuppliers.TARGET_BLOCK_STRONG_POWERED_UP;
            }
            case "target_block_strong_power_down", "target_strong_power_down", "tbspd" -> {
                enabled.targetBlock = true;
                enabled.world = true;
                yield IntegerSuppliers.TARGET_BLOCK_STRONG_POWERED_DOWN;
            }
            case "in_chunk_x", "icx" -> IntegerSuppliers.IN_CHUNK_X;
            case "in_chunk_y", "icy" -> IntegerSuppliers.IN_CHUNK_Y;
            case "in_chunk_z", "icz" -> IntegerSuppliers.IN_CHUNK_Z;
            case "chunk_x", "cx" -> IntegerSuppliers.CHUNK_X;
            case "chunk_y", "cy" -> IntegerSuppliers.CHUNK_Y;
            case "chunk_z", "cz" -> IntegerSuppliers.CHUNK_Z;
            case "region_x", "rex" -> IntegerSuppliers.REGION_X;
            case "region_z", "rez" -> IntegerSuppliers.REGION_Z;
            case "region_relative_x", "rrx" -> IntegerSuppliers.REGION_RELATIVE_X;
            case "region_relative_z", "rrz" -> IntegerSuppliers.REGION_RELATIVE_Z;
            case "ccw1", "client_chunks_w1", "client_chunks_cached" -> IntegerSuppliers.CHUNK_CLIENT_CACHED;
            case "ccw2", "client_chunks_w2", "client_chunks_loaded" -> IntegerSuppliers.CHUNK_CLIENT_LOADED;
            case "cce1", "client_chunks_e1", "client_entities_loaded" -> IntegerSuppliers.CHUNK_CLIENT_ENTITIES_LOADED;
            case "cce2", "client_chunks_e2", "client_entities_cached_sections" -> IntegerSuppliers.CHUNK_CLIENT_ENTITIES_CACHED_SECTIONS;
            case "cce3", "client_chunks_e3", "client_entities_ticking_chunks" -> IntegerSuppliers.CHUNK_CLIENT_ENTITIES_TICKING_CHUNKS;
            case "scw1", "server_chunks_w1", "server_chunks_loaded" -> {
                enabled.serverWorld = true;
                yield IntegerSuppliers.CHUNK_SERVER_LOADED;
            }
            case "sce1", "server_chunks_e1", "server_entities_registered" -> {
                enabled.serverWorld = true;
                yield IntegerSuppliers.CHUNK_SERVER_ENTITIES_REGISTERED;
            }
            case "sce2", "server_chunks_e2", "server_entities_loaded" -> {
                enabled.serverWorld = true;
                yield IntegerSuppliers.CHUNK_SERVER_ENTITIES_LOADED;
            }
            case "sce3", "server_chunks_e3", "server_entities_cached_sections" -> {
                enabled.serverWorld = true;
                yield IntegerSuppliers.CHUNK_SERVER_ENTITIES_CACHED_SECTIONS;
            }
            case "sce4", "server_chunks_e4", "server_entities_managed" -> {
                enabled.serverWorld = true;
                yield IntegerSuppliers.CHUNK_SERVER_ENTITIES_MANAGED;
            }
            case "sce5", "server_chunks_e5", "server_entities_tracked" -> {
                enabled.serverWorld = true;
                yield IntegerSuppliers.CHUNK_SERVER_ENTITIES_TRACKED;
            }
            case "sce6", "server_chunks_e6", "server_entities_loading" -> {
                enabled.serverWorld = true;
                yield IntegerSuppliers.CHUNK_SERVER_ENTITIES_LOADING;
            }
            case "sce7", "server_chunks_e7", "server_entities_unloading" -> {
                enabled.serverWorld = true;
                yield IntegerSuppliers.CHUNK_SERVER_ENTITIES_UNLOADING;
            }
            case "client_light", "light" -> {
                enabled.clientChunk = true;
                yield IntegerSuppliers.CLIENT_LIGHT;
            }
            case "client_light_sky", "light_sky" -> {
                enabled.clientChunk = true;
                yield IntegerSuppliers.CLIENT_LIGHT_SKY;
            }
            case "client_light_sun", "light_sun" -> {
                enabled.clientChunk = true;
                yield IntegerSuppliers.CLIENT_LIGHT_SUN;
            }
            case "client_light_block", "light_block" -> {
                enabled.clientChunk = true;
                yield IntegerSuppliers.CLIENT_LIGHT_BLOCK;
            }
            case "server_light_sky" -> {
                enabled.serverChunk = true;
                enabled.world = true;
                yield IntegerSuppliers.SERVER_LIGHT_SKY;
            }
            case "server_light_block" -> {
                enabled.serverChunk = true;
                enabled.world = true;
                yield IntegerSuppliers.SERVER_LIGHT_BLOCK;
            }
            case "client_height_map_surface", "chs" -> {
                enabled.clientChunk = true;
                yield IntegerSuppliers.CLIENT_HEIGHT_MAP_SURFACE;
            }
            case "client_height_map_motion_blocking", "chm" -> {
                enabled.clientChunk = true;
                yield IntegerSuppliers.CLIENT_HEIGHT_MAP_MOTION_BLOCKING;
            }
            case "server_height_map_surface", "shs" -> {
                enabled.serverChunk = true;
                yield IntegerSuppliers.SERVER_HEIGHT_MAP_SURFACE;
            }
            case "server_height_map_ocean_floor", "sho" -> {
                enabled.serverChunk = true;
                yield IntegerSuppliers.SERVER_HEIGHT_MAP_OCEAN_FLOOR;
            }
            case "server_height_map_motion_blocking", "shm" -> {
                enabled.serverChunk = true;
                yield IntegerSuppliers.SERVER_HEIGHT_MAP_MOTION_BLOCKING;
            }
            case "server_height_map_motion_blocking_no_leaves", "shml" -> {
                enabled.serverChunk = true;
                yield IntegerSuppliers.SERVER_HEIGHT_MAP_MOTION_BLOCKING_NO_LEAVES;
            }
            case "world_min_y", "min_y" -> {
                enabled.world = true;
                yield IntegerSuppliers.WORLD_MIN_Y;
            }
            case "world_max_y", "max_y" -> {
                enabled.world = true;
                yield IntegerSuppliers.WORLD_MAX_Y;
            }
            case "world_height" -> {
                enabled.world = true;
                yield IntegerSuppliers.WORLD_HEIGHT;
            }
            case "world_coord_scale", "coord_scale" -> {
                enabled.world = true;
                yield IntegerSuppliers.WORLD_COORD_SCALE;
            }
            case "moon_phase" -> {
                enabled.clientChunk = true;
                yield IntegerSuppliers.MOON_PHASE;
            }
            case "spawn_chunks", "sc" -> {
                enabled.serverWorld = true;
                yield IntegerSuppliers.SPAWN_CHUNKS;
            }
            case "monsters" -> {
                enabled.serverWorld = true;
                yield IntegerSuppliers.MONSTERS;
            }
            case "creatures" -> {
                enabled.serverWorld = true;
                yield IntegerSuppliers.CREATURES;
            }
            case "ambient_mobs" -> {
                enabled.serverWorld = true;
                yield IntegerSuppliers.AMBIENT_MOBS;
            }
            case "water_creatures" -> {
                enabled.serverWorld = true;
                yield IntegerSuppliers.WATER_CREATURES;
            }
            case "water_ambient_mobs" -> {
                enabled.serverWorld = true;
                yield IntegerSuppliers.WATER_AMBIENT_MOBS;
            }
            case "underground_water_creatures" -> {
                enabled.serverWorld = true;
                yield IntegerSuppliers.UNDERGROUND_WATER_CREATURE;
            }
            case "axolotls" -> {
                enabled.serverWorld = true;
                yield IntegerSuppliers.AXOLOTLS;
            }
            case "misc_mobs" -> {
                enabled.serverWorld = true;
                yield IntegerSuppliers.MISC_MOBS;
            }
            case "java_bit" -> IntegerSuppliers.JAVA_BIT;
            case "cpu_cores" -> {
                enabled.cpu = true;
                yield IntegerSuppliers.CPU_CORES;
            }
            case "cpu_threads" -> {
                enabled.cpu = true;
                yield IntegerSuppliers.CPU_THREADS;
            }
            case "display_width" -> IntegerSuppliers.DISPLAY_WIDTH;
            case "display_height" -> IntegerSuppliers.DISPLAY_HEIGHT;
            case "display_refresh_rate" -> IntegerSuppliers.DISPLAY_REFRESH_RATE;
            case "ping" -> {
                enabled.pingMetrics = true;
                yield IntegerSuppliers.PING;
            }
            case "latency" -> IntegerSuppliers.LATENCY;
            case "time", "solar_time" -> IntegerSuppliers.SOLAR_TIME;
            case "lunar_time" -> IntegerSuppliers.LUNAR_TIME;
            case "particles", "p" -> IntegerSuppliers.PARTICLES;
            case "streaming_sounds", "sounds" -> IntegerSuppliers.STREAMING_SOUNDS;
            case "max_streaming_sounds", "max_sounds" -> IntegerSuppliers.MAX_STREAMING_SOUNDS;
            case "static_sounds" -> IntegerSuppliers.STATIC_SOUNDS;
            case "max_static_sounds" -> IntegerSuppliers.MAX_STATIC_SOUNDS;
            case "slots_used" -> {
                enabled.slots = true;
                yield IntegerSuppliers.SLOTS_USED;
            }
            case "slots_empty" -> {
                enabled.slots = true;
                yield IntegerSuppliers.SLOTS_EMPTY;
            }
            case "health", "hp" -> IntegerSuppliers.HEALTH;
            case "max_health", "max_hp" -> IntegerSuppliers.HEALTH_MAX;
            case "food", "hunger" -> IntegerSuppliers.FOOD_LEVEL;
            case "food_per", "food_percentage" -> IntegerSuppliers.FOOD_LEVEL_PERCENTAGE;
            case "saturation" -> IntegerSuppliers.SATURATION_LEVEL;
            case "saturation_per", "saturation_percentage" -> IntegerSuppliers.SATURATION_LEVEL_PERCENTAGE;
            case "armor", "armour" -> IntegerSuppliers.ARMOR_LEVEL;
            case "armor_per", "armor_percentage", "armour_per", "armour_percentage" -> IntegerSuppliers.ARMOR_LEVEL_PERCENTAGE;
            case "air" -> IntegerSuppliers.AIR_LEVEL;
            case "score" -> IntegerSuppliers.SCORE;
            case "xp_level" -> IntegerSuppliers.XP_LEVEL;
            case "xp" -> IntegerSuppliers.XP_POINTS;
            case "xp_needed" -> IntegerSuppliers.XP_POINTS_NEEDED;
            case "bb_erosion", "biome_builder_erosion" -> {
                enabled.serverWorld = true;
                yield IntegerSuppliers.BIOME_BUILDER_EROSION;
            }
            case "bb_temp", "biome_builder_temperature" -> {
                enabled.serverWorld = true;
                yield IntegerSuppliers.BIOME_BUILDER_TEMPERATURE;
            }
            case "bb_veg", "biome_builder_vegetation" -> {
                enabled.serverWorld = true;
                yield IntegerSuppliers.BIOME_BUILDER_VEGETATION;
            }
            case "hotbar_slot" -> IntegerSuppliers.HOTBAR_SLOT;
            case "hotbar_index" -> IntegerSuppliers.HOTBAR_INDEX;
            case "item_durability", "item_dur" -> IntegerSuppliers.ITEM_DURABILITY;
            case "item_max_durability", "item_max_dur" -> IntegerSuppliers.ITEM_MAX_DURABILITY;
            case "offhand_item_durability", "oitem_dur" -> IntegerSuppliers.OFFHAND_ITEM_DURABILITY;
            case "offhand_item_max_durability", "oitem_max_dur" -> IntegerSuppliers.OFFHAND_ITEM_MAX_DURABILITY;
            case "lcps" -> {
                enabled.clicksPerSeconds = true;
                yield IntegerSuppliers.LCPS;
            }
            case "rcps" -> {
                enabled.clicksPerSeconds = true;
                yield IntegerSuppliers.RCPS;
            }
            case "hour12", "hour", "hours12", "hours" -> {
                enabled.time = true;
                yield IntegerSuppliers.TIME_HOUR_12;
            }
            case "unix_time" -> IntegerSuppliers.UNIX_TIME;
            case "real_year" -> IntegerSuppliers.REAL_YEAR;
            case "real_month" -> IntegerSuppliers.REAL_MONTH;
            case "real_day" -> IntegerSuppliers.REAL_DAY;
            case "real_day_of_week", "real_dow" -> IntegerSuppliers.REAL_DAY_OF_WEEK;
            case "real_day_of_year", "real_doy" -> IntegerSuppliers.REAL_DAY_OF_YEAR;
            case "real_hour12", "real_hour" -> IntegerSuppliers.REAL_HOUR_12;
            case "real_hour24" -> IntegerSuppliers.REAL_HOUR_24;
            case "real_minute" -> IntegerSuppliers.REAL_MINUTE;
            case "real_second" -> IntegerSuppliers.REAL_SECOND;
            case "real_millisecond", "real_ms" -> IntegerSuppliers.REAL_MICROSECOND;
            case "resource_pack_major_version", "rp_major", "rp_major_version" -> IntegerSuppliers.RESOURCE_PACK_VERSION_MAJOR;
            case "resource_pack_minor_version", "rp_minor", "rp_minor_version" -> IntegerSuppliers.RESOURCE_PACK_VERSION_MINOR;
            case "data_pack_major_version", "datapack_major_version", "dp_major" -> IntegerSuppliers.DATA_PACK_VERSION_MAJOR;
            case "data_pack_minor_version", "datapack_minor_version", "dp_minor" -> IntegerSuppliers.DATA_PACK_VERSION_MINOR;
            case "mainhand_slot" -> IntegerSuppliers.MAINHAND_SLOT;
            default -> null;
        };
    }

    private static NumberSupplierElement.Entry getDecimalSupplier(String element, ComplexData.Enabled enabled) {
        return switch (element) {
            case "x" -> EntryNumberSuppliers.X;
            case "y" -> EntryNumberSuppliers.Y;
            case "z" -> EntryNumberSuppliers.Z;
            case "nether_x", "nx" -> EntryNumberSuppliers.NETHER_X;
            case "nether_z", "nz" -> EntryNumberSuppliers.NETHER_Z;
            case "target_entity_x", "tex" -> {
                enabled.targetEntity = true;
                yield EntitySuppliers.TARGET_ENTITY_X;
            }
            case "target_entity_y", "tey" -> {
                enabled.targetEntity = true;
                yield EntitySuppliers.TARGET_ENTITY_Y;
            }
            case "target_entity_z", "tez" -> {
                enabled.targetEntity = true;
                yield EntitySuppliers.TARGET_ENTITY_Z;
            }
            case "target_entity_distance", "ted" -> {
                enabled.targetEntity = true;
                yield EntitySuppliers.TARGET_ENTITY_DISTANCE;
            }
            case "last_hit_distance", "lhd" -> {
                enabled.targetEntity = true;
                yield EntitySuppliers.LAST_HIT_ENTITY_DISTANCE;
            }
            case "last_hit_ago", "lha" -> {
                enabled.targetEntity = true;
                yield EntitySuppliers.LAST_HIT_ENTITY_AGO;
            }
            case "hooked_entity_x", "hex" -> EntitySuppliers.HOOKED_ENTITY_X;
            case "hooked_entity_y", "hey" -> EntitySuppliers.HOOKED_ENTITY_Y;
            case "hooked_entity_z", "hez" -> EntitySuppliers.HOOKED_ENTITY_Z;
            case "hooked_entity_distance", "hed" -> EntitySuppliers.HOOKED_ENTITY_DISTANCE;
            case "hooked_entity_direction_yaw", "hedy" -> EntitySuppliers.HOOKED_ENTITY_DIRECTION_YAW;
            case "hooked_entity_direction_pitch", "hedp" -> EntitySuppliers.HOOKED_ENTITY_DIRECTION_PITCH;
            case "vehicle_entity_health", "vehicle_health", "veh" -> EntitySuppliers.VEHICLE_ENTITY_HEALTH;
            case "vehicle_entity_max_health", "vehicle_max_health", "vemh" -> EntitySuppliers.VEHICLE_ENTITY_MAX_HEALTH;
            case "vehicle_horse_jump", "horse_jump", "vhj" -> EntitySuppliers.VEHICLE_HORSE_JUMP;
            case "entity_reach_distance", "reach_distance", "entity_reach", "reach" -> EntryNumberSuppliers.ENTITY_REACH_DISTANCE;
            case "block_reach_distance", "block_reach" -> EntryNumberSuppliers.BLOCK_REACH_DISTANCE;
            case "fishing_hook_distance" -> EntryNumberSuppliers.FISHING_HOOK_DISTANCE;
            case "yaw" -> EntryNumberSuppliers.YAW;
            case "pitch" -> EntryNumberSuppliers.PITCH;
            case "day" -> EntryNumberSuppliers.DAY;
            case "mood" -> EntryNumberSuppliers.MOOD;
            case "tps" -> EntryNumberSuppliers.TPS;
            case "max_tps" -> {
                enabled.world = true;
                yield EntryNumberSuppliers.MAX_TPS;
            }
            case "memory_used_percentage" -> EntryNumberSuppliers.MEMORY_USED_PERCENTAGE;
            case "memory_used" -> EntryNumberSuppliers.MEMORY_USED;
            case "memory_total" -> EntryNumberSuppliers.TOTAL_MEMORY;
            case "memory_allocated_percentage" -> EntryNumberSuppliers.ALLOCATED_PERCENTAGE;
            case "memory_allocated" -> EntryNumberSuppliers.ALLOCATED;
            case "memory_allocation_rate" -> EntryNumberSuppliers.ALLOCATION_RATE;
            case "cpu_usage", "cpu" -> {
                enabled.cpu = true;
                enabled.cpuUsage = true;
                yield EntryNumberSuppliers.CPU_USAGE;
            }
            case "gpu_usage", "gpu" -> {
                enabled.gpuMetrics = true;
                yield EntryNumberSuppliers.GPU_USAGE;
            }
            case "ms_per_tick" -> {
                enabled.world = true;
                yield EntryNumberSuppliers.MS_PER_TICK;
            }
            case "ms_ticks", "tick_ms" -> EntryNumberSuppliers.TICK_MS;
            case "frame_ms_min" -> {
                enabled.frameMetrics = true;
                yield EntryNumberSuppliers.FRAME_MS_MIN;
            }
            case "frame_ms_max" -> {
                enabled.frameMetrics = true;
                yield EntryNumberSuppliers.FRAME_MS_MAX;
            }
            case "frame_ms_avg" -> {
                enabled.frameMetrics = true;
                yield EntryNumberSuppliers.FRAME_MS_AVG;
            }
            case "fps_min" -> {
                enabled.frameMetrics = true;
                yield EntryNumberSuppliers.FPS_MIN;
            }
            case "fps_max" -> {
                enabled.frameMetrics = true;
                yield EntryNumberSuppliers.FPS_MAX;
            }
            case "fps_avg" -> {
                enabled.frameMetrics = true;
                yield EntryNumberSuppliers.FPS_AVG;
            }
            case "frame_ms_samples", "fps_samples" -> {
                enabled.frameMetrics = true;
                yield EntryNumberSuppliers.FRAME_MS_SAMPLES;
            }
            case "tick_ms_min" -> {
                enabled.tickMetrics = true;
                yield EntryNumberSuppliers.TICK_MS_MIN;
            }
            case "tick_ms_max" -> {
                enabled.tickMetrics = true;
                yield EntryNumberSuppliers.TICK_MS_MAX;
            }
            case "tick_ms_avg" -> {
                enabled.tickMetrics = true;
                yield EntryNumberSuppliers.TICK_MS_AVG;
            }
            case "tick_ms_samples" -> {
                enabled.tickMetrics = true;
                yield EntryNumberSuppliers.TICK_MS_SAMPLES;
            }
            case "tps_min" -> {
                enabled.tpsMetrics = true;
                yield EntryNumberSuppliers.TPS_MIN;
            }
            case "tps_max" -> {
                enabled.tpsMetrics = true;
                yield EntryNumberSuppliers.TPS_MAX;
            }
            case "tps_avg" -> {
                enabled.tpsMetrics = true;
                yield EntryNumberSuppliers.TPS_AVG;
            }
            case "tps_samples" -> {
                enabled.tpsMetrics = true;
                yield EntryNumberSuppliers.TPS_SAMPLES;
            }
            case "ping_min" -> {
                enabled.pingMetrics = true;
                yield EntryNumberSuppliers.PING_MIN;
            }
            case "ping_max" -> {
                enabled.pingMetrics = true;
                yield EntryNumberSuppliers.PING_MAX;
            }
            case "ping_avg" -> {
                enabled.pingMetrics = true;
                yield EntryNumberSuppliers.PING_AVG;
            }
            case "ping_samples" -> {
                enabled.pingMetrics = true;
                yield EntryNumberSuppliers.PING_SAMPLES;
            }
            case "packet_size_min" -> {
                enabled.packetMetrics = true;
                yield EntryNumberSuppliers.PACKET_SIZE_MIN;
            }
            case "packet_size_max" -> {
                enabled.packetMetrics = true;
                yield EntryNumberSuppliers.PACKET_SIZE_MAX;
            }
            case "packet_size_avg" -> {
                enabled.packetMetrics = true;
                yield EntryNumberSuppliers.PACKET_SIZE_AVG;
            }
            case "packet_size_samples" -> {
                enabled.packetMetrics = true;
                yield EntryNumberSuppliers.PACKET_SIZE_SAMPLES;
            }
            case "slots_percentage", "slots_per" -> {
                enabled.slots = true;
                yield EntryNumberSuppliers.SLOTS_PERCENTAGE;
            }
            case "record_elapsed_percentage", "record_elapsed_per" -> {
                enabled.music = true;
                yield EntryNumberSuppliers.RECORD_ELAPSED_PER;
            }
            case "record_length" -> {
                enabled.music = true;
                yield EntryNumberSuppliers.RECORD_LENGTH;
            }
            case "record_elapsed" -> {
                enabled.music = true;
                yield EntryNumberSuppliers.RECORD_ELAPSED;
            }
            case "record_remaining" -> {
                enabled.music = true;
                yield EntryNumberSuppliers.RECORD_REMAINING;
            }
            case "xp_per", "xp_percentage" -> EntryNumberSuppliers.XP_POINTS_PER;
            case "air_per", "air_percentage" -> EntryNumberSuppliers.AIR_LEVEL_PERCENTAGE;
            case "health_per", "health_percentage", "hp_per" -> EntryNumberSuppliers.HEALTH_PERCENTAGE;
            case "frozen_per", "frozen_percentage" -> EntryNumberSuppliers.FROZEN_PERCENTAGE;
            case "frozen_ticks" -> EntryNumberSuppliers.FROZEN_TICKS;
            case "attack_cooldown" -> EntryNumberSuppliers.ATTACK_COOLDOWN;
            case "nr_temp", "noise_temperature" -> {
                enabled.serverWorld = true;
                yield EntryNumberSuppliers.NOISE_ROUTER_TEMPERATURE;
            }
            case "nr_veg", "noise_vegetation" -> {
                enabled.serverWorld = true;
                yield EntryNumberSuppliers.NOISE_ROUTER_VEGETATION;
            }
            case "nr_cont", "noise_continents" -> {
                enabled.serverWorld = true;
                yield EntryNumberSuppliers.NOISE_ROUTER_CONTINENTS;
            }
            case "nr_erosion", "noise_erosion" -> {
                enabled.serverWorld = true;
                yield EntryNumberSuppliers.NOISE_ROUTER_EROSION;
            }
            case "nr_depth", "noise_depth" -> {
                enabled.serverWorld = true;
                yield EntryNumberSuppliers.NOISE_ROUTER_DEPTH;
            }
            case "nr_ridges", "noise_ridges" -> {
                enabled.serverWorld = true;
                yield EntryNumberSuppliers.NOISE_ROUTER_RIDGES;
            }
            case "nr_peaks", "noise_peaks" -> {
                enabled.serverWorld = true;
                yield EntryNumberSuppliers.NOISE_ROUTER_PEAKS;
            }
            case "nr_init", "noise_init_density" -> {
                enabled.serverWorld = true;
                yield EntryNumberSuppliers.NOISE_ROUTER_INIT_DENSITY;
            }
            case "nr_final", "noise_final_density" -> {
                enabled.serverWorld = true;
                yield EntryNumberSuppliers.NOISE_ROUTER_FINAL_DENSITY;
            }
            case "item_durability_percent", "item_dur_per" -> EntryNumberSuppliers.ITEM_DURABILITY_PERCENT;
            case "offhand_item_durability_percent", "oitem_dur_per" -> EntryNumberSuppliers.OFFHAND_ITEM_DURABILITY_PERCENT;
            case "local_difficulty" -> {
                enabled.world = true;
                enabled.localDifficulty = true;
                yield EntryNumberSuppliers.LOCAL_DIFFICULTY;
            }
            case "clamped_local_difficulty" -> {
                enabled.world = true;
                enabled.localDifficulty = true;
                yield EntryNumberSuppliers.CLAMPED_LOCAL_DIFFICULTY;
            }
            case "actionbar_remaining" -> EntryNumberSuppliers.ACTIONBAR_REMAINING;
            case "title_remaining" -> EntryNumberSuppliers.TITLE_REMAINING;
            case "pi", "\u03c0" -> EntryNumberSuppliers.PI;
            case "tau", "\u03c4" -> EntryNumberSuppliers.TAU;
            case "phi", "\u03c6", "golden_ratio" -> EntryNumberSuppliers.PHI;
            case "e" -> EntryNumberSuppliers.E;
            default -> null;
        };
    }

    private static SpecialSupplierElement.Entry getSpecialSupplierElements(String element, ComplexData.Enabled enabled) {
        return switch (element) {
            case "difficulty" -> SpecialSupplierElement.DIFFICULTY;
            case "max_fps" -> SpecialSupplierElement.MAX_FPS;
            case "profile_keybind" -> SpecialSupplierElement.PROFILE_KEYBIND;
            case "hour24", "hours25" -> {
                enabled.time = true;
                yield SpecialSupplierElement.TIME_HOUR_24;
            }
            case "minute", "minutes" -> {
                enabled.time = true;
                yield SpecialSupplierElement.TIME_MINUTES;
            }
            case "second", "seconds" -> {
                enabled.time = true;
                yield SpecialSupplierElement.TIME_SECONDS;
            }
            case "target_block", "tb" -> {
                enabled.targetBlock = true;
                enabled.world = true;
                yield SpecialSupplierElement.TARGET_BLOCK;
            }
            case "target_fluid", "tf" -> {
                enabled.targetFluid = true;
                enabled.world = true;
                yield SpecialSupplierElement.TARGET_FLUID;
            }
            case "item" -> SpecialSupplierElement.ITEM_OLD;
            case "item_name" -> SpecialSupplierElement.ITEM_NAME;
            case "offhand_item", "oitem" -> SpecialSupplierElement.OFFHAND_ITEM;
            case "offhand_item_name" -> SpecialSupplierElement.OFFHAND_ITEM_NAME;
            case "clouds" -> SpecialSupplierElement.CLOUDS;
            case "graphics_mode" -> SpecialSupplierElement.GRAPHICS_MODE;
            case "facing_towards_pn_word" -> SpecialSupplierElement.FACING_TOWARDS_PN_WORD;
            case "facing_towards_pn_sign" -> SpecialSupplierElement.FACING_TOWARDS_PN_SIGN;
            case "gamemode" -> SpecialSupplierElement.GAMEMODE;
            case "active_renderer" -> SpecialSupplierElement.ACTIVE_RENDERER;
            case "perspective" -> SpecialSupplierElement.CAMERA_PERSPECTIVE;
            default -> null;
        };
    }

    private static SpecialIdSupplier.Entry getSpecialIdSupplierElements(String element, ComplexData.Enabled enabled) {
        return switch (element) {
            case "target_block_id", "tbi" -> {
                enabled.targetBlock = true;
                enabled.world = true;
                yield SpecialIdSupplier.TARGET_BLOCK_ID;
            }
            case "target_fluid_id", "tfi" -> {
                enabled.targetFluid = true;
                enabled.world = true;
                yield SpecialIdSupplier.TARGET_FLUID_ID;
            }
            case "item_id" -> SpecialIdSupplier.ITEM_ID;
            case "offhand_item_id", "oitem_id" -> SpecialIdSupplier.OFFHAND_ITEM_ID;
            default -> null;
        };
    }

    private static HudElement getListSupplierElements(String part, Profile profile, int debugLine, ComplexData.Enabled enabled, String original, ListProviderSet listProviders) {
        ListProviderSet.Entry provider;
        List<String> parts = VariableParser.partitionConditional(part);
        if (parts.isEmpty()) {
            Errors.addError(profile.name, debugLine, original, ErrorType.UNKNOWN_SLOT, "WHY U EMPTY");
            return null;
        }
        String[] flagParts = parts.get(0).split(" ");
        String providerName = flagParts[0];
        int dotIndex = providerName.indexOf(46);
        if (dotIndex != -1) {
            providerName = providerName.substring(0, dotIndex);
        }
        if ((provider = VariableParser.getListProvider(parts.get(0), profile, debugLine, enabled, original, listProviders)) == null) {
            return null;
        }
        listProviders = listProviders.with(provider);
        if (provider.provider() == ListProvider.REGUIRES_MODMENU) {
            Errors.addError(profile.name, debugLine, original, ErrorType.REQUIRES_MODMENU, "");
            return new FunctionalElement.IgnoreErrorElement();
        }
        if (parts.size() == 1) {
            String attr = dotIndex == -1 ? "" : parts.get(0).substring(dotIndex + 1);
            HudElement attribute = Attributers.get(listProviders, attr, new Flags(), profile, debugLine);
            if (attribute == null) {
                Errors.addError(profile.name, debugLine, original, ErrorType.UNKNOWN_ATTRIBUTE, attr);
            }
            return new ListCountElement(provider, attribute);
        }
        String format = parts.get(1).trim();
        if (!VariableParser.inQuotes(format)) {
            Errors.addError(profile.name, debugLine, original, ErrorType.MALFORMED_LIST, "format part not in quotations");
            return null;
        }
        format = format.substring(1, format.length() - 1);
        CustomHud.logInDebugMode("Format: " + format);
        Operation operation = null;
        String seperator = "";
        if (parts.size() > 2) {
            String sep;
            if (parts.size() > 3) {
                operation = ExpressionParser.parseExpression(parts.get(3), original, profile, debugLine, enabled, listProviders, true);
                CustomHud.logInDebugMode("Filter:");
                operation.printTree(2);
            }
            if (VariableParser.inQuotes(sep = parts.get(2).trim())) {
                seperator = sep.substring(1, sep.length() - 1);
                CustomHud.logInDebugMode("Separator: " + sep);
            } else if (parts.size() == 3) {
                operation = ExpressionParser.parseExpression(parts.get(2), original, profile, debugLine, enabled, listProviders, true);
                CustomHud.logInDebugMode("Filter:");
                operation.printTree(2);
            } else {
                Errors.addError(profile.name, debugLine, original, ErrorType.MALFORMED_LIST, "separator part not in quotations");
                return new FunctionalElement.IgnoreErrorElement();
            }
        }
        return ListElement.of(provider.provider(), provider.id(), VariableParser.addElements(format, profile, debugLine, enabled, false, listProviders), VariableParser.addElements(seperator, profile, debugLine, enabled, false, listProviders), operation, provider.reverse());
    }

    public static ListProviderSet.Entry getListProvider(String variable, Profile profile, int debugLine, ComplexData.Enabled enabled, String original, ListProviderSet listProviders) {
        ListProvider provider;
        if ((variable = variable.trim()).startsWith("loop")) {
            return VariableParser.getLoopProvider(variable, profile, debugLine, enabled, original, listProviders);
        }
        String[] flagParts = variable.split(" ");
        switch (variable = flagParts[0]) {
            case "effects": {
                ListProvider listProvider = ListSuppliers.STATUS_EFFECTS;
                break;
            }
            case "pos_effects": 
            case "positive_effects": {
                ListProvider listProvider = ListSuppliers.STATUS_EFFECTS_POSITIVE;
                break;
            }
            case "neg_effects": 
            case "negative_effects": {
                ListProvider listProvider = ListSuppliers.STATUS_EFFECTS_NEGATIVE;
                break;
            }
            case "neu_effects": 
            case "neutral_effects": {
                ListProvider listProvider = ListSuppliers.STATUS_EFFECTS_NEUTRAL;
                break;
            }
            case "players": {
                ListProvider listProvider = ListSuppliers.ONLINE_PLAYERS;
                break;
            }
            case "subtitles": {
                enabled.subtitles = true;
                ListProvider listProvider = ListSuppliers.SUBTITLES;
                break;
            }
            case "target_block_props": 
            case "target_block_properties": 
            case "tbprops": {
                enabled.targetBlock = true;
                enabled.world = true;
                ListProvider listProvider = ListSuppliers.TARGET_BLOCK_STATES;
                break;
            }
            case "target_block_tags": 
            case "target_tags": 
            case "tbt": {
                enabled.targetBlock = true;
                enabled.world = true;
                ListProvider listProvider = ListSuppliers.TARGET_BLOCK_TAGS;
                break;
            }
            case "target_block_powers": 
            case "target_powers": 
            case "tbpowers": {
                enabled.targetBlock = true;
                enabled.world = true;
                ListProvider listProvider = ListSuppliers.TARGET_BLOCK_POWERS;
                break;
            }
            case "target_fluid_props": 
            case "target_fluid_properties": 
            case "tfprops": {
                enabled.targetFluid = true;
                enabled.world = true;
                ListProvider listProvider = ListSuppliers.TARGET_FLUID_STATES;
                break;
            }
            case "target_fluid_tags": 
            case "tft": {
                enabled.targetFluid = true;
                enabled.world = true;
                ListProvider listProvider = ListSuppliers.TARGET_FLUID_TAGS;
                break;
            }
            case "attributes": {
                ListProvider listProvider = ListSuppliers.PLAYER_ATTRIBUTES;
                break;
            }
            case "target_entity_attributes": 
            case "target_entity_attrs": 
            case "teas": {
                enabled.targetEntity = true;
                ListProvider listProvider = ListSuppliers.TARGET_ENTITY_ATTRIBUTES;
                break;
            }
            case "hooked_entity_attributes": 
            case "hooked_entity_attrs": 
            case "heas": {
                ListProvider listProvider = ListSuppliers.HOOKED_ENTITY_ATTRIBUTES;
                break;
            }
            case "target_villager_offers": 
            case "tvo": {
                enabled.targetEntity = true;
                enabled.targetVillager = true;
                ListProvider listProvider = ListSuppliers.TARGET_VILLAGER_OFFERS;
                break;
            }
            case "teams": {
                ListProvider listProvider = ListSuppliers.TEAMS;
                break;
            }
            case "items": {
                ListProvider listProvider = ListSuppliers.ITEMS;
                break;
            }
            case "items_unpacked": {
                ListProvider listProvider = ListSuppliers.ITEMS_UNPACKED;
                break;
            }
            case "inventory_items": 
            case "inv_items": {
                ListProvider listProvider = ListSuppliers.INV_ITEMS;
                break;
            }
            case "armor_items": {
                ListProvider listProvider = ListSuppliers.ARMOR_ITEMS;
                break;
            }
            case "equipped_items": {
                ListProvider listProvider = ListSuppliers.EQUIPPED_ITEMS;
                break;
            }
            case "hotbar_items": {
                ListProvider listProvider = ListSuppliers.HOTBAR_ITEMS;
                break;
            }
            case "all_items": {
                ListProvider listProvider = ListSuppliers.ALL_ITEMS;
                break;
            }
            case "objectives": {
                ListProvider listProvider = ListSuppliers.SCOREBOARD_OBJECTIVES;
                break;
            }
            case "scores": {
                ListProvider listProvider = ListSuppliers.PLAYER_SCOREBOARD_SCORES;
                break;
            }
            case "bossbars": {
                ListProvider listProvider = ListSuppliers.BOSSBARS;
                break;
            }
            case "all_bossbars": {
                ListProvider listProvider = ListSuppliers.ALL_BOSSBARS;
                break;
            }
            case "profiler_timings": {
                enabled.profilerTimings = true;
                ListProvider listProvider = ListSuppliers.PROFILER_TIMINGS;
                break;
            }
            case "mods": {
                ListProvider listProvider;
                if (CustomHud.MODMENU_INSTALLED) {
                    listProvider = ListSuppliers.MODS;
                    break;
                }
                listProvider = ListProvider.REGUIRES_MODMENU;
                break;
            }
            case "all_root_mods": {
                ListProvider listProvider;
                if (CustomHud.MODMENU_INSTALLED) {
                    listProvider = ListSuppliers.ALL_ROOT_MODS;
                    break;
                }
                listProvider = ListProvider.REGUIRES_MODMENU;
                break;
            }
            case "all_mods": {
                ListProvider listProvider;
                if (CustomHud.MODMENU_INSTALLED) {
                    listProvider = ListSuppliers.ALL_MODS;
                    break;
                }
                listProvider = ListProvider.REGUIRES_MODMENU;
                break;
            }
            case "resource_packs": {
                ListProvider listProvider = ListSuppliers.RESOURCE_PACKS;
                break;
            }
            case "disabled_resource_packs": {
                ListProvider listProvider = ListSuppliers.DISABLED_RESOURCE_PACKS;
                break;
            }
            case "data_packs": 
            case "datapacks": {
                ListProvider listProvider = ListSuppliers.DATA_PACKS;
                break;
            }
            case "disabled_data_packs": 
            case "disabled_datapacks": {
                ListProvider listProvider = ListSuppliers.DISABLED_DATA_PACKS;
                break;
            }
            case "records": {
                enabled.music = true;
                ListProvider listProvider = ListSuppliers.RECORDS;
                break;
            }
            case "chat_messages": {
                ListProvider listProvider = ListSuppliers.CHAT_MESSAGES;
                break;
            }
            case "on_chat_msg": 
            case "on_chat_message": {
                ListProvider listProvider = ListSuppliers.ON_CHAT_MESSAGE.register(profile);
                break;
            }
            default: {
                ListProvider listProvider = provider = null;
            }
        }
        if (provider == null) {
            provider = CustomHudRegistry.getList(variable, enabled);
        }
        if (provider == null) {
            return null;
        }
        class_3545<String, Boolean> flags = VariableParser.getPrefix(provider, flagParts, profile.name, debugLine, variable);
        return new ListProviderSet.Entry(provider, UUID.randomUUID(), (String)flags.method_15442(), (Boolean)flags.method_15441());
    }

    public static class_3545<String, Boolean> getPrefix(ListProvider provider, String[] flagParts, String profile, int line, String part) {
        String prefix = Attributers.defaultPrefix(provider);
        boolean reversed = false;
        for (int i = 1; i < flagParts.length; ++i) {
            if (flagParts[i].startsWith("-pre:") || flagParts[i].startsWith("-prefix:")) {
                prefix = flagParts[i].substring(flagParts[i].indexOf(58) + 1);
                continue;
            }
            if (flagParts[i].equalsIgnoreCase("-r") || flagParts[i].equalsIgnoreCase("-reverse")) {
                reversed = true;
                continue;
            }
            Errors.addError(profile, line, part, ErrorType.UNKNOWN_LIST_VARIABLE_FLAG, flagParts[i]);
        }
        return new class_3545((Object)prefix, (Object)reversed);
    }

    public static boolean getReversed(String[] flagParts) {
        for (int i = 1; i < flagParts.length; ++i) {
            if (!flagParts[i].equalsIgnoreCase("-r") && !flagParts[i].equalsIgnoreCase("-reverse")) continue;
            return true;
        }
        return false;
    }

    public static ListProviderSet.Entry getLoopProvider(String variable, Profile profile, int debugLine, ComplexData.Enabled enabled, String original, ListProviderSet listProviders) {
        Operation stepO;
        Operation endO;
        Operation startO;
        String argsStr = variable.substring(4);
        int endIndex = argsStr.lastIndexOf(93);
        if (!argsStr.startsWith("[") || endIndex == -1) {
            Errors.addError(profile.name, debugLine, original, ErrorType.MALFORMED_LOOP, null);
            return null;
        }
        List<String> parts = VariableParser.partitionConditional(argsStr.substring(1, endIndex));
        if (parts.isEmpty() || parts.size() > 3) {
            Errors.addError(profile.name, debugLine, original, ErrorType.MALFORMED_LOOP, null);
            return null;
        }
        if (parts.size() == 1) {
            startO = new Operation.Literal(0.0);
            endO = ExpressionParser.parseExpression(parts.get(0), original, profile, debugLine, enabled, listProviders, false);
            stepO = new Operation.Literal(1.0);
        } else if (parts.size() == 2) {
            startO = ExpressionParser.parseExpression(parts.get(0), original, profile, debugLine, enabled, listProviders, false);
            endO = ExpressionParser.parseExpression(parts.get(1), original, profile, debugLine, enabled, listProviders, false);
            stepO = new Operation.Literal(1.0);
        } else {
            startO = ExpressionParser.parseExpression(parts.get(0), original, profile, debugLine, enabled, listProviders, false);
            endO = ExpressionParser.parseExpression(parts.get(1), original, profile, debugLine, enabled, listProviders, false);
            stepO = ExpressionParser.parseExpression(parts.get(2), original, profile, debugLine, enabled, listProviders, false);
        }
        ListProvider provider = () -> {
            ArrayList<Double> values = new ArrayList<Double>();
            double end = endO.getValue();
            double step = stepO.getValue();
            for (double i = startO.getValue(); i < end; i += step) {
                values.add(i);
            }
            return values;
        };
        Attributers.ATTRIBUTER_MAP.put(provider, Attributers.LOOP_ITEM);
        String[] flagParts = ("loop" + argsStr.substring(endIndex + 1)).split(" ");
        String prefix = Attributers.DEFAULT_PREFIX.get(Attributers.LOOP_ITEM);
        for (int i = 1; i < flagParts.length; ++i) {
            if (flagParts[i].startsWith("-pre:") || flagParts[i].startsWith("-prefix:")) {
                prefix = flagParts[i].substring(flagParts[i].indexOf(58) + 1);
                continue;
            }
            Errors.addError(profile.name, debugLine, variable, ErrorType.UNKNOWN_LIST_VARIABLE_FLAG, flagParts[i]);
        }
        return new ListProviderSet.Entry(provider, UUID.randomUUID(), prefix, VariableParser.getReversed(flagParts));
    }

    public static HudElement barElement(boolean background, String part, Profile profile, int debugLine, ComplexData.Enabled enabled, String original, ListProviderSet listProviders) {
        Flags flags;
        if (part.indexOf(44) == -1) {
            Errors.addError(profile.name, debugLine, original, ErrorType.MALFORMED_BAR, null);
            return null;
        }
        List<String> parts = VariableParser.partitionConditional(part);
        CustomHud.logInDebugMode("SUPPLIER");
        for (String p : parts) {
            CustomHud.logInDebugMode("`" + p + "`");
        }
        if (parts.size() < 3) {
            Errors.addError(profile.name, debugLine, original, ErrorType.MALFORMED_BAR, null);
            return null;
        }
        Operation op1 = ExpressionParser.parseExpression(parts.get(1).trim(), part, profile, debugLine, enabled, listProviders, false);
        Operation op2 = ExpressionParser.parseExpression(parts.get(2).trim(), part, profile, debugLine, enabled, listProviders, false);
        if (parts.size() < 4) {
            flags = new Flags();
        } else {
            StringBuilder str = new StringBuilder();
            for (int i = 3; i < parts.size(); ++i) {
                str.append(parts.get(i)).append(",");
            }
            flags = Flags.parse(profile.name, debugLine, str.substring(0, str.length() - 1).split(" "));
        }
        ProgressBarIcon.BarStyle style = null;
        int collinIndex = parts.get(0).indexOf(58);
        if (collinIndex != -1) {
            style = ProgressBarIcon.getStyle(parts.get(0).substring(collinIndex + 1));
        }
        return new ProgressBarIcon(background, op1, op2, style, flags);
    }

    public static HudElement listOnlyElement(String part, Profile profile, int debugLine, ComplexData.Enabled enabled, String original, ListProviderSet listProviders, Function<String, ListProvider> getProvider) {
        String[] flagParts;
        ListProvider provider;
        int commaIndex = part.indexOf(",");
        String p = part;
        if (commaIndex != -1) {
            p = p.substring(0, commaIndex);
        }
        if ((provider = getProvider.apply((flagParts = p.split(" "))[0])) == null) {
            return null;
        }
        class_3545<String, Boolean> flags = VariableParser.getPrefix(provider, flagParts, profile.name, debugLine, original);
        return VariableParser.listElement(new ListProviderSet.Entry(provider, UUID.randomUUID(), (String)flags.method_15442(), (Boolean)flags.method_15441()), part, commaIndex, profile, debugLine, enabled, original, listProviders);
    }

    public static HudElement listElement(ListProviderSet.Entry provider, String part, int commaIndex, Profile profile, int debugLine, ComplexData.Enabled enabled, String original, ListProviderSet listProviders) {
        if (commaIndex == -1) {
            int dotIndex = part.indexOf(46);
            String attr = dotIndex == -1 ? "" : part.substring(dotIndex + 1);
            HudElement attribute = Attributers.get(new ListProviderSet().with(provider), attr, new Flags(), profile, debugLine);
            if (attribute == null) {
                Errors.addError(profile.name, debugLine, original, ErrorType.UNKNOWN_ATTRIBUTE, attr);
            }
            return new ListCountElement(provider, attribute);
        }
        List<String> parts = VariableParser.partitionConditional(part);
        CustomHud.logInDebugMode("SUPPLIER");
        for (String p : parts) {
            CustomHud.logInDebugMode("`" + p + "`");
        }
        if (parts.size() < 2) {
            return null;
        }
        listProviders = listProviders.with(provider);
        String format = parts.get(1).trim();
        if (!VariableParser.inQuotes(format)) {
            Errors.addError(profile.name, debugLine, original, ErrorType.MALFORMED_LIST, "format part not in quotations");
            return null;
        }
        format = format.substring(1, format.length() - 1);
        CustomHud.logInDebugMode("Format: " + format);
        Operation operation = null;
        String seperator = "";
        if (parts.size() > 2) {
            String sep;
            if (parts.size() > 3) {
                operation = ExpressionParser.parseExpression(parts.get(3), original, profile, debugLine, enabled, listProviders, true);
                CustomHud.logInDebugMode("Filter: ");
                operation.printTree(2);
            }
            if (VariableParser.inQuotes(sep = parts.get(2).trim())) {
                seperator = sep.substring(1, sep.length() - 1);
                CustomHud.logInDebugMode("Separator: " + sep);
            } else if (parts.size() == 3) {
                operation = ExpressionParser.parseExpression(parts.get(2), original, profile, debugLine, enabled, listProviders, true);
                CustomHud.logInDebugMode("Filter: ");
                operation.printTree(2);
            } else {
                Errors.addError(profile.name, debugLine, original, ErrorType.MALFORMED_LIST, "separator part not in quotations");
                return new FunctionalElement.IgnoreErrorElement();
            }
        }
        return ListElement.of(provider.provider(), provider.id(), VariableParser.addElements(format, profile, debugLine, enabled, false, listProviders), VariableParser.addElements(seperator, profile, debugLine, enabled, false, listProviders), operation, provider.reverse());
    }

    public static HudElement getAttributeElement(String part, Profile profile, int debugLine, ComplexData.Enabled enabled, String original) {
        if (part.startsWith("item:")) {
            return VariableParser.attrElement(part, AttributeHelpers.SLOT_READER, false, slot -> () -> CustomHud.CLIENT.field_1724.method_32318(slot.intValue()).method_32327(), Attributers.ITEM, ErrorType.UNKNOWN_SLOT, ErrorType.UNKNOWN_ITEM_METHOD, profile, debugLine, enabled, original);
        }
        if (part.startsWith("attribute:")) {
            return VariableParser.attrElement(part, AttributeHelpers.ENTITY_ATTR_READER, true, attr -> () -> AttributeHelpers.getEntityAttr((class_1297)CustomHud.CLIENT.field_1724, attr), Attributers.ATTRIBUTE, ErrorType.UNKNOWN_ATTRIBUTE, ErrorType.UNKNOWN_ATTRIBUTE_METHOD, profile, debugLine, enabled, original);
        }
        if (part.startsWith("target_entity_attribute:") || part.startsWith("target_entity_attr:") || part.startsWith("tea:")) {
            return VariableParser.attrElement(part, AttributeHelpers.ENTITY_ATTR_READER, true, attr -> () -> AttributeHelpers.getEntityAttr(ComplexData.targetEntity, attr), Attributers.ATTRIBUTE, ErrorType.UNKNOWN_ATTRIBUTE, ErrorType.UNKNOWN_ATTRIBUTE_METHOD, profile, debugLine, enabled, original);
        }
        if (part.startsWith("hooked_entity_attribute:") || part.startsWith("hooked_entity_attr:") || part.startsWith("hea:")) {
            return VariableParser.attrElement(part, AttributeHelpers.ENTITY_ATTR_READER, true, attr -> () -> AttributeHelpers.getEntityAttr(CustomHud.CLIENT.field_1724.field_7513 == null ? null : CustomHud.CLIENT.field_1724.field_7513.method_26957(), attr), Attributers.ATTRIBUTE, ErrorType.UNKNOWN_ATTRIBUTE, ErrorType.UNKNOWN_ATTRIBUTE_METHOD, profile, debugLine, enabled, original);
        }
        if (part.startsWith("target_block_property:") || part.startsWith("target_property:") || part.startsWith("tbprop:")) {
            HudElement e = VariableParser.attrElement(part, src -> src, false, prop -> () -> {
                for (Map.Entry p : ComplexData.targetBlock.method_11656().entrySet()) {
                    if (!((class_2769)p.getKey()).method_11899().equalsIgnoreCase((String)prop)) continue;
                    return p;
                }
                return null;
            }, Attributers.BLOCK_PROPERTY, null, ErrorType.UNKNOWN_ATTRIBUTE_METHOD, profile, debugLine, enabled, original);
            if (e != null) {
                enabled.targetBlock = true;
                enabled.world = true;
            }
            return e;
        }
        if (part.startsWith("player:")) {
            return VariableParser.attrElement(part, src -> src, false, player -> () -> AttributeHelpers.getPlayer(player), Attributers.PLAYER, null, ErrorType.UNKNOWN_TEAM_METHOD, profile, debugLine, enabled, original);
        }
        if (part.startsWith("team:")) {
            return VariableParser.attrElement(part, src -> src, false, team -> () -> CustomHud.CLIENT.field_1687.method_8428().method_1153(team), Attributers.TEAM, null, ErrorType.UNKNOWN_TEAM_METHOD, profile, debugLine, enabled, original);
        }
        if (part.startsWith("objective:")) {
            enabled.serverWorld = true;
            return VariableParser.attrElement(part, src -> src, false, name -> () -> AttributeHelpers.scoreboard().method_1170(name), Attributers.SCOREBOARD_OBJECTIVE, null, ErrorType.UNKNOWN_OBJECTIVE_METHOD, profile, debugLine, enabled, original);
        }
        if (part.startsWith("bossbar:")) {
            return VariableParser.attrElement(part, src -> src, true, name -> () -> AttributeHelpers.getBossBar(name), Attributers.BOSSBAR, null, ErrorType.UNKNOWN_BOSSBAR_METHOD, profile, debugLine, enabled, original);
        }
        if (part.startsWith("effect:")) {
            return VariableParser.attrElement(part, src -> class_7923.field_41174.method_10223(class_2960.method_12829((String)src)).orElse(null), true, effect -> () -> CustomHud.CLIENT.field_1724.method_6112((class_6880)effect), Attributers.EFFECT, ErrorType.UNKNOWN_EFFECT_ID, ErrorType.UNKNOWN_EFFECT_METHOD, profile, debugLine, enabled, original);
        }
        if (part.startsWith("mod:")) {
            if (!CustomHud.MODMENU_INSTALLED) {
                Errors.addError(profile.name, debugLine, original, ErrorType.REQUIRES_MODMENU, "");
                return new FunctionalElement.IgnoreErrorElement();
            }
            return VariableParser.attrElement(part, ModMenu.MODS::get, false, mod -> () -> mod, Attributers.MOD, ErrorType.UNKNOWN_MOD, ErrorType.UNKNOWN_MOD_METHOD, profile, debugLine, enabled, original);
        }
        if (part.startsWith("resource_pack:")) {
            return VariableParser.attrElement(part, src -> CustomHud.CLIENT.method_1520().method_14449(src), false, pack -> () -> pack, Attributers.PACK, ErrorType.UNKNOWN_RESOURCE_PACK, ErrorType.UNKNOWN_PACK_METHOD, profile, debugLine, enabled, original);
        }
        if (part.startsWith("data_pack:") || part.startsWith("datapack:")) {
            return VariableParser.attrElement(part, AttributeHelpers.DATA_PACK_READER, false, pack -> () -> pack, Attributers.PACK, ErrorType.UNKNOWN_DATA_PACK, ErrorType.UNKNOWN_PACK_METHOD, profile, debugLine, enabled, original);
        }
        if (part.startsWith("profiler_timing:")) {
            HudElement e = VariableParser.attrElement(part, AttributeHelpers.PROFILER_TIMING_READER, false, path -> () -> ComplexData.allEntries.get(path), Attributers.PROFILER_TIMING, null, ErrorType.UNKNOWN_PROFILER_TIMING_PROPERTY, profile, debugLine, enabled, original);
            if (e != null) {
                enabled.profilerTimings = true;
            }
            return e;
        }
        return null;
    }

    public static <T> HudElement attrElement(String part, Function<String, T> reader, boolean tryWithNamespace, Function<T, Supplier<?>> supplier, Attributers.Attributer attributer, ErrorType unknownX, ErrorType unknownAttribute, Profile profile, int debugLine, ComplexData.Enabled enabled, String original) {
        int collinIndex;
        String method;
        Matcher m = ITEM_VARIABLE_PATTERN.matcher((CharSequence)(part = ((String)part).substring(((String)part).indexOf(58) + 1)));
        if (!m.matches()) {
            return null;
        }
        Matcher shflagMatch = Flags.SHIFT_PATTERN.matcher((CharSequence)part);
        if (shflagMatch.find() && shflagMatch.group(2) != null && !shflagMatch.group(2).isEmpty() && shflagMatch.start() < m.end(2)) {
            int index = m.end(2);
            part = ((String)part).substring(0, index) + "|" + ((String)part).substring(index + 1);
            m = ITEM_VARIABLE_PATTERN.matcher((CharSequence)part);
            m.matches();
        }
        String src = m.group(1) == null ? "" : m.group(1);
        String oMethod = method = m.group(2) == null ? "" : m.group(2);
        int dotIndex = method.lastIndexOf(46);
        if (dotIndex != -1 && dotIndex > method.lastIndexOf(":")) {
            method = method.substring(0, dotIndex);
        }
        Object src2 = src;
        T value = reader.apply(src);
        if (value == null && tryWithNamespace && (collinIndex = method.indexOf(":")) != -1) {
            src2 = (String)src2 + ":" + method.substring(0, collinIndex);
            value = reader.apply((String)src2);
            method = method.substring(collinIndex + 1);
        }
        if (value == null) {
            String s = src.equals(src2) ? src : src + "\u00a7f or \u00a7e" + (String)src2;
            Errors.addError(profile.name, debugLine, original, unknownX, s);
            return new FunctionalElement.IgnoreErrorElement();
        }
        String[] flagParts = oMethod.split(" ");
        Flags flags = Flags.parse(profile.name, debugLine, flagParts);
        ParseContext context = new ParseContext(profile, debugLine, enabled, null);
        HudElement element = attributer.get(null, supplier.apply(value), flagParts[0], flags, context);
        if (element == null) {
            Errors.addError(profile.name, debugLine, original, unknownAttribute, method);
            return new FunctionalElement.IgnoreErrorElement();
        }
        if (!(element instanceof FunctionalElement.CreateListElement)) {
            return Flags.wrap(element, flags);
        }
        return element;
    }

    private static /* synthetic */ class_2561 lambda$parseElement2$6(String name) {
        Toggle toggle = ProfileManager.getActive().toggles.get(name);
        if (toggle == null) {
            return null;
        }
        class_2561 out = toggle.key.method_16007();
        if (!toggle.modifier.method_1415()) {
            out = toggle.modifier.method_16007().method_27661().method_27693(" + ").method_10852(out);
        }
        return out;
    }
}

