/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.customhud.complex;

import java.util.Arrays;

public class EstimatedTick {
    private static final float[] tickRates = new float[10];
    private static int nextIndex = 0;
    private static long lastTime = -1L;

    public static void record() {
        long time = System.currentTimeMillis();
        EstimatedTick.tickRates[EstimatedTick.nextIndex] = (float)(time - lastTime) / 20.0f;
        nextIndex = (nextIndex + 1) % tickRates.length;
        lastTime = time;
    }

    public static void reset() {
        Arrays.fill(tickRates, -1.0f);
        nextIndex = 0;
        lastTime = System.currentTimeMillis();
    }

    public static float get() {
        int ticks = 0;
        float total = 0.0f;
        for (float time : tickRates) {
            if (time == -1.0f) continue;
            ++ticks;
            total += time;
        }
        return Math.round(total / (float)ticks);
    }
}

