/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.customhud.data;

import com.minenash.customhud.HudElements.FormattedElement;
import com.minenash.customhud.HudElements.FrequencyElement;
import com.minenash.customhud.HudElements.RomanNumeralElement;
import com.minenash.customhud.HudElements.icon.IconElement;
import com.minenash.customhud.HudElements.interfaces.HudElement;
import com.minenash.customhud.errors.ErrorType;
import com.minenash.customhud.errors.Errors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Flags {
    public TextCase textCase = null;
    public boolean smallCaps = false;
    public int numSize = 0;
    public boolean noDelimiters = false;
    public IdPart idPart = IdPart.FULL;
    public String listPrefix = "";
    public boolean reverseList = false;
    public int precision = -1;
    public double scale = 1.0;
    public int zerofill = 0;
    public int base = 10;
    public int frequency = -1;
    public boolean formatted = false;
    public boolean romanNumerals = false;
    public int iconWidth = -1;
    public int iconShiftX = 0;
    public int iconShiftY = 0;
    public float rotation = 0.0f;
    public boolean iconReferenceCorner = false;
    public boolean iconShowCount = false;
    public boolean iconShowDur = false;
    public boolean iconShowCooldown = false;
    private static final Pattern PRECISION_PATTERN = Pattern.compile("-(?:p|precision)(\\d+)");
    private static final Pattern ZEROFILL_PATTERN = Pattern.compile("-(?:zf|zero-?fill)(\\d+)");
    private static final Pattern SCALE_PATTERN = Pattern.compile("-(?:s|scale)((\\d+)/(\\d+)|\\d+(\\.\\d+)?)");
    private static final Pattern FREQUENCY_PATTERN = Pattern.compile("-(?:v|freq|frequency)((\\d+)/(\\d+)|\\d+(\\.\\d+)?)");
    private static final Pattern WIDTH_PATTERN = Pattern.compile("-(?:w|width)(\\d+)");
    public static final Pattern SHIFT_PATTERN = Pattern.compile("-(?:sh|shift)(-?\\d+)(?:[,|](-?\\d+))?");
    private static final Pattern ROTATE_PATTERN = Pattern.compile("-(?:r|rotation)(-?\\d+)");
    private static final Pattern PREFIX_PATTERN = Pattern.compile("-(?:pre|prefix):(-?\\w+)");
    private static final Pattern BASE_PATTERN = Pattern.compile("-base(\\d+)");

    public boolean anyTextUsed() {
        return this.textCase != null || this.smallCaps || this.numSize != 0 || this.noDelimiters;
    }

    public static Flags parse(String profileName, int line, String[] parts) {
        Flags flags = new Flags();
        if (parts.length <= 1) {
            return flags;
        }
        block55: for (int i = 1; i < parts.length; ++i) {
            switch (parts[i]) {
                case "-uc": 
                case "-uppercase": {
                    flags.textCase = TextCase.UPPER;
                    continue block55;
                }
                case "-lc": 
                case "-lowercase": {
                    flags.textCase = TextCase.LOWER;
                    continue block55;
                }
                case "-tc": 
                case "-titlecase": {
                    flags.textCase = TextCase.TITLE;
                    continue block55;
                }
                case "-sc": 
                case "-smallcaps": {
                    flags.smallCaps = true;
                    continue block55;
                }
                case "-sub": 
                case "-subnums": {
                    flags.numSize = 1;
                    continue block55;
                }
                case "-sup": 
                case "-supnums": {
                    flags.numSize = 2;
                    continue block55;
                }
                case "-hex": {
                    flags.base = 16;
                    continue block55;
                }
                case "-oct": {
                    flags.base = 8;
                    continue block55;
                }
                case "-bin": {
                    flags.base = 2;
                    continue block55;
                }
                case "-nd": 
                case "-nodashes": {
                    flags.noDelimiters = true;
                    continue block55;
                }
                case "-ns": 
                case "-namespace": {
                    flags.idPart = IdPart.NAMESPACE;
                    continue block55;
                }
                case "-path": {
                    flags.idPart = IdPart.PATH;
                    continue block55;
                }
                case "-f": 
                case "-formatted": {
                    flags.formatted = true;
                    continue block55;
                }
                case "-rn": 
                case "-roman": {
                    flags.romanNumerals = true;
                    continue block55;
                }
                case "-dvc": {
                    flags.iconReferenceCorner = true;
                    continue block55;
                }
                case "-rich": {
                    flags.iconShowCooldown = true;
                    flags.iconShowDur = true;
                    flags.iconShowCount = true;
                    continue block55;
                }
                case "-count": {
                    flags.iconShowCount = true;
                    continue block55;
                }
                case "-dur": {
                    flags.iconShowDur = true;
                    continue block55;
                }
                case "-cooldown": {
                    flags.iconShowCooldown = true;
                    continue block55;
                }
                case "-r": 
                case "-reverse": {
                    flags.reverseList = true;
                    continue block55;
                }
                default: {
                    Matcher matcher = PRECISION_PATTERN.matcher(parts[i]);
                    if (matcher.matches()) {
                        flags.precision = Integer.parseInt(matcher.group(1));
                        continue block55;
                    }
                    matcher = ZEROFILL_PATTERN.matcher(parts[i]);
                    if (matcher.matches()) {
                        flags.zerofill = Integer.parseInt(matcher.group(1));
                        continue block55;
                    }
                    matcher = SCALE_PATTERN.matcher(parts[i]);
                    if (matcher.matches()) {
                        if (parts[i].contains("/")) {
                            flags.scale = (double)Integer.parseInt(matcher.group(2)) / (double)Integer.parseInt(matcher.group(3));
                            continue block55;
                        }
                        flags.scale = Double.parseDouble(matcher.group(1));
                        continue block55;
                    }
                    matcher = BASE_PATTERN.matcher(parts[i]);
                    if (matcher.matches()) {
                        int base = Integer.parseInt(matcher.group(1));
                        if (base > 36) {
                            Errors.addError(profileName, line, parts[i], ErrorType.RADIX_TOO_BIG, null);
                            continue block55;
                        }
                        if (base < 2) {
                            Errors.addError(profileName, line, parts[i], ErrorType.RADIX_TOO_SMALL, null);
                            continue block55;
                        }
                        flags.base = base;
                        continue block55;
                    }
                    matcher = FREQUENCY_PATTERN.matcher(parts[i]);
                    if (matcher.matches()) {
                        if (parts[i].contains("/")) {
                            flags.frequency = (int)((double)(1000 * Integer.parseInt(matcher.group(2))) / (double)Integer.parseInt(matcher.group(3)));
                            continue block55;
                        }
                        flags.frequency = (int)(1000.0 * Double.parseDouble(matcher.group(1)));
                        continue block55;
                    }
                    matcher = WIDTH_PATTERN.matcher(parts[i]);
                    if (matcher.matches()) {
                        flags.iconWidth = Integer.parseInt(matcher.group(1));
                        continue block55;
                    }
                    matcher = SHIFT_PATTERN.matcher(parts[i]);
                    if (matcher.matches()) {
                        flags.iconShiftX = Integer.parseInt(matcher.group(1));
                        if (matcher.group(2) == null) continue block55;
                        flags.iconShiftY = Integer.parseInt(matcher.group(2));
                        continue block55;
                    }
                    matcher = ROTATE_PATTERN.matcher(parts[i]);
                    if (matcher.matches()) {
                        flags.rotation = (float)Integer.parseInt(matcher.group(1)) * ((float)Math.PI / 180);
                        continue block55;
                    }
                    matcher = PREFIX_PATTERN.matcher(parts[i]);
                    if (matcher.matches()) {
                        flags.listPrefix = matcher.group(1);
                        continue block55;
                    }
                    Errors.addError(profileName, line, parts[i], ErrorType.UNKNOWN_VARIABLE_FLAG, null);
                }
            }
        }
        return flags;
    }

    public static String smallCaps(String text) {
        char[] chars = text.toCharArray();
        block27: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case 'a': {
                    chars[i] = 7424;
                    continue block27;
                }
                case 'b': {
                    chars[i] = 665;
                    continue block27;
                }
                case 'c': {
                    chars[i] = 7428;
                    continue block27;
                }
                case 'd': {
                    chars[i] = 7429;
                    continue block27;
                }
                case 'e': {
                    chars[i] = 7431;
                    continue block27;
                }
                case 'f': {
                    chars[i] = 42800;
                    continue block27;
                }
                case 'g': {
                    chars[i] = 610;
                    continue block27;
                }
                case 'h': {
                    chars[i] = 668;
                    continue block27;
                }
                case 'i': {
                    chars[i] = 618;
                    continue block27;
                }
                case 'j': {
                    chars[i] = 7434;
                    continue block27;
                }
                case 'k': {
                    chars[i] = 7435;
                    continue block27;
                }
                case 'l': {
                    chars[i] = 671;
                    continue block27;
                }
                case 'm': {
                    chars[i] = 7437;
                    continue block27;
                }
                case 'n': {
                    chars[i] = 628;
                    continue block27;
                }
                case 'o': {
                    chars[i] = 7439;
                    continue block27;
                }
                case 'p': {
                    chars[i] = 7448;
                    continue block27;
                }
                case 'q': {
                    chars[i] = 42927;
                    continue block27;
                }
                case 'r': {
                    chars[i] = 640;
                    continue block27;
                }
                case 's': {
                    chars[i] = 42801;
                    continue block27;
                }
                case 't': {
                    chars[i] = 7451;
                    continue block27;
                }
                case 'u': {
                    chars[i] = 7452;
                    continue block27;
                }
                case 'v': {
                    chars[i] = 7456;
                    continue block27;
                }
                case 'w': {
                    chars[i] = 7457;
                    continue block27;
                }
                case 'y': {
                    chars[i] = 655;
                    continue block27;
                }
                case 'z': {
                    chars[i] = 7458;
                }
            }
        }
        return new String(chars);
    }

    public static String subNums(String text) {
        char[] chars = text.toCharArray();
        block12: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '0': {
                    chars[i] = 8320;
                    continue block12;
                }
                case '1': {
                    chars[i] = 8321;
                    continue block12;
                }
                case '2': {
                    chars[i] = 8322;
                    continue block12;
                }
                case '3': {
                    chars[i] = 8323;
                    continue block12;
                }
                case '4': {
                    chars[i] = 8324;
                    continue block12;
                }
                case '5': {
                    chars[i] = 8325;
                    continue block12;
                }
                case '6': {
                    chars[i] = 8326;
                    continue block12;
                }
                case '7': {
                    chars[i] = 8327;
                    continue block12;
                }
                case '8': {
                    chars[i] = 8328;
                    continue block12;
                }
                case '9': {
                    chars[i] = 8329;
                }
            }
        }
        return new String(chars);
    }

    public static String supNums(String text) {
        char[] chars = text.toCharArray();
        block12: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '0': {
                    chars[i] = 8304;
                    continue block12;
                }
                case '1': {
                    chars[i] = 185;
                    continue block12;
                }
                case '2': {
                    chars[i] = 178;
                    continue block12;
                }
                case '3': {
                    chars[i] = 179;
                    continue block12;
                }
                case '4': {
                    chars[i] = 8308;
                    continue block12;
                }
                case '5': {
                    chars[i] = 8309;
                    continue block12;
                }
                case '6': {
                    chars[i] = 8310;
                    continue block12;
                }
                case '7': {
                    chars[i] = 8311;
                    continue block12;
                }
                case '8': {
                    chars[i] = 8312;
                    continue block12;
                }
                case '9': {
                    chars[i] = 8313;
                }
            }
        }
        return new String(chars);
    }

    public static HudElement wrap(HudElement element, Flags flags) {
        if (element instanceof IconElement) {
            return element;
        }
        if (flags.romanNumerals) {
            element = new RomanNumeralElement(element);
        }
        if (flags.anyTextUsed() && !flags.romanNumerals) {
            element = new FormattedElement(element, flags);
        }
        if (flags.frequency > 0) {
            element = new FrequencyElement(element, flags.frequency);
        }
        return element;
    }

    public static enum TextCase {
        UPPER,
        LOWER,
        TITLE;

    }

    public static enum IdPart {
        NAMESPACE,
        PATH,
        FULL;

    }
}

