/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.customhud.HudElements.icon;

import com.minenash.customhud.CustomHud;
import com.minenash.customhud.HudElements.icon.BossbarIcon;
import com.minenash.customhud.HudElements.icon.IconElement;
import com.minenash.customhud.conditionals.Operation;
import com.minenash.customhud.data.Flags;
import com.minenash.customhud.render.RenderPiece;
import net.minecraft.class_1259;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_337;
import net.minecraft.class_3532;
import net.minecraft.class_4587;

public class ProgressBarIcon
extends IconElement {
    private final boolean background;
    private final Operation numerator;
    private final Operation denominator;
    private final BarStyle style;
    public static BarStyle DEFAULT = new BossBarStyle(class_1259.class_1260.field_5786, class_1259.class_1261.field_5795);
    public static BarStyle XP = new TextureStyle(class_2960.method_60654((String)"hud/experience_bar_progress"), class_2960.method_60654((String)"hud/experience_bar_background"));
    public static BarStyle JUMP = new TextureStyle(class_2960.method_60654((String)"hud/jump_bar_progress"), class_2960.method_60654((String)"hud/jump_bar_background"));
    public static BarStyle VILLAGER_GREEN = new VillagerTextureStyle(class_2960.method_60654((String)"container/villager/experience_bar_current"));
    public static BarStyle VILLAGER_WHITE = new VillagerTextureStyle(class_2960.method_60654((String)"container/villager/experience_bar_result"));
    private static final class_2960 EXPERIENCE_BAR_BACKGROUND_TEXTURE = class_2960.method_60654((String)"container/villager/experience_bar_background");

    public ProgressBarIcon(boolean background, Operation numerator, Operation denominator, BarStyle style, Flags flags) {
        super(flags, style instanceof VillagerTextureStyle ? 102.0 : 182.0);
        this.background = background;
        this.numerator = numerator;
        this.denominator = denominator;
        this.style = style == null ? DEFAULT : style;
    }

    @Override
    public void render(class_332 context, RenderPiece piece) {
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_46416((float)(piece.x + this.shiftX), (float)(piece.y + this.shiftY + 1), 0.0f);
        if (!this.referenceCorner) {
            matrices.method_46416(0.0f, -(5.0f * this.scale - 5.0f) / 2.0f, 0.0f);
        }
        matrices.method_22905(this.scale, this.scale, 0.0f);
        this.rotate(matrices, 182.0f, 5.0f);
        this.style.render(context, (float)class_3532.method_15350((double)(this.numerator.getValue() / this.denominator.getValue()), (double)0.0, (double)1.0), this.background);
        matrices.method_22909();
    }

    public static BarStyle getStyle(String settings) {
        switch (settings) {
            case "experience": 
            case "xp": {
                return XP;
            }
            case "jump": 
            case "horse": {
                return JUMP;
            }
            case "villager_green": 
            case "villager": {
                return VILLAGER_GREEN;
            }
            case "villager_white": {
                return VILLAGER_WHITE;
            }
        }
        class_1259.class_1260 color = null;
        class_1259.class_1261 style = null;
        switch (settings) {
            case "pink": {
                color = class_1259.class_1260.field_5788;
                break;
            }
            case "blue": {
                color = class_1259.class_1260.field_5780;
                break;
            }
            case "red": {
                color = class_1259.class_1260.field_5784;
                break;
            }
            case "green": {
                color = class_1259.class_1260.field_5785;
                break;
            }
            case "yellow": {
                color = class_1259.class_1260.field_5782;
                break;
            }
            case "purple": {
                color = class_1259.class_1260.field_5783;
                break;
            }
            case "white": {
                color = class_1259.class_1260.field_5786;
                break;
            }
            case "6": {
                style = class_1259.class_1261.field_5796;
                break;
            }
            case "10": {
                style = class_1259.class_1261.field_5791;
                break;
            }
            case "12": {
                style = class_1259.class_1261.field_5793;
                break;
            }
            case "20": {
                style = class_1259.class_1261.field_5790;
                break;
            }
            case "pink6": {
                color = class_1259.class_1260.field_5788;
                style = class_1259.class_1261.field_5796;
                break;
            }
            case "blue6": {
                color = class_1259.class_1260.field_5780;
                style = class_1259.class_1261.field_5796;
                break;
            }
            case "red6": {
                color = class_1259.class_1260.field_5784;
                style = class_1259.class_1261.field_5796;
                break;
            }
            case "green6": {
                color = class_1259.class_1260.field_5785;
                style = class_1259.class_1261.field_5796;
                break;
            }
            case "yellow6": {
                color = class_1259.class_1260.field_5782;
                style = class_1259.class_1261.field_5796;
                break;
            }
            case "purple6": {
                color = class_1259.class_1260.field_5783;
                style = class_1259.class_1261.field_5796;
                break;
            }
            case "white6": {
                color = class_1259.class_1260.field_5786;
                style = class_1259.class_1261.field_5796;
                break;
            }
            case "pink10": {
                color = class_1259.class_1260.field_5788;
                style = class_1259.class_1261.field_5791;
                break;
            }
            case "blue10": {
                color = class_1259.class_1260.field_5780;
                style = class_1259.class_1261.field_5791;
                break;
            }
            case "red10": {
                color = class_1259.class_1260.field_5784;
                style = class_1259.class_1261.field_5791;
                break;
            }
            case "green10": {
                color = class_1259.class_1260.field_5785;
                style = class_1259.class_1261.field_5791;
                break;
            }
            case "yellow10": {
                color = class_1259.class_1260.field_5782;
                style = class_1259.class_1261.field_5791;
                break;
            }
            case "purple10": {
                color = class_1259.class_1260.field_5783;
                style = class_1259.class_1261.field_5791;
                break;
            }
            case "white10": {
                color = class_1259.class_1260.field_5786;
                style = class_1259.class_1261.field_5791;
                break;
            }
            case "pink12": {
                color = class_1259.class_1260.field_5788;
                style = class_1259.class_1261.field_5793;
                break;
            }
            case "blue12": {
                color = class_1259.class_1260.field_5780;
                style = class_1259.class_1261.field_5793;
                break;
            }
            case "red12": {
                color = class_1259.class_1260.field_5784;
                style = class_1259.class_1261.field_5793;
                break;
            }
            case "green12": {
                color = class_1259.class_1260.field_5785;
                style = class_1259.class_1261.field_5793;
                break;
            }
            case "yellow12": {
                color = class_1259.class_1260.field_5782;
                style = class_1259.class_1261.field_5793;
                break;
            }
            case "purple12": {
                color = class_1259.class_1260.field_5783;
                style = class_1259.class_1261.field_5793;
                break;
            }
            case "white12": {
                color = class_1259.class_1260.field_5786;
                style = class_1259.class_1261.field_5793;
                break;
            }
            case "pink20": {
                color = class_1259.class_1260.field_5788;
                style = class_1259.class_1261.field_5790;
                break;
            }
            case "blue20": {
                color = class_1259.class_1260.field_5780;
                style = class_1259.class_1261.field_5790;
                break;
            }
            case "red20": {
                color = class_1259.class_1260.field_5784;
                style = class_1259.class_1261.field_5790;
                break;
            }
            case "green20": {
                color = class_1259.class_1260.field_5785;
                style = class_1259.class_1261.field_5790;
                break;
            }
            case "yellow20": {
                color = class_1259.class_1260.field_5782;
                style = class_1259.class_1261.field_5790;
                break;
            }
            case "purple20": {
                color = class_1259.class_1260.field_5783;
                style = class_1259.class_1261.field_5790;
                break;
            }
            case "white20": {
                color = class_1259.class_1260.field_5786;
                style = class_1259.class_1261.field_5790;
            }
        }
        if (color == null && style == null) {
            return null;
        }
        return new BossBarStyle(color == null ? class_1259.class_1260.field_5786 : color, style == null ? class_1259.class_1261.field_5795 : style);
    }

    public static class VillagerTextureStyle
    implements BarStyle {
        private final class_2960 fg;

        public VillagerTextureStyle(class_2960 fg) {
            this.fg = fg;
        }

        @Override
        public void render(class_332 context, float progress, boolean background) {
            if (background) {
                context.method_52706(EXPERIENCE_BAR_BACKGROUND_TEXTURE, 0, 0, 102, 5);
            }
            if (progress > 0.0f) {
                context.method_52708(this.fg, 102, 5, 0, 0, 0, 0, (int)(progress * 102.0f), 5);
            }
        }
    }

    public static interface BarStyle {
        public void render(class_332 var1, float var2, boolean var3);
    }

    public static class BossBarStyle
    implements BarStyle {
        private final class_1259 bossBar;

        public BossBarStyle(class_1259.class_1260 color, class_1259.class_1261 style) {
            this.bossBar = new BossbarIcon.BasicBar(color, style);
        }

        @Override
        public void render(class_332 context, float progress, boolean background) {
            int i;
            this.bossBar.method_5408(progress);
            class_337 bbh = CustomHud.CLIENT.field_1705.method_1740();
            if (background) {
                bbh.method_41830(context, 0, 0, this.bossBar, 182, class_337.field_45344, class_337.field_45346);
            }
            if ((i = class_3532.method_53063((float)this.bossBar.method_5412(), (int)0, (int)182)) > 0) {
                bbh.method_41830(context, 0, 0, this.bossBar, i, class_337.field_45345, class_337.field_45347);
            }
        }
    }

    public static class TextureStyle
    implements BarStyle {
        private final class_2960 fg;
        private final class_2960 bg;

        public TextureStyle(class_2960 fg, class_2960 bg) {
            this.fg = fg;
            this.bg = bg;
        }

        @Override
        public void render(class_332 context, float progress, boolean background) {
            if (background) {
                context.method_52706(this.bg, 0, 0, 182, 5);
            }
            if (progress > 0.0f) {
                context.method_52708(this.fg, 182, 5, 0, 0, 0, 0, (int)(progress * 182.0f), 5);
            }
        }
    }
}

