/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.customhud.HudElements.list;

import com.google.common.collect.Lists;
import com.minenash.customhud.CustomHud;
import com.minenash.customhud.HudElements.list.AttributeHelpers;
import com.minenash.customhud.HudElements.list.ListProvider;
import com.minenash.customhud.complex.ComplexData;
import com.minenash.customhud.complex.MusicAndRecordTracker;
import com.minenash.customhud.complex.SubtitleTracker;
import com.terraformersmc.modmenu.ModMenu;
import com.terraformersmc.modmenu.util.mod.Mod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1259;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1324;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_1934;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_266;
import net.minecraft.class_268;
import net.minecraft.class_2960;
import net.minecraft.class_3002;
import net.minecraft.class_3222;
import net.minecraft.class_3283;
import net.minecraft.class_3288;
import net.minecraft.class_329;
import net.minecraft.class_3545;
import net.minecraft.class_359;
import net.minecraft.class_4081;
import net.minecraft.class_5321;
import net.minecraft.class_640;
import net.minecraft.class_6538;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_8144;
import net.minecraft.class_9331;
import net.minecraft.class_9334;

public class ListSuppliers {
    public static final class_2350[] DIRS = new class_2350[]{class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039, class_2350.field_11036, class_2350.field_11033};
    public static final Comparator<class_640> ENTRY_ORDERING = Comparator.comparingInt(entry -> entry.method_2958() == class_1934.field_9219 ? 1 : 0).thenComparing(entry -> (String)class_8144.method_49078((Object)entry.method_2955(), class_268::method_1197, (Object)"")).thenComparing(entry -> entry.method_2966().getName(), String::compareToIgnoreCase);
    public static final List<String> IGNORE_MODS = List.of("minecraft", "fabricloader", "java");
    public static final Comparator<?> MOD_ORDERING = Comparator.comparing(mod -> ((Mod)mod).getTranslatedName().toLowerCase(Locale.ROOT));
    public static final Predicate<?> MOD_PREDICATE = mod -> !((Mod)mod).isHidden() && !((Mod)mod).getBadges().contains(Mod.Badge.LIBRARY) && !((Mod)mod).getBadges().contains(Mod.Badge.MINECRAFT);
    public static final Predicate<?> ALL_ROOT_MODS_PREDICATE = mod -> !((Mod)mod).isHidden() && !IGNORE_MODS.contains(((Mod)mod).getId());
    public static final Comparator<class_1293> EFFECT_ORDERING = Comparator.comparingInt(e -> e.method_5584() == -1 ? Integer.MAX_VALUE : e.method_5584());
    public static final ListProvider STATUS_EFFECTS = () -> Arrays.asList(CustomHud.CLIENT.field_1724.method_6026().stream().sorted(EFFECT_ORDERING).toArray());
    public static final ListProvider STATUS_EFFECTS_POSITIVE = () -> Arrays.asList(CustomHud.CLIENT.field_1724.method_6026().stream().filter(e -> ((class_1291)e.method_5579().comp_349()).method_18792() == class_4081.field_18271).sorted(EFFECT_ORDERING).toArray());
    public static final ListProvider STATUS_EFFECTS_NEGATIVE = () -> Arrays.asList(CustomHud.CLIENT.field_1724.method_6026().stream().filter(e -> ((class_1291)e.method_5579().comp_349()).method_18792() == class_4081.field_18272).sorted(EFFECT_ORDERING).toArray());
    public static final ListProvider STATUS_EFFECTS_NEUTRAL = () -> Arrays.asList(CustomHud.CLIENT.field_1724.method_6026().stream().filter(e -> ((class_1291)e.method_5579().comp_349()).method_18792() == class_4081.field_18273).sorted(EFFECT_ORDERING).toArray());
    public static final ListProvider ONLINE_PLAYERS = () -> Arrays.asList(CustomHud.CLIENT.method_1562().method_2880().stream().sorted(ENTRY_ORDERING).toArray());
    public static final ListProvider SUBTITLES = () -> SubtitleTracker.INSTANCE.entries;
    public static final ListProvider TARGET_BLOCK_STATES = () -> ComplexData.targetBlock == null ? Collections.EMPTY_LIST : Arrays.asList(ComplexData.targetBlock.method_11656().entrySet().toArray());
    public static final ListProvider TARGET_BLOCK_TAGS = () -> ComplexData.targetBlock == null ? Collections.EMPTY_LIST : Arrays.asList(ComplexData.targetBlock.method_40144().toArray());
    public static final ListProvider TARGET_FLUID_STATES = () -> ComplexData.targetFluid == null ? Collections.EMPTY_LIST : Arrays.asList(ComplexData.targetFluid.method_11656().entrySet().toArray());
    public static final ListProvider TARGET_FLUID_TAGS = () -> ComplexData.targetFluid == null ? Collections.EMPTY_LIST : Arrays.asList(ComplexData.targetFluid.method_40181().toArray());
    public static final ListProvider TARGET_BLOCK_POWERS = () -> {
        if (ComplexData.targetBlockPos == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<AttributeHelpers.ReceivedPower> powers = new ArrayList<AttributeHelpers.ReceivedPower>(6);
        for (class_2350 d : DIRS) {
            class_2338 pos = ComplexData.targetBlockPos.method_10093(d);
            powers.add(new AttributeHelpers.ReceivedPower(d, CustomHud.CLIENT.field_1687.method_49808(pos, d), CustomHud.CLIENT.field_1687.method_49805(pos, d)));
        }
        return powers;
    };
    public static final ListProvider PLAYER_ATTRIBUTES = () -> AttributeHelpers.getEntityAttributes((class_1297)CustomHud.CLIENT.field_1724);
    public static final ListProvider TARGET_ENTITY_ATTRIBUTES = () -> ComplexData.targetEntity == null ? Collections.EMPTY_LIST : AttributeHelpers.getEntityAttributes(ComplexData.targetEntity);
    public static final ListProvider HOOKED_ENTITY_ATTRIBUTES = () -> ListSuppliers.hooked() == null ? Collections.EMPTY_LIST : AttributeHelpers.getEntityAttributes(ListSuppliers.hooked());
    public static final ListProvider TEAMS = () -> Arrays.asList(CustomHud.CLIENT.field_1687.method_8428().method_1159().toArray());
    public static final ListProvider TARGET_VILLAGER_OFFERS = () -> ComplexData.villagerOffers;
    public static final ListProvider ITEMS = () -> AttributeHelpers.compactItems((List<class_1799>)CustomHud.CLIENT.field_1724.method_31548().field_7547);
    public static final ListProvider INV_ITEMS = () -> CustomHud.CLIENT.field_1724.method_31548().field_7547.subList(9, CustomHud.CLIENT.field_1724.method_31548().field_7547.size());
    public static final ListProvider ARMOR_ITEMS = () -> {
        class_2371 a = CustomHud.CLIENT.field_1724.method_31548().field_7548;
        return List.of((class_1799)a.get(3), (class_1799)a.get(2), (class_1799)a.get(1), (class_1799)a.get(0));
    };
    public static final ListProvider HOTBAR_ITEMS = () -> CustomHud.CLIENT.field_1724.method_31548().field_7547.subList(0, 9);
    public static final ListProvider ALL_ITEMS = () -> {
        class_1661 inv = CustomHud.CLIENT.field_1724.method_31548();
        ArrayList<class_1799> items = new ArrayList<class_1799>((Collection<class_1799>)inv.field_7547);
        items.add((class_1799)inv.field_7548.get(3));
        items.add((class_1799)inv.field_7548.get(2));
        items.add((class_1799)inv.field_7548.get(1));
        items.add((class_1799)inv.field_7548.get(0));
        items.add((class_1799)inv.field_7544.get(0));
        return items;
    };
    public static final ListProvider EQUIPPED_ITEMS = () -> {
        class_1661 inv = CustomHud.CLIENT.field_1724.method_31548();
        ArrayList<class_1799> items = new ArrayList<class_1799>(5);
        items.add((class_1799)inv.field_7548.get(3));
        items.add((class_1799)inv.field_7548.get(2));
        items.add((class_1799)inv.field_7548.get(1));
        items.add((class_1799)inv.field_7548.get(0));
        items.add(inv.method_7391());
        items.add((class_1799)inv.field_7544.get(0));
        return items;
    };
    public static final ListProvider ITEMS_UNPACKED = () -> {
        ArrayList<class_1799> items = new ArrayList<class_1799>(36);
        for (class_1799 stack : CustomHud.CLIENT.field_1724.method_31548().field_7547) {
            List<class_1799> innerItems = AttributeHelpers.getItemItems(stack, true);
            if (innerItems.isEmpty()) {
                items.add(stack);
                continue;
            }
            items.addAll(innerItems);
        }
        return AttributeHelpers.compactItems(items);
    };
    public static final ListProvider SCOREBOARD_OBJECTIVES = () -> Arrays.asList(AttributeHelpers.scoreboard().method_1151().toArray());
    public static final ListProvider PLAYER_SCOREBOARD_SCORES = () -> Arrays.asList(AttributeHelpers.scoreboard().method_55431((String)CustomHud.CLIENT.method_53462().getName()).field_47529.entrySet().toArray());
    public static final ListProvider BOSSBARS = () -> AttributeHelpers.bossbars(false);
    public static final ListProvider ALL_BOSSBARS = () -> AttributeHelpers.bossbars(true);
    public static final ListProvider RECORDS = () -> MusicAndRecordTracker.records;
    public static final ListProvider MODS = () -> Arrays.asList(ModMenu.ROOT_MODS.values().stream().filter(MOD_PREDICATE).sorted(MOD_ORDERING).toArray());
    public static final ListProvider ALL_ROOT_MODS = () -> Arrays.asList(ModMenu.ROOT_MODS.values().stream().filter(ALL_ROOT_MODS_PREDICATE).sorted(MOD_ORDERING).toArray());
    public static final ListProvider ALL_MODS = () -> Arrays.asList(ModMenu.MODS.values().stream().sorted(MOD_ORDERING).toArray());
    public static final ListProvider RESOURCE_PACKS = () -> {
        ArrayList<class_3288> packs = new ArrayList<class_3288>(CustomHud.CLIENT.method_1520().method_14444());
        packs.removeIf(pack -> AttributeHelpers.isFabricRP(pack) || pack.method_14463().equals("vanilla"));
        Collections.reverse(packs);
        return packs;
    };
    public static final ListProvider DISABLED_RESOURCE_PACKS = () -> {
        ArrayList profiles = Lists.newArrayList((Iterable)CustomHud.CLIENT.method_1520().method_14441());
        profiles.removeAll(CustomHud.CLIENT.method_1520().method_14444());
        Collections.reverse(profiles);
        return profiles;
    };
    public static final ListProvider DATA_PACKS = () -> CustomHud.CLIENT.method_1576() == null ? Collections.EMPTY_LIST : Arrays.asList(CustomHud.CLIENT.method_1576().method_3836().method_14444().toArray());
    public static final ListProvider DISABLED_DATA_PACKS = () -> {
        if (CustomHud.CLIENT.method_1576() == null) {
            return Collections.EMPTY_LIST;
        }
        class_3283 manager = CustomHud.CLIENT.method_1576().method_3836();
        ArrayList profiles = Lists.newArrayList((Iterable)manager.method_14441());
        profiles.removeAll(manager.method_14444());
        return profiles;
    };
    public static final ListProvider CHAT_MESSAGES = () -> CustomHud.CLIENT.field_1705.method_1743().field_2061;
    public static final ListProvider PROFILER_TIMINGS = () -> ComplexData.rootEntries;
    public static final Function<class_359.class_360, List<?>> SUBTITLE_SOUNDS = entry -> new ArrayList(entry.field_51913);
    public static final Function<ComplexData.ProfilerTimingWithPath, List<?>> TIMINGS_SUB_ENTRIES = timing -> timing == null ? Collections.EMPTY_LIST : timing.entries();
    public static final Function<class_1324, List<?>> ATTRIBUTE_MODIFIERS = attr -> new ArrayList(attr.method_6195());
    public static final Function<class_268, List<?>> TEAM_MEMBERS = team -> Arrays.asList(team.method_1204().toArray());
    public static final Function<class_268, List<?>> TEAM_PLAYERS = team -> CustomHud.CLIENT.method_1562().method_2880().stream().filter(p -> p.method_2955() == team).sorted(ENTRY_ORDERING).toList();
    public static final Function<class_1799, List<?>> ITEM_ATTRIBUTES = AttributeHelpers::getItemStackAttributes;
    public static final Function<class_1799, List<?>> ITEM_ENCHANTS = stack -> new ArrayList(stack.method_58657().method_57539());
    public static final Function<class_1799, List<?>> ITEM_LORE_LINES = AttributeHelpers::getLore;
    public static final Function<class_1799, List<?>> ITEM_CAN_DESTROY = stack -> AttributeHelpers.getCanX(stack, (class_9331<class_6538>)class_9334.field_49635);
    public static final Function<class_1799, List<?>> ITEM_CAN_PLAY_ON = stack -> AttributeHelpers.getCanX(stack, (class_9331<class_6538>)class_9334.field_49634);
    public static final Function<class_1799, List<?>> ITEM_TAGS = stack -> stack.method_40133().toList();
    public static final Function<class_1799, List<?>> ITEM_ITEMS = stack -> AttributeHelpers.getItemItems(stack, false);
    public static final Function<class_1799, List<?>> ITEM_ITEMS_COMPACT = stack -> AttributeHelpers.compactItems(AttributeHelpers.getItemItems(stack, false));
    public static final Function<class_1259, List<?>> BOSSBAR_PLAYERS = bar -> {
        if (CustomHud.CLIENT.method_1576() == null || !(bar instanceof class_3002)) {
            return Collections.EMPTY_LIST;
        }
        class_3002 cboss = (class_3002)bar;
        List<Object> listPlayers = Arrays.asList(CustomHud.CLIENT.method_1562().method_2880().toArray());
        ArrayList<class_640> out = new ArrayList<class_640>(cboss.method_14092().size());
        for (class_3222 player : cboss.method_14092()) {
            for (Object listPlayer : listPlayers) {
                if (!player.method_5667().equals(((class_640)listPlayer).method_2966().getId())) continue;
                out.add((class_640)listPlayer);
            }
        }
        return out;
    };
    public static final Function<class_266, List<?>> SCOREBOARD_OBJECTIVE_SCORES = obj -> AttributeHelpers.scoreboard().method_1184(obj).stream().sorted(class_329.field_47550).toList();
    public static final Function<class_266, List<?>> SCOREBOARD_OBJECTIVE_SCORES_ONLINE = obj -> AttributeHelpers.scoreboard().method_1184(obj).stream().filter(score -> AttributeHelpers.entryOnline(score.comp_2127())).sorted(class_329.field_47550).toList();
    public static final Function<?, List<?>> MOD_AUTHORS = mod -> ((Mod)mod).getAuthors();
    public static final Function<?, List<?>> MOD_CONTRIBUTORS = mod -> {
        ArrayList<class_3545> contributors = new ArrayList<class_3545>();
        for (Map.Entry e : ((Mod)mod).getContributors().entrySet()) {
            String set = (String)e.getKey();
            for (String contributor : (Collection)e.getValue()) {
                contributors.add(new class_3545((Object)contributor, (Object)set));
            }
        }
        return contributors;
    };
    public static final Function<?, List<?>> MOD_CREDITS = mod -> {
        ArrayList<class_3545> credits = new ArrayList<class_3545>();
        for (Map.Entry e : ((Mod)mod).getCredits().entrySet()) {
            String set = (String)e.getKey();
            for (String contributor : (Set)e.getValue()) {
                credits.add(new class_3545((Object)contributor, (Object)set));
            }
        }
        return credits;
    };
    public static final Function<?, List<?>> MOD_BADGES = mod -> Arrays.asList(((Mod)mod).getBadges().toArray());
    public static final Function<?, List<?>> MOD_LICENSES = mod -> Arrays.asList(((Mod)mod).getLicense().toArray());
    public static final Function<?, List<?>> MOD_PARENTS = mod -> {
        Mod parent = (Mod)ModMenu.MODS.get(((Mod)mod).getParent());
        return parent == null ? Collections.emptyList() : Collections.singletonList(parent);
    };
    public static final Function<?, List<?>> MOD_CHILDREN = mod -> ModMenu.PARENT_MAP.get((Object)((Mod)mod));
    public static final Function<class_1914, List<?>> OFFER_FIRST_ADJUSTED = offer -> Collections.singletonList(offer.method_19272());
    public static final Function<class_1914, List<?>> OFFER_FIRST_BASE = offer -> Collections.singletonList(offer.method_8246());
    public static final Function<class_1914, List<?>> OFFER_SECOND = offer -> Collections.singletonList(offer.method_8247());
    public static final Function<class_1914, List<?>> OFFER_RESULT = offer -> Collections.singletonList(offer.method_8250());

    public static ListProvider SCORES(String name) {
        return () -> Arrays.asList(AttributeHelpers.scoreboard().method_55431((String)name).field_47529.entrySet().toArray());
    }

    public static <T> ListProvider TAG_ENTRIES(class_2378<T> registry, String name) {
        class_2960 id;
        if (name.startsWith("#")) {
            name = name.substring(1);
        }
        if ((id = class_2960.method_12829((String)name)) == null) {
            return null;
        }
        return () -> {
            Optional opt = registry.method_40266(class_6862.method_40092((class_5321)registry.method_30517(), (class_2960)id));
            if (opt.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            class_6885.class_6888 entryList = (class_6885.class_6888)opt.get();
            ArrayList<Object> values = new ArrayList<Object>(entryList.method_40247());
            for (class_6880 e : entryList) {
                values.add(e.comp_349());
            }
            return values;
        };
    }

    private static class_1297 hooked() {
        return CustomHud.CLIENT.field_1724.field_7513 == null ? null : CustomHud.CLIENT.field_1724.field_7513.method_26957();
    }
}

