/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.customhud.conditionals;

import com.minenash.customhud.CustomHud;
import com.minenash.customhud.HudElements.interfaces.HudElement;
import com.minenash.customhud.HudElements.list.ListProviderSet;
import com.minenash.customhud.VariableParser;
import com.minenash.customhud.complex.ComplexData;
import com.minenash.customhud.conditionals.Operation;
import com.minenash.customhud.conditionals.SudoElements;
import com.minenash.customhud.data.Profile;
import com.minenash.customhud.errors.ErrorException;
import com.minenash.customhud.errors.ErrorType;
import com.minenash.customhud.errors.Errors;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_3545;

public class ExpressionParser {
    private static final List<TokenType> SUBTRACTABLE = List.of(TokenType.NUMBER, TokenType.BOOLEAN, TokenType.STRING, TokenType.VARIABLE, TokenType.END_PREN);
    private static final double DR = Math.PI / 180;
    private static final double RD = 57.29577951308232;
    private static final Function<Double, Double> NEGATE = in -> in > 0.0 ? 0.0 : 1.0;
    private static final Function<Double, Double> SIN = in -> ExpressionParser.round(Math.sin(in * (Math.PI / 180)));
    private static final Function<Double, Double> COS = in -> ExpressionParser.round(Math.cos(in * (Math.PI / 180)));
    private static final Function<Double, Double> TAN = in -> ExpressionParser.round(Math.tan(in * (Math.PI / 180)));
    private static final Function<Double, Double> CSC = in -> ExpressionParser.round(1.0 / Math.sin(in * (Math.PI / 180)));
    private static final Function<Double, Double> SEC = in -> ExpressionParser.round(1.0 / Math.cos(in * (Math.PI / 180)));
    private static final Function<Double, Double> COT = in -> ExpressionParser.round(1.0 / Math.tan(in * (Math.PI / 180)));
    private static final Function<Double, Double> ASIN = in -> ExpressionParser.round(57.29577951308232 * Math.asin(in));
    private static final Function<Double, Double> ACOS = in -> ExpressionParser.round(57.29577951308232 * Math.acos(in));
    private static final Function<Double, Double> ATAN = in -> ExpressionParser.round(57.29577951308232 * Math.atan(in));
    private static final Function<Double, Double> ACSC = in -> ExpressionParser.round(57.29577951308232 * Math.asin(1.0 / in));
    private static final Function<Double, Double> ASEC = in -> ExpressionParser.round(57.29577951308232 * Math.acos(1.0 / in));
    private static final Function<Double, Double> ACOT = in -> ExpressionParser.round(57.29577951308232 * Math.atan(1.0 / in));
    private static final Function<Double, Double> ROUND = in -> Math.round(in);
    private static final Function<Double, Double> LOG_2 = in -> Math.log(in) / Math.log(2.0);

    public static Operation parseExpression(String input, String source, Profile profile, int debugLine, ComplexData.Enabled enabled, ListProviderSet listSuppliers, boolean forCondition) {
        if (input.isBlank() || input.equals(",") || input.equals(", ")) {
            return forCondition ? new Operation.Literal(1.0) : new Operation.Literal(0.0);
        }
        try {
            List<Token> tokens = ExpressionParser.getTokens(input, profile, debugLine, enabled, listSuppliers);
            Operation c = ExpressionParser.getConditional(tokens, forCondition);
            CustomHud.logInDebugMode("Tree for Conditional on line " + debugLine + ":");
            c.printTree(0);
            CustomHud.logInDebugMode("");
            return c;
        }
        catch (ErrorException e) {
            Errors.addError(profile.name, debugLine, source, e.type, e.context);
            CustomHud.logInDebugMode("[Line: " + debugLine + "] Conditional Couldn't Be Parsed: " + e.getMessage());
            CustomHud.logInDebugMode("Input: \"{" + input + "}\"");
            return forCondition ? new Operation.Literal(1.0) : new Operation.Literal(0.0);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<Token> getTokens(String original, Profile profile, int debugLine, ComplexData.Enabled enabled, ListProviderSet listSuppliers) throws ErrorException {
        ArrayList<Token> tokens = new ArrayList<Token>();
        char[] chars = original.toCharArray();
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (c == '(') {
                tokens.add(new Token(TokenType.START_PREN, null));
            } else if (c == ')') {
                tokens.add(new Token(TokenType.END_PREN, null));
            } else if (c == '?' && i + 1 != chars.length && chars[i + 1] == '?') {
                tokens.add(new Token(TokenType.MATH, (Object)MathOperator.IF_NULL));
                ++i;
            } else if (c == '?') {
                tokens.add(new Token(TokenType.IF, null));
            } else if (c == ';') {
                tokens.add(new Token(TokenType.ELSE, null));
            } else if (c == '\u2227' || c == '\u22c0') {
                tokens.add(new Token(TokenType.AND, null));
            } else if (c == '\u2228' || c == '\u22c1') {
                tokens.add(new Token(TokenType.OR, null));
            } else if (c == '|') {
                if (i + 1 != chars.length && chars[i + 1] == '|') {
                    ++i;
                }
                tokens.add(new Token(TokenType.OR, null));
            } else if (c == '&') {
                if (i + 1 != chars.length && chars[i + 1] == '&') {
                    ++i;
                }
                tokens.add(new Token(TokenType.AND, null));
            } else if (c == '=') {
                if (i + 1 != chars.length && chars[i + 1] == '=') {
                    ++i;
                }
                tokens.add(new Token(TokenType.COMPARISON, (Object)Comparison.EQUALS));
            } else if (c == '+') {
                tokens.add(new Token(TokenType.MATH, (Object)MathOperator.ADD));
            } else if (c == '*') {
                tokens.add(new Token(TokenType.MATH, (Object)MathOperator.MULTIPLY));
            } else if (c == '/') {
                tokens.add(new Token(TokenType.MATH, (Object)MathOperator.DIVIDE));
            } else if (c == '%') {
                tokens.add(new Token(TokenType.MATH, (Object)MathOperator.MOD));
            } else if (c == '^') {
                tokens.add(new Token(TokenType.MATH, (Object)MathOperator.EXPONENT));
            } else if (c == '-' && i + 1 < chars.length && !tokens.isEmpty() && SUBTRACTABLE.contains((Object)((Token)tokens.get((int)(tokens.size() - 1))).type)) {
                tokens.add(new Token(TokenType.MATH, (Object)MathOperator.SUBTRACT));
            } else if (c == '!') {
                if (i + 1 == chars.length) {
                    throw new ErrorException(ErrorType.CONDITIONAL_UNEXPECTED_VALUE, "!");
                }
                if (chars[i + 1] == '=') {
                    tokens.add(new Token(TokenType.COMPARISON, (Object)Comparison.NOT_EQUALS));
                    ++i;
                } else if (chars[i + 1] == '(') {
                    tokens.add(new Token(TokenType.START_PREN, NEGATE));
                    ++i;
                } else {
                    if (chars[i + 1] == 'h' && i + 1 + 2 < chars.length && (original.startsWith("has ", i + 1) || original.startsWith("has(", i + 1))) {
                        tokens.add(new Token(TokenType.COMPARISON, (Object)Comparison.NOT_HAS));
                        i += 4;
                        continue;
                    }
                    if (!ExpressionParser.isVar(chars[i + 1])) throw new ErrorException(ErrorType.CONDITIONAL_UNEXPECTED_VALUE, "!");
                    i += ExpressionParser.parseVariable(tokens, chars, i, profile, debugLine, enabled, listSuppliers) - 1;
                }
            } else {
                if (c == '>') {
                    boolean hasEqual = i + 1 != chars.length && chars[i + 1] == '=';
                    tokens.add(new Token(TokenType.COMPARISON, (Object)(hasEqual ? Comparison.GREATER_THAN_OR_EQUALS : Comparison.GREATER_THAN)));
                    i += hasEqual ? 2 : 1;
                    continue;
                }
                if (c == '<') {
                    boolean hasEqual = i + 1 != chars.length && chars[i + 1] == '=';
                    tokens.add(new Token(TokenType.COMPARISON, (Object)(hasEqual ? Comparison.LESS_THAN_OR_EQUAL : Comparison.LESS_THAN)));
                    i += hasEqual ? 2 : 1;
                    continue;
                }
                if (c == 'h' && i + 2 < chars.length && (original.startsWith("has ", i) || original.startsWith("has(", i))) {
                    tokens.add(new Token(TokenType.COMPARISON, (Object)Comparison.HAS));
                    i += 3;
                    continue;
                }
                if (c == '\u2208' || c == '\u220a') {
                    tokens.add(new Token(TokenType.COMPARISON, (Object)Comparison.IS_IN));
                } else if (c == '\u2209') {
                    tokens.add(new Token(TokenType.COMPARISON, (Object)Comparison.NOT_IS_IN));
                } else if (c == '\u220b' || c == '\u220d') {
                    tokens.add(new Token(TokenType.COMPARISON, (Object)Comparison.HAS));
                } else if (c == '\u220c') {
                    tokens.add(new Token(TokenType.COMPARISON, (Object)Comparison.NOT_HAS));
                } else if (c == '\u221a' && i + 1 != chars.length && chars[i + 1] == '(') {
                    tokens.add(new Token(TokenType.START_PREN, Math::sqrt));
                    ++i;
                } else {
                    if (c == 'f' && i + 4 < chars.length && original.startsWith("false", i)) {
                        tokens.add(new Token(TokenType.BOOLEAN, false));
                        i += 5;
                        continue;
                    }
                    if (c == 't' && i + 3 < chars.length && original.startsWith("true", i)) {
                        tokens.add(new Token(TokenType.BOOLEAN, true));
                        i += 4;
                        continue;
                    }
                    if (c == '\"') {
                        StringBuilder builder = new StringBuilder();
                        ++i;
                        while (i < chars.length && chars[i] != '\"') {
                            builder.append(chars[i++]);
                        }
                        tokens.add(new Token(TokenType.STRING, builder.toString()));
                    } else {
                        if (ExpressionParser.isNum(c) && c != '.' || c == '-') {
                            StringBuilder builder = new StringBuilder();
                            builder.append(chars[i++]);
                            while (i < chars.length && ExpressionParser.isNum(chars[i])) {
                                builder.append(chars[i++]);
                            }
                            tokens.add(new Token(TokenType.NUMBER, Double.parseDouble(builder.toString())));
                            continue;
                        }
                        if (ExpressionParser.isVar(c)) {
                            i += ExpressionParser.parseVariable(tokens, chars, i, profile, debugLine, enabled, listSuppliers);
                            continue;
                        }
                    }
                }
            }
            ++i;
        }
        int start = -1;
        for (int i2 = 0; i2 < tokens.size(); ++i2) {
            TokenType type = ((Token)tokens.get(i2)).type();
            if (type == TokenType.START_PREN) {
                start = i2;
                continue;
            }
            if (type != TokenType.END_PREN) continue;
            ExpressionParser.reducePren(tokens, start, i2);
            start = -1;
            i2 = -1;
        }
        ExpressionParser.reduceTernary0(tokens);
        return tokens;
    }

    private static boolean isNum(char c) {
        return c == '.' || c >= '0' && c <= '9';
    }

    private static boolean isVar(char c) {
        return c == '.' || c == ':' || c == '_' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '[' || c == ']' || c == ',' || c == '\u03c0' || c == '\u03c4' || c == '\u03c6';
    }

    private static int parseVariable(List<Token> tokens, char[] chars, int i, Profile profile, int debugLine, ComplexData.Enabled enabled, ListProviderSet listSuppliers) {
        class_3545<Token, Integer> func = ExpressionParser.getFunctionStart(chars, i);
        if (func != null) {
            tokens.add((Token)func.method_15442());
            return (Integer)func.method_15441();
        }
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        int offset = 0;
        boolean negate = false;
        if (chars[i] == '!') {
            negate = true;
            ++i;
            ++offset;
        }
        while (i < chars.length && ExpressionParser.isVar(chars[i])) {
            builder.append(chars[i]);
            ++i;
            ++offset;
        }
        builder.append('}');
        HudElement element = VariableParser.parseElement(builder.toString(), profile, debugLine, enabled, listSuppliers);
        if (element == null) {
            tokens.add(new Token(TokenType.BOOLEAN, false));
        } else {
            tokens.add(new Token(negate ? TokenType.NEGATED_VARIABLE : TokenType.VARIABLE, element));
        }
        return offset;
    }

    private static double round(double in) {
        return (double)Math.round(in * 100000.0) / 100000.0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static class_3545<Token, Integer> getFunctionStart(char[] chars, int i) {
        Function<Double, Double> function;
        String funcStr;
        int pren = -1;
        for (int j = i; j < chars.length; ++j) {
            if (chars[j] == '(') {
                pren = j;
                break;
            }
            if (ExpressionParser.isFunc(chars[j])) continue;
            return null;
        }
        if (pren == -1) {
            return null;
        }
        switch (funcStr = new String(Arrays.copyOfRange(chars, i, pren))) {
            case "sin": {
                function = SIN;
                break;
            }
            case "cos": {
                function = COS;
                break;
            }
            case "tan": {
                function = TAN;
                break;
            }
            case "csc": {
                function = CSC;
                break;
            }
            case "sec": {
                function = SEC;
                break;
            }
            case "cot": {
                function = COT;
                break;
            }
            case "asin": {
                function = ASIN;
                break;
            }
            case "acos": {
                function = ACOS;
                break;
            }
            case "atan": {
                function = ATAN;
                break;
            }
            case "acsc": {
                function = ACSC;
                break;
            }
            case "asec": {
                function = ASEC;
                break;
            }
            case "acot": {
                function = ACOT;
                break;
            }
            case "round": {
                function = ROUND;
                break;
            }
            case "ceil": {
                function = Math::ceil;
                break;
            }
            case "floor": {
                function = Math::floor;
                break;
            }
            case "ln": 
            case "log_e": {
                function = Math::log;
                break;
            }
            case "ln1p": 
            case "log_e1p": {
                function = Math::log1p;
                break;
            }
            case "log2": {
                function = LOG_2;
                break;
            }
            case "log": 
            case "log10": {
                function = Math::log10;
                break;
            }
            case "sqrt": {
                function = Math::sqrt;
                break;
            }
            case "abs": {
                function = Math::abs;
                break;
            }
            default: {
                return null;
            }
        }
        Function<Double, Double> func = function;
        if (func == null) {
            return null;
        }
        class_3545 class_35452 = new class_3545((Object)new Token(TokenType.START_PREN, func), (Object)(funcStr.length() + 1));
        return class_35452;
    }

    private static boolean isFunc(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static void reducePren(List<Token> original, int start, int end) {
        Function func = (Function)original.get((int)start).value;
        if (func == null) {
            original.set(start, new Token(TokenType.FULL_PREN, new ArrayList<Token>(original.subList(start + 1, end))));
        } else {
            original.set(start, new Token(TokenType.FUNCTION, new class_3545((Object)func, new ArrayList<Token>(original.subList(start + 1, end)))));
        }
        while (end > start) {
            original.remove(end);
            --end;
        }
    }

    private static void reduceTernary0(List<Token> original) {
        for (Token token : original) {
            if (token.type != TokenType.FULL_PREN) continue;
            ExpressionParser.reduceTernary0((List)token.value);
        }
        ExpressionParser.reduceTernary(original);
    }

    private static void reduceTernary(List<Token> original) {
        boolean foundIf;
        do {
            Token ter;
            List<Token> right;
            ArrayList<Token> left;
            int start = 0;
            int ifIndex = -1;
            int elseIndex = -1;
            foundIf = false;
            for (int i = 0; i < original.size(); ++i) {
                TokenType type = original.get(i).type();
                if (type == TokenType.IF) {
                    foundIf = true;
                    start = elseIndex != -1 ? elseIndex + 1 : ifIndex + 1;
                    ifIndex = i;
                    elseIndex = -1;
                    continue;
                }
                if (type != TokenType.ELSE || ifIndex == -1) continue;
                if (elseIndex == -1) {
                    elseIndex = i;
                    continue;
                }
                ArrayList<Token> conditional = new ArrayList<Token>(original.subList(start, ifIndex));
                ArrayList<Token> left2 = new ArrayList<Token>(original.subList(ifIndex + 1, elseIndex));
                ArrayList<Token> right2 = new ArrayList<Token>(original.subList(elseIndex + 1, i));
                Token ter2 = new Token(TokenType.TERNARY, new TernaryTokens(conditional, left2, right2));
                original.set(start, ter2);
                while (--i > start) {
                    original.remove(i);
                }
                i = -1;
                start = 0;
                elseIndex = -1;
                ifIndex = -1;
            }
            if (elseIndex != -1) {
                ArrayList<Token> conditional = new ArrayList<Token>(original.subList(start, ifIndex));
                left = new ArrayList<Token>(original.subList(ifIndex + 1, elseIndex));
                right = new ArrayList<Token>(original.subList(elseIndex + 1, original.size()));
                ter = new Token(TokenType.TERNARY, new TernaryTokens(conditional, left, right));
                original.set(start, ter);
                if (original.size() <= start + 1) continue;
                original.subList(start + 1, original.size()).clear();
                continue;
            }
            if (ifIndex == -1) continue;
            ArrayList<Token> conditional = new ArrayList<Token>(original.subList(start, ifIndex));
            left = new ArrayList<Token>(original.subList(ifIndex + 1, original.size()));
            right = Collections.emptyList();
            ter = new Token(TokenType.TERNARY, new TernaryTokens(conditional, left, right));
            original.set(start, ter);
            if (original.size() <= start + 1) continue;
            original.subList(start + 1, original.size()).clear();
        } while (foundIf);
    }

    private static Operation getConditional(List<Token> tokens, boolean forCondition) throws ErrorException {
        if (tokens.isEmpty()) {
            throw new ErrorException(ErrorType.EMPTY_SECTION, "");
        }
        List<List<Token>> ors = ExpressionParser.split(tokens, TokenType.OR);
        ArrayList<Operation> conditionals = new ArrayList<Operation>();
        for (List<Token> or : ors) {
            conditionals.add(ExpressionParser.getAndConditional(or));
        }
        if (conditionals.size() == 1) {
            Operation operation;
            Operation o = (Operation)conditionals.get(0);
            if (forCondition && o instanceof Operation.Element) {
                Operation.Element oe = (Operation.Element)o;
                operation = new Operation.ElementUseBool(oe.element());
            } else {
                operation = o;
            }
            return operation;
        }
        return new Operation.Or(conditionals);
    }

    private static Operation getAndConditional(List<Token> tokens) throws ErrorException {
        List<List<Token>> ands = ExpressionParser.split(tokens, TokenType.AND);
        ArrayList<Operation> conditionals = new ArrayList<Operation>();
        for (List<Token> and : ands) {
            conditionals.add(ExpressionParser.getComparisonOperation(and));
        }
        return conditionals.size() == 1 ? (Operation)conditionals.get(0) : new Operation.And(conditionals);
    }

    private static Operation getComparisonOperation(List<Token> tokens) throws ErrorException {
        if (tokens.size() == 1) {
            return ExpressionParser.getPrimitiveOperation(tokens.get(0));
        }
        int comparatorIndex = -1;
        for (int i = 0; i < tokens.size(); ++i) {
            if (tokens.get((int)i).type != TokenType.COMPARISON) continue;
            comparatorIndex = i;
            break;
        }
        if (comparatorIndex == -1) {
            return ExpressionParser.getMathOperation(tokens);
        }
        if (comparatorIndex == 0) {
            throw new ErrorException(ErrorType.CONDITIONAL_WRONG_NUMBER_OF_TOKENS, "No values on the left of comparison");
        }
        if (comparatorIndex == tokens.size() - 1) {
            throw new ErrorException(ErrorType.CONDITIONAL_WRONG_NUMBER_OF_TOKENS, "No values on the right of comparison");
        }
        HudElement left = comparatorIndex == 1 ? ExpressionParser.getValueElement(tokens.get(0)) : new SudoElements.Op(ExpressionParser.getMathOperation(tokens.subList(0, comparatorIndex)));
        HudElement right = comparatorIndex == tokens.size() - 2 ? ExpressionParser.getValueElement(tokens.get(tokens.size() - 1)) : new SudoElements.Op(ExpressionParser.getMathOperation(tokens.subList(comparatorIndex + 1, tokens.size())));
        return new Operation.Comparison(left, right, (Comparison)((Object)tokens.get(comparatorIndex).value()));
    }

    private static Operation getMathOperation(List<Token> tokens) throws ErrorException {
        if (tokens.size() == 1) {
            return ExpressionParser.getPrimitiveOperation(tokens.get(0));
        }
        if (tokens.size() == 2) {
            if (tokens.get((int)0).type == TokenType.MATH) {
                throw new ErrorException(ErrorType.CONDITIONAL_WRONG_NUMBER_OF_TOKENS, "No value on left side of operator");
            }
            if (tokens.get((int)1).type == TokenType.MATH) {
                throw new ErrorException(ErrorType.CONDITIONAL_WRONG_NUMBER_OF_TOKENS, "No value on right side of operator");
            }
            throw new ErrorException(ErrorType.CONDITIONAL_WRONG_NUMBER_OF_TOKENS, "No operation");
        }
        class_3545<List<List<Token>>, List<MathOperator>> ifNullPairs = ExpressionParser.split(tokens, List.of(MathOperator.IF_NULL));
        ArrayList<Operation> ops0 = new ArrayList<Operation>();
        for (List partTokens0 : (List)ifNullPairs.method_15442()) {
            class_3545<List<List<Token>>, List<MathOperator>> addPairs = ExpressionParser.split((List<Token>)partTokens0, List.of(MathOperator.ADD, MathOperator.SUBTRACT));
            ArrayList<Operation> ops1 = new ArrayList<Operation>();
            for (List partTokens : (List)addPairs.method_15442()) {
                class_3545<List<List<Token>>, List<MathOperator>> multiplyPairs = ExpressionParser.split((List<Token>)partTokens, List.of(MathOperator.MULTIPLY, MathOperator.DIVIDE, MathOperator.MOD));
                ArrayList<Operation> ops2 = new ArrayList<Operation>();
                for (List partPartToken : (List)multiplyPairs.method_15442()) {
                    class_3545<List<List<Token>>, List<MathOperator>> exponentPairs = ExpressionParser.split((List<Token>)partPartToken, List.of(MathOperator.EXPONENT));
                    ArrayList<HudElement> elements = new ArrayList<HudElement>();
                    for (List partPartPartToken : (List)exponentPairs.method_15442()) {
                        if (partPartPartToken.size() > 1) {
                            throw new ErrorException(ErrorType.CONDITIONAL_WRONG_NUMBER_OF_TOKENS, "No operation between values");
                        }
                        elements.add(ExpressionParser.getValueElement((Token)partPartPartToken.get(0)));
                    }
                    if (elements.size() == 1) {
                        ops2.add(new Operation.Element((HudElement)elements.get(0)));
                        continue;
                    }
                    ops2.add(new Operation.MathOperation(elements, (List)exponentPairs.method_15441()));
                }
                ops1.add(ops2.size() == 1 ? (Operation)ops2.get(0) : new Operation.MathOperationsOp(ops2, (List)multiplyPairs.method_15441()));
            }
            ops0.add(ops1.size() == 1 ? (Operation)ops1.get(0) : new Operation.MathOperationsOp(ops1, (List)addPairs.method_15441()));
        }
        return ops0.size() == 1 ? (Operation)ops0.get(0) : new Operation.MathOperationsOp(ops0, (List)ifNullPairs.method_15441());
    }

    private static HudElement getValueElement(Token token) throws ErrorException {
        return switch (token.type().ordinal()) {
            case 11 -> (HudElement)token.value();
            case 12 -> new SudoElements.Op(new Operation.Negate((HudElement)token.value()));
            case 9 -> new SudoElements.Str((String)token.value());
            case 8 -> new SudoElements.Num((Number)token.value());
            case 10 -> new SudoElements.Bool((Boolean)token.value());
            case 2 -> new SudoElements.Op(ExpressionParser.getConditional((List)token.value(), false));
            case 3 -> {
                class_3545 pair = (class_3545)token.value();
                yield new SudoElements.Op(new Operation.Func((Function)pair.method_15442(), ExpressionParser.getConditional((List)pair.method_15441(), false)));
            }
            case 15 -> {
                TernaryTokens tokens = (TernaryTokens)token.value();
                yield new SudoElements.Op(new Operation.Ternary(ExpressionParser.getConditional(tokens.conditional, true), ExpressionParser.getConditional(tokens.left, false), ExpressionParser.getConditional(tokens.right, false)));
            }
            case 13 -> throw new ErrorException(ErrorType.CONDITIONAL_UNEXPECTED_VALUE, "? (IF)");
            case 14 -> throw new ErrorException(ErrorType.CONDITIONAL_UNEXPECTED_VALUE, "; (ELSE)");
            default -> throw new ErrorException(ErrorType.CONDITIONAL_UNEXPECTED_VALUE, token.type().toString());
        };
    }

    private static Operation getPrimitiveOperation(Token token) throws ErrorException {
        return switch (token.type.ordinal()) {
            case 2 -> ExpressionParser.getConditional((List)token.value(), false);
            case 10 -> new Operation.Literal((Boolean)token.value() != false ? 1.0 : 0.0);
            case 8 -> new Operation.Literal((Double)token.value());
            case 11 -> new Operation.Element((HudElement)token.value());
            case 12 -> new Operation.Negate((HudElement)token.value());
            case 3 -> {
                class_3545 pair = (class_3545)token.value();
                yield new Operation.Func((Function)pair.method_15442(), ExpressionParser.getConditional((List)pair.method_15441(), false));
            }
            case 15 -> {
                TernaryTokens tokens = (TernaryTokens)token.value();
                yield new Operation.Ternary(ExpressionParser.getConditional(tokens.conditional, true), ExpressionParser.getConditional(tokens.left, false), ExpressionParser.getConditional(tokens.right, false));
            }
            case 13 -> throw new ErrorException(ErrorType.CONDITIONAL_UNEXPECTED_VALUE, "? (IF)");
            case 14 -> throw new ErrorException(ErrorType.CONDITIONAL_UNEXPECTED_VALUE, "; (ELSE)");
            default -> throw new ErrorException(ErrorType.CONDITIONAL_UNEXPECTED_VALUE, token.type().toString());
        };
    }

    private static List<List<Token>> split(List<Token> tokens, TokenType type) {
        ArrayList<List<Token>> sections = new ArrayList<List<Token>>();
        ArrayList<Token> current = new ArrayList<Token>();
        for (Token token : tokens) {
            if (token.type() == type) {
                sections.add(current);
                current = new ArrayList();
                continue;
            }
            current.add(token);
        }
        sections.add(current);
        return sections;
    }

    private static class_3545<List<List<Token>>, List<MathOperator>> split(List<Token> tokens, List<MathOperator> ops) {
        ArrayList sections = new ArrayList();
        ArrayList<MathOperator> operators = new ArrayList<MathOperator>();
        ArrayList<Token> current = new ArrayList<Token>();
        for (Token token : tokens) {
            if (token.type == TokenType.MATH && ops.contains(token.value())) {
                sections.add(current);
                operators.add((MathOperator)((Object)token.value()));
                current = new ArrayList();
                continue;
            }
            current.add(token);
        }
        sections.add(current);
        return new class_3545(sections, operators);
    }

    record Token(TokenType type, Object value) {
        @Override
        public String toString() {
            return String.valueOf((Object)this.type) + (String)(this.value == null ? "" : " (" + String.valueOf(this.value) + ")");
        }
    }

    public static enum TokenType {
        START_PREN,
        END_PREN,
        FULL_PREN,
        FUNCTION,
        AND,
        OR,
        MATH,
        COMPARISON,
        NUMBER,
        STRING,
        BOOLEAN,
        VARIABLE,
        NEGATED_VARIABLE,
        IF,
        ELSE,
        TERNARY;

    }

    public static enum MathOperator {
        ADD,
        SUBTRACT,
        MULTIPLY,
        DIVIDE,
        MOD,
        EXPONENT,
        IF_NULL;

    }

    public static enum Comparison {
        LESS_THAN,
        LESS_THAN_OR_EQUAL,
        GREATER_THAN,
        GREATER_THAN_OR_EQUALS,
        EQUALS,
        NOT_EQUALS,
        HAS,
        IS_IN,
        NOT_HAS,
        NOT_IS_IN;

    }

    public record TernaryTokens(List<Token> conditional, List<Token> left, List<Token> right) {
    }
}

