/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.customhud.conditionals;

import com.minenash.customhud.HudElements.interfaces.HudElement;
import com.minenash.customhud.conditionals.Operation;

public class SudoElements {

    public record Op(Operation op) implements HudElement
    {
        @Override
        public String getString() {
            return Double.toString(this.op.getValue());
        }

        @Override
        public Number getNumber() {
            return this.op.getValue();
        }

        @Override
        public boolean getBoolean() {
            return this.op.getValue() != 0.0;
        }
    }

    public record Bool(boolean bool) implements HudElement
    {
        @Override
        public String getString() {
            return Boolean.toString(this.bool);
        }

        @Override
        public Number getNumber() {
            return this.bool ? 1 : 0;
        }

        @Override
        public boolean getBoolean() {
            return this.bool;
        }
    }

    public record Num(Number number) implements HudElement
    {
        @Override
        public String getString() {
            return this.number.toString();
        }

        @Override
        public Number getNumber() {
            return this.number;
        }

        @Override
        public boolean getBoolean() {
            return this.number.doubleValue() > 0.0;
        }
    }

    public record Str(String str) implements HudElement
    {
        @Override
        public String getString() {
            return this.str;
        }

        @Override
        public Number getNumber() {
            return this.str.length();
        }

        @Override
        public boolean getBoolean() {
            return this.str.length() > 1;
        }
    }
}

