/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.customhud.HudElements;

import com.minenash.customhud.HudElements.interfaces.HudElement;
import com.minenash.customhud.HudElements.interfaces.NumElement;
import com.minenash.customhud.conditionals.Operation;
import com.minenash.customhud.data.Flags;
import com.minenash.customhud.data.NumberFlags;

public class TimerElement
implements HudElement,
NumElement {
    private final NumberFlags flags;
    private final Operation interval;
    private final Operation end;
    private long lastMS = System.currentTimeMillis();
    private int value = 0;

    public TimerElement(Operation end, Operation interval, Flags flags) {
        this.flags = NumberFlags.of(flags);
        this.interval = interval;
        this.end = end;
    }

    public int get() {
        long currentMs = System.currentTimeMillis();
        long diff = currentMs - this.lastMS;
        int inter = Math.max(1, (int)(this.interval.getValue() * 1000.0));
        this.lastMS = currentMs - diff % (long)inter;
        this.value = (int)((long)this.value + diff / (long)inter);
        if ((double)this.value >= this.end.getValue()) {
            this.value = 0;
        }
        return this.value;
    }

    @Override
    public String getString() {
        return this.flags.formatString(this.get());
    }

    @Override
    public Number getNumber() {
        return this.get();
    }

    @Override
    public boolean getBoolean() {
        return this.get() > 0;
    }

    @Override
    public int getPrecision() {
        return this.flags.precision();
    }
}

