/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.customhud.data;

import com.minenash.customhud.data.Flags;
import net.minecraft.class_3446;

public record NumberFlags(int precision, double scale, int zerofill, class_3446 formatter, int base) {
    private static final char[] RADIX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    public static NumberFlags of(Flags flags, int defaultPrecision, class_3446 formatter) {
        return new NumberFlags(flags.precision == -1 ? defaultPrecision : flags.precision, flags.scale, flags.zerofill, (class_3446)(flags.formatted ? formatter : null), flags.base);
    }

    public static NumberFlags of(Flags flags) {
        return NumberFlags.of(flags, 0, null);
    }

    public String formatString(double num) {
        if (Double.isNaN(num)) {
            return "-";
        }
        num *= this.scale;
        if (this.formatter != null) {
            return this.formatter.format((int)num);
        }
        if (this.base != 10) {
            return this.formatNonDecimalString(num);
        }
        if (this.precision == 0 && this.zerofill == 0) {
            return Long.toString((long)num);
        }
        String zf = this.zerofill == 0 ? "" : "0" + this.zerofill;
        return String.format("%" + zf + "." + this.precision + "f", num);
    }

    private String formatNonDecimalString(double num) {
        Object wholeStr;
        int whole = (int)num;
        double fractional = Math.abs(num % 1.0);
        String fracStr = "";
        if (this.precision != -1) {
            int length = Math.min(this.precision + 2, 32);
            int[] fracArray = new int[length];
            for (int i = 0; i < length; ++i) {
                fracArray[i] = (int)(fractional *= (double)this.base);
                if ((fractional %= 1.0) == 0.0) break;
            }
            if (this.precision < 31 && this.base > 2) {
                if (fracArray[this.precision + 1] >= this.base / 2) {
                    int n = this.precision;
                    fracArray[n] = fracArray[n] + 1;
                }
                if (fracArray[this.precision] >= this.base / 2) {
                    int n = this.precision - 1;
                    fracArray[n] = fracArray[n] + 1;
                }
            }
            StringBuilder fracBuilder = new StringBuilder();
            for (int i = this.precision - 1; i > 0; --i) {
                if (fracArray[i] >= this.base) {
                    int n = i - 1;
                    fracArray[n] = fracArray[n] + 1;
                    int n2 = i;
                    fracArray[n2] = fracArray[n2] - this.base;
                }
                fracBuilder.append(RADIX_CHARS[fracArray[i]]);
            }
            if (fracArray[0] >= this.base) {
                ++whole;
                fracArray[0] = fracArray[0] - this.base;
            }
            fracBuilder.append(RADIX_CHARS[fracArray[0]]);
            fracBuilder.append('.');
            fracStr = fracBuilder.reverse().toString();
        }
        if (((String)(wholeStr = Integer.toString(whole, this.base).toUpperCase())).length() < this.zerofill) {
            wholeStr = "0".repeat(this.zerofill - ((String)wholeStr).length()) + (String)wholeStr;
        }
        if (whole == 0 && num < 0.0) {
            wholeStr = "-" + (String)wholeStr;
        }
        return (String)wholeStr + fracStr;
    }
}

