/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.customhud.render;

import com.minenash.customhud.CustomHud;
import com.minenash.customhud.HudElements.functional.FunctionalElement;
import com.minenash.customhud.HudElements.icon.IconElement;
import com.minenash.customhud.HudElements.icon.NewTextureIconElement;
import com.minenash.customhud.HudElements.interfaces.ExecuteElement;
import com.minenash.customhud.HudElements.interfaces.HudElement;
import com.minenash.customhud.HudElements.interfaces.MultiElement;
import com.minenash.customhud.HudElements.text.TextElement;
import com.minenash.customhud.ProfileManager;
import com.minenash.customhud.complex.ListManager;
import com.minenash.customhud.data.CHFormatting;
import com.minenash.customhud.data.HudHiddenBehavior;
import com.minenash.customhud.data.HudTheme;
import com.minenash.customhud.data.Profile;
import com.minenash.customhud.data.Section;
import com.minenash.customhud.render.BackgroundBuilder;
import com.minenash.customhud.render.RenderPiece;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_10209;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_340;
import net.minecraft.class_408;
import net.minecraft.class_9779;

public class CustomHudRenderer3 {
    private static final class_310 client = class_310.method_1551();
    private static final class_2960 defaultFont = class_2960.method_60655((String)"minecraft", (String)"default");
    public static class_2960 font;
    public static HudTheme theme;

    public static void render(class_332 context, class_9779 tick) {
        Profile profile = ProfileManager.getActive();
        if (profile == null || client.method_53526().method_53536() || profile.hudHiddenBehavior == HudHiddenBehavior.HIDE && CustomHudRenderer3.client.field_1690.field_1842 || profile.hudHiddenBehavior == HudHiddenBehavior.SHOW_IF_SCREEN && CustomHudRenderer3.client.field_1690.field_1842 && CustomHudRenderer3.client.field_1755 == null) {
            return;
        }
        if (profile.baseTheme.getTargetGuiScale() != client.method_22683().method_4495()) {
            client.method_15993();
        }
        boolean isChatOpen = CustomHudRenderer3.client.field_1755 instanceof class_408;
        ArrayList<RenderPiece> pieces = new ArrayList<RenderPiece>();
        ArrayList<RenderPiece> wipPieces = new ArrayList<RenderPiece>();
        class_10209.method_64146().method_15396("custom_hud");
        class_10209.method_64146().method_15396("processing");
        context.method_51448().method_22903();
        context.method_51448().method_22905(profile.baseTheme.getScale(), profile.baseTheme.getScale(), 1.0f);
        context.method_51448().method_46416(0.0f, 0.0f, 560.0f);
        for (Section section : profile.sections) {
            if (section == null || isChatOpen && section.hideOnChat) continue;
            theme = profile.baseTheme;
            font = profile.baseTheme.font;
            BackgroundBuilder bgBuilder = new BackgroundBuilder(section);
            int totalHeight = 0;
            int xOffset = 0;
            int yOffset = 0;
            CHFormatting formatting = CustomHudRenderer3.theme.fgColor.copy();
            ArrayList<HudElement> elements = new ArrayList<HudElement>(section.elements);
            StringBuilder builder = new StringBuilder();
            block20: for (int i = 0; i < elements.size(); ++i) {
                FunctionalElement pl;
                HudElement e = (HudElement)elements.get(i);
                if (!(e instanceof FunctionalElement)) {
                    builder.append(e.getString());
                    continue;
                }
                if (e instanceof ExecuteElement) {
                    ExecuteElement ee = (ExecuteElement)((Object)e);
                    ee.run();
                    continue;
                }
                Object str = builder.toString();
                if (!((String)str).isEmpty()) {
                    if (CustomHudRenderer3.theme.ignoreLeadingSpace && xOffset == 0) {
                        str = CustomHudRenderer3.leftTrim((String)str);
                    }
                    str = formatting.getFormatting() + (String)str;
                    wipPieces.add(new RenderPiece(str, null, CustomHudRenderer3.theme.font, xOffset + section.hPaddingOffset(theme), yOffset + CustomHudRenderer3.theme.padding.top(), formatting.getColor(), CustomHudRenderer3.theme.bgColor, CustomHudRenderer3.theme.textShadow, CustomHudRenderer3.theme.lineSpacing == 0));
                    xOffset += CustomHudRenderer3.client.field_1772.method_1727((String)str);
                    builder.setLength(0);
                }
                if (e instanceof FunctionalElement.NewLine) {
                    if (e instanceof FunctionalElement.LineBreak) {
                        if (!CustomHudRenderer3.theme.convertLineBreaks || CustomHudRenderer3.theme.ignoreBlankLines && (i == 0 || elements.get(i - 1) instanceof FunctionalElement.LineBreak)) continue;
                        boolean maybeIgnore = false;
                        UUID listUUID = null;
                        for (int j = i - 1; j >= 0; --j) {
                            HudElement element = (HudElement)elements.get(j);
                            if (element instanceof FunctionalElement.IgnoreNewLineIfSurroundedByNewLine || listUUID != null && FunctionalElement.isList(element)) {
                                maybeIgnore = true;
                                if (j != 0) continue;
                                continue block20;
                            }
                            if (element instanceof FunctionalElement.LineBreak && maybeIgnore && listUUID == null) continue block20;
                            if (j == i - 1 && element instanceof FunctionalElement.PopList) {
                                FunctionalElement.PopList pl2 = (FunctionalElement.PopList)element;
                                listUUID = pl2.providerID;
                                continue;
                            }
                            if (listUUID != null && element instanceof FunctionalElement.PushList) {
                                FunctionalElement.PushList pl3 = (FunctionalElement.PushList)element;
                                if (listUUID.equals(pl3.providerID)) {
                                    listUUID = null;
                                    continue;
                                }
                            }
                            if (listUUID != null || !FunctionalElement.isList(element)) break;
                        }
                    }
                    if (e instanceof FunctionalElement.EndProfile && (i == 0 || elements.get(i - 1) instanceof FunctionalElement.NewLine)) continue;
                    for (int j = wipPieces.size() - 1; j >= 0; --j) {
                        RenderPiece piece = (RenderPiece)wipPieces.get(j);
                        if (piece.y != yOffset + CustomHudRenderer3.theme.padding.top()) break;
                        piece.lineWith = xOffset;
                    }
                    int height = 6 + CustomHudRenderer3.theme.lineSpacing + CustomHudRenderer3.theme.padding.top() + CustomHudRenderer3.theme.padding.bottom();
                    if (xOffset > 0) {
                        bgBuilder.addLine(yOffset, xOffset + CustomHudRenderer3.theme.padding.left() + CustomHudRenderer3.theme.padding.right(), height, CustomHudRenderer3.theme.bgColor);
                    }
                    yOffset += height;
                    totalHeight += height;
                    xOffset = 0;
                    formatting = CustomHudRenderer3.theme.fgColor.copy();
                    continue;
                }
                if (e instanceof TextElement) {
                    TextElement te = (TextElement)e;
                    wipPieces.add(new RenderPiece(te.getText(), null, font, xOffset + section.hPaddingOffset(theme), yOffset + CustomHudRenderer3.theme.padding.top(), te.getColor(formatting.getColor()), CustomHudRenderer3.theme.bgColor, CustomHudRenderer3.theme.textShadow, CustomHudRenderer3.theme.lineSpacing == 0));
                    xOffset += te.getTextWidth();
                    continue;
                }
                if (e instanceof MultiElement) {
                    MultiElement me = (MultiElement)((Object)e);
                    List<HudElement> expanded = me.expand();
                    if (expanded.isEmpty()) {
                        if (!CustomHudRenderer3.theme.convertLineBreaks || !me.ignoreNewlineIfEmpty()) continue;
                        elements.set(i, new FunctionalElement.IgnoreNewLineIfSurroundedByNewLine());
                        continue;
                    }
                    elements.addAll(i + 1, me.expand());
                    continue;
                }
                if (e instanceof IconElement) {
                    IconElement ie = (IconElement)e;
                    if (e instanceof NewTextureIconElement) {
                        NewTextureIconElement ntie = (NewTextureIconElement)e;
                        ntie.calculate();
                    }
                    wipPieces.add(new RenderPiece(ie, ListManager.getValue(ie.getProviderID()), null, xOffset + section.hPaddingOffset(theme), yOffset + CustomHudRenderer3.theme.padding.top(), formatting.getColor(), CustomHudRenderer3.theme.bgColor, false, CustomHudRenderer3.theme.fitItemIconsToLine));
                    xOffset += ie.getTextWidth();
                    continue;
                }
                if (e instanceof FunctionalElement.ChangeFormatting) {
                    FunctionalElement.ChangeFormatting cfe = (FunctionalElement.ChangeFormatting)e;
                    if (cfe.getFormatting() == null) continue;
                    formatting.apply(cfe.getFormatting(), theme);
                    continue;
                }
                if (e instanceof FunctionalElement.ChangeTheme) {
                    FunctionalElement.ChangeTheme cte = (FunctionalElement.ChangeTheme)e;
                    bgBuilder.onThemeChange(cte);
                    theme = cte.theme;
                    font = cte.theme.font;
                    continue;
                }
                if (e instanceof FunctionalElement.ExitList) {
                    FunctionalElement.ExitList el = (FunctionalElement.ExitList)e;
                    for (int j = i + 1; j < elements.size(); ++j) {
                        Object e2 = elements.get(j);
                        if (e2 instanceof FunctionalElement.PopList) {
                            pl = (FunctionalElement.PopList)e2;
                            if (pl.providerID.equals(el.providerID)) continue block20;
                        }
                        ++i;
                    }
                    continue;
                }
                if (!(e instanceof FunctionalElement.ContinueList)) continue;
                FunctionalElement.ContinueList cl = (FunctionalElement.ContinueList)e;
                for (int j = i + 1; j < elements.size(); ++j) {
                    Object e3 = elements.get(j);
                    if (e3 instanceof FunctionalElement.AdvanceList) {
                        pl = (FunctionalElement.AdvanceList)e3;
                        if (((FunctionalElement.AdvanceList)pl).providerID.equals(cl.providerID)) continue block20;
                    }
                    if ((e3 = elements.get(j)) instanceof FunctionalElement.PopList) {
                        pl = (FunctionalElement.PopList)e3;
                        if (pl.providerID.equals(cl.providerID)) continue block20;
                    }
                    ++i;
                }
            }
            int width = section.width > 0 ? section.width : bgBuilder.maxWidth;
            int n = section.xOffset;
            int sectionXOffset = n + (switch (section.sAlign) {
                default -> throw new IncompatibleClassChangeError();
                case Section.Align.LEFT -> 3;
                case Section.Align.RIGHT -> (int)((float)client.method_22683().method_4486() * (1.0f / theme.getScale())) - width - 1;
                case Section.Align.CENTER -> (int)((float)client.method_22683().method_4486() * (1.0f / theme.getScale())) / 2 - width / 2;
            });
            int sectionYOffset = section.yOffset + (section instanceof Section.Top ? 1 : (section instanceof Section.Bottom ? (int)((float)client.method_22683().method_4502() * (1.0f / theme.getScale())) - totalHeight - 8 : (int)((float)client.method_22683().method_4502() * (1.0f / theme.getScale())) / 2 - totalHeight / 2 - 1));
            if (section.textAlign == Section.Align.RIGHT) {
                if (section.width < 0) {
                    for (RenderPiece piece : wipPieces) {
                        pieces.add(piece.adjust(sectionXOffset + bgBuilder.maxWidth - piece.lineWith, sectionYOffset));
                    }
                } else {
                    for (RenderPiece piece : wipPieces) {
                        pieces.add(piece.adjust(sectionXOffset + section.width - piece.lineWith, sectionYOffset));
                    }
                }
            } else if (section.textAlign == Section.Align.CENTER) {
                for (RenderPiece piece : wipPieces) {
                    pieces.add(piece.adjust(sectionXOffset + width / 2 - piece.lineWith / 2, sectionYOffset));
                }
            } else {
                for (RenderPiece piece : wipPieces) {
                    pieces.add(piece.adjust(sectionXOffset, sectionYOffset));
                }
            }
            bgBuilder.finalizeBg(context, sectionXOffset, sectionYOffset);
            wipPieces.clear();
        }
        class_10209.method_64146().method_15407();
        class_10209.method_64146().method_15396("rendering");
        for (RenderPiece piece : pieces) {
            String value;
            font = piece.font;
            Object yOffset = piece.element;
            if (yOffset instanceof IconElement) {
                IconElement ie = (IconElement)yOffset;
                try {
                    ie.render(context, piece);
                }
                catch (Exception e) {
                    CustomHud.LOGGER.catching((Throwable)e);
                }
                continue;
            }
            Object object = piece.element;
            if (object instanceof String && !(value = (String)object).isEmpty()) {
                context.method_51433(CustomHudRenderer3.client.field_1772, value, piece.x, piece.shiftTextUpOrFitItemIcon ? piece.y - 1 : piece.y, piece.color, piece.shadow);
                continue;
            }
            object = piece.element;
            if (!(object instanceof class_2561)) continue;
            class_2561 text = (class_2561)object;
            text = text.method_10866().method_27708().equals((Object)defaultFont) ? text.method_27661().method_10862(text.method_10866().method_27704(font)) : text;
            context.method_51439(CustomHudRenderer3.client.field_1772, text, piece.x, piece.shiftTextUpOrFitItemIcon ? piece.y - 1 : piece.y, piece.color, piece.shadow);
        }
        if (profile.charts) {
            int right = context.method_51421();
            int center = right / 2;
            class_340 hud = CustomHudRenderer3.client.field_1705.method_53531();
            switch (profile.leftChart) {
                case FPS: {
                    hud.field_45910.method_53472(context, 0, hud.field_45910.method_53470(center));
                    break;
                }
                case TICK: {
                    hud.field_45913.method_53472(context, 0, hud.field_45913.method_53470(center));
                    break;
                }
                case PING: {
                    hud.field_45911.method_53472(context, 0, hud.field_45911.method_53470(center));
                    break;
                }
                case PACKET_SIZE: {
                    hud.field_45912.method_53472(context, 0, hud.field_45912.method_53470(center));
                }
            }
            switch (profile.rightChart) {
                case FPS: {
                    int w = hud.field_45910.method_53470(center);
                    hud.field_45910.method_53472(context, right - w, w);
                    break;
                }
                case TICK: {
                    int w = hud.field_45913.method_53470(center);
                    hud.field_45913.method_53472(context, right - w, w);
                    break;
                }
                case PING: {
                    int w = hud.field_45911.method_53470(center);
                    hud.field_45911.method_53472(context, right - w, w);
                    break;
                }
                case PACKET_SIZE: {
                    int w = hud.field_45912.method_53470(center);
                    hud.field_45912.method_53472(context, right - w, w);
                }
            }
        }
        class_10209.method_64146().method_15407();
        context.method_51448().method_22909();
        font = null;
        class_10209.method_64146().method_15407();
    }

    private static String leftTrim(String str) {
        int i;
        for (i = 0; i < str.length() && Character.isWhitespace(str.charAt(i)); ++i) {
        }
        return str.substring(i);
    }
}

