/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.customhud.HudElements.list;

import com.minenash.customhud.data.Profile;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

@FunctionalInterface
public interface ListProvider {
    public static final RequiredModmenu REGUIRES_MODMENU = new RequiredModmenu();

    public List<?> get();

    public static class RequiredModmenu
    implements ListProvider {
        @Override
        public List<?> get() {
            return null;
        }
    }

    public static class EventListProvider<T>
    implements ListProvider {
        private final String id;
        private final List<T> entries = new ArrayList<T>();

        public EventListProvider(String id) {
            this.id = id;
        }

        public EventListProvider<?> register(Profile profile) {
            profile.listEvents.put(this.id, this);
            return this;
        }

        public void reset() {
            this.entries.clear();
        }

        public void add(T entry) {
            this.entries.add(entry);
        }

        @Override
        public List<?> get() {
            return this.entries;
        }
    }

    public record ListFunctioner<T>(Supplier<T> supplier, Function<T, List<?>> function) implements ListProvider
    {
        @Override
        public List<?> get() {
            return this.function.apply(this.supplier.get());
        }
    }
}

