/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.customhud.gui.profiles_widget;

import com.minenash.customhud.CustomHud;
import com.minenash.customhud.ProfileManager;
import com.minenash.customhud.data.Profile;
import com.minenash.customhud.errors.Errors;
import com.minenash.customhud.gui.ErrorsScreen;
import com.minenash.customhud.gui.NewConfigScreen;
import com.minenash.customhud.gui.TogglesScreen;
import com.minenash.customhud.gui.profiles_widget.LineEntry;
import com.minenash.customhud.gui.profiles_widget.ProfileLinesWidget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_6379;
import net.minecraft.class_7919;

public class ProfileLineEntry
extends LineEntry {
    public final class_4185 selected;
    public final class_4185 cycled;
    public final class_4185 toggles;
    private final class_4185 keybind;
    private final class_4185 edit;
    private final class_4185 error;
    private final class_4185 delete;
    private final class_4185 up;
    private final class_4185 down;
    public final class_342 editName;
    private final ProfileLinesWidget widget;
    public final Profile profile;
    private String displayName;
    private static final List<Character> invalidCharacters = List.of(Character.valueOf('\\'), Character.valueOf('/'), Character.valueOf(':'), Character.valueOf('*'), Character.valueOf('?'), Character.valueOf('\"'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('|'));

    public ProfileLineEntry(Profile profile, ProfileLinesWidget widget) {
        this.profile = profile;
        this.widget = widget;
        this.displayName = profile.name;
        this.selected = ProfileLineEntry.button(ProfileManager.getActive() == profile ? "\u2611" : "\u2610", "Swap to this profile", 16, b -> {
            ProfileManager.setActive(profile);
            b.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)(ProfileManager.getActive() == profile ? "Turn off this profile" : "Swap to this profile"))));
        });
        this.edit = ProfileLineEntry.button("Edit", "Open in your text editor", 40, b -> ProfileManager.open(profile));
        this.cycled = ProfileLineEntry.button(profile.cycle ? "\u2611" : "\u2610", "Include this profile in the profile cycle", 16, b -> {
            profile.cycle = !profile.cycle;
            b.method_25355((class_2561)class_2561.method_43470((String)(profile.cycle ? "\u2611" : "\u2610")));
        });
        this.keybind = ProfileLineEntry.button(profile.keyBinding.method_16007().getString(), "Keybind to switch to this profile", 80, b -> {
            widget.screen.selectedKeybind = profile.keyBinding;
            widget.update();
        });
        int errors = Errors.getErrors(profile.name).size();
        int toggles = profile.toggles.size();
        this.error = ProfileLineEntry.button("\u00a7c!", "\u00a7c" + (String)(errors == 1 ? "1 Error Found" : errors + " Errors Found"), 16, b -> CustomHud.CLIENT.method_1507((class_437)new ErrorsScreen(widget.screen, profile)));
        this.toggles = ProfileLineEntry.button("Toggles", (String)(toggles == 1 ? "1 Toggle in the profile" : toggles + " Toggles in the profile"), 48, b -> CustomHud.CLIENT.method_1507((class_437)new TogglesScreen(widget.screen, profile)));
        this.delete = ProfileLineEntry.button("\u00a7cDelete", "\u00a7cThis Can't Be \u00a7nUndone!!!!", 48, b -> widget.deleteProfile(this));
        this.up = ProfileLineEntry.button("\u00a7a\u2191", 16, b -> widget.move(this, -1));
        this.down = ProfileLineEntry.button("\u00a7c\u2193", 16, b -> widget.move(this, 1));
        this.editName = new class_342(CustomHud.CLIENT.field_1772, 0, 0, 200, 16, (class_2561)class_2561.method_43470((String)"Edit Name"));
        this.editName.method_1852(profile.name);
        this.editName.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Click to edit name")));
        this.editName.method_1856(true);
        this.editName.method_1890(str -> {
            for (int i = 0; i < str.length(); ++i) {
                if (!invalidCharacters.contains(Character.valueOf(str.charAt(i)))) continue;
                return false;
            }
            return true;
        });
        this.editName.method_1863(n -> {
            widget.screen.editing = this;
        });
    }

    @Override
    public void update() {
        this.keybind.method_25355(this.profile.keyBinding.method_16007());
        if (this.widget.screen.selectedKeybind == this.profile.keyBinding) {
            this.keybind.method_25355((class_2561)class_2561.method_43470((String)"> ").method_10852((class_2561)this.keybind.method_25369().method_27661().method_27695(new class_124[]{class_124.field_1068, class_124.field_1073})).method_27693(" <").method_27692(class_124.field_1054));
        }
        this.editName.method_25365(false);
        if (!this.editName.method_1882().equals(this.profile.name)) {
            ProfileManager.rename(this.profile, this.editName.method_1882());
        }
    }

    public void method_25343(class_332 context, int mX, int mY, boolean hovered, float delta) {
        int x = this.method_73380();
        int y = this.method_73382();
        int eWidth = this.method_73387();
        this.editName.method_46421(x + 16 + 20);
        this.editName.method_46419(y);
        this.editName.method_25358(eWidth - 16 - 20 - 16 - 42 - 82 - 18 - (this.profile.toggles.isEmpty() ? 0 : 50) - 3);
        if (this.editName.method_25367() || this.editName.method_25405((double)mX, (double)mY)) {
            this.editName.method_25394(context, mX, mY, delta);
        } else {
            if (!this.editName.method_1882().equals(this.profile.name)) {
                ProfileManager.rename(this.profile, this.editName.method_1882());
                this.displayName = this.profile.name;
            }
            context.method_25303(CustomHud.CLIENT.field_1772, this.truncateName(x, eWidth), x + 16 + 20 + 4, y + 4, -1);
        }
        this.selected.method_25355((class_2561)class_2561.method_43470((String)(ProfileManager.getActive() == this.profile ? "\u2611" : "\u2610")));
        this.posAndRender(context, mX, mY, delta, x, y, eWidth, this.selected, 2);
        if (this.widget.screen.mode == NewConfigScreen.Mode.DELETE) {
            this.posAndRender(context, mX, mY, delta, x, y, eWidth, this.delete, -58);
            return;
        }
        if (this.widget.screen.mode == NewConfigScreen.Mode.REORDER) {
            this.down.field_22763 = this.widget.method_25396().get(this.widget.method_25396().size() - 2) != this;
            this.down.method_25355((class_2561)class_2561.method_43470((String)(this.down.field_22763 ? "\u00a7c\u2193" : "\u00a74\u2193")));
            this.posAndRender(context, mX, mY, delta, x, y, eWidth, this.down, -34);
            this.up.field_22763 = this.widget.method_25396().get(0) != this;
            this.up.method_25355((class_2561)class_2561.method_43470((String)(this.up.field_22763 ? "\u00a7a\u2191" : "\u00a72\u2191")));
            this.posAndRender(context, mX, mY, delta, x, y, eWidth, this.up, -52);
            return;
        }
        if (Errors.hasErrors(this.profile.name)) {
            this.posAndRender(context, mX, mY, delta, x, y, eWidth, this.error, -16);
        }
        this.posAndRender(context, mX, mY, delta, x, y, eWidth, this.edit, -58);
        this.posAndRender(context, mX, mY, delta, x, y, eWidth, this.keybind, -140);
        this.posAndRender(context, mX, mY, delta, x, y, eWidth, this.cycled, -158);
        boolean bl = this.toggles.field_22763 = !this.profile.toggles.isEmpty();
        if (this.toggles.field_22763) {
            this.posAndRender(context, mX, mY, delta, x, y, eWidth, this.toggles, -208);
        }
    }

    private String truncateName(int x, int eWidth) {
        String name = this.displayName;
        int width = CustomHud.CLIENT.field_1772.method_1727(name);
        int maxWidth = x + eWidth + (switch (this.widget.screen.mode) {
            default -> throw new IncompatibleClassChangeError();
            case NewConfigScreen.Mode.NORMAL -> -158 - (this.profile.toggles.isEmpty() ? 0 : 50);
            case NewConfigScreen.Mode.REORDER -> -52;
            case NewConfigScreen.Mode.DELETE -> -58;
        }) - 2 - (x + 16 + 20 + 4);
        if (maxWidth > width) {
            return name;
        }
        maxWidth -= CustomHud.CLIENT.field_1772.method_1727("\u2026") + 2;
        while (width > maxWidth) {
            name = name.substring(0, name.length() - 1);
            width = CustomHud.CLIENT.field_1772.method_1727(name);
        }
        return name + "\u2026";
    }

    public List<? extends class_6379> method_37025() {
        return this.widgets();
    }

    public List<? extends class_364> method_25396() {
        return this.widgets();
    }

    public List<class_339> widgets() {
        ArrayList<class_339> widgets = new ArrayList<class_339>(6);
        widgets.add((class_339)this.selected);
        widgets.add((class_339)this.editName);
        if (this.widget.screen.mode == NewConfigScreen.Mode.DELETE) {
            widgets.add((class_339)this.delete);
        } else if (this.widget.screen.mode == NewConfigScreen.Mode.REORDER) {
            widgets.add((class_339)this.up);
            widgets.add((class_339)this.down);
        } else {
            widgets.add((class_339)this.toggles);
            widgets.add((class_339)this.cycled);
            widgets.add((class_339)this.keybind);
            widgets.add((class_339)this.edit);
            if (Errors.hasErrors(this.profile.name)) {
                widgets.add((class_339)this.error);
            }
        }
        return widgets;
    }
}

