/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads;

import net.countered.settlementroads.client.gui.ClothConfigScreen;
import net.countered.settlementroads.config.forge.ForgeJsonConfig;
import net.countered.settlementroads.datagen.SettlementRoadsDataGenerator;
import net.countered.settlementroads.events.ModEventHandler;
import net.countered.settlementroads.features.config.forge.ForgeRoadFeatureRegistry;
import net.countered.settlementroads.network.RoadWeaverNetworkManager;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="roadweaver")
public class SettlementRoads {
    public static final String MOD_ID = "roadweaver";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadweaver");

    public SettlementRoads() {
        LOGGER.info("Initializing RoadWeaver (Forge)...");
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ForgeJsonConfig.load();
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((client, parent) -> ClothConfigScreen.createConfigScreen(parent)));
        ForgeRoadFeatureRegistry.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(SettlementRoadsDataGenerator::gatherData);
        ModEventHandler.register();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            RoadWeaverNetworkManager.registerPackets();
            LOGGER.info("Network packets registered");
        });
        LOGGER.info("RoadWeaver common setup completed");
    }

    public static Logger getLogger() {
        return LOGGER;
    }
}

