/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.client;

import java.util.ArrayList;
import java.util.List;
import net.countered.settlementroads.client.gui.RoadDebugScreen;
import net.countered.settlementroads.helpers.Records;
import net.countered.settlementroads.network.DebugDataPacket;
import net.countered.settlementroads.network.PacketHandler;
import net.countered.settlementroads.network.RoadWeaverNetworkManager;
import net.countered.settlementroads.persistence.forge.WorldDataHelper;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="roadweaver", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class SettlementRoadsClient {
    private static KeyMapping debugMapKey;

    @SubscribeEvent
    public static void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        debugMapKey = new KeyMapping("key.roadweaver.debug_map", 72, "category.roadweaver");
        event.register(debugMapKey);
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
    }

    private static void handleDebugMapKey(Minecraft client) {
        if (client.f_91080_ instanceof RoadDebugScreen) {
            client.execute(() -> client.m_91152_(null));
            PacketHandler.clearCachedDebugData();
            return;
        }
        if (client.m_91092_() != null) {
            ServerLevel world = client.m_91092_().m_129783_();
            if (world == null) {
                return;
            }
            try {
                Records.StructureLocationData structureData = WorldDataHelper.getStructureLocations((Level)world);
                List<Records.StructureConnection> connections = WorldDataHelper.getConnectedStructures((Level)world);
                List<Records.RoadData> roads = WorldDataHelper.getRoadDataList((Level)world);
                ArrayList<Records.StructureInfo> structureInfos = structureData != null ? new ArrayList<Records.StructureInfo>(structureData.structureInfos()) : new ArrayList();
                client.execute(() -> client.m_91152_((Screen)new RoadDebugScreen(structureInfos, connections, roads)));
            }
            catch (Exception e) {
                client.execute(() -> client.m_91152_((Screen)new RoadDebugScreen(new ArrayList<Records.StructureInfo>(), new ArrayList<Records.StructureConnection>(), new ArrayList<Records.RoadData>())));
            }
        } else if (client.f_91074_ != null && client.m_91403_() != null) {
            if (!client.f_91074_.m_20310_(2)) {
                client.execute(() -> {
                    if (client.f_91074_ != null) {
                        client.f_91074_.m_5661_((Component)Component.m_237115_((String)"roadweaver.debug_map.no_permission"), true);
                    }
                });
                return;
            }
            RoadWeaverNetworkManager.requestDebugData();
            client.execute(() -> {
                if (client.f_91074_ != null) {
                    client.f_91074_.m_5661_((Component)Component.m_237115_((String)"roadweaver.debug_map.loading"), true);
                }
            });
            new Thread(() -> {
                try {
                    for (int i = 0; i < 50; ++i) {
                        Thread.sleep(100L);
                        DebugDataPacket cachedData = PacketHandler.getCachedDebugData();
                        if (cachedData == null) continue;
                        client.execute(() -> client.m_91152_((Screen)new RoadDebugScreen(cachedData.getStructureInfos(), cachedData.getConnections(), cachedData.getRoads())));
                        return;
                    }
                    client.execute(() -> {
                        if (client.f_91074_ != null) {
                            client.f_91074_.m_5661_((Component)Component.m_237115_((String)"roadweaver.debug_map.timeout"), false);
                        }
                    });
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }).start();
        }
    }

    @Mod.EventBusSubscriber(modid="roadweaver", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    public static class ClientEvents {
        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            Minecraft client = Minecraft.m_91087_();
            while (debugMapKey.m_90859_()) {
                SettlementRoadsClient.handleDebugMapKey(client);
            }
        }
    }
}

