/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.config.forge;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.fml.loading.FMLPaths;

public class ForgeJsonConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FMLPaths.CONFIGDIR.get().resolve("roadweaver.json");
    private static ConfigData data = new ConfigData();

    public static List<String> getStructuresToLocate() {
        return ForgeJsonConfig.data.structuresToLocate;
    }

    public static void setStructuresToLocate(List<String> value) {
        ForgeJsonConfig.data.structuresToLocate = value != null ? value : new ArrayList();
    }

    public static int getStructureSearchRadius() {
        return ForgeJsonConfig.data.structureSearchRadius;
    }

    public static void setStructureSearchRadius(int value) {
        ForgeJsonConfig.data.structureSearchRadius = value;
    }

    public static int getInitialLocatingCount() {
        return ForgeJsonConfig.data.initialLocatingCount;
    }

    public static void setInitialLocatingCount(int value) {
        ForgeJsonConfig.data.initialLocatingCount = value;
    }

    public static int getMaxConcurrentRoadGeneration() {
        return ForgeJsonConfig.data.maxConcurrentRoadGeneration;
    }

    public static void setMaxConcurrentRoadGeneration(int value) {
        ForgeJsonConfig.data.maxConcurrentRoadGeneration = value;
    }

    public static int getStructureSearchTriggerDistance() {
        return ForgeJsonConfig.data.structureSearchTriggerDistance;
    }

    public static void setStructureSearchTriggerDistance(int value) {
        ForgeJsonConfig.data.structureSearchTriggerDistance = Math.max(150, Math.min(1500, value));
    }

    public static int getAveragingRadius() {
        return ForgeJsonConfig.data.averagingRadius;
    }

    public static void setAveragingRadius(int value) {
        ForgeJsonConfig.data.averagingRadius = value;
    }

    public static boolean getAllowArtificial() {
        return ForgeJsonConfig.data.allowArtificial;
    }

    public static void setAllowArtificial(boolean value) {
        ForgeJsonConfig.data.allowArtificial = value;
    }

    public static boolean getAllowNatural() {
        return ForgeJsonConfig.data.allowNatural;
    }

    public static void setAllowNatural(boolean value) {
        ForgeJsonConfig.data.allowNatural = value;
    }

    public static int getStructureDistanceFromRoad() {
        return ForgeJsonConfig.data.structureDistanceFromRoad;
    }

    public static void setStructureDistanceFromRoad(int value) {
        ForgeJsonConfig.data.structureDistanceFromRoad = value;
    }

    public static int getMaxHeightDifference() {
        return ForgeJsonConfig.data.maxHeightDifference;
    }

    public static void setMaxHeightDifference(int value) {
        ForgeJsonConfig.data.maxHeightDifference = value;
    }

    public static int getMaxTerrainStability() {
        return ForgeJsonConfig.data.maxTerrainStability;
    }

    public static void setMaxTerrainStability(int value) {
        ForgeJsonConfig.data.maxTerrainStability = value;
    }

    public static boolean getPlaceWaypoints() {
        return ForgeJsonConfig.data.placeWaypoints;
    }

    public static void setPlaceWaypoints(boolean value) {
        ForgeJsonConfig.data.placeWaypoints = value;
    }

    public static boolean getPlaceRoadFences() {
        return ForgeJsonConfig.data.placeRoadFences;
    }

    public static void setPlaceRoadFences(boolean value) {
        ForgeJsonConfig.data.placeRoadFences = value;
    }

    public static boolean getPlaceSwings() {
        return ForgeJsonConfig.data.placeSwings;
    }

    public static void setPlaceSwings(boolean value) {
        ForgeJsonConfig.data.placeSwings = value;
    }

    public static boolean getPlaceBenches() {
        return ForgeJsonConfig.data.placeBenches;
    }

    public static void setPlaceBenches(boolean value) {
        ForgeJsonConfig.data.placeBenches = value;
    }

    public static boolean getPlaceGloriettes() {
        return ForgeJsonConfig.data.placeGloriettes;
    }

    public static void setPlaceGloriettes(boolean value) {
        ForgeJsonConfig.data.placeGloriettes = value;
    }

    public static int getManualMaxHeightDifference() {
        return ForgeJsonConfig.data.manualMaxHeightDifference;
    }

    public static void setManualMaxHeightDifference(int value) {
        ForgeJsonConfig.data.manualMaxHeightDifference = value;
    }

    public static int getManualMaxTerrainStability() {
        return ForgeJsonConfig.data.manualMaxTerrainStability;
    }

    public static void setManualMaxTerrainStability(int value) {
        ForgeJsonConfig.data.manualMaxTerrainStability = value;
    }

    public static boolean getManualIgnoreWater() {
        return ForgeJsonConfig.data.manualIgnoreWater;
    }

    public static void setManualIgnoreWater(boolean value) {
        ForgeJsonConfig.data.manualIgnoreWater = value;
    }

    public static void load() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                String json = Files.readString(CONFIG_PATH);
                data = (ConfigData)GSON.fromJson(json, ConfigData.class);
                if ((ForgeJsonConfig.data.structuresToLocate == null || ForgeJsonConfig.data.structuresToLocate.isEmpty()) && ForgeJsonConfig.data.structureToLocate != null && !ForgeJsonConfig.data.structureToLocate.isBlank()) {
                    ForgeJsonConfig.data.structuresToLocate = ForgeJsonConfig.tokenizeToList(ForgeJsonConfig.data.structureToLocate);
                    ForgeJsonConfig.data.structureToLocate = null;
                    ForgeJsonConfig.save();
                }
                if (ForgeJsonConfig.data.structureSearchTriggerDistance < 150 || ForgeJsonConfig.data.structureSearchTriggerDistance > 1500) {
                    ForgeJsonConfig.data.structureSearchTriggerDistance = 500;
                    ForgeJsonConfig.save();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            if (ForgeJsonConfig.data.structuresToLocate == null || ForgeJsonConfig.data.structuresToLocate.isEmpty()) {
                ForgeJsonConfig.data.structuresToLocate = new ArrayList<String>(List.of("#minecraft:village"));
            }
            ForgeJsonConfig.save();
        }
    }

    public static void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            Files.writeString(CONFIG_PATH, (CharSequence)GSON.toJson((Object)data), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static List<String> tokenizeToList(String raw) {
        ArrayList<String> list = new ArrayList<String>();
        if (raw == null) {
            return list;
        }
        String normalized = raw.replace('\r', '\n');
        List<String> lines = Arrays.asList(normalized.split("\n"));
        for (String line : lines) {
            String[] tokens;
            String trimmed;
            if (line == null || (trimmed = line.trim()).isEmpty()) continue;
            for (String t : tokens = trimmed.split("[;,\\s]+")) {
                String token;
                if (t == null || (token = t.trim()).isEmpty()) continue;
                list.add(token);
            }
        }
        return list;
    }

    private static class ConfigData {
        String structureToLocate = "#minecraft:village";
        List<String> structuresToLocate = new ArrayList<String>(List.of("#minecraft:village"));
        int structureSearchRadius = 100;
        int initialLocatingCount = 7;
        int maxConcurrentRoadGeneration = 3;
        int structureSearchTriggerDistance = 600;
        int averagingRadius = 1;
        boolean allowArtificial = true;
        boolean allowNatural = false;
        int structureDistanceFromRoad = 4;
        int maxHeightDifference = 5;
        int maxTerrainStability = 4;
        boolean placeWaypoints = false;
        boolean placeRoadFences = true;
        boolean placeSwings = false;
        boolean placeBenches = false;
        boolean placeGloriettes = false;
        int manualMaxHeightDifference = 10;
        int manualMaxTerrainStability = 10;
        boolean manualIgnoreWater = false;

        private ConfigData() {
        }
    }
}

