/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.events;

import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.TickEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.countered.settlementroads.config.ConfigProvider;
import net.countered.settlementroads.config.IModConfig;
import net.countered.settlementroads.features.RoadFeature;
import net.countered.settlementroads.features.config.RoadFeatureConfig;
import net.countered.settlementroads.features.roadlogic.Road;
import net.countered.settlementroads.features.roadlogic.RoadPathCalculator;
import net.countered.settlementroads.helpers.Records;
import net.countered.settlementroads.helpers.StructureConnector;
import net.countered.settlementroads.persistence.WorldDataProvider;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModEventHandler {
    private static final int THREAD_COUNT = 128;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadweaver");
    private static ExecutorService executor = Executors.newFixedThreadPool(128);
    private static final ConcurrentHashMap<String, Future<?>> runningTasks = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Integer> worldInitDelay = new ConcurrentHashMap();
    private static final int INIT_DELAY_TICKS = 100;

    public static void register() {
        WorldDataProvider dataProvider = WorldDataProvider.getInstance();
        LifecycleEvent.SERVER_LEVEL_LOAD.register(ModEventHandler::onWorldLoad);
        LifecycleEvent.SERVER_LEVEL_UNLOAD.register(level -> {
            if (!level.m_46472_().equals(Level.f_46428_)) {
                return;
            }
            String worldKey = level.m_46472_().m_135782_().toString();
            Future<?> task = runningTasks.remove(worldKey);
            if (task != null && !task.isDone()) {
                task.cancel(true);
                LOGGER.debug("Aborted running road task for world: {}", (Object)level.m_46472_().m_135782_());
            }
            worldInitDelay.remove(worldKey);
            StructureConnector.clearQueueForWorld(level);
        });
        TickEvent.SERVER_PRE.register(server -> {
            for (ServerLevel level : server.m_129785_()) {
                if (!level.m_46472_().equals(Level.f_46428_)) continue;
                ModEventHandler.tryGenerateNewRoads(level, true, 5000);
            }
        });
        LifecycleEvent.SERVER_STOPPING.register(server -> {
            RoadPathCalculator.heightCache.clear();
            runningTasks.values().forEach(future -> future.cancel(true));
            runningTasks.clear();
            executor.shutdownNow();
            LOGGER.debug("RoadWeaver: ExecutorService shut down.");
        });
    }

    private static void onWorldLoad(ServerLevel level) {
        ModEventHandler.restartExecutorIfNeeded();
        if (!level.m_46472_().equals(Level.f_46428_)) {
            return;
        }
        String worldKey = level.m_46472_().m_135782_().toString();
        worldInitDelay.put(worldKey, 100);
        LOGGER.info("RoadWeaver: \u4e16\u754c {} \u5df2\u52a0\u8f7d\uff0c\u5c06\u5728 {} ticks \u540e\u5f00\u59cb\u9053\u8def\u751f\u6210", (Object)worldKey, (Object)100);
        WorldDataProvider dataProvider = WorldDataProvider.getInstance();
        Records.StructureLocationData structureLocationData = dataProvider.getStructureLocations(level);
        ModEventHandler.restoreUnfinishedRoads(level);
        IModConfig config = ConfigProvider.get();
        if (structureLocationData.structureLocations().size() < config.initialLocatingCount()) {
            LOGGER.info("Initializing world with {} structures", (Object)config.initialLocatingCount());
            for (int i = 0; i < config.initialLocatingCount(); ++i) {
                StructureConnector.cacheNewConnection(level, false);
            }
            LOGGER.info("Initial structure search completed, queue size: {}", (Object)StructureConnector.getQueueForWorld(level).size());
        }
    }

    private static void tryGenerateNewRoads(ServerLevel level, Boolean async, int steps) {
        String worldKey = level.m_46472_().m_135782_().toString();
        Integer delayTicks = worldInitDelay.get(worldKey);
        if (delayTicks != null) {
            if (delayTicks > 0) {
                worldInitDelay.put(worldKey, delayTicks - 1);
                return;
            }
            worldInitDelay.remove(worldKey);
            LOGGER.info("RoadWeaver: \u4e16\u754c {} \u521d\u59cb\u5316\u5ef6\u8fdf\u7ed3\u675f\uff0c\u5f00\u59cb\u9053\u8def\u751f\u6210", (Object)worldKey);
        }
        IModConfig config = ConfigProvider.get();
        WorldDataProvider dataProvider = WorldDataProvider.getInstance();
        runningTasks.entrySet().removeIf(entry -> {
            Future future = (Future)entry.getValue();
            if (future.isDone()) {
                try {
                    future.get();
                }
                catch (Exception e) {
                    LOGGER.warn("Task {} completed with error: {}", entry.getKey(), (Object)e.getMessage());
                }
                return true;
            }
            return false;
        });
        int currentRunning = runningTasks.size();
        if (currentRunning >= config.maxConcurrentRoadGeneration()) {
            return;
        }
        Queue<Records.StructureConnection> queue = StructureConnector.getQueueForWorld(level);
        if (!queue.isEmpty()) {
            Records.StructureConnection structureConnection = queue.peek();
            if (structureConnection == null) {
                return;
            }
            RoadFeatureConfig roadConfig = ModEventHandler.getRoadFeatureConfig(level);
            if (roadConfig == null) {
                LOGGER.debug("RoadWeaver: \u6ce8\u518c\u8868\u672a\u5c31\u7eea\uff0c\u7b49\u5f85\u4e0b\u4e00\u4e2a tick\uff08\u961f\u5217\u5927\u5c0f: {}\uff09", (Object)queue.size());
                return;
            }
            queue.poll();
            LOGGER.info("\ud83d\udea7 Starting road generation: {} -> {} (running: {}/{}, queue: {})", new Object[]{structureConnection.from(), structureConnection.to(), currentRunning + 1, config.maxConcurrentRoadGeneration(), queue.size()});
            if (async.booleanValue()) {
                String taskId = level.m_46472_().m_135782_().toString() + "_" + System.nanoTime();
                Future<?> future = executor.submit(() -> {
                    try {
                        LOGGER.debug("\ud83d\udd28 Generating road: {} -> {}", (Object)structureConnection.from(), (Object)structureConnection.to());
                        new Road(level, structureConnection, roadConfig).generateRoad(steps);
                        LOGGER.info("\u2705 Road generation completed: {} -> {}", (Object)structureConnection.from(), (Object)structureConnection.to());
                    }
                    catch (Exception e) {
                        LOGGER.error("\u274c Error generating road {} -> {}: {}", new Object[]{structureConnection.from(), structureConnection.to(), e.getMessage(), e});
                        try {
                            ModEventHandler.markConnectionAsFailed(level, structureConnection);
                        }
                        catch (Exception ex) {
                            LOGGER.error("Failed to mark connection as failed", (Throwable)ex);
                        }
                    }
                    finally {
                        runningTasks.remove(taskId);
                    }
                });
                runningTasks.put(taskId, future);
            } else {
                try {
                    new Road(level, structureConnection, roadConfig).generateRoad(steps);
                }
                catch (Exception e) {
                    LOGGER.error("\u274c Error generating road: {}", (Object)e.getMessage(), (Object)e);
                    ModEventHandler.markConnectionAsFailed(level, structureConnection);
                }
            }
        }
    }

    private static RoadFeatureConfig getRoadFeatureConfig(ServerLevel level) {
        try {
            FeatureConfiguration featureConfiguration;
            if (level.m_9598_() == null) {
                LOGGER.debug("RoadWeaver: RegistryAccess is null");
                return null;
            }
            Optional registry = level.m_9598_().m_6632_(Registries.f_256911_);
            if (registry.isEmpty()) {
                LOGGER.debug("RoadWeaver: ConfiguredFeature registry is not available");
                return null;
            }
            ConfiguredFeature feature = (ConfiguredFeature)((Registry)registry.get()).m_6246_(RoadFeature.ROAD_FEATURE_KEY);
            if (feature != null && (featureConfiguration = feature.f_65378_()) instanceof RoadFeatureConfig) {
                RoadFeatureConfig cfg = (RoadFeatureConfig)featureConfiguration;
                LOGGER.debug("RoadWeaver: Using registered RoadFeatureConfig");
                return cfg;
            }
            LOGGER.debug("RoadWeaver: ConfiguredFeature {} missing or invalid, using fallback", (Object)RoadFeature.ROAD_FEATURE_KEY.m_135782_());
            return ModEventHandler.defaultRoadConfig();
        }
        catch (Exception e) {
            LOGGER.debug("RoadWeaver: Exception while getting RoadFeatureConfig: {}", (Object)e.getMessage());
            return null;
        }
    }

    private static RoadFeatureConfig defaultRoadConfig() {
        List<List<BlockState>> artificialMaterials = List.of(List.of(Blocks.f_220844_.m_49966_(), Blocks.f_220843_.m_49966_()), List.of(Blocks.f_50387_.m_49966_(), Blocks.f_50222_.m_49966_()), List.of(Blocks.f_50222_.m_49966_(), Blocks.f_50223_.m_49966_(), Blocks.f_50224_.m_49966_()));
        List<List<BlockState>> naturalMaterials = List.of(List.of(Blocks.f_50546_.m_49966_(), Blocks.f_152549_.m_49966_(), Blocks.f_220843_.m_49966_()), List.of(Blocks.f_50652_.m_49966_(), Blocks.f_50079_.m_49966_(), Blocks.f_50224_.m_49966_()), List.of(Blocks.f_152481_.m_49966_(), Blocks.f_50546_.m_49966_(), Blocks.f_220843_.m_49966_()));
        List<Integer> widths = List.of(Integer.valueOf(3));
        List<Integer> qualities = List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8), Integer.valueOf(9));
        return new RoadFeatureConfig(artificialMaterials, naturalMaterials, widths, qualities);
    }

    private static void markConnectionAsFailed(ServerLevel level, Records.StructureConnection structureConnection) {
        WorldDataProvider dataProvider = WorldDataProvider.getInstance();
        ArrayList connections = dataProvider.getStructureConnections(level);
        ArrayList<Records.StructureConnection> mutableConnections = new ArrayList<Records.StructureConnection>(connections != null ? connections : new ArrayList());
        for (int i = 0; i < mutableConnections.size(); ++i) {
            Records.StructureConnection conn = (Records.StructureConnection)mutableConnections.get(i);
            if ((!conn.from().equals((Object)structureConnection.from()) || !conn.to().equals((Object)structureConnection.to())) && (!conn.from().equals((Object)structureConnection.to()) || !conn.to().equals((Object)structureConnection.from()))) continue;
            mutableConnections.set(i, new Records.StructureConnection(conn.from(), conn.to(), Records.ConnectionStatus.FAILED, conn.manual()));
            dataProvider.setStructureConnections(level, mutableConnections);
            LOGGER.info("Marked connection as FAILED: {} -> {}", (Object)conn.from(), (Object)conn.to());
            break;
        }
    }

    private static void restartExecutorIfNeeded() {
        if (executor.isShutdown() || executor.isTerminated()) {
            executor = Executors.newFixedThreadPool(128);
            LOGGER.debug("RoadWeaver: ExecutorService restarted.");
        }
    }

    private static void restoreUnfinishedRoads(ServerLevel level) {
        WorldDataProvider dataProvider = WorldDataProvider.getInstance();
        List<Records.StructureConnection> connections = dataProvider.getStructureConnections(level);
        int restoredCount = 0;
        ArrayList<Records.StructureConnection> updatedConnections = new ArrayList<Records.StructureConnection>(connections);
        boolean needsUpdate = false;
        for (int i = 0; i < updatedConnections.size(); ++i) {
            Records.StructureConnection connection = (Records.StructureConnection)updatedConnections.get(i);
            if (connection.status() != Records.ConnectionStatus.PLANNED && connection.status() != Records.ConnectionStatus.GENERATING) continue;
            if (connection.status() == Records.ConnectionStatus.GENERATING) {
                Records.StructureConnection resetConnection = new Records.StructureConnection(connection.from(), connection.to(), Records.ConnectionStatus.PLANNED, connection.manual());
                updatedConnections.set(i, resetConnection);
                StructureConnector.getQueueForWorld(level).add(resetConnection);
                needsUpdate = true;
            } else {
                StructureConnector.getQueueForWorld(level).add(connection);
            }
            ++restoredCount;
        }
        if (needsUpdate) {
            dataProvider.setStructureConnections(level, updatedConnections);
        }
        if (restoredCount > 0) {
            LOGGER.info("RoadWeaver: \u6062\u590d\u4e86 {} \u4e2a\u672a\u5b8c\u6210\u7684\u9053\u8def\u751f\u6210\u4efb\u52a1\uff08\u961f\u5217\u5927\u5c0f: {}\uff09", (Object)restoredCount, (Object)StructureConnector.getQueueForWorld(level).size());
        }
    }
}

