/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.features.decoration;

import java.util.Iterator;
import java.util.Set;
import net.countered.settlementroads.features.decoration.BenchDecoration;
import net.countered.settlementroads.features.decoration.Decoration;
import net.countered.settlementroads.features.decoration.DistanceSignDecoration;
import net.countered.settlementroads.features.decoration.FenceWaypointDecoration;
import net.countered.settlementroads.features.decoration.GlorietteDecoration;
import net.countered.settlementroads.features.decoration.LamppostDecoration;
import net.countered.settlementroads.features.decoration.NbtStructureDecoration;
import net.countered.settlementroads.features.decoration.RoadFenceDecoration;
import net.countered.settlementroads.features.decoration.SwingDecoration;
import net.countered.settlementroads.features.decoration.util.WoodSelector;

public class RoadStructures {
    public static void tryPlaceDecorations(Set<Decoration> roadDecorationPlacementPositions) {
        if (roadDecorationPlacementPositions.isEmpty()) {
            return;
        }
        Iterator<Decoration> iterator = roadDecorationPlacementPositions.iterator();
        while (iterator.hasNext()) {
            Decoration roadDecoration = iterator.next();
            if (roadDecoration == null) continue;
            if (roadDecoration instanceof LamppostDecoration) {
                LamppostDecoration lamppostDecoration = (LamppostDecoration)roadDecoration;
                lamppostDecoration.setWoodType(WoodSelector.forBiome(lamppostDecoration.getWorld(), lamppostDecoration.getPos()));
                lamppostDecoration.place();
            }
            if (roadDecoration instanceof DistanceSignDecoration) {
                DistanceSignDecoration distanceSignDecoration = (DistanceSignDecoration)roadDecoration;
                distanceSignDecoration.setWoodType(WoodSelector.forBiome(distanceSignDecoration.getWorld(), distanceSignDecoration.getPos()));
                distanceSignDecoration.place();
            }
            if (roadDecoration instanceof FenceWaypointDecoration) {
                FenceWaypointDecoration fenceWaypointDecoration = (FenceWaypointDecoration)roadDecoration;
                fenceWaypointDecoration.setWoodType(WoodSelector.forBiome(fenceWaypointDecoration.getWorld(), fenceWaypointDecoration.getPos()));
                fenceWaypointDecoration.place();
            }
            if (roadDecoration instanceof RoadFenceDecoration) {
                RoadFenceDecoration roadFenceDecoration = (RoadFenceDecoration)roadDecoration;
                roadFenceDecoration.setWoodType(WoodSelector.forBiome(roadFenceDecoration.getWorld(), roadFenceDecoration.getPos()));
                roadFenceDecoration.place();
            }
            if (roadDecoration instanceof SwingDecoration) {
                SwingDecoration swingDecoration = (SwingDecoration)roadDecoration;
                swingDecoration.setWoodType(WoodSelector.forBiome(swingDecoration.getWorld(), swingDecoration.getPos()));
                swingDecoration.place();
            }
            if (roadDecoration instanceof BenchDecoration) {
                BenchDecoration benchDecoration = (BenchDecoration)roadDecoration;
                benchDecoration.setWoodType(WoodSelector.forBiome(benchDecoration.getWorld(), benchDecoration.getPos()));
                benchDecoration.place();
            }
            if (roadDecoration instanceof GlorietteDecoration) {
                GlorietteDecoration glorietteDecoration = (GlorietteDecoration)roadDecoration;
                glorietteDecoration.setWoodType(WoodSelector.forBiome(glorietteDecoration.getWorld(), glorietteDecoration.getPos()));
                glorietteDecoration.place();
            }
            if (roadDecoration instanceof NbtStructureDecoration) {
                NbtStructureDecoration nbtStructureDecoration = (NbtStructureDecoration)roadDecoration;
                nbtStructureDecoration.setWoodType(WoodSelector.forBiome(nbtStructureDecoration.getWorld(), nbtStructureDecoration.getPos()));
                nbtStructureDecoration.place();
            }
            iterator.remove();
        }
    }
}

