/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.helpers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public final class Records {
    private Records() {
    }

    public record RoadData(int width, int roadType, List<BlockState> materials, List<RoadSegmentPlacement> roadSegmentList) {
        public static final Codec<RoadData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("width").forGetter(RoadData::width), (App)Codec.INT.fieldOf("road_type").forGetter(RoadData::roadType), (App)BlockState.f_61039_.listOf().fieldOf("materials").forGetter(RoadData::materials), (App)RoadSegmentPlacement.CODEC.listOf().fieldOf("placements").forGetter(RoadData::roadSegmentList)).apply((Applicative)instance, RoadData::new));
    }

    public record RoadSegmentPlacement(BlockPos middlePos, List<BlockPos> positions) {
        public static final Codec<RoadSegmentPlacement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.f_121852_.fieldOf("middle_pos").forGetter(RoadSegmentPlacement::middlePos), (App)BlockPos.f_121852_.listOf().fieldOf("positions").forGetter(RoadSegmentPlacement::positions)).apply((Applicative)instance, RoadSegmentPlacement::new));
    }

    public record StructureConnection(BlockPos from, BlockPos to, ConnectionStatus status, boolean manual) {
        public static final Codec<StructureConnection> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.f_121852_.fieldOf("from").forGetter(StructureConnection::from), (App)BlockPos.f_121852_.fieldOf("to").forGetter(StructureConnection::to), (App)Codec.STRING.optionalFieldOf("status", (Object)"PLANNED").xmap(ConnectionStatus::valueOf, Enum::name).forGetter(StructureConnection::status), (App)Codec.BOOL.optionalFieldOf("manual", (Object)false).forGetter(StructureConnection::manual)).apply((Applicative)instance, StructureConnection::new));

        public StructureConnection(BlockPos from, BlockPos to) {
            this(from, to, ConnectionStatus.PLANNED, false);
        }

        public StructureConnection(BlockPos from, BlockPos to, ConnectionStatus status) {
            this(from, to, status, false);
        }
    }

    public static enum ConnectionStatus {
        PLANNED,
        GENERATING,
        COMPLETED,
        FAILED;

    }

    public record StructureLocationData(List<BlockPos> structureLocations, List<StructureInfo> structureInfos) {
        public static final Codec<StructureLocationData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.f_121852_.listOf().optionalFieldOf("structure_locations", new ArrayList()).forGetter(StructureLocationData::structureLocations), (App)StructureInfo.CODEC.listOf().optionalFieldOf("structure_infos", new ArrayList()).forGetter(StructureLocationData::structureInfos)).apply((Applicative)instance, StructureLocationData::new));

        public StructureLocationData(List<BlockPos> structureLocations, List<StructureInfo> structureInfos) {
            this.structureLocations = new ArrayList<BlockPos>(structureLocations != null ? structureLocations : new ArrayList());
            this.structureInfos = new ArrayList<StructureInfo>(structureInfos != null ? structureInfos : new ArrayList());
        }

        public StructureLocationData(List<BlockPos> structureLocations) {
            this(structureLocations, new ArrayList<StructureInfo>());
        }

        public void addStructure(BlockPos pos) {
            this.structureLocations.add(pos);
        }

        public void addStructureInfo(StructureInfo info) {
            this.structureInfos.add(info);
            if (!this.structureLocations.contains(info.pos())) {
                this.structureLocations.add(info.pos());
            }
        }
    }

    public record StructureInfo(BlockPos pos, String structureId) {
        public static final Codec<StructureInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.f_121852_.fieldOf("pos").forGetter(StructureInfo::pos), (App)Codec.STRING.optionalFieldOf("structure_id", (Object)"unknown").forGetter(StructureInfo::structureId)).apply((Applicative)instance, StructureInfo::new));
    }

    public record RoadDecoration(BlockPos placePos, Vec3i vector, int centerBlockCount, String signText, boolean isStart) {
    }

    public record WoodAssets(Block fence, Block hangingSign, Block planks) {
    }
}

