/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.helpers;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.countered.settlementroads.helpers.Records;
import net.countered.settlementroads.helpers.StructureLocator;
import net.countered.settlementroads.persistence.WorldDataProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructureConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadweaver");
    private static final ConcurrentHashMap<String, Queue<Records.StructureConnection>> worldQueues = new ConcurrentHashMap();

    public static Queue<Records.StructureConnection> getQueueForWorld(ServerLevel level) {
        String worldKey = level.m_46472_().m_135782_().toString();
        return worldQueues.computeIfAbsent(worldKey, k -> new ConcurrentLinkedQueue());
    }

    public static void clearQueueForWorld(ServerLevel level) {
        String worldKey = level.m_46472_().m_135782_().toString();
        Queue<Records.StructureConnection> queue = worldQueues.remove(worldKey);
        if (queue != null) {
            queue.clear();
            LOGGER.debug("Cleared queue for world: {}", (Object)worldKey);
        }
    }

    public static void cacheNewConnection(ServerLevel serverWorld, boolean locateAtPlayer) {
        LOGGER.debug(" cacheNewConnection called, locateAtPlayer={}", (Object)locateAtPlayer);
        WorldDataProvider dataProvider = WorldDataProvider.getInstance();
        int beforeCount = dataProvider.getStructureLocations(serverWorld).structureLocations().size();
        StructureLocator.locateConfiguredStructure(serverWorld, 1, locateAtPlayer);
        Records.StructureLocationData structureLocationData = dataProvider.getStructureLocations(serverWorld);
        if (structureLocationData == null) {
            LOGGER.warn(" structureLocationData is null");
            return;
        }
        List<BlockPos> locations = structureLocationData.structureLocations();
        int afterCount = locations.size();
        LOGGER.debug("Structure count: before={}, after={}", (Object)beforeCount, (Object)afterCount);
        if (locations == null || locations.size() < 2) {
            LOGGER.debug(" Not enough structures to create connection (need 2, have {})", (Object)locations.size());
            return;
        }
        StructureConnector.createNewStructureConnection(serverWorld);
    }

    private static void createNewStructureConnection(ServerLevel serverWorld) {
        WorldDataProvider dataProvider = WorldDataProvider.getInstance();
        Records.StructureLocationData structureLocationData = dataProvider.getStructureLocations(serverWorld);
        if (structureLocationData == null) {
            return;
        }
        List<BlockPos> worldStructureLocations = structureLocationData.structureLocations();
        if (worldStructureLocations == null || worldStructureLocations.size() < 2) {
            return;
        }
        BlockPos latestVillagePos = worldStructureLocations.get(worldStructureLocations.size() - 1);
        BlockPos closestVillage = StructureConnector.findClosestStructure(latestVillagePos, worldStructureLocations);
        if (closestVillage != null) {
            ArrayList<Records.StructureConnection> connections = new ArrayList<Records.StructureConnection>(Optional.ofNullable(dataProvider.getStructureConnections(serverWorld)).orElseGet(ArrayList::new));
            if (!StructureConnector.connectionExists(connections, latestVillagePos, closestVillage)) {
                Records.StructureConnection structureConnection = new Records.StructureConnection(latestVillagePos, closestVillage);
                connections.add(structureConnection);
                dataProvider.setStructureConnections(serverWorld, connections);
                Queue<Records.StructureConnection> queue = StructureConnector.getQueueForWorld(serverWorld);
                queue.add(structureConnection);
                double distance = Math.sqrt(latestVillagePos.m_123331_((Vec3i)closestVillage));
                LOGGER.info(" Created connection between {} and {} (distance: {} blocks, queue size: {})", new Object[]{latestVillagePos, closestVillage, (int)Math.round(distance), queue.size()});
            } else {
                LOGGER.debug("Connection already exists between {} and {}", (Object)latestVillagePos, (Object)closestVillage);
            }
        } else {
            LOGGER.warn(" Could not find closest structure for {}", (Object)latestVillagePos);
        }
    }

    private static boolean connectionExists(List<Records.StructureConnection> existingConnections, BlockPos a, BlockPos b) {
        for (Records.StructureConnection connection : existingConnections) {
            if ((!connection.from().equals((Object)a) || !connection.to().equals((Object)b)) && (!connection.from().equals((Object)b) || !connection.to().equals((Object)a))) continue;
            return true;
        }
        return false;
    }

    private static BlockPos findClosestStructure(BlockPos currentVillage, List<BlockPos> allVillages) {
        BlockPos closestVillage = null;
        double minDistance = Double.MAX_VALUE;
        for (BlockPos village : allVillages) {
            double distance;
            if (village.equals((Object)currentVillage) || !((distance = currentVillage.m_123331_((Vec3i)village)) < minDistance)) continue;
            minDistance = distance;
            closestVillage = village;
        }
        return closestVillage;
    }
}

