/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.persistence.forge;

import java.util.ArrayList;
import java.util.List;
import net.countered.settlementroads.helpers.Records;
import net.countered.settlementroads.persistence.WorldDataProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public final class WorldDataHelper {
    private WorldDataHelper() {
    }

    public static Records.StructureLocationData getStructureLocations(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            return WorldDataProvider.getInstance().getStructureLocations(server);
        }
        return new Records.StructureLocationData(new ArrayList<BlockPos>());
    }

    public static List<Records.StructureConnection> getConnectedStructures(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            return WorldDataProvider.getInstance().getStructureConnections(server);
        }
        return new ArrayList<Records.StructureConnection>();
    }

    public static List<Records.RoadData> getRoadDataList(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            return WorldDataProvider.getInstance().getRoadDataList(server);
        }
        return new ArrayList<Records.RoadData>();
    }

    public static void setStructureLocations(Level level, Records.StructureLocationData data) {
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            WorldDataProvider.getInstance().setStructureLocations(server, data);
        }
    }

    public static void setStructureConnections(Level level, List<Records.StructureConnection> connections) {
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            WorldDataProvider.getInstance().setStructureConnections(server, connections);
        }
    }

    public static void setRoadDataList(Level level, List<Records.RoadData> roadDataList) {
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            WorldDataProvider.getInstance().setRoadDataList(server, roadDataList);
        }
    }
}

