/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.client.map;

import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_2338;
import org.jetbrains.annotations.Nullable;

public final class MapState {
    private boolean dragging;
    private int dragButton;
    private double lastMouseX;
    private double lastMouseY;
    private boolean zoomDebouncePending;
    private long zoomDebounceDeadlineMs;
    private boolean contextMenuOpen;
    private int menuX;
    private int menuY;
    @Nullable
    private class_2338 menuTarget;
    private boolean manualMode;
    @Nullable
    private class_2338 selectedA;
    private final AtomicInteger requestSeq = new AtomicInteger(0);

    public void startDrag(int button, double mouseX, double mouseY) {
        this.dragging = true;
        this.dragButton = button;
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        this.zoomDebouncePending = false;
        this.closeContextMenu();
    }

    public void updateDrag(double mouseX, double mouseY) {
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
    }

    public void endDrag() {
        this.dragging = false;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public int getDragButton() {
        return this.dragButton;
    }

    public double getLastMouseX() {
        return this.lastMouseX;
    }

    public double getLastMouseY() {
        return this.lastMouseY;
    }

    public void scheduleZoomDebounce(long delayMs) {
        this.zoomDebouncePending = true;
        this.zoomDebounceDeadlineMs = System.currentTimeMillis() + delayMs;
    }

    public void cancelZoomDebounce() {
        this.zoomDebouncePending = false;
    }

    public boolean isZoomDebounceReady() {
        return this.zoomDebouncePending && System.currentTimeMillis() >= this.zoomDebounceDeadlineMs;
    }

    public void clearZoomDebounce() {
        this.zoomDebouncePending = false;
    }

    public void openContextMenu(int x, int y, class_2338 target) {
        this.contextMenuOpen = true;
        this.menuX = x;
        this.menuY = y;
        this.menuTarget = target;
    }

    public void closeContextMenu() {
        this.contextMenuOpen = false;
        this.menuTarget = null;
    }

    public boolean isContextMenuOpen() {
        return this.contextMenuOpen;
    }

    public int getMenuX() {
        return this.menuX;
    }

    public int getMenuY() {
        return this.menuY;
    }

    @Nullable
    public class_2338 getMenuTarget() {
        return this.menuTarget;
    }

    public void toggleManualMode() {
        boolean bl = this.manualMode = !this.manualMode;
        if (!this.manualMode) {
            this.selectedA = null;
        }
        this.closeContextMenu();
    }

    public void setManualMode(boolean enabled) {
        this.manualMode = enabled;
        if (!enabled) {
            this.selectedA = null;
        }
    }

    public boolean isManualMode() {
        return this.manualMode;
    }

    public void selectFirstPoint(class_2338 pos) {
        this.selectedA = pos;
    }

    public void clearSelection() {
        this.selectedA = null;
    }

    @Nullable
    public class_2338 getSelectedA() {
        return this.selectedA;
    }

    public boolean hasSelection() {
        return this.selectedA != null;
    }

    public int incrementAndGetRequestSeq() {
        return this.requestSeq.incrementAndGet();
    }

    public int getCurrentRequestSeq() {
        return this.requestSeq.get();
    }

    public void reset() {
        this.dragging = false;
        this.zoomDebouncePending = false;
        this.contextMenuOpen = false;
        this.menuTarget = null;
        this.manualMode = false;
        this.selectedA = null;
    }
}

