/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.client.map.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2338;
import net.shiroha233.roadweaver.client.map.data.MapDataStorage;
import org.jetbrains.annotations.Nullable;

public final class ClientMapNotes {
    private static String currentWorldId = null;
    private static final Map<class_2338, String> aliases = new HashMap<class_2338, String>();
    private static final Map<class_2338, List<String>> notes = new HashMap<class_2338, List<String>>();
    private static boolean dirty = false;

    private ClientMapNotes() {
    }

    public static void onWorldJoin() {
        class_2338 pos;
        String worldId = MapDataStorage.getWorldId();
        if (worldId == null) {
            return;
        }
        if (worldId.equals(currentWorldId)) {
            return;
        }
        if (currentWorldId != null && dirty) {
            ClientMapNotes.saveToFile();
        }
        currentWorldId = worldId;
        aliases.clear();
        notes.clear();
        dirty = false;
        MapDataStorage.NotesData data = MapDataStorage.loadNotes();
        for (Map.Entry<String, String> entry : data.aliases.entrySet()) {
            pos = MapDataStorage.keyToPos(entry.getKey());
            if (pos == null) continue;
            aliases.put(pos, entry.getValue());
        }
        for (Map.Entry<String, Object> entry : data.notes.entrySet()) {
            pos = MapDataStorage.keyToPos(entry.getKey());
            if (pos == null) continue;
            notes.put(pos, new ArrayList((Collection)entry.getValue()));
        }
    }

    public static void onWorldLeave() {
        if (dirty) {
            ClientMapNotes.saveToFile();
        }
        currentWorldId = null;
        aliases.clear();
        notes.clear();
        dirty = false;
    }

    public static void saveToFile() {
        MapDataStorage.NotesData data = new MapDataStorage.NotesData();
        for (Map.Entry<class_2338, String> entry : aliases.entrySet()) {
            data.aliases.put(MapDataStorage.posToKey(entry.getKey()), entry.getValue());
        }
        for (Map.Entry<class_2338, Object> entry : notes.entrySet()) {
            data.notes.put(MapDataStorage.posToKey(entry.getKey()), (List)entry.getValue());
        }
        MapDataStorage.saveNotes(data);
        dirty = false;
    }

    @Nullable
    public static String getAlias(class_2338 pos) {
        return aliases.get(pos);
    }

    public static void setAlias(class_2338 pos, String alias) {
        if (alias == null || alias.isBlank()) {
            if (aliases.remove(pos) != null) {
                dirty = true;
                ClientMapNotes.saveToFile();
            }
        } else {
            aliases.put(pos, alias);
            dirty = true;
            ClientMapNotes.saveToFile();
        }
    }

    public static boolean hasAlias(class_2338 pos) {
        return aliases.containsKey(pos);
    }

    public static List<String> getNotes(class_2338 pos) {
        return notes.getOrDefault(pos, List.of());
    }

    public static void addNote(class_2338 pos, String note) {
        if (note == null || note.isBlank()) {
            return;
        }
        notes.computeIfAbsent(pos, k -> new ArrayList()).add(note);
        dirty = true;
        ClientMapNotes.saveToFile();
    }

    public static void clearNotes(class_2338 pos) {
        if (notes.remove(pos) != null) {
            dirty = true;
            ClientMapNotes.saveToFile();
        }
    }

    public static void setNotes(class_2338 pos, List<String> noteList) {
        if (noteList == null || noteList.isEmpty()) {
            if (notes.remove(pos) != null) {
                dirty = true;
                ClientMapNotes.saveToFile();
            }
        } else {
            notes.put(pos, new ArrayList<String>(noteList));
            dirty = true;
            ClientMapNotes.saveToFile();
        }
    }

    public static boolean hasNotes(class_2338 pos) {
        List<String> n = notes.get(pos);
        return n != null && !n.isEmpty();
    }
}

