/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.client.map.ui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.shiroha233.roadweaver.client.map.data.ClientMapNotes;

public class NoteEditScreen
extends class_437 {
    private static final class_2960 BOOK_TEXTURE = new class_2960("minecraft", "textures/gui/book.png");
    private static final int BOOK_WIDTH = 192;
    private static final int BOOK_HEIGHT = 192;
    private static final int TEXT_WIDTH = 114;
    private static final int TEXT_X_OFFSET = 36;
    private static final int TEXT_Y_OFFSET = 32;
    private static final int MAX_LINES = 14;
    private static final int LINE_HEIGHT = 9;
    private final class_2338 targetPos;
    private final class_437 parent;
    private final List<String> lines = new ArrayList<String>();
    private int cursorLine = 0;
    private int cursorPos = 0;
    private int bookX;
    private int bookY;
    private long lastBlink = 0L;
    private boolean cursorVisible = true;

    public NoteEditScreen(class_2338 targetPos, class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"gui.roadweaver.map.note.title"));
        this.targetPos = targetPos;
        this.parent = parent;
        List<String> existing = ClientMapNotes.getNotes(targetPos);
        if (!existing.isEmpty()) {
            this.lines.addAll(existing);
        } else {
            this.lines.add("");
        }
    }

    protected void method_25426() {
        this.bookX = (this.field_22789 - 192) / 2;
        this.bookY = (this.field_22790 - 192) / 2;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.roadweaver.common.save"), b -> this.save()).method_46434(this.bookX + 96 - 50, this.bookY + 192 + 4, 100, 20).method_46431());
    }

    public void method_25394(class_332 g, int mouseX, int mouseY, float partialTick) {
        this.method_25420(g);
        g.method_25302(BOOK_TEXTURE, this.bookX, this.bookY, 0, 0, 192, 192);
        String alias = ClientMapNotes.getAlias(this.targetPos);
        String titleStr = alias != null && !alias.isEmpty() ? alias : String.format("(%d, %d)", this.targetPos.method_10263(), this.targetPos.method_10260());
        g.method_51433(this.field_22793, titleStr, this.bookX + 36, this.bookY + 18, 0, false);
        int textX = this.bookX + 36;
        int textY = this.bookY + 32;
        for (int i = 0; i < Math.min(this.lines.size(), 14); ++i) {
            String line = this.lines.get(i);
            g.method_51433(this.field_22793, line, textX, textY + i * 9, 0, false);
        }
        this.updateCursorBlink();
        if (this.cursorVisible && this.cursorLine < this.lines.size()) {
            String currentLine = this.lines.get(this.cursorLine);
            int cursorX = textX + this.field_22793.method_1727(currentLine.substring(0, Math.min(this.cursorPos, currentLine.length())));
            int cursorY = textY + this.cursorLine * 9;
            g.method_25294(cursorX, cursorY, cursorX + 1, cursorY + 9, -16777216);
        }
        super.method_25394(g, mouseX, mouseY, partialTick);
    }

    private void updateCursorBlink() {
        long now = System.currentTimeMillis();
        if (now - this.lastBlink > 500L) {
            this.cursorVisible = !this.cursorVisible;
            this.lastBlink = now;
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.field_22787.method_1507(this.parent);
            return true;
        }
        if (keyCode == 257 || keyCode == 335) {
            if (this.lines.size() < 14) {
                String current = this.lines.get(this.cursorLine);
                String before = current.substring(0, Math.min(this.cursorPos, current.length()));
                String after = current.substring(Math.min(this.cursorPos, current.length()));
                this.lines.set(this.cursorLine, before);
                this.lines.add(this.cursorLine + 1, after);
                ++this.cursorLine;
                this.cursorPos = 0;
            }
            return true;
        }
        if (keyCode == 259) {
            if (this.cursorPos > 0) {
                String current = this.lines.get(this.cursorLine);
                String newLine = current.substring(0, this.cursorPos - 1) + current.substring(this.cursorPos);
                this.lines.set(this.cursorLine, newLine);
                --this.cursorPos;
            } else if (this.cursorLine > 0) {
                String current = this.lines.remove(this.cursorLine);
                --this.cursorLine;
                String prev = this.lines.get(this.cursorLine);
                this.cursorPos = prev.length();
                this.lines.set(this.cursorLine, prev + current);
            }
            return true;
        }
        if (keyCode == 261) {
            String current = this.lines.get(this.cursorLine);
            if (this.cursorPos < current.length()) {
                String newLine = current.substring(0, this.cursorPos) + current.substring(this.cursorPos + 1);
                this.lines.set(this.cursorLine, newLine);
            } else if (this.cursorLine < this.lines.size() - 1) {
                String next = this.lines.remove(this.cursorLine + 1);
                this.lines.set(this.cursorLine, current + next);
            }
            return true;
        }
        if (keyCode == 263) {
            if (this.cursorPos > 0) {
                --this.cursorPos;
            } else if (this.cursorLine > 0) {
                --this.cursorLine;
                this.cursorPos = this.lines.get(this.cursorLine).length();
            }
            return true;
        }
        if (keyCode == 262) {
            String current = this.lines.get(this.cursorLine);
            if (this.cursorPos < current.length()) {
                ++this.cursorPos;
            } else if (this.cursorLine < this.lines.size() - 1) {
                ++this.cursorLine;
                this.cursorPos = 0;
            }
            return true;
        }
        if (keyCode == 265) {
            if (this.cursorLine > 0) {
                --this.cursorLine;
                this.cursorPos = Math.min(this.cursorPos, this.lines.get(this.cursorLine).length());
            }
            return true;
        }
        if (keyCode == 264) {
            if (this.cursorLine < this.lines.size() - 1) {
                ++this.cursorLine;
                this.cursorPos = Math.min(this.cursorPos, this.lines.get(this.cursorLine).length());
            }
            return true;
        }
        if (keyCode == 268) {
            this.cursorPos = 0;
            return true;
        }
        if (keyCode == 269) {
            this.cursorPos = this.lines.get(this.cursorLine).length();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char c, int modifiers) {
        if (Character.isISOControl(c)) {
            return false;
        }
        String current = this.lines.get(this.cursorLine);
        String newLine = current.substring(0, this.cursorPos) + c + current.substring(this.cursorPos);
        if (this.field_22793.method_1727(newLine) <= 114) {
            this.lines.set(this.cursorLine, newLine);
            ++this.cursorPos;
        }
        return true;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int textX = this.bookX + 36;
        int textY = this.bookY + 32;
        if (mouseX >= (double)textX && mouseX < (double)(textX + 114) && mouseY >= (double)textY && mouseY < (double)(textY + 126)) {
            int clickedLine = (int)((mouseY - (double)textY) / 9.0);
            if (clickedLine < this.lines.size()) {
                this.cursorLine = clickedLine;
                String line = this.lines.get(this.cursorLine);
                int relX = (int)(mouseX - (double)textX);
                this.cursorPos = 0;
                int i = 0;
                while (i <= line.length()) {
                    if (this.field_22793.method_1727(line.substring(0, i)) >= relX) {
                        this.cursorPos = Math.max(0, i - 1);
                        break;
                    }
                    this.cursorPos = i++;
                }
            }
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private void save() {
        ClientMapNotes.clearNotes(this.targetPos);
        for (String line : this.lines) {
            if (line.isEmpty()) continue;
            ClientMapNotes.addNote(this.targetPos, line);
        }
        this.field_22787.method_1507(this.parent);
    }

    public boolean method_25421() {
        return false;
    }
}

