/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.client.roadside;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.shiroha233.roadweaver.client.roadside.StructurePreviewRenderer;
import net.shiroha233.roadweaver.structures.roadside.model.RoadsideDecorationSpec;
import net.shiroha233.roadweaver.structures.roadside.registry.RoadsideRegistry;

public class RoadsideStructureBrowserScreen
extends class_437 {
    private static final int ENTRY_HEIGHT = 18;
    private final class_437 parent;
    private final List<RoadsideDecorationSpec> specs = new ArrayList<RoadsideDecorationSpec>();
    private final StructurePreviewRenderer previewRenderer = new StructurePreviewRenderer();
    private int selectedIndex = 0;
    private int scrollOffset = 0;

    public RoadsideStructureBrowserScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"gui.roadweaver.roadside_browser.title"));
        this.parent = parent;
        for (RoadsideDecorationSpec spec : RoadsideRegistry.all()) {
            this.specs.add(spec);
        }
        this.specs.sort(Comparator.comparing(s -> s.id().toString()));
        if (this.selectedIndex >= this.specs.size()) {
            this.selectedIndex = this.specs.isEmpty() ? -1 : 0;
        }
    }

    protected void method_25426() {
        super.method_25426();
        this.method_37067();
        int cx = this.field_22789 / 2;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.roadweaver.common.cancel"), b -> this.method_25419()).method_46434(cx - 40, this.field_22790 - 30, 80, 20).method_46431());
    }

    public void method_25394(class_332 gfx, int mouseX, int mouseY, float partialTick) {
        this.method_25420(gfx);
        int panelWidth = Math.min(500, this.field_22789 - 40);
        int panelHeight = Math.min(320, this.field_22790 - 60);
        int panelLeft = (this.field_22789 - panelWidth) / 2;
        int panelTop = 35;
        gfx.method_25294(panelLeft - 2, panelTop - 2, panelLeft + panelWidth + 2, panelTop + panelHeight + 2, -13421773);
        gfx.method_25294(panelLeft, panelTop, panelLeft + panelWidth, panelTop + panelHeight, -872415232);
        gfx.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 15, 0xFFFFFF);
        int listWidth = (int)((float)panelWidth * 0.45f);
        int listLeft = panelLeft + 8;
        int listTop = panelTop + 8;
        int listBottom = panelTop + panelHeight - 8;
        gfx.method_25294(listLeft, listTop, listLeft + listWidth, listBottom, Integer.MIN_VALUE);
        this.renderList(gfx, mouseX, mouseY, listLeft, listTop, listWidth, listBottom);
        int previewLeft = listLeft + listWidth + 12;
        int previewWidth = panelWidth - listWidth - 28;
        int previewTop = listTop;
        int previewHeight = listBottom - listTop;
        gfx.method_25294(previewLeft, previewTop, previewLeft + previewWidth, previewTop + previewHeight, Integer.MIN_VALUE);
        this.renderPreview(gfx, partialTick, previewLeft, previewTop, previewWidth, previewHeight);
        super.method_25394(gfx, mouseX, mouseY, partialTick);
    }

    private void renderList(class_332 gfx, int mouseX, int mouseY, int left, int top, int width, int bottom) {
        int visible = Math.max(1, (bottom - top) / 18);
        int maxOffset = Math.max(0, this.specs.size() - visible);
        if (this.scrollOffset > maxOffset) {
            this.scrollOffset = maxOffset;
        }
        if (this.scrollOffset < 0) {
            this.scrollOffset = 0;
        }
        int y = top;
        for (int index = this.scrollOffset; y + 18 <= bottom && index < this.specs.size(); ++index) {
            boolean selected;
            boolean hovered = mouseX >= left && mouseX < left + width && mouseY >= y && mouseY < y + 18;
            boolean bl = selected = index == this.selectedIndex;
            int bg = selected ? -2130706433 : (hovered ? 0x40FFFFFF : 0x40000000);
            gfx.method_25294(left, y, left + width, y + 18, bg);
            RoadsideDecorationSpec spec = this.specs.get(index);
            String text = spec.id().toString();
            gfx.method_51433(this.field_22793, text, left + 4, y + 4, 0xFFFFFF, false);
            y += 18;
        }
        if (this.specs.isEmpty()) {
            class_5250 class_52502 = class_2561.method_43471((String)"gui.roadweaver.roadside_browser.empty");
            int n = left + width / 2;
            Objects.requireNonNull(this.field_22793);
            gfx.method_27534(this.field_22793, (class_2561)class_52502, n, top + (bottom - top - 9) / 2, 0xAAAAAA);
        }
    }

    private void renderPreview(class_332 gfx, float partialTick, int x, int y, int width, int height) {
        if (width <= 0 || height <= 0) {
            return;
        }
        if (this.specs.isEmpty() || this.selectedIndex < 0 || this.selectedIndex >= this.specs.size()) {
            return;
        }
        RoadsideDecorationSpec spec = this.specs.get(this.selectedIndex);
        int textY = y;
        gfx.method_51433(this.field_22793, spec.id().toString(), x, textY, 0xFFFFFF, false);
        Objects.requireNonNull(this.field_22793);
        gfx.method_51433(this.field_22793, spec.templateId().toString(), x, textY += 9 + 2, 0xAAAAAA, false);
        Objects.requireNonNull(this.field_22793);
        int previewTop = textY + 9 + 4;
        int previewHeight = height - (previewTop - y);
        if (previewHeight <= 0) {
            return;
        }
        boolean ok = this.previewRenderer.render(spec, gfx, x, previewTop, width, previewHeight, partialTick);
        if (!ok) {
            gfx.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.roadweaver.roadside_browser.preview_unavailable"), x + width / 2, previewTop + previewHeight / 2, 0xAAAAAA);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int relativeY;
        int row;
        int index;
        int panelWidth = Math.min(500, this.field_22789 - 40);
        int panelHeight = Math.min(320, this.field_22790 - 60);
        int panelLeft = (this.field_22789 - panelWidth) / 2;
        int panelTop = 35;
        int listWidth = (int)((float)panelWidth * 0.45f);
        int listLeft = panelLeft + 8;
        int listTop = panelTop + 8;
        int listBottom = panelTop + panelHeight - 8;
        if (mouseX >= (double)listLeft && mouseX < (double)(listLeft + listWidth) && mouseY >= (double)listTop && mouseY < (double)listBottom && (index = this.scrollOffset + (row = (relativeY = (int)mouseY - listTop) / 18)) >= 0 && index < this.specs.size()) {
            this.selectedIndex = index;
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        int panelWidth = Math.min(500, this.field_22789 - 40);
        int panelHeight = Math.min(320, this.field_22790 - 60);
        int panelLeft = (this.field_22789 - panelWidth) / 2;
        int panelTop = 35;
        int listWidth = (int)((float)panelWidth * 0.45f);
        int listLeft = panelLeft + 8;
        int listTop = panelTop + 8;
        int listBottom = panelTop + panelHeight - 8;
        if (mouseX >= (double)listLeft && mouseX < (double)(listLeft + listWidth) && mouseY >= (double)listTop && mouseY < (double)listBottom) {
            this.scrollOffset += delta < 0.0 ? 1 : -1;
            return true;
        }
        return super.method_25401(mouseX, mouseY, delta);
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    public boolean method_25421() {
        return false;
    }
}

