/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.client.roadside;

import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3499;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_776;
import net.minecraft.class_7833;
import net.shiroha233.roadweaver.structures.roadside.model.RoadsideDecorationSpec;

public final class StructurePreviewRenderer {
    private final class_310 mc = class_310.method_1551();
    private final class_776 blockRenderer = this.mc.method_1541();
    private final Map<class_2960, class_3499> cache = new HashMap<class_2960, class_3499>();

    public boolean render(RoadsideDecorationSpec spec, class_332 gfx, int x, int y, int width, int height, float partialTick) {
        List<Object> palettes;
        class_3499 tpl = this.getTemplate(spec.templateId());
        List<Object> list = palettes = tpl != null ? StructurePreviewRenderer.getPalettes(tpl) : List.of();
        if (tpl == null || palettes.isEmpty()) {
            return false;
        }
        class_4587 pose = gfx.method_51448();
        pose.method_22903();
        RenderSystem.enableDepthTest();
        pose.method_46416((float)x + (float)width / 2.0f, (float)y + (float)height / 2.0f, 200.0f);
        class_2382 size = tpl.method_15160();
        float maxDim = Math.max(size.method_10263(), Math.max(size.method_10264(), size.method_10260()));
        float scale = (float)Math.min(width, height) / (maxDim * 2.0f);
        pose.method_22905(scale, -scale, scale);
        float rotation = (this.mc.field_1687 != null ? (float)this.mc.field_1687.method_8510() + partialTick : (float)this.mc.field_1705.method_1738() + partialTick) % 360.0f;
        pose.method_22907(class_7833.field_40716.rotationDegrees(rotation));
        pose.method_22907(class_7833.field_40714.rotationDegrees(25.0f));
        float centerX = (float)size.method_10263() / 2.0f;
        float centerY = (float)size.method_10264() / 2.0f;
        float centerZ = (float)size.method_10260() / 2.0f;
        pose.method_46416(-centerX, -centerY, -centerZ);
        class_4597.class_4598 buffer = this.mc.method_22940().method_23000();
        int light = 0xF000F0;
        class_3499.class_5162 palette = (class_3499.class_5162)palettes.get(0);
        for (class_3499.class_3501 info : palette.method_27125()) {
            class_2680 state = info.comp_1342();
            if (state.method_26217() == class_2464.field_11455) continue;
            pose.method_22903();
            class_2338 pos = info.comp_1341();
            pose.method_46416((float)pos.method_10263(), (float)pos.method_10264(), (float)pos.method_10260());
            this.blockRenderer.method_3353(state, pose, (class_4597)buffer, light, class_4608.field_21444);
            pose.method_22909();
        }
        buffer.method_22993();
        RenderSystem.disableDepthTest();
        pose.method_22909();
        return true;
    }

    private class_3499 getTemplate(class_2960 id) {
        return this.cache.computeIfAbsent(id, key -> {
            if (this.mc.method_1576() == null) {
                return null;
            }
            return this.mc.method_1576().method_27727().method_15094(key).orElse(null);
        });
    }

    private static List<class_3499.class_5162> getPalettes(class_3499 tpl) {
        try {
            Field f = class_3499.class.getDeclaredField("palettes");
            f.setAccessible(true);
            Object val = f.get(tpl);
            if (val instanceof List) {
                List list = (List)val;
                return list;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return List.of();
    }
}

