/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features;

import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3031;
import net.minecraft.class_3218;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.features.config.RoadFeatureConfig;
import net.shiroha233.roadweaver.features.decoration.base.Decoration;
import net.shiroha233.roadweaver.features.decoration.system.DecorationExecutor;
import net.shiroha233.roadweaver.features.decoration.system.DecorationPlanner;
import net.shiroha233.roadweaver.features.roadlogic.bridge.BridgeRangeCalculator;
import net.shiroha233.roadweaver.features.roadlogic.bridge.BridgeSegmentPlanner;
import net.shiroha233.roadweaver.features.roadlogic.core.SegmentPaver;
import net.shiroha233.roadweaver.features.roadlogic.core.StructureAvoidanceService;
import net.shiroha233.roadweaver.features.roadlogic.surface.BridgeTransitionAdjuster;
import net.shiroha233.roadweaver.features.roadlogic.surface.HeightProfileService;
import net.shiroha233.roadweaver.features.roadlogic.surface.RoadTerrainAdapter;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.persistence.sharded.RoadShardStorage;
import net.shiroha233.roadweaver.structures.roadside.runtime.RoadPlacementContext;
import net.shiroha233.roadweaver.structures.roadside.runtime.RoadsideStructureService;

public class RoadFeature
extends class_3031<RoadFeatureConfig> {
    public RoadFeature(Codec<RoadFeatureConfig> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<RoadFeatureConfig> ctx) {
        class_5281 world = ctx.method_33652();
        class_3218 lvl = world.method_8410();
        if (!(lvl instanceof class_3218)) {
            return false;
        }
        class_3218 server = lvl;
        class_1923 currentChunk = new class_1923(ctx.method_33655());
        int minX = currentChunk.method_8326();
        int minZ = currentChunk.method_8328();
        int maxX = currentChunk.method_8327();
        int maxZ = currentChunk.method_8329();
        List<Records.RoadData> roadDataList = RoadShardStorage.queryRect(server, minX, minZ, maxX, maxZ);
        if (roadDataList == null || roadDataList.isEmpty()) {
            return false;
        }
        class_5819 random = ctx.method_33654();
        ModConfig cfg = ConfigService.get();
        int averagingRadius = Math.max(0, cfg.averagingRadius());
        HashSet<class_2338> processedMiddle = new HashSet<class_2338>();
        HashSet<Decoration> decorations = new HashSet<Decoration>();
        for (Records.RoadData data : roadDataList) {
            RoadFeature.processRoadDataInChunk(world, server, currentChunk, data, processedMiddle, decorations, random, cfg, averagingRadius);
        }
        DecorationExecutor.tryPlaceDecorations(decorations);
        return true;
    }

    private static void processRoadDataInChunk(class_5281 world, class_3218 server, class_1923 currentChunk, Records.RoadData data, Set<class_2338> processedMiddle, Set<Decoration> decorations, class_5819 random, ModConfig cfg, int averagingRadius) {
        int roadType = data.roadType();
        int roadWidth = Math.max(1, data.width());
        List<class_2680> materials = data.materials();
        List<class_2680> slabMaterials = data.slabMaterials();
        List<Records.RoadSegmentPlacement> segments = data.roadSegmentList();
        if (segments == null || segments.size() < 5) {
            return;
        }
        List<class_2338> middlePositions = segments.stream().map(Records.RoadSegmentPlacement::middlePos).toList();
        BridgeRangeCalculator.RangeResult res = BridgeRangeCalculator.compute(middlePositions, data.spans());
        boolean[] isBridge = res.isBridge();
        List<int[]> bridgeRanges = res.mergedRanges();
        List<Integer> targetY = data.targetY();
        HeightProfileService.HeightProfile hp = HeightProfileService.build(world, middlePositions, currentChunk, averagingRadius, cfg, targetY);
        boolean usePersisted = hp.usePersisted();
        int[] smoothedYArr = hp.smoothedY();
        int[] baseYArr = usePersisted && targetY != null && targetY.size() == middlePositions.size() ? targetY.stream().mapToInt(Integer::intValue).toArray() : smoothedYArr;
        if (baseYArr != null && cfg.bridgeEnabled() && !bridgeRanges.isEmpty()) {
            baseYArr = BridgeTransitionAdjuster.adjust(baseYArr, bridgeRanges, cfg);
        }
        int deckY = server.method_8615() + cfg.bridgeDeckClearance();
        int segmentIndex = 0;
        BridgeSegmentPlanner.Context bridgeCtx = BridgeSegmentPlanner.newContext();
        int roadLength = segments.size();
        RoadPlacementContext roadsideCtx = new RoadPlacementContext(roadLength);
        int roadsideCheckInterval = RoadFeature.calculateRoadsideCheckInterval(roadLength, cfg.maxStructuresPerRoad());
        for (int i = 2; i < segments.size() - 2; ++i) {
            class_1923 middleChunk;
            class_2338 middle = middlePositions.get(i);
            if (!processedMiddle.add(middle) || ++segmentIndex < 8 || segmentIndex > segments.size() - 8 || !(middleChunk = new class_1923(middle)).equals((Object)currentChunk)) continue;
            class_2338 prev = middlePositions.get(i - 2);
            class_2338 next = middlePositions.get(i + 2);
            int topYCenter = world.method_8624(class_2902.class_2903.field_13203, middle.method_10263(), middle.method_10260());
            class_2338 averaged = new class_2338(middle.method_10263(), topYCenter, middle.method_10260());
            int baseYForThis = baseYArr != null ? baseYArr[i] : topYCenter;
            Records.RoadSegmentPlacement seg = segments.get(i);
            if (StructureAvoidanceService.shouldAvoid(world, middle)) continue;
            if (cfg.bridgeEnabled() && isBridge[i]) {
                BridgeSegmentPlanner.processSegment(world, seg, middle, prev, next, roadWidth, baseYForThis, deckY, segmentIndex, random, cfg, bridgeRanges, baseYArr, i, bridgeCtx);
            } else {
                RoadTerrainAdapter.adapt(world, middle, roadWidth, baseYForThis, random, cfg);
                SegmentPaver.paveSegment(world, seg, i, middlePositions, baseYArr, roadType, materials, slabMaterials, random, cfg);
            }
            if (!isBridge[i] || cfg.bridgeKeepLamps()) {
                DecorationPlanner.addDecoration(world, decorations, averaged, segmentIndex, next, prev, middlePositions, roadWidth, random, cfg, roadType == 0 ? DecorationPlanner.Mode.ARTIFICIAL : DecorationPlanner.Mode.NATURAL);
            }
            if (isBridge[i] || segmentIndex % roadsideCheckInterval != 0 || roadsideCtx.isMaxReached(cfg.maxStructuresPerRoad())) continue;
            RoadsideStructureService.tryPlace(world, server, middle, prev, next, roadWidth, roadLength, roadsideCtx, random, cfg);
        }
    }

    private static int calculateRoadsideCheckInterval(int roadLength, int maxStructures) {
        if (maxStructures <= 0 || roadLength <= 0) {
            return Integer.MAX_VALUE;
        }
        return Math.max(1, roadLength / (maxStructures + 1));
    }
}

