/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.roadlogic.core;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Map;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2806;
import net.minecraft.class_2810;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3449;
import net.minecraft.class_4076;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.shiroha233.roadweaver.config.ConfigService;

public final class StructureAvoidanceService {
    private static final int SEA_LEVEL = 63;

    private StructureAvoidanceService() {
    }

    public static boolean shouldAvoid(class_5281 world, class_2338 pos) {
        if (!ConfigService.get().structureAvoidanceEnabled()) {
            return false;
        }
        class_3218 level = world.method_8410();
        if (level == null) {
            return false;
        }
        class_5138 sm = level.method_27056();
        if (!sm.method_38852(pos)) {
            return false;
        }
        Map allStructures = sm.method_41037(pos);
        if (allStructures.isEmpty()) {
            return false;
        }
        for (Map.Entry entry : allStructures.entrySet()) {
            class_3195 structure = (class_3195)entry.getKey();
            LongSet chunkRefs = (LongSet)entry.getValue();
            LongIterator longIterator = chunkRefs.iterator();
            while (longIterator.hasNext()) {
                long chunkLong = (Long)longIterator.next();
                class_1923 chunkPos = new class_1923(chunkLong);
                class_4076 sectionPos = class_4076.method_18681((class_1923)chunkPos, (int)level.method_32891());
                class_3449 start = sm.method_26975(sectionPos, structure, (class_2810)level.method_22342(chunkPos.field_9181, chunkPos.field_9180, class_2806.field_16423));
                if (start == null || !start.method_16657()) continue;
                for (class_3443 piece : start.method_14963()) {
                    class_3341 bb = piece.method_14935();
                    if (bb.method_35416() < 63 || pos.method_10263() < bb.method_35415() || pos.method_10263() > bb.method_35418() || pos.method_10260() < bb.method_35417() || pos.method_10260() > bb.method_35420()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean shouldAvoidAny(class_5281 world, Iterable<class_2338> positions) {
        for (class_2338 pos : positions) {
            if (!StructureAvoidanceService.shouldAvoid(world, pos)) continue;
            return true;
        }
        return false;
    }
}

