/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.roadlogic.pathfinding;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_5539;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import net.minecraft.class_7138;

public final class TerrainSamplingCache {
    private final Map<Long, Boolean> waterCache = new HashMap<Long, Boolean>();
    private final Map<Long, Boolean> nearWaterCache = new HashMap<Long, Boolean>();
    private final Map<Long, Boolean> columnWaterCache = new HashMap<Long, Boolean>();
    private final Map<Long, Integer> heightCache = new HashMap<Long, Integer>();
    private final Map<Long, Integer> oceanFloorCache = new HashMap<Long, Integer>();
    private final Map<Long, class_6880<class_1959>> biomeCache = new HashMap<Long, class_6880<class_1959>>();

    private static long hashXZ(int x, int z) {
        return (long)x << 32 | (long)z & 0xFFFFFFFFL;
    }

    public int height(class_3218 level, int x, int z) {
        long key = TerrainSamplingCache.hashXZ(x, z);
        Integer cached = this.heightCache.get(key);
        if (cached != null) {
            return cached;
        }
        class_2794 generator = level.method_14178().method_12129();
        class_7138 rs = level.method_14178().method_46642().method_46713();
        int h = generator.method_16397(x, z, class_2902.class_2903.field_13203, (class_5539)level, rs);
        this.heightCache.put(key, h);
        return h;
    }

    boolean isWaterLike(class_3218 level, int x, int z) {
        long key = TerrainSamplingCache.hashXZ(x, z);
        Boolean cached = this.waterCache.get(key);
        if (cached != null) {
            return cached;
        }
        class_3215 chunkSource = level.method_14178();
        class_7138 randomState = chunkSource.method_46642().method_46713();
        class_1966 biomeSource = chunkSource.method_12129().method_12098();
        class_6880 biome = biomeSource.method_38109(x >> 2, 16, z >> 2, randomState.method_42371());
        boolean res = biome.method_40220(class_6908.field_36511) || biome.method_40220(class_6908.field_36509) || biome.method_40220(class_6908.field_36508);
        this.waterCache.put(key, res);
        return res;
    }

    int oceanFloor(class_3218 level, int x, int z) {
        long key = TerrainSamplingCache.hashXZ(x, z);
        Integer cached = this.oceanFloorCache.get(key);
        if (cached != null) {
            return cached;
        }
        class_2794 generator = level.method_14178().method_12129();
        class_7138 rs = level.method_14178().method_46642().method_46713();
        int h = generator.method_16397(x, z, class_2902.class_2903.field_13195, (class_5539)level, rs);
        this.oceanFloorCache.put(key, h);
        return h;
    }

    boolean isNearWaterLike(class_3218 level, int x, int z, int neighborDistance) {
        int[][] neighborOffsets;
        long key = TerrainSamplingCache.hashXZ(x, z);
        Boolean cached = this.nearWaterCache.get(key);
        if (cached != null) {
            return cached;
        }
        int d = neighborDistance;
        for (int[] off : neighborOffsets = new int[][]{{d, 0}, {-d, 0}, {0, d}, {0, -d}, {d, d}, {d, -d}, {-d, d}, {-d, -d}}) {
            int nx = x + off[0];
            int nz = z + off[1];
            if (!this.isWaterLike(level, nx, nz)) continue;
            this.nearWaterCache.put(key, true);
            return true;
        }
        this.nearWaterCache.put(key, false);
        return false;
    }

    boolean isColumnWater(class_3218 level, int x, int z) {
        long key = TerrainSamplingCache.hashXZ(x, z);
        Boolean cached = this.columnWaterCache.get(key);
        if (cached != null) {
            return cached;
        }
        int of = this.oceanFloor(level, x, z);
        int h = this.height(level, x, z);
        int sea = level.method_8615();
        boolean isWaterBiome = this.isWaterLike(level, x, z);
        boolean biomeWater = isWaterBiome && of < sea;
        boolean heightWater = h <= sea + 1 && of < h - 1;
        boolean res = biomeWater || heightWater;
        this.columnWaterCache.put(key, res);
        return res;
    }

    class_6880<class_1959> getBiome(class_3218 level, int x, int z) {
        long key = TerrainSamplingCache.hashXZ(x, z);
        class_6880<class_1959> cached = this.biomeCache.get(key);
        if (cached != null) {
            return cached;
        }
        class_3215 chunkSource = level.method_14178();
        class_7138 randomState = chunkSource.method_46642().method_46713();
        class_1966 biomeSource = chunkSource.method_12129().method_12098();
        class_6880 biome = biomeSource.method_38109(x >> 2, 16, z >> 2, randomState.method_42371());
        this.biomeCache.put(key, (class_6880<class_1959>)biome);
        return biome;
    }
}

