/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.planning.fabric;

import java.util.List;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.shiroha233.roadweaver.generation.InitialGenManager;
import net.shiroha233.roadweaver.generation.RoadGenerationService;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.persistence.RoadPositionQuery;
import net.shiroha233.roadweaver.persistence.WorldDataProvider;
import net.shiroha233.roadweaver.persistence.sharded.RoadShardStorage;
import net.shiroha233.roadweaver.planning.RoadPlanningService;
import net.shiroha233.roadweaver.runtime.ThreadPoolManager;
import net.shiroha233.roadweaver.structures.StructureSystem;
import net.shiroha233.roadweaver.structures.index.StructureIndexRestorer;
import net.shiroha233.roadweaver.util.ComputeService;

public final class ServerPlanningHooks {
    private static int tick;

    private ServerPlanningHooks() {
    }

    public static void register() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            StructureSystem.clearAll();
            ThreadPoolManager.onServerStarted(server);
            class_3218 level = server.method_3847(class_1937.field_25179);
            if (level == null) {
                return;
            }
            StructureIndexRestorer.restore(level);
            boolean dedicated = server.method_3816();
            if (dedicated) {
                RoadGenerationService.onServerStarted();
                RoadPlanningService.initialPlanAsync(level);
                return;
            }
            List<Records.StructureConnection> conns = WorldDataProvider.getInstance().getStructureConnections(level);
            if (conns == null || conns.isEmpty()) {
                InitialGenManager.begin(level);
                InitialGenManager.blockUntilDone(level);
            } else {
                RoadGenerationService.onServerStarted();
            }
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            class_3218 level;
            if (tick++ % 20 == 0) {
                for (class_3222 p : server.method_3760().method_14571()) {
                    RoadPlanningService.planAroundPlayer(p);
                }
            }
            if ((level = server.method_3847(class_1937.field_25179)) != null) {
                RoadGenerationService.tick(level);
            }
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            for (class_3218 lvl : server.method_3738()) {
                RoadShardStorage.flushAll(lvl);
                RoadShardStorage.clearAll(lvl);
            }
            RoadPositionQuery.clearAllCache();
            RoadGenerationService.onServerStopping();
            StructureSystem.clearAll();
            ComputeService.shutdownNow();
        });
    }
}

