/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.structures;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.shiroha233.roadweaver.structures.api.StructureBlueprint;
import net.shiroha233.roadweaver.structures.index.ChunkStructureIndex;
import net.shiroha233.roadweaver.structures.index.StructureIndex;

public final class StructureSystem {
    private static final Map<class_2960, StructureBlueprint> BLUEPRINTS = new ConcurrentHashMap<class_2960, StructureBlueprint>();
    private static final Map<class_2960, StructureIndex> INDICES = new ConcurrentHashMap<class_2960, StructureIndex>();

    private StructureSystem() {
    }

    public static void registerBlueprint(StructureBlueprint bp) {
        BLUEPRINTS.put(Objects.requireNonNull(bp).id(), bp);
    }

    public static StructureBlueprint getBlueprint(class_2960 id) {
        return BLUEPRINTS.get(id);
    }

    public static StructureIndex index(class_3218 level) {
        return INDICES.computeIfAbsent(level.method_27983().method_29177(), k -> new ChunkStructureIndex());
    }

    public static void clearAll() {
        BLUEPRINTS.clear();
        INDICES.clear();
    }
}

