/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.structures.roadside;

import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3532;
import net.minecraft.class_5281;
import net.minecraft.class_5819;

public final class BeardedTerracePlacer {
    private static final int TRANSITION_RADIUS = 4;
    private static final double MIN_CONTRIBUTION = 0.05;
    private static final int PIT_FILL_DEPTH = 3;
    private static final int MAX_CUT_DEPTH = 6;

    private BeardedTerracePlacer() {
    }

    public static void buildTerrace(class_5281 world, class_2338 anchor, class_2382 size, class_5819 random) {
        int centerX = anchor.method_10263() + size.method_10263() / 2;
        int centerZ = anchor.method_10260() + size.method_10260() / 2;
        int targetY = anchor.method_10264() - 1;
        double innerRadius = (double)Math.max(size.method_10263(), size.method_10260()) / 2.0 + 0.5;
        double outerRadius = innerRadius + 4.0;
        int searchRadius = (int)Math.ceil(outerRadius) + 1;
        for (int x = centerX - searchRadius; x <= centerX + searchRadius; ++x) {
            for (int z = centerZ - searchRadius; z <= centerZ + searchRadius; ++z) {
                int cutDepth;
                double dx = x - centerX;
                double dz = z - centerZ;
                double dist = Math.sqrt(dx * dx + dz * dz);
                if (dist > outerRadius) continue;
                int groundY = world.method_8624(class_2902.class_2903.field_13203, x, z) - 1;
                if (dist <= innerRadius) {
                    int cutDepth2;
                    if (groundY < targetY) {
                        BeardedTerracePlacer.fillColumnUp(world, x, z, groundY, targetY, random);
                    } else if (groundY > targetY && (cutDepth2 = groundY - targetY) <= 6) {
                        BeardedTerracePlacer.clearColumnDown(world, x, z, targetY + 1, groundY);
                    }
                    BeardedTerracePlacer.fillPitBelow(world, x, z, targetY, random);
                    continue;
                }
                double t = (dist - innerRadius) / (outerRadius - innerRadius);
                double smooth = BeardedTerracePlacer.smoothstep(t);
                double contribution = 1.0 - smooth;
                if (contribution < 0.05) continue;
                int finalY = (int)Math.round((double)targetY * contribution + (double)groundY * (1.0 - contribution));
                if (finalY > groundY) {
                    BeardedTerracePlacer.fillColumnUp(world, x, z, groundY, finalY, random);
                    continue;
                }
                if (finalY >= groundY || (cutDepth = groundY - finalY) > 6) continue;
                BeardedTerracePlacer.clearColumnDown(world, x, z, finalY + 1, groundY);
            }
        }
        BeardedTerracePlacer.fixExposedDirt(world, centerX, centerZ, searchRadius, targetY);
    }

    public static void buildTerraceByCenter(class_5281 world, int centerX, int centerZ, int targetY, int innerRadius, int outerRadius, class_5819 random) {
        int searchRadius = outerRadius + 2;
        for (int x = centerX - searchRadius; x <= centerX + searchRadius; ++x) {
            for (int z = centerZ - searchRadius; z <= centerZ + searchRadius; ++z) {
                int cutDepth;
                double dx = x - centerX;
                double dz = z - centerZ;
                double dist = Math.sqrt(dx * dx + dz * dz);
                if (dist > (double)outerRadius) continue;
                int groundY = world.method_8624(class_2902.class_2903.field_13203, x, z) - 1;
                if (dist <= (double)innerRadius) {
                    int cutDepth2;
                    if (groundY < targetY) {
                        BeardedTerracePlacer.fillColumnUp(world, x, z, groundY, targetY, random);
                    } else if (groundY > targetY && (cutDepth2 = groundY - targetY) <= 6) {
                        BeardedTerracePlacer.clearColumnDown(world, x, z, targetY + 1, groundY);
                    }
                    BeardedTerracePlacer.fillPitBelow(world, x, z, targetY, random);
                    continue;
                }
                double t = (dist - (double)innerRadius) / (double)(outerRadius - innerRadius);
                double smooth = BeardedTerracePlacer.smoothstep(t);
                double contribution = 1.0 - smooth;
                if (contribution < 0.05) continue;
                int finalY = (int)Math.round((double)targetY * contribution + (double)groundY * (1.0 - contribution));
                if (finalY > groundY) {
                    BeardedTerracePlacer.fillColumnUp(world, x, z, groundY, finalY, random);
                    continue;
                }
                if (finalY >= groundY || (cutDepth = groundY - finalY) > 6) continue;
                BeardedTerracePlacer.clearColumnDown(world, x, z, finalY + 1, groundY);
            }
        }
        BeardedTerracePlacer.fixExposedDirt(world, centerX, centerZ, searchRadius, targetY);
    }

    public static void buildTerraceForLargeStructure(class_1936 level, int centerX, int centerZ, int targetY, int innerRadius, int outerRadius, class_5819 random) {
        int searchRadius = outerRadius + 2;
        for (int x = centerX - searchRadius; x <= centerX + searchRadius; ++x) {
            for (int z = centerZ - searchRadius; z <= centerZ + searchRadius; ++z) {
                int cutDepth;
                double dx = x - centerX;
                double dz = z - centerZ;
                double dist = Math.sqrt(dx * dx + dz * dz);
                if (dist > (double)outerRadius) continue;
                int groundY = level.method_8624(class_2902.class_2903.field_13203, x, z) - 1;
                if (dist <= (double)innerRadius) {
                    int cutDepth2;
                    if (groundY < targetY) {
                        BeardedTerracePlacer.fillColumnUpGeneric(level, x, z, groundY, targetY, random);
                    } else if (groundY > targetY && (cutDepth2 = groundY - targetY) <= 6) {
                        BeardedTerracePlacer.clearColumnDownGeneric(level, x, z, targetY + 1, groundY);
                    }
                    BeardedTerracePlacer.fillPitBelowGeneric(level, x, z, targetY, random);
                    continue;
                }
                double t = (dist - (double)innerRadius) / (double)(outerRadius - innerRadius);
                double smooth = BeardedTerracePlacer.smoothstep(t);
                double contribution = 1.0 - smooth;
                if (contribution < 0.05) continue;
                int finalY = (int)Math.round((double)targetY * contribution + (double)groundY * (1.0 - contribution));
                if (finalY > groundY) {
                    BeardedTerracePlacer.fillColumnUpGeneric(level, x, z, groundY, finalY, random);
                    continue;
                }
                if (finalY >= groundY || (cutDepth = groundY - finalY) > 6) continue;
                BeardedTerracePlacer.clearColumnDownGeneric(level, x, z, finalY + 1, groundY);
            }
        }
        BeardedTerracePlacer.fixExposedDirtGeneric(level, centerX, centerZ, searchRadius, targetY);
    }

    private static void fillColumnUpGeneric(class_1936 level, int x, int z, int groundY, int targetY, class_5819 random) {
        class_2680 surfaceState = level.method_8320(new class_2338(x, groundY, z));
        class_2680 fillState = BeardedTerracePlacer.getSuitableFillState(surfaceState);
        class_2680 topState = BeardedTerracePlacer.getSuitableTopState(surfaceState);
        for (int y = groundY + 1; y <= targetY; ++y) {
            class_2680 state = y == targetY ? topState : fillState;
            level.method_8652(new class_2338(x, y, z), state, 3);
        }
    }

    private static void fixExposedDirtGeneric(class_1936 level, int centerX, int centerZ, int radius, int baseY) {
        for (int x = centerX - radius; x <= centerX + radius; ++x) {
            for (int z = centerZ - radius; z <= centerZ + radius; ++z) {
                for (int y = baseY; y >= baseY - 5; --y) {
                    class_2338 pos = new class_2338(x, y, z);
                    class_2680 state = level.method_8320(pos);
                    if ((state.method_27852(class_2246.field_10566) || state.method_27852(class_2246.field_10253)) && BeardedTerracePlacer.isExposedToAirGeneric(level, pos)) {
                        level.method_8652(pos, class_2246.field_10219.method_9564(), 3);
                    }
                    if (!state.method_27852(class_2246.field_10491) || !BeardedTerracePlacer.isExposedToAirGeneric(level, pos)) continue;
                    level.method_8652(pos, class_2246.field_10491.method_9564(), 3);
                }
            }
        }
    }

    private static boolean isExposedToAirGeneric(class_1936 level, class_2338 pos) {
        if (level.method_8320(pos.method_10084()).method_26215()) {
            return true;
        }
        return level.method_8320(pos.method_10095()).method_26215() || level.method_8320(pos.method_10072()).method_26215() || level.method_8320(pos.method_10078()).method_26215() || level.method_8320(pos.method_10067()).method_26215();
    }

    private static void fixExposedDirt(class_5281 world, int centerX, int centerZ, int radius, int baseY) {
        for (int x = centerX - radius; x <= centerX + radius; ++x) {
            for (int z = centerZ - radius; z <= centerZ + radius; ++z) {
                for (int y = baseY; y >= baseY - 5; --y) {
                    class_2338 pos = new class_2338(x, y, z);
                    class_2680 state = world.method_8320(pos);
                    if ((state.method_27852(class_2246.field_10566) || state.method_27852(class_2246.field_10253)) && BeardedTerracePlacer.isExposedToAir(world, pos)) {
                        world.method_8652(pos, class_2246.field_10219.method_9564(), 2);
                    }
                    if (!state.method_27852(class_2246.field_10491) || !BeardedTerracePlacer.isExposedToAir(world, pos)) continue;
                    world.method_8652(pos, class_2246.field_10491.method_9564(), 2);
                }
            }
        }
    }

    private static boolean isExposedToAir(class_5281 world, class_2338 pos) {
        if (world.method_8320(pos.method_10084()).method_26215()) {
            return true;
        }
        return world.method_8320(pos.method_10095()).method_26215() || world.method_8320(pos.method_10072()).method_26215() || world.method_8320(pos.method_10078()).method_26215() || world.method_8320(pos.method_10067()).method_26215();
    }

    private static double smoothstep(double t) {
        t = class_3532.method_15350((double)t, (double)0.0, (double)1.0);
        return t * t * (3.0 - 2.0 * t);
    }

    private static void clearColumnDown(class_5281 world, int x, int z, int fromY, int toY) {
        for (int y = fromY; y <= toY; ++y) {
            class_2338 pos = new class_2338(x, y, z);
            class_2680 state = world.method_8320(pos);
            if (!BeardedTerracePlacer.isNaturalBlock(state)) continue;
            world.method_8652(pos, class_2246.field_10124.method_9564(), 2);
        }
    }

    private static void clearColumnDownGeneric(class_1936 level, int x, int z, int fromY, int toY) {
        for (int y = fromY; y <= toY; ++y) {
            class_2338 pos = new class_2338(x, y, z);
            class_2680 state = level.method_8320(pos);
            if (!BeardedTerracePlacer.isNaturalBlock(state)) continue;
            level.method_8652(pos, class_2246.field_10124.method_9564(), 3);
        }
    }

    private static void fillPitBelow(class_5281 world, int x, int z, int targetY, class_5819 random) {
        class_2338 pos;
        class_2680 state;
        class_2680 surfaceState = world.method_8320(new class_2338(x, targetY, z));
        class_2680 fillState = BeardedTerracePlacer.getSuitableFillState(surfaceState);
        for (int y = targetY; y > targetY - 3 && ((state = world.method_8320(pos = new class_2338(x, y, z))).method_26215() || state.method_45474()); --y) {
            world.method_8652(pos, fillState, 2);
        }
    }

    private static void fillPitBelowGeneric(class_1936 level, int x, int z, int targetY, class_5819 random) {
        class_2338 pos;
        class_2680 state;
        class_2680 surfaceState = level.method_8320(new class_2338(x, targetY, z));
        class_2680 fillState = BeardedTerracePlacer.getSuitableFillState(surfaceState);
        for (int y = targetY; y > targetY - 3 && ((state = level.method_8320(pos = new class_2338(x, y, z))).method_26215() || state.method_45474()); --y) {
            level.method_8652(pos, fillState, 3);
        }
    }

    private static boolean isNaturalBlock(class_2680 state) {
        return state.method_27852(class_2246.field_10566) || state.method_27852(class_2246.field_10219) || state.method_27852(class_2246.field_10340) || state.method_27852(class_2246.field_10102) || state.method_27852(class_2246.field_10534) || state.method_27852(class_2246.field_10255) || state.method_27852(class_2246.field_10520) || state.method_27852(class_2246.field_10402) || state.method_27852(class_2246.field_10253) || state.method_27852(class_2246.field_28685) || state.method_27852(class_2246.field_10115) || state.method_27852(class_2246.field_10508) || state.method_27852(class_2246.field_10474) || state.method_27852(class_2246.field_28888) || state.method_27852(class_2246.field_27165) || state.method_27852(class_2246.field_27114) || state.method_27852(class_2246.field_10491) || state.method_27852(class_2246.field_10477) || state.method_27852(class_2246.field_10460) || state.method_27852(class_2246.field_37576) || state.method_27852(class_2246.field_37556) || state.method_27852(class_2246.field_37547);
    }

    private static void fillColumnUp(class_5281 world, int x, int z, int groundY, int targetY, class_5819 random) {
        class_2680 surfaceState = world.method_8320(new class_2338(x, groundY, z));
        class_2680 fillState = BeardedTerracePlacer.getSuitableFillState(surfaceState);
        class_2680 topState = BeardedTerracePlacer.getSuitableTopState(surfaceState);
        for (int y = groundY + 1; y <= targetY; ++y) {
            class_2680 state = y == targetY ? topState : fillState;
            world.method_8652(new class_2338(x, y, z), state, 2);
        }
    }

    private static class_2680 getSuitableFillState(class_2680 surface) {
        if (surface.method_27852(class_2246.field_10219) || surface.method_27852(class_2246.field_10566) || surface.method_27852(class_2246.field_10520) || surface.method_27852(class_2246.field_10402)) {
            return class_2246.field_10566.method_9564();
        }
        if (surface.method_27852(class_2246.field_10102)) {
            return class_2246.field_10102.method_9564();
        }
        if (surface.method_27852(class_2246.field_10534)) {
            return class_2246.field_10534.method_9564();
        }
        if (surface.method_27852(class_2246.field_10255)) {
            return class_2246.field_10255.method_9564();
        }
        if (surface.method_27852(class_2246.field_10340) || surface.method_27852(class_2246.field_10115) || surface.method_27852(class_2246.field_10508) || surface.method_27852(class_2246.field_10474)) {
            return class_2246.field_10340.method_9564();
        }
        return class_2246.field_10566.method_9564();
    }

    private static class_2680 getSuitableTopState(class_2680 surface) {
        if (surface.method_27852(class_2246.field_10219)) {
            return class_2246.field_10219.method_9564();
        }
        if (surface.method_27852(class_2246.field_10520)) {
            return class_2246.field_10520.method_9564();
        }
        if (surface.method_27852(class_2246.field_10402)) {
            return class_2246.field_10402.method_9564();
        }
        if (surface.method_27852(class_2246.field_10102)) {
            return class_2246.field_10102.method_9564();
        }
        if (surface.method_27852(class_2246.field_10534)) {
            return class_2246.field_10534.method_9564();
        }
        if (surface.method_27852(class_2246.field_10255)) {
            return class_2246.field_10255.method_9564();
        }
        return class_2246.field_10219.method_9564();
    }
}

