/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.structures.roadside.model;

import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_6908;

public enum BiomeCategory {
    PLAINS,
    FOREST,
    TAIGA,
    JUNGLE,
    DESERT,
    SAVANNA,
    BADLANDS,
    SNOWY,
    SWAMP,
    CHERRY_GROVE,
    MUSHROOM,
    MOUNTAIN,
    BEACH,
    OTHER;

    private static final class_2960 PLAINS_ID;
    private static final class_2960 SUNFLOWER_PLAINS_ID;
    private static final class_2960 MEADOW_ID;
    private static final class_2960 FOREST_ID;
    private static final class_2960 FLOWER_FOREST_ID;
    private static final class_2960 BIRCH_FOREST_ID;
    private static final class_2960 OLD_GROWTH_BIRCH_FOREST_ID;
    private static final class_2960 DARK_FOREST_ID;
    private static final class_2960 TAIGA_ID;
    private static final class_2960 OLD_GROWTH_PINE_TAIGA_ID;
    private static final class_2960 OLD_GROWTH_SPRUCE_TAIGA_ID;
    private static final class_2960 SNOWY_TAIGA_ID;
    private static final class_2960 JUNGLE_ID;
    private static final class_2960 SPARSE_JUNGLE_ID;
    private static final class_2960 BAMBOO_JUNGLE_ID;
    private static final class_2960 DESERT_ID;
    private static final class_2960 SAVANNA_ID;
    private static final class_2960 SAVANNA_PLATEAU_ID;
    private static final class_2960 WINDSWEPT_SAVANNA_ID;
    private static final class_2960 BADLANDS_ID;
    private static final class_2960 WOODED_BADLANDS_ID;
    private static final class_2960 ERODED_BADLANDS_ID;
    private static final class_2960 SNOWY_PLAINS_ID;
    private static final class_2960 ICE_SPIKES_ID;
    private static final class_2960 SNOWY_SLOPES_ID;
    private static final class_2960 FROZEN_PEAKS_ID;
    private static final class_2960 SWAMP_ID;
    private static final class_2960 MANGROVE_SWAMP_ID;
    private static final class_2960 CHERRY_GROVE_ID;
    private static final class_2960 MUSHROOM_FIELDS_ID;
    private static final class_2960 WINDSWEPT_HILLS_ID;
    private static final class_2960 WINDSWEPT_GRAVELLY_HILLS_ID;
    private static final class_2960 WINDSWEPT_FOREST_ID;
    private static final class_2960 STONY_PEAKS_ID;
    private static final class_2960 JAGGED_PEAKS_ID;
    private static final class_2960 BEACH_ID;
    private static final class_2960 SNOWY_BEACH_ID;
    private static final class_2960 STONY_SHORE_ID;

    public static BiomeCategory fromBiome(class_6880<class_1959> biome) {
        if (biome == null) {
            return OTHER;
        }
        class_2960 biomeId = biome.method_40230().map(key -> key.method_29177()).orElse(null);
        if (biomeId == null) {
            return OTHER;
        }
        return BiomeCategory.fromBiomeId(biomeId, biome);
    }

    private static BiomeCategory fromBiomeId(class_2960 id, class_6880<class_1959> biome) {
        if (id.equals((Object)PLAINS_ID) || id.equals((Object)SUNFLOWER_PLAINS_ID) || id.equals((Object)MEADOW_ID)) {
            return PLAINS;
        }
        if (id.equals((Object)FOREST_ID) || id.equals((Object)FLOWER_FOREST_ID) || id.equals((Object)BIRCH_FOREST_ID) || id.equals((Object)OLD_GROWTH_BIRCH_FOREST_ID) || id.equals((Object)DARK_FOREST_ID)) {
            return FOREST;
        }
        if (id.equals((Object)TAIGA_ID) || id.equals((Object)OLD_GROWTH_PINE_TAIGA_ID) || id.equals((Object)OLD_GROWTH_SPRUCE_TAIGA_ID) || id.equals((Object)SNOWY_TAIGA_ID)) {
            return TAIGA;
        }
        if (id.equals((Object)JUNGLE_ID) || id.equals((Object)SPARSE_JUNGLE_ID) || id.equals((Object)BAMBOO_JUNGLE_ID)) {
            return JUNGLE;
        }
        if (id.equals((Object)DESERT_ID)) {
            return DESERT;
        }
        if (id.equals((Object)SAVANNA_ID) || id.equals((Object)SAVANNA_PLATEAU_ID) || id.equals((Object)WINDSWEPT_SAVANNA_ID)) {
            return SAVANNA;
        }
        if (id.equals((Object)BADLANDS_ID) || id.equals((Object)WOODED_BADLANDS_ID) || id.equals((Object)ERODED_BADLANDS_ID)) {
            return BADLANDS;
        }
        if (id.equals((Object)SNOWY_PLAINS_ID) || id.equals((Object)ICE_SPIKES_ID) || id.equals((Object)SNOWY_SLOPES_ID) || id.equals((Object)FROZEN_PEAKS_ID)) {
            return SNOWY;
        }
        if (id.equals((Object)SWAMP_ID) || id.equals((Object)MANGROVE_SWAMP_ID)) {
            return SWAMP;
        }
        if (id.equals((Object)CHERRY_GROVE_ID)) {
            return CHERRY_GROVE;
        }
        if (id.equals((Object)MUSHROOM_FIELDS_ID)) {
            return MUSHROOM;
        }
        if (id.equals((Object)WINDSWEPT_HILLS_ID) || id.equals((Object)WINDSWEPT_GRAVELLY_HILLS_ID) || id.equals((Object)WINDSWEPT_FOREST_ID) || id.equals((Object)STONY_PEAKS_ID) || id.equals((Object)JAGGED_PEAKS_ID)) {
            return MOUNTAIN;
        }
        if (id.equals((Object)BEACH_ID) || id.equals((Object)SNOWY_BEACH_ID) || id.equals((Object)STONY_SHORE_ID)) {
            return BEACH;
        }
        if (biome.method_40220(class_6908.field_36517)) {
            return FOREST;
        }
        if (biome.method_40220(class_6908.field_36515)) {
            return TAIGA;
        }
        if (biome.method_40220(class_6908.field_36516)) {
            return JUNGLE;
        }
        if (biome.method_40220(class_6908.field_36513)) {
            return BADLANDS;
        }
        if (biome.method_40220(class_6908.field_36512)) {
            return MOUNTAIN;
        }
        if (biome.method_40220(class_6908.field_36510)) {
            return BEACH;
        }
        if (biome.method_40220(class_6908.field_37392)) {
            return SAVANNA;
        }
        return OTHER;
    }

    static {
        PLAINS_ID = new class_2960("minecraft", "plains");
        SUNFLOWER_PLAINS_ID = new class_2960("minecraft", "sunflower_plains");
        MEADOW_ID = new class_2960("minecraft", "meadow");
        FOREST_ID = new class_2960("minecraft", "forest");
        FLOWER_FOREST_ID = new class_2960("minecraft", "flower_forest");
        BIRCH_FOREST_ID = new class_2960("minecraft", "birch_forest");
        OLD_GROWTH_BIRCH_FOREST_ID = new class_2960("minecraft", "old_growth_birch_forest");
        DARK_FOREST_ID = new class_2960("minecraft", "dark_forest");
        TAIGA_ID = new class_2960("minecraft", "taiga");
        OLD_GROWTH_PINE_TAIGA_ID = new class_2960("minecraft", "old_growth_pine_taiga");
        OLD_GROWTH_SPRUCE_TAIGA_ID = new class_2960("minecraft", "old_growth_spruce_taiga");
        SNOWY_TAIGA_ID = new class_2960("minecraft", "snowy_taiga");
        JUNGLE_ID = new class_2960("minecraft", "jungle");
        SPARSE_JUNGLE_ID = new class_2960("minecraft", "sparse_jungle");
        BAMBOO_JUNGLE_ID = new class_2960("minecraft", "bamboo_jungle");
        DESERT_ID = new class_2960("minecraft", "desert");
        SAVANNA_ID = new class_2960("minecraft", "savanna");
        SAVANNA_PLATEAU_ID = new class_2960("minecraft", "savanna_plateau");
        WINDSWEPT_SAVANNA_ID = new class_2960("minecraft", "windswept_savanna");
        BADLANDS_ID = new class_2960("minecraft", "badlands");
        WOODED_BADLANDS_ID = new class_2960("minecraft", "wooded_badlands");
        ERODED_BADLANDS_ID = new class_2960("minecraft", "eroded_badlands");
        SNOWY_PLAINS_ID = new class_2960("minecraft", "snowy_plains");
        ICE_SPIKES_ID = new class_2960("minecraft", "ice_spikes");
        SNOWY_SLOPES_ID = new class_2960("minecraft", "snowy_slopes");
        FROZEN_PEAKS_ID = new class_2960("minecraft", "frozen_peaks");
        SWAMP_ID = new class_2960("minecraft", "swamp");
        MANGROVE_SWAMP_ID = new class_2960("minecraft", "mangrove_swamp");
        CHERRY_GROVE_ID = new class_2960("minecraft", "cherry_grove");
        MUSHROOM_FIELDS_ID = new class_2960("minecraft", "mushroom_fields");
        WINDSWEPT_HILLS_ID = new class_2960("minecraft", "windswept_hills");
        WINDSWEPT_GRAVELLY_HILLS_ID = new class_2960("minecraft", "windswept_gravelly_hills");
        WINDSWEPT_FOREST_ID = new class_2960("minecraft", "windswept_forest");
        STONY_PEAKS_ID = new class_2960("minecraft", "stony_peaks");
        JAGGED_PEAKS_ID = new class_2960("minecraft", "jagged_peaks");
        BEACH_ID = new class_2960("minecraft", "beach");
        SNOWY_BEACH_ID = new class_2960("minecraft", "snowy_beach");
        STONY_SHORE_ID = new class_2960("minecraft", "stony_shore");
    }
}

