/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.structures.roadside.registry;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2960;
import net.shiroha233.roadweaver.structures.roadside.model.RoadsideDecorationSpec;
import net.shiroha233.roadweaver.structures.roadside.registry.RoadsideType;

public final class RoadsideRegistry {
    private static final Map<class_2960, RoadsideDecorationSpec> BY_ID = new ConcurrentHashMap<class_2960, RoadsideDecorationSpec>();
    private static volatile boolean builtinInitialized = false;

    private RoadsideRegistry() {
    }

    public static Collection<RoadsideDecorationSpec> all() {
        RoadsideRegistry.ensureBuiltin();
        return BY_ID.values();
    }

    public static RoadsideDecorationSpec get(class_2960 id) {
        RoadsideRegistry.ensureBuiltin();
        return BY_ID.get(id);
    }

    public static void register(RoadsideDecorationSpec spec) {
        Objects.requireNonNull(spec, "spec");
        BY_ID.putIfAbsent(spec.id(), spec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureBuiltin() {
        if (builtinInitialized) {
            return;
        }
        Class<RoadsideRegistry> clazz = RoadsideRegistry.class;
        synchronized (RoadsideRegistry.class) {
            if (builtinInitialized) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            for (RoadsideType type : RoadsideType.values()) {
                class_2960 id = new class_2960("roadweaver", "roadside/" + type.name().toLowerCase());
                RoadsideDecorationSpec spec = new RoadsideDecorationSpec(id, type.templateId(), type.sizeHint(), type.weight(), type.faceRoad(), type.scale(), type.placementRule());
                RoadsideRegistry.register(spec);
            }
            builtinInitialized = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static void clear() {
        BY_ID.clear();
        builtinInitialized = false;
    }
}

