/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.structures.roadside.registry;

import java.util.ArrayList;
import net.minecraft.class_5819;
import net.shiroha233.roadweaver.structures.roadside.model.BiomeCategory;
import net.shiroha233.roadweaver.structures.roadside.model.RoadsideDecorationSpec;
import net.shiroha233.roadweaver.structures.roadside.registry.RoadsideRegistry;
import net.shiroha233.roadweaver.structures.roadside.rules.RoadsidePlacementRule;

public final class RoadsideSelector {
    private RoadsideSelector() {
    }

    public static RoadsideDecorationSpec choose(class_5819 random, BiomeCategory biome, int roadLength) {
        ArrayList<RoadsideDecorationSpec> candidates = new ArrayList<RoadsideDecorationSpec>();
        int totalWeight = 0;
        for (RoadsideDecorationSpec spec : RoadsideRegistry.all()) {
            int w;
            RoadsidePlacementRule rule = spec.placementRule();
            if (!rule.isBiomeAllowed(biome) || !rule.isRoadLongEnough(roadLength) || (w = spec.weight()) <= 0) continue;
            candidates.add(spec);
            totalWeight += w;
        }
        if (candidates.isEmpty() || totalWeight <= 0) {
            return null;
        }
        int roll = random.method_43048(totalWeight);
        int sum = 0;
        for (RoadsideDecorationSpec spec : candidates) {
            if (roll >= (sum += spec.weight())) continue;
            return spec;
        }
        return (RoadsideDecorationSpec)candidates.get(0);
    }
}

