/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.structures.roadside.rules;

import java.util.EnumSet;
import java.util.Set;
import net.shiroha233.roadweaver.structures.roadside.model.BiomeCategory;

public final class RoadsidePlacementRule {
    private final Set<BiomeCategory> allowedBiomes;
    private final int minRoadLength;
    public static final RoadsidePlacementRule UNIVERSAL = RoadsidePlacementRule.builder().allowAll().minRoadLength(0).build();
    public static final RoadsidePlacementRule TEMPERATE = RoadsidePlacementRule.builder().allow(BiomeCategory.PLAINS, BiomeCategory.FOREST, BiomeCategory.TAIGA, BiomeCategory.CHERRY_GROVE).minRoadLength(0).build();
    public static final RoadsidePlacementRule COLD = RoadsidePlacementRule.builder().allow(BiomeCategory.SNOWY, BiomeCategory.TAIGA).minRoadLength(0).build();
    public static final RoadsidePlacementRule HOT = RoadsidePlacementRule.builder().allow(BiomeCategory.DESERT, BiomeCategory.SAVANNA, BiomeCategory.BADLANDS).minRoadLength(0).build();
    public static final RoadsidePlacementRule LONG_ROAD_ONLY = RoadsidePlacementRule.builder().allowAll().minRoadLength(100).build();
    public static final RoadsidePlacementRule VERY_LONG_ROAD_ONLY = RoadsidePlacementRule.builder().allowAll().minRoadLength(200).build();
    public static final RoadsidePlacementRule CHERRY_ONLY = RoadsidePlacementRule.builder().allow(BiomeCategory.CHERRY_GROVE).minRoadLength(0).build();
    public static final RoadsidePlacementRule FOREST_ONLY = RoadsidePlacementRule.builder().allow(BiomeCategory.FOREST).minRoadLength(0).build();

    private RoadsidePlacementRule(Set<BiomeCategory> allowedBiomes, int minRoadLength) {
        this.allowedBiomes = allowedBiomes.isEmpty() ? EnumSet.allOf(BiomeCategory.class) : EnumSet.copyOf(allowedBiomes);
        this.minRoadLength = Math.max(0, minRoadLength);
    }

    public boolean isBiomeAllowed(BiomeCategory category) {
        return this.allowedBiomes.contains((Object)category);
    }

    public boolean isRoadLongEnough(int roadLength) {
        return roadLength >= this.minRoadLength;
    }

    public Set<BiomeCategory> allowedBiomes() {
        return EnumSet.copyOf(this.allowedBiomes);
    }

    public int minRoadLength() {
        return this.minRoadLength;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Set<BiomeCategory> allowedBiomes = EnumSet.noneOf(BiomeCategory.class);
        private int minRoadLength = 0;

        private Builder() {
        }

        public Builder allow(BiomeCategory ... categories) {
            for (BiomeCategory cat : categories) {
                this.allowedBiomes.add(cat);
            }
            return this;
        }

        public Builder allowAll() {
            this.allowedBiomes.addAll(EnumSet.allOf(BiomeCategory.class));
            return this;
        }

        public Builder exclude(BiomeCategory ... categories) {
            for (BiomeCategory cat : categories) {
                this.allowedBiomes.remove((Object)cat);
            }
            return this;
        }

        public Builder minRoadLength(int length) {
            this.minRoadLength = length;
            return this;
        }

        public RoadsidePlacementRule build() {
            return new RoadsidePlacementRule(this.allowedBiomes, this.minRoadLength);
        }
    }
}

