/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.structures.roadside.runtime;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2338;

public final class RoadPlacementContext {
    private final List<class_2338> placedPositions = new ArrayList<class_2338>();
    private final int roadLength;

    public RoadPlacementContext(int roadLength) {
        this.roadLength = Math.max(0, roadLength);
    }

    public int roadLength() {
        return this.roadLength;
    }

    public int placedCount() {
        return this.placedPositions.size();
    }

    public boolean isMaxReached(int maxStructures) {
        return this.placedPositions.size() >= maxStructures;
    }

    public boolean checkSpacing(class_2338 pos, int minSpacing) {
        if (minSpacing <= 0) {
            return true;
        }
        double minSpacingSq = (double)minSpacing * (double)minSpacing;
        for (class_2338 placed : this.placedPositions) {
            double dz;
            double dx = pos.method_10263() - placed.method_10263();
            double distSq = dx * dx + (dz = (double)(pos.method_10260() - placed.method_10260())) * dz;
            if (!(distSq < minSpacingSq)) continue;
            return false;
        }
        return true;
    }

    public void recordPlacement(class_2338 pos) {
        this.placedPositions.add(pos.method_10062());
    }

    public List<class_2338> getPlacedPositions() {
        return List.copyOf(this.placedPositions);
    }

    public void reset() {
        this.placedPositions.clear();
    }
}

