/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.client;

import java.util.ArrayList;
import net.countered.settlementroads.client.gui.RoadDebugScreen;
import net.countered.settlementroads.config.ConfigScreenFactory;
import net.countered.settlementroads.config.ModConfig;
import net.countered.settlementroads.helpers.Records;
import net.countered.settlementroads.persistence.attachments.WorldDataHelper;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class SettlementRoadsClient {
    private static final KeyMapping DEBUG_MAP_KEY = new KeyMapping("key.roadweaver.debug_map", 72, "category.roadweaver");
    private static final KeyMapping CONFIG_KEY = new KeyMapping("key.roadweaver.config", 78, "category.roadweaver");

    @Mod.EventBusSubscriber(modid="roadweaver", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ForgeEvents {
        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            Minecraft client = Minecraft.m_91087_();
            if (client.f_91074_ == null) {
                return;
            }
            while (DEBUG_MAP_KEY.m_90859_()) {
                ForgeEvents.handleDebugMapKey(client);
            }
            while (CONFIG_KEY.m_90859_()) {
                ForgeEvents.handleConfigKey(client);
            }
        }

        private static void handleDebugMapKey(Minecraft client) {
            if (client.f_91080_ instanceof RoadDebugScreen) {
                client.m_91152_(null);
                return;
            }
            if (!client.m_91091_()) {
                return;
            }
            ServerLevel serverLevel = client.m_91092_().m_129783_();
            if (serverLevel == null) {
                return;
            }
            WorldDataHelper.StructureLocationsData locationsData = WorldDataHelper.structureLocations(serverLevel);
            WorldDataHelper.StructureConnectionsData connectionsData = WorldDataHelper.structureConnections(serverLevel);
            WorldDataHelper.RoadDataStorage roadDataStorage = WorldDataHelper.roadData(serverLevel);
            ArrayList<BlockPos> structures = new ArrayList<BlockPos>(locationsData.getLocations());
            ArrayList<Records.StructureConnection> connections = new ArrayList<Records.StructureConnection>(connectionsData.getConnections());
            ArrayList<Records.RoadData> roads = new ArrayList<Records.RoadData>(roadDataStorage.getRoadData());
            client.m_91152_((Screen)new RoadDebugScreen(structures, connections, roads));
        }

        private static void handleConfigKey(Minecraft client) {
            client.m_91152_(ModConfig.createConfigScreen(client.f_91080_));
        }
    }

    @Mod.EventBusSubscriber(modid="roadweaver", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModEvents {
        @SubscribeEvent
        public static void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
            event.register(DEBUG_MAP_KEY);
            event.register(CONFIG_KEY);
        }

        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            ConfigScreenFactory.register();
        }
    }
}

