/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.client.gui;

import java.util.List;
import java.util.Map;
import net.countered.settlementroads.client.gui.RenderUtils;
import net.countered.settlementroads.client.gui.RoadDebugScreen;
import net.countered.settlementroads.helpers.Records;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;

public class MapRenderer {
    private static final int RADIUS = 5;
    private static final int TARGET_GRID_PX = 80;
    private static final double ROAD_LOD_FINEST = 300.0;
    private static final double ROAD_LOD_8TH = 300.0;
    private static final double ROAD_LOD_16TH = 800.0;
    private static final double ROAD_LOD_32ND = 1600.0;
    private static final double ROAD_LOD_64TH = 3200.0;
    private static final double ROAD_LOD_128TH = 6400.0;
    private static final double ROAD_LOD_256TH = 12800.0;
    private static final double ROAD_LOD_512TH = 25600.0;
    private static final double ROAD_LOD_NONE = 50000.0;
    private static final double LOD_DISTANCE_1 = 0.3;
    private static final double LOD_DISTANCE_2 = 1.0;
    private static final double LOD_DISTANCE_3 = 3.0;
    private final Map<String, Integer> statusColors;
    private final RoadDebugScreen.ScreenBounds bounds;

    public MapRenderer(Map<String, Integer> statusColors, RoadDebugScreen.ScreenBounds bounds) {
        this.statusColors = statusColors;
        this.bounds = bounds;
    }

    public LODLevel getLODLevel(double zoom) {
        if (zoom > 3.0) {
            return LODLevel.HIGH;
        }
        if (zoom > 1.0) {
            return LODLevel.MEDIUM;
        }
        if (zoom > 0.3) {
            return LODLevel.LOW;
        }
        return LODLevel.MINIMAL;
    }

    public RoadLODLevel getRoadLODLevel(double baseScale, double zoom) {
        double blocksPerPixel = 1.0 / (baseScale * zoom);
        double blocksPerGrid = blocksPerPixel * 80.0;
        if (blocksPerGrid < 300.0) {
            return RoadLODLevel.FINEST;
        }
        if (blocksPerGrid < 300.0) {
            return RoadLODLevel.EIGHTH;
        }
        if (blocksPerGrid < 800.0) {
            return RoadLODLevel.SIXTEENTH;
        }
        if (blocksPerGrid < 1600.0) {
            return RoadLODLevel.THIRTY_SECOND;
        }
        if (blocksPerGrid < 3200.0) {
            return RoadLODLevel.SIXTY_FOURTH;
        }
        if (blocksPerGrid < 6400.0) {
            return RoadLODLevel.ONE_TWENTY_EIGHTH;
        }
        if (blocksPerGrid < 12800.0) {
            return RoadLODLevel.TWO_FIFTY_SIXTH;
        }
        if (blocksPerGrid < 25600.0) {
            return RoadLODLevel.FIVE_TWELVE;
        }
        if (blocksPerGrid < 50000.0) {
            return RoadLODLevel.NONE;
        }
        return RoadLODLevel.NONE;
    }

    public void drawRoadPaths(GuiGraphics ctx, List<Records.RoadData> roads, LODLevel lod, double baseScale, double zoom, WorldToScreenConverter converter) {
        if (roads == null || roads.isEmpty()) {
            return;
        }
        if (lod == LODLevel.MINIMAL) {
            return;
        }
        RoadLODLevel roadLOD = this.getRoadLODLevel(baseScale, zoom);
        if (roadLOD == RoadLODLevel.NONE) {
            return;
        }
        int roadColor = this.statusColors.get("road") & 0xFFFFFF | Integer.MIN_VALUE;
        boolean needsRoughCheck = roadLOD == RoadLODLevel.TWO_FIFTY_SIXTH || roadLOD == RoadLODLevel.FIVE_TWELVE;
        for (Records.RoadData roadData : roads) {
            List<Records.RoadSegmentPlacement> segments = roadData.roadSegmentList();
            if (segments == null || segments.size() < 2) continue;
            if (needsRoughCheck && segments.size() > 1) {
                BlockPos start = segments.get(0).middlePos();
                BlockPos end = segments.get(segments.size() - 1).middlePos();
                RoadDebugScreen.ScreenPos startScreen = converter.worldToScreen(start.m_123341_(), start.m_123343_());
                RoadDebugScreen.ScreenPos endScreen = converter.worldToScreen(end.m_123341_(), end.m_123343_());
                if (!this.bounds.isInBounds(startScreen.x(), startScreen.y(), 200) && !this.bounds.isInBounds(endScreen.x(), endScreen.y(), 200)) continue;
            }
            this.drawRoadPathWithLOD(ctx, segments, roadColor, roadLOD, converter);
        }
    }

    private void drawRoadPathWithLOD(GuiGraphics ctx, List<Records.RoadSegmentPlacement> segments, int color, RoadLODLevel roadLOD, WorldToScreenConverter converter) {
        int step;
        switch (roadLOD.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                int n = 1;
                break;
            }
            case 1: {
                int n = 8;
                break;
            }
            case 2: {
                int n = 16;
                break;
            }
            case 3: {
                int n = 32;
                break;
            }
            case 4: {
                int n = 64;
                break;
            }
            case 5: {
                int n = 128;
                break;
            }
            case 6: {
                int n = 256;
                break;
            }
            case 7: {
                int n = 512;
                break;
            }
            case 8: {
                int n = step = Integer.MAX_VALUE;
            }
        }
        if (step >= segments.size()) {
            return;
        }
        RoadDebugScreen.ScreenPos prevPos = null;
        int drawnSegments = 0;
        int maxSegments = 10000;
        for (int i = 0; i < segments.size() && drawnSegments < maxSegments; i += step) {
            BlockPos pos = segments.get(i).middlePos();
            RoadDebugScreen.ScreenPos currentPos = converter.worldToScreen(pos.m_123341_(), pos.m_123343_());
            if (!this.bounds.isInBounds(currentPos.x(), currentPos.y(), 100)) {
                prevPos = currentPos;
                continue;
            }
            if (prevPos != null && i > 0 && this.bounds.isLineInBounds(prevPos.x(), prevPos.y(), currentPos.x(), currentPos.y())) {
                RenderUtils.drawLine(ctx, prevPos.x(), prevPos.y(), currentPos.x(), currentPos.y(), color);
                ++drawnSegments;
            }
            prevPos = currentPos;
        }
    }

    public void drawConnections(GuiGraphics ctx, List<Records.StructureConnection> connections, List<Records.RoadData> roads, LODLevel lod, WorldToScreenConverter converter) {
        if (connections == null || connections.isEmpty()) {
            return;
        }
        if (lod == LODLevel.MINIMAL) {
            return;
        }
        for (Records.StructureConnection connection : connections) {
            if (connection.status() == Records.ConnectionStatus.COMPLETED) continue;
            Records.RoadData matchingRoad = this.findMatchingRoad(connection, roads);
            if (matchingRoad != null && matchingRoad.roadSegmentList() != null && matchingRoad.roadSegmentList().size() >= 2) {
                List<Records.RoadSegmentPlacement> segments = matchingRoad.roadSegmentList();
                BlockPos start = segments.get(0).middlePos();
                BlockPos end = segments.get(segments.size() - 1).middlePos();
                RoadDebugScreen.ScreenPos fromPos = converter.worldToScreen(start.m_123341_(), start.m_123343_());
                RoadDebugScreen.ScreenPos toPos = converter.worldToScreen(end.m_123341_(), end.m_123343_());
                if (!this.bounds.isLineInBounds(fromPos.x(), fromPos.y(), toPos.x(), toPos.y())) continue;
                int color = this.getConnectionColor(connection);
                RenderUtils.drawDashedLine(ctx, fromPos.x(), fromPos.y(), toPos.x(), toPos.y(), color);
                continue;
            }
            RoadDebugScreen.ScreenPos fromPos = converter.worldToScreen(connection.from().m_123341_(), connection.from().m_123343_());
            RoadDebugScreen.ScreenPos toPos = converter.worldToScreen(connection.to().m_123341_(), connection.to().m_123343_());
            if (!this.bounds.isLineInBounds(fromPos.x(), fromPos.y(), toPos.x(), toPos.y())) continue;
            int color = this.getConnectionColor(connection);
            RenderUtils.drawDashedLine(ctx, fromPos.x(), fromPos.y(), toPos.x(), toPos.y(), color);
        }
    }

    private Records.RoadData findMatchingRoad(Records.StructureConnection connection, List<Records.RoadData> roads) {
        if (roads == null || roads.isEmpty()) {
            return null;
        }
        for (Records.RoadData road : roads) {
            if (road.roadSegmentList() == null || road.roadSegmentList().isEmpty()) continue;
            BlockPos roadStart = road.roadSegmentList().get(0).middlePos();
            BlockPos roadEnd = road.roadSegmentList().get(road.roadSegmentList().size() - 1).middlePos();
            if (this.isNearby(roadStart, connection.from(), 100) && this.isNearby(roadEnd, connection.to(), 100)) {
                return road;
            }
            if (!this.isNearby(roadStart, connection.to(), 100) || !this.isNearby(roadEnd, connection.from(), 100)) continue;
            return road;
        }
        return null;
    }

    private boolean isNearby(BlockPos pos1, BlockPos pos2, int maxDistance) {
        int dz;
        int dx = pos1.m_123341_() - pos2.m_123341_();
        return dx * dx + (dz = pos1.m_123343_() - pos2.m_123343_()) * dz <= maxDistance * maxDistance;
    }

    private int getConnectionColor(Records.StructureConnection connection) {
        return switch (connection.status()) {
            case Records.ConnectionStatus.PLANNED -> this.statusColors.get("planned");
            case Records.ConnectionStatus.GENERATING -> this.statusColors.get("generating");
            case Records.ConnectionStatus.FAILED -> this.statusColors.get("failed");
            default -> this.statusColors.get("completed");
        };
    }

    public void drawStructures(GuiGraphics ctx, List<BlockPos> structures, BlockPos hoveredStructure, LODLevel lod, WorldToScreenConverter converter) {
        if (structures == null || structures.isEmpty()) {
            return;
        }
        int adaptiveRadius = this.getAdaptiveNodeRadius(lod, 3.0);
        for (BlockPos structure : structures) {
            RoadDebugScreen.ScreenPos pos = converter.worldToScreen(structure.m_123341_(), structure.m_123343_());
            if (!this.bounds.isInBounds(pos.x(), pos.y(), adaptiveRadius + 6)) continue;
            boolean isHovered = structure.equals((Object)hoveredStructure);
            int radius = isHovered ? adaptiveRadius + 2 : adaptiveRadius;
            switch (lod.ordinal()) {
                case 0: {
                    int glowColor = 1076808817;
                    RenderUtils.fillCircle(ctx, pos.x(), pos.y(), radius + 1, glowColor);
                    RenderUtils.fillCircle(ctx, pos.x(), pos.y(), radius, this.statusColors.get("structure"));
                    RenderUtils.drawCircleOutline(ctx, pos.x(), pos.y(), radius, -14778828);
                    int highlightSize = Math.max(1, radius / 3);
                    ctx.m_280509_(pos.x() - highlightSize, pos.y() - highlightSize, pos.x() + highlightSize + 1, pos.y() + highlightSize + 1, -2130706433);
                    break;
                }
                case 1: {
                    RenderUtils.fillCircle(ctx, pos.x(), pos.y(), radius, this.statusColors.get("structure"));
                    RenderUtils.drawCircleOutline(ctx, pos.x(), pos.y(), radius, -14778828);
                    if (radius < 3) break;
                    ctx.m_280509_(pos.x() - 1, pos.y() - 1, pos.x() + 1, pos.y() + 1, 0x60FFFFFF);
                    break;
                }
                case 2: {
                    RenderUtils.fillCircle(ctx, pos.x(), pos.y(), radius, this.statusColors.get("structure"));
                    if (radius < 4) break;
                    RenderUtils.drawCircleOutline(ctx, pos.x(), pos.y(), radius, -14778828);
                    break;
                }
                case 3: {
                    if (adaptiveRadius >= 2) {
                        ctx.m_280509_(pos.x() - 1, pos.y() - 1, pos.x() + 2, pos.y() + 2, this.statusColors.get("structure").intValue());
                        break;
                    }
                    RenderUtils.fillCircle(ctx, pos.x(), pos.y(), adaptiveRadius, this.statusColors.get("structure"));
                }
            }
        }
    }

    public void drawPlayerMarker(GuiGraphics ctx, LODLevel lod, double zoom, WorldToScreenConverter converter) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null || mc.f_91074_ == null) {
            return;
        }
        double px = mc.f_91074_.m_20185_();
        double pz = mc.f_91074_.m_20189_();
        RoadDebugScreen.ScreenPos p = converter.worldToScreen(px, pz);
        int playerRadius = Math.max(3, this.getAdaptiveNodeRadius(lod, zoom) + 1);
        if (!this.bounds.isInBounds(p.x(), p.y(), playerRadius + 10)) {
            return;
        }
        int fill = -1618884;
        int glow = 1088900156;
        int outline = -7131873;
        float yaw = mc.f_91074_.m_146908_();
        double angle = Math.toRadians(yaw) + 1.5707963267948966;
        int arrowLength = playerRadius + Math.max(3, (int)(4.0 * Math.min(zoom / 3.0, 1.5)));
        double tx = (double)p.x() + Math.cos(angle) * (double)arrowLength;
        double ty = (double)p.y() + Math.sin(angle) * (double)arrowLength;
        int lineThickness = zoom > 5.0 ? 1 : (zoom > 2.0 ? 2 : 1);
        switch (lod.ordinal()) {
            case 0: {
                RenderUtils.fillCircle(ctx, p.x(), p.y(), playerRadius + 1, 1088900156);
                RenderUtils.fillCircle(ctx, p.x(), p.y(), playerRadius, -1618884);
                RenderUtils.drawCircleOutline(ctx, p.x(), p.y(), playerRadius, -7131873);
                int highlightSize = Math.max(1, playerRadius / 4);
                ctx.m_280509_(p.x() - highlightSize, p.y() - highlightSize, p.x() + highlightSize + 1, p.y() + highlightSize + 1, -1426063361);
                if (lineThickness > 1) {
                    RenderUtils.drawThickLine(ctx, p.x(), p.y(), (int)Math.round(tx), (int)Math.round(ty), -1, lineThickness);
                    break;
                }
                RenderUtils.drawSmoothLine(ctx, p.x(), p.y(), tx, ty, -1);
                break;
            }
            case 1: {
                RenderUtils.fillCircle(ctx, p.x(), p.y(), playerRadius, -1618884);
                RenderUtils.drawCircleOutline(ctx, p.x(), p.y(), playerRadius, -7131873);
                ctx.m_280509_(p.x() - 1, p.y() - 1, p.x() + 1, p.y() + 1, -1996488705);
                RenderUtils.drawSmoothLine(ctx, p.x(), p.y(), tx, ty, -1);
                break;
            }
            case 2: {
                RenderUtils.fillCircle(ctx, p.x(), p.y(), playerRadius, -1618884);
                if (playerRadius >= 4) {
                    RenderUtils.drawCircleOutline(ctx, p.x(), p.y(), playerRadius, -7131873);
                }
                RenderUtils.drawSmoothLine(ctx, p.x(), p.y(), tx, ty, -1);
                break;
            }
            case 3: {
                RenderUtils.fillCircle(ctx, p.x(), p.y(), Math.max(2, playerRadius), -1618884);
                int shortArrow = playerRadius + 2;
                double stx = (double)p.x() + Math.cos(angle) * (double)shortArrow;
                double sty = (double)p.y() + Math.sin(angle) * (double)shortArrow;
                RenderUtils.drawSmoothLine(ctx, p.x(), p.y(), stx, sty, -1);
            }
        }
    }

    private int getAdaptiveNodeRadius(LODLevel lod, double zoom) {
        double baseRadius = 5.0;
        double zoomFactor = Math.max(0.3, Math.min(1.2, 1.0 + Math.log10(zoom) * 0.15));
        double scaledRadius = baseRadius * zoomFactor;
        double lodMultiplier = switch (lod.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> 0.9;
            case 1 -> 1.0;
            case 2 -> 0.8;
            case 3 -> 0.6;
        };
        return Math.max(2, (int)Math.round(scaledRadius * lodMultiplier));
    }

    public static enum LODLevel {
        HIGH,
        MEDIUM,
        LOW,
        MINIMAL;

    }

    public static enum RoadLODLevel {
        FINEST,
        EIGHTH,
        SIXTEENTH,
        THIRTY_SECOND,
        SIXTY_FOURTH,
        ONE_TWENTY_EIGHTH,
        TWO_FIFTY_SIXTH,
        FIVE_TWELVE,
        NONE;

    }

    public static interface WorldToScreenConverter {
        public RoadDebugScreen.ScreenPos worldToScreen(double var1, double var3);
    }
}

