/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.countered.settlementroads.client.gui.GridRenderer;
import net.countered.settlementroads.client.gui.MapRenderer;
import net.countered.settlementroads.client.gui.UIRenderer;
import net.countered.settlementroads.helpers.Records;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;

public class RoadDebugScreen
extends Screen {
    private static final int PADDING = 20;
    private final List<BlockPos> structures;
    private final List<Records.StructureConnection> connections;
    private final List<Records.RoadData> roads;
    private final Map<String, Integer> statusColors = Map.of("structure", -14176672, "planned", -865972, "generating", -1671646, "completed", -14176672, "failed", -1618884, "road", -13330213);
    private boolean dragging = false;
    private boolean firstLayout = true;
    private boolean layoutDirty = true;
    private double zoom = 3.0;
    private double offsetX = 0.0;
    private double offsetY = 0.0;
    private double baseScale = 1.0;
    private int minX;
    private int maxX;
    private int minZ;
    private int maxZ;
    private int lastWidth = 0;
    private int lastHeight = 0;
    private double lastZoom = 1.0;
    private double lastOffsetX = 0.0;
    private double lastOffsetY = 0.0;
    private BlockPos hoveredStructure = null;
    private final MapRenderer mapRenderer;
    private final GridRenderer gridRenderer;
    private final UIRenderer uiRenderer;
    private final ScreenBounds bounds;

    public RoadDebugScreen(List<BlockPos> structures, List<Records.StructureConnection> connections, List<Records.RoadData> roads) {
        super((Component)Component.m_237115_((String)"gui.roadweaver.debug_map.title"));
        this.structures = structures != null ? new ArrayList<BlockPos>(structures) : new ArrayList();
        this.connections = connections != null ? new ArrayList<Records.StructureConnection>(connections) : new ArrayList();
        List<Records.RoadData> list = this.roads = roads != null ? new ArrayList<Records.RoadData>(roads) : new ArrayList();
        if (!this.structures.isEmpty()) {
            this.minX = this.structures.stream().mapToInt(Vec3i::m_123341_).min().orElse(0);
            this.maxX = this.structures.stream().mapToInt(Vec3i::m_123341_).max().orElse(0);
            this.minZ = this.structures.stream().mapToInt(Vec3i::m_123343_).min().orElse(0);
            this.maxZ = this.structures.stream().mapToInt(Vec3i::m_123343_).max().orElse(0);
        }
        this.bounds = new ScreenBounds();
        this.mapRenderer = new MapRenderer(this.statusColors, this.bounds);
        this.gridRenderer = new GridRenderer();
        this.uiRenderer = new UIRenderer(this.statusColors);
    }

    private void computeLayout() {
        if (this.structures.isEmpty()) {
            this.baseScale = 1.0;
            return;
        }
        int w = this.f_96543_ - 40;
        int h = this.f_96544_ - 40;
        if (w <= 0 || h <= 0) {
            return;
        }
        int worldW = this.maxX - this.minX;
        int worldH = this.maxZ - this.minZ;
        if (worldW <= 0 || worldH <= 0) {
            this.baseScale = 1.0;
            return;
        }
        double scaleX = (double)w / (double)worldW;
        double scaleY = (double)h / (double)worldH;
        this.baseScale = Math.min(scaleX, scaleY) * 0.8;
        if (this.firstLayout) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ != null) {
                double playerX = mc.f_91074_.m_20185_();
                double playerZ = mc.f_91074_.m_20189_();
                double playerScreenX = (playerX - (double)this.minX) * this.baseScale * this.zoom;
                double playerScreenZ = (playerZ - (double)this.minZ) * this.baseScale * this.zoom;
                this.offsetX = (double)w / 2.0 - playerScreenX;
                this.offsetY = (double)h / 2.0 - playerScreenZ;
            } else {
                this.offsetX = ((double)w - (double)worldW * this.baseScale * this.zoom) / 2.0;
                this.offsetY = ((double)h - (double)worldH * this.baseScale * this.zoom) / 2.0;
            }
            this.firstLayout = false;
        }
        this.layoutDirty = false;
    }

    private void updateUIBounds() {
        this.bounds.update(20, this.f_96543_ - 20, 20, this.f_96544_ - 20);
    }

    private ScreenPos worldToScreen(double worldX, double worldZ) {
        int x = 20 + (int)((worldX - (double)this.minX) * this.baseScale * this.zoom + this.offsetX);
        int y = 20 + (int)((worldZ - (double)this.minZ) * this.baseScale * this.zoom + this.offsetY);
        return new ScreenPos(x, y);
    }

    public void m_88315_(GuiGraphics ctx, int mouseX, int mouseY, float delta) {
        if (this.layoutDirty || this.lastWidth != this.f_96543_ || this.lastHeight != this.f_96544_ || this.lastZoom != this.zoom || this.lastOffsetX != this.offsetX || this.lastOffsetY != this.offsetY) {
            this.computeLayout();
            this.updateUIBounds();
            this.lastWidth = this.f_96543_;
            this.lastHeight = this.f_96544_;
            this.lastZoom = this.zoom;
            this.lastOffsetX = this.offsetX;
            this.lastOffsetY = this.offsetY;
            this.layoutDirty = false;
        }
        this.renderCustomBackground(ctx);
        MapRenderer.LODLevel lod = this.mapRenderer.getLODLevel(this.zoom);
        MapRenderer.WorldToScreenConverter converter = this::worldToScreen;
        if (lod != MapRenderer.LODLevel.MINIMAL) {
            this.gridRenderer.drawGrid(ctx, lod, this.f_96543_, this.f_96544_, 20, this.baseScale, this.zoom, this.offsetX, this.offsetY, this.minX, this.minZ, this.bounds);
        }
        this.mapRenderer.drawRoadPaths(ctx, this.roads, lod, this.baseScale, this.zoom, converter);
        this.mapRenderer.drawConnections(ctx, this.connections, this.roads, lod, converter);
        this.mapRenderer.drawStructures(ctx, this.structures, this.hoveredStructure, lod, converter);
        this.mapRenderer.drawPlayerMarker(ctx, lod, this.zoom, converter);
        this.uiRenderer.drawTitle(ctx, this.f_96543_);
        this.uiRenderer.drawStatsPanel(ctx, this.f_96543_, this.structures, this.connections, this.roads, this.zoom, this.baseScale);
        this.uiRenderer.drawLegendPanel(ctx, this.f_96544_);
        if (this.hoveredStructure != null) {
            this.uiRenderer.drawTooltip(ctx, this.hoveredStructure, mouseX, mouseY, this.f_96543_);
        }
        this.updateHoveredStructure(mouseX, mouseY);
    }

    public boolean m_6913_() {
        return true;
    }

    private void renderCustomBackground(GuiGraphics ctx) {
        ctx.m_280024_(0, 0, this.f_96543_, this.f_96544_, -1072689136, -804253680);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.dragging && button == 0) {
            this.offsetX += dragX;
            this.offsetY += dragY;
            this.layoutDirty = true;
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double vertical) {
        double old = this.zoom;
        this.zoom = vertical > 0.0 ? this.zoom * 1.1 : this.zoom / 1.1;
        this.zoom = Math.max(0.1, Math.min(10.0, this.zoom));
        this.offsetX = (this.offsetX - mouseX + 20.0) * (this.zoom / old) + mouseX - 20.0;
        this.offsetY = (this.offsetY - mouseY + 20.0) * (this.zoom / old) + mouseY - 20.0;
        this.layoutDirty = true;
        return true;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return super.m_6375_(mouseX, mouseY, button);
        }
        BlockPos clicked = this.findClickedStructure(mouseX, mouseY);
        if (clicked != null) {
            this.teleportTo(clicked);
            return true;
        }
        this.dragging = true;
        return true;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.dragging) {
            this.dragging = false;
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    private void updateHoveredStructure(int mouseX, int mouseY) {
        this.hoveredStructure = this.findClickedStructure(mouseX, mouseY);
    }

    private BlockPos findClickedStructure(double mouseX, double mouseY) {
        for (BlockPos structure : this.structures) {
            ScreenPos pos = this.worldToScreen(structure.m_123341_(), structure.m_123343_());
            double dx = (double)pos.x - mouseX;
            double dy = (double)pos.y - mouseY;
            if (!(Math.sqrt(dx * dx + dy * dy) <= 7.0)) continue;
            return structure;
        }
        return null;
    }

    private void teleportTo(BlockPos pos) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || !mc.m_91091_()) {
            return;
        }
        LocalPlayer player = mc.f_91074_;
        String command = "/tp " + player.m_7755_().getString() + " " + pos.m_123341_() + " ~ " + pos.m_123343_();
        if (mc.m_91092_() != null) {
            mc.m_91092_().m_129892_().m_230957_(mc.m_91092_().m_129893_(), command);
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7379_() {
        super.m_7379_();
    }

    public static class ScreenBounds {
        private int left;
        private int right;
        private int top;
        private int bottom;

        public void update(int left, int right, int top, int bottom) {
            this.left = left;
            this.right = right;
            this.top = top;
            this.bottom = bottom;
        }

        public boolean isInBounds(int x, int y, int margin) {
            return x >= this.left - margin && x <= this.right + margin && y >= this.top - margin && y <= this.bottom + margin;
        }

        public boolean isLineInBounds(int x1, int y1, int x2, int y2) {
            return !(x1 < this.left && x2 < this.left || x1 > this.right && x2 > this.right || y1 < this.top && y2 < this.top) && (y1 <= this.bottom || y2 <= this.bottom);
        }

        public int left() {
            return this.left;
        }

        public int right() {
            return this.right;
        }

        public int top() {
            return this.top;
        }

        public int bottom() {
            return this.bottom;
        }
    }

    public record ScreenPos(int x, int y) {
    }
}

