/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.client.gui;

import java.util.List;
import java.util.Map;
import net.countered.settlementroads.client.gui.RenderUtils;
import net.countered.settlementroads.helpers.Records;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class UIRenderer {
    private static final int PADDING = 20;
    private final Map<String, Integer> statusColors;

    public UIRenderer(Map<String, Integer> statusColors) {
        this.statusColors = statusColors;
    }

    public void drawTitle(GuiGraphics ctx, int width) {
        Font font = Minecraft.m_91087_().f_91062_;
        MutableComponent title = Component.m_237115_((String)"gui.roadweaver.debug_map.title");
        int tw = font.m_92852_((FormattedText)title);
        int x = (width - tw) / 2;
        int y = 28;
        RenderUtils.drawPanel(ctx, x - 10, y - 5, x + tw + 10, y + 14, -1073741824, -11890462);
        ctx.m_280614_(font, (Component)title, x, y, -1, true);
    }

    public void drawStatsPanel(GuiGraphics ctx, int width, List<BlockPos> structures, List<Records.StructureConnection> connections, List<Records.RoadData> roads, double zoom, double baseScale) {
        Font font = Minecraft.m_91087_().f_91062_;
        int planned = 0;
        int generating = 0;
        int completed = 0;
        int failed = 0;
        for (Records.StructureConnection structureConnection : connections) {
            switch (structureConnection.status()) {
                case PLANNED: {
                    ++planned;
                    break;
                }
                case GENERATING: {
                    ++generating;
                    break;
                }
                case COMPLETED: {
                    ++completed;
                    break;
                }
                case FAILED: {
                    ++failed;
                }
            }
        }
        int validRoads = 0;
        for (Records.RoadData road : roads) {
            if (road.roadSegmentList() == null || road.roadSegmentList().size() < 2) continue;
            ++validRoads;
        }
        double d = 1.0 / (baseScale * zoom);
        double blocksPerGrid = d * 80.0;
        String bpg = String.format("%.0f", blocksPerGrid);
        Component[] labels = new Component[]{Component.m_237110_((String)"gui.roadweaver.debug_map.structures", (Object[])new Object[]{structures.size()}), Component.m_237110_((String)"gui.roadweaver.debug_map.planned", (Object[])new Object[]{planned}), Component.m_237110_((String)"gui.roadweaver.debug_map.generating", (Object[])new Object[]{generating}), Component.m_237110_((String)"gui.roadweaver.debug_map.completed", (Object[])new Object[]{completed}), Component.m_237110_((String)"gui.roadweaver.debug_map.failed", (Object[])new Object[]{failed}), Component.m_237110_((String)"gui.roadweaver.debug_map.roads", (Object[])new Object[]{roads.size()}), Component.m_237110_((String)"gui.roadweaver.debug_map.valid", (Object[])new Object[]{validRoads}), Component.m_237110_((String)"gui.roadweaver.debug_map.zoom", (Object[])new Object[]{String.format("%.1f", zoom)}), Component.m_237110_((String)"gui.roadweaver.debug_map.lod_value", (Object[])new Object[]{bpg})};
        int[] colors = new int[]{this.statusColors.get("structure"), this.statusColors.get("planned"), this.statusColors.get("generating"), this.statusColors.get("completed"), this.statusColors.get("failed"), this.statusColors.get("road"), -16711936, -1, -256};
        int maxWidth = 0;
        for (Component label : labels) {
            maxWidth = Math.max(maxWidth, font.m_92852_((FormattedText)label));
        }
        int panelX = width - maxWidth - 20 - 20;
        int panelY = 60;
        int panelW = maxWidth + 16;
        int panelH = labels.length * 12 + 8;
        RenderUtils.drawPanel(ctx, panelX, panelY, panelX + panelW, panelY + panelH, -536870912, -13877680);
        for (int i = 0; i < labels.length; ++i) {
            int textY = panelY + 8 + i * 12;
            ctx.m_280614_(font, labels[i], panelX + 8, textY, colors[i], false);
        }
    }

    public void drawLegendPanel(GuiGraphics ctx, int height) {
        Font font = Minecraft.m_91087_().f_91062_;
        Component[] labels = new Component[]{Component.m_237115_((String)"gui.roadweaver.debug_map.legend.structures"), Component.m_237115_((String)"gui.roadweaver.debug_map.legend.planned"), Component.m_237115_((String)"gui.roadweaver.debug_map.legend.generating"), Component.m_237115_((String)"gui.roadweaver.debug_map.legend.failed"), Component.m_237115_((String)"gui.roadweaver.debug_map.legend.roads"), Component.m_237115_((String)"gui.roadweaver.debug_map.legend.player")};
        int[] colors = new int[]{this.statusColors.get("structure"), this.statusColors.get("planned"), this.statusColors.get("generating"), this.statusColors.get("failed"), this.statusColors.get("road"), -1618884};
        int maxWidth = 0;
        for (Component label : labels) {
            maxWidth = Math.max(maxWidth, font.m_92852_((FormattedText)label));
        }
        int panelX = 20;
        int panelY = height - labels.length * 12 - 20 - 16;
        int panelW = maxWidth + 32;
        int panelH = labels.length * 12 + 8;
        RenderUtils.drawPanel(ctx, panelX, panelY, panelX + panelW, panelY + panelH, -536870912, -13350562);
        for (int i = 0; i < labels.length; ++i) {
            int textY = panelY + 8 + i * 12;
            RenderUtils.fillCircle(ctx, panelX + 12, textY + 4, 3, colors[i]);
            ctx.m_280614_(font, labels[i], panelX + 24, textY, -1, false);
        }
    }

    public void drawTooltip(GuiGraphics ctx, BlockPos structure, int mouseX, int mouseY, int width) {
        Font font = Minecraft.m_91087_().f_91062_;
        MutableComponent text = Component.m_237110_((String)"gui.roadweaver.debug_map.tooltip.coord", (Object[])new Object[]{structure.m_123341_(), structure.m_123343_()});
        int tooltipWidth = font.m_92852_((FormattedText)text) + 8;
        int tooltipHeight = 18;
        int x = mouseX + 10;
        int y = mouseY - 25;
        if (x + tooltipWidth > width) {
            x = mouseX - tooltipWidth - 10;
        }
        if (y < 0) {
            y = mouseY + 10;
        }
        RenderUtils.drawPanel(ctx, x, y, x + tooltipWidth, y + tooltipHeight, -268435456, -11184811);
        ctx.m_280614_(font, (Component)text, x + 4, y + 5, -1, false);
    }
}

