/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.fml.loading.FMLPaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModConfig.class);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FMLPaths.CONFIGDIR.get().resolve("roadweaver.json");
    public static String structureToLocate = "#minecraft:village";
    public static int structureSearchRadius = 100;
    public static int initialLocatingCount = 7;
    public static int maxLocatingCount = 15;
    public static int maxConcurrentRoadGeneration = 3;
    public static int averagingRadius = 1;
    public static boolean allowArtificial = true;
    public static boolean allowNatural = true;
    public static boolean placeWaypoints = false;
    public static boolean placeRoadFences = true;
    public static boolean placeSwings = true;
    public static boolean placeBenches = true;
    public static boolean placeGloriettes = true;
    public static int structureDistanceFromRoad = 4;
    public static int maxHeightDifference = 5;
    public static int maxTerrainStability = 4;

    public static void init() {
        ModConfig.loadConfig();
    }

    public static Screen createConfigScreen(Screen parent) {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((Component)Component.m_237115_((String)"config.roadweaver.title"));
        ConfigCategory structures = builder.getOrCreateCategory((Component)Component.m_237115_((String)"config.roadweaver.category.structures"));
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        structures.addEntry((AbstractConfigListEntry)entryBuilder.startStrField((Component)Component.m_237115_((String)"config.roadweaver.structureToLocate"), structureToLocate).setDefaultValue("#minecraft:village").setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.structureToLocate.tooltip")}).setSaveConsumer(value -> {
            structureToLocate = value;
        }).build());
        structures.addEntry((AbstractConfigListEntry)entryBuilder.startIntField((Component)Component.m_237115_((String)"config.roadweaver.structureSearchRadius"), structureSearchRadius).setDefaultValue(100).setMin(50).setMax(200).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.structureSearchRadius.tooltip")}).setSaveConsumer(value -> {
            structureSearchRadius = value;
        }).build());
        ConfigCategory preGeneration = builder.getOrCreateCategory((Component)Component.m_237115_((String)"config.roadweaver.category.pregeneration"));
        preGeneration.addEntry((AbstractConfigListEntry)entryBuilder.startIntField((Component)Component.m_237115_((String)"config.roadweaver.initialLocatingCount"), initialLocatingCount).setDefaultValue(7).setMin(1).setMax(20).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.initialLocatingCount.tooltip")}).setSaveConsumer(value -> {
            initialLocatingCount = value;
        }).build());
        preGeneration.addEntry((AbstractConfigListEntry)entryBuilder.startIntField((Component)Component.m_237115_((String)"config.roadweaver.maxLocatingCount"), maxLocatingCount).setDefaultValue(15).setMin(2).setMax(50).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.maxLocatingCount.tooltip")}).setSaveConsumer(value -> {
            maxLocatingCount = value;
        }).build());
        preGeneration.addEntry((AbstractConfigListEntry)entryBuilder.startIntField((Component)Component.m_237115_((String)"config.roadweaver.maxConcurrentRoadGeneration"), maxConcurrentRoadGeneration).setDefaultValue(3).setMin(1).setMax(10).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.maxConcurrentRoadGeneration.tooltip")}).setSaveConsumer(value -> {
            maxConcurrentRoadGeneration = value;
        }).build());
        ConfigCategory roads = builder.getOrCreateCategory((Component)Component.m_237115_((String)"config.roadweaver.category.roads"));
        roads.addEntry((AbstractConfigListEntry)entryBuilder.startIntField((Component)Component.m_237115_((String)"config.roadweaver.averagingRadius"), averagingRadius).setDefaultValue(1).setMin(0).setMax(5).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.averagingRadius.tooltip")}).setSaveConsumer(value -> {
            averagingRadius = value;
        }).build());
        roads.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"config.roadweaver.allowArtificial"), allowArtificial).setDefaultValue(true).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.allowArtificial.tooltip")}).setSaveConsumer(value -> {
            allowArtificial = value;
        }).build());
        roads.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"config.roadweaver.allowNatural"), allowNatural).setDefaultValue(true).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.allowNatural.tooltip")}).setSaveConsumer(value -> {
            allowNatural = value;
        }).build());
        roads.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"config.roadweaver.placeWaypoints"), placeWaypoints).setDefaultValue(false).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.placeWaypoints.tooltip")}).setSaveConsumer(value -> {
            placeWaypoints = value;
        }).build());
        roads.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"config.roadweaver.placeRoadFences"), placeRoadFences).setDefaultValue(true).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.placeRoadFences.tooltip")}).setSaveConsumer(value -> {
            placeRoadFences = value;
        }).build());
        roads.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"config.roadweaver.placeSwings"), placeSwings).setDefaultValue(true).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.placeSwings.tooltip")}).setSaveConsumer(value -> {
            placeSwings = value;
        }).build());
        roads.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"config.roadweaver.placeBenches"), placeBenches).setDefaultValue(true).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.placeBenches.tooltip")}).setSaveConsumer(value -> {
            placeBenches = value;
        }).build());
        roads.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"config.roadweaver.placeGloriettes"), placeGloriettes).setDefaultValue(true).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.placeGloriettes.tooltip")}).setSaveConsumer(value -> {
            placeGloriettes = value;
        }).build());
        roads.addEntry((AbstractConfigListEntry)entryBuilder.startIntField((Component)Component.m_237115_((String)"config.roadweaver.structureDistanceFromRoad"), structureDistanceFromRoad).setDefaultValue(4).setMin(3).setMax(8).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.structureDistanceFromRoad.tooltip")}).setSaveConsumer(value -> {
            structureDistanceFromRoad = value;
        }).build());
        roads.addEntry((AbstractConfigListEntry)entryBuilder.startIntField((Component)Component.m_237115_((String)"config.roadweaver.maxHeightDifference"), maxHeightDifference).setDefaultValue(5).setMin(3).setMax(10).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.maxHeightDifference.tooltip")}).setSaveConsumer(value -> {
            maxHeightDifference = value;
        }).build());
        roads.addEntry((AbstractConfigListEntry)entryBuilder.startIntField((Component)Component.m_237115_((String)"config.roadweaver.maxTerrainStability"), maxTerrainStability).setDefaultValue(4).setMin(2).setMax(10).setTooltip(new Component[]{Component.m_237115_((String)"config.roadweaver.maxTerrainStability.tooltip")}).setSaveConsumer(value -> {
            maxTerrainStability = value;
        }).build());
        builder.setSavingRunnable(ModConfig::saveConfig);
        return builder.build();
    }

    private static void loadConfig() {
        try {
            if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                String json = Files.readString(CONFIG_PATH);
                ConfigData data = (ConfigData)GSON.fromJson(json, ConfigData.class);
                ModConfig.applyConfig(data);
                LOGGER.info("RoadWeaver config loaded successfully");
            } else {
                ModConfig.saveConfig();
                LOGGER.info("RoadWeaver config created with default values");
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load RoadWeaver config: {}", (Object)e.getMessage());
        }
    }

    public static void saveConfig() {
        try {
            ConfigData data = ModConfig.getCurrentConfig();
            String json = GSON.toJson((Object)data);
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            Files.writeString(CONFIG_PATH, (CharSequence)json, new OpenOption[0]);
            LOGGER.info("RoadWeaver config saved successfully");
        }
        catch (IOException e) {
            LOGGER.error("Failed to save RoadWeaver config: {}", (Object)e.getMessage());
        }
    }

    private static void applyConfig(ConfigData data) {
        structureToLocate = data.structureToLocate;
        structureSearchRadius = data.structureSearchRadius;
        initialLocatingCount = data.initialLocatingCount;
        maxLocatingCount = data.maxLocatingCount;
        maxConcurrentRoadGeneration = data.maxConcurrentRoadGeneration;
        averagingRadius = data.averagingRadius;
        allowArtificial = data.allowArtificial;
        allowNatural = data.allowNatural;
        placeWaypoints = data.placeWaypoints;
        placeRoadFences = data.placeRoadFences;
        placeSwings = data.placeSwings;
        placeBenches = data.placeBenches;
        placeGloriettes = data.placeGloriettes;
        structureDistanceFromRoad = data.structureDistanceFromRoad;
        maxHeightDifference = data.maxHeightDifference;
        maxTerrainStability = data.maxTerrainStability;
    }

    private static ConfigData getCurrentConfig() {
        ConfigData data = new ConfigData();
        data.structureToLocate = structureToLocate;
        data.structureSearchRadius = structureSearchRadius;
        data.initialLocatingCount = initialLocatingCount;
        data.maxLocatingCount = maxLocatingCount;
        data.maxConcurrentRoadGeneration = maxConcurrentRoadGeneration;
        data.averagingRadius = averagingRadius;
        data.allowArtificial = allowArtificial;
        data.allowNatural = allowNatural;
        data.placeWaypoints = placeWaypoints;
        data.placeRoadFences = placeRoadFences;
        data.placeSwings = placeSwings;
        data.placeBenches = placeBenches;
        data.placeGloriettes = placeGloriettes;
        data.structureDistanceFromRoad = structureDistanceFromRoad;
        data.maxHeightDifference = maxHeightDifference;
        data.maxTerrainStability = maxTerrainStability;
        return data;
    }

    public static class ConfigData {
        public String structureToLocate = "#minecraft:village";
        public int structureSearchRadius = 100;
        public int initialLocatingCount = 7;
        public int maxLocatingCount = 15;
        public int maxConcurrentRoadGeneration = 3;
        public int averagingRadius = 1;
        public boolean allowArtificial = true;
        public boolean allowNatural = true;
        public boolean placeWaypoints = false;
        public boolean placeRoadFences = true;
        public boolean placeSwings = true;
        public boolean placeBenches = true;
        public boolean placeGloriettes = true;
        public int structureDistanceFromRoad = 4;
        public int maxHeightDifference = 5;
        public int maxTerrainStability = 4;
    }
}

